(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    857453,      27932]*)
(*NotebookOutlinePosition[    859133,      27987]*)
(*  CellTagsIndexPosition[    858994,      27979]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["\n",
    FontSize->12],
  "\t\t\n",
  StyleBox["RIEMANNIAN GEOMETRY & TENSOR CALCULUS\n",
    FontSize->24,
    FontWeight->"Bold"],
  StyleBox[
  "A set of functions for tensor calculations in Riemannian Geometry and \
General Relativity\n",
    FontSize->16]
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextAlignment->Center,
  TextJustification->0,
  FontColor->RGBColor[0, 0, 1]],

Cell["version 3.8.9 - May 2013", "Text",
  TextAlignment->Center,
  TextJustification->0,
  FontFamily->"Times",
  FontSize->14,
  FontSlant->"Italic"],

Cell[TextData[{
  StyleBox["\n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ButtonBox["S. Bonanos",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/SB.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox[ButtonBox["Institute of Nuclear Physics",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[ButtonBox["NCSR \"Demokritos\"",
    ButtonData:>{
      URL[ "http://www.demokritos.gr/index_muk.asp"], None},
    ButtonStyle->"Hyperlink"],
    FontSlant->"Italic"],
  StyleBox[", \nAghia Paraskevi 15310, Greece. ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  "Please send comments, suggestions, bug reports to:  ",
  ButtonBox["sbonano@inp.demokritos.gr",
    ButtonData:>{
      URL[ "mailto:sbonano@inp.demokritos.gr"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[" \t",
    FontWeight->"Bold"]
}], "Text",
  TextAlignment->Center,
  TextJustification->0,
  FontFamily->"Times",
  FontSize->16]
}, Closed]],

Cell[TextData["\[CapitalDelta]\[Omega]\[Rho]\[Epsilon]",
Cell[BoxData[
    StyleBox[\(\[Alpha]\&`\),
      FontFamily->"Times"]]],
"\[Nu] \[Epsilon]\[Lambda]",
Cell[BoxData[
    StyleBox[\(\[Alpha]\&'\),
      FontFamily->"Times"]]],
"\[Beta]\[Epsilon]\[Tau]\[Epsilon], \[Delta]\[Omega]\[Rho]\[Epsilon]",
Cell[BoxData[
    StyleBox[\(\[Alpha]\&`\),
      FontFamily->"Times"]]],
"\[Nu] \[Delta]",
Cell[BoxData[
    StyleBox[\(o\&'\),
      FontFamily->"Times"]]],
"\[Tau]\[Epsilon]."], "Text",
  TextAlignment->Center,
  TextJustification->0,
  FontFamily->"Helvetica",
  FontSize->24,
  FontColor->GrayLevel[1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 1  Instructions",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell["  1.0  Introduction", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  StyleBox["\t",
    FontWeight->"Bold"],
  "This package allows calculations in Riemannian Geometry by defining all \
basic tensors and tensor operations. Tensors are represented as nested lists \
of their components in a particular frame (default = coordinate frame). \
Functions are defined for Raising/Lowering indices, Contracting (multiple) \
indices on one (or between two) tensors, for Covariant and Lie \
Differentiation and for classifying the Weyl and Ricci tensors. One can also \
use standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions like ",
  StyleBox["Dot",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Outer",
    FontFamily->"Courier"],
  " (giving tensor products), and ",
  StyleBox["Transpose",
    FontFamily->"Courier"],
  " (index rearrangement) to create new (lists representing) tensors. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tGiven a metric and a set of coordinates, the main routine in the package \
computes explicit expressions for all common Riemannian Geometry tensors \
(Riemann, Ricci, Einstein, Weyl) and tests if the space belongs to any of the \
following categories: ",
  StyleBox["Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Conformally Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Ricci Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Einstein Space",
    FontSlant->"Italic"],
  " or ",
  StyleBox["Space of Constant Curvature",
    FontSlant->"Italic"],
  ". Each tensor is stored as a nested list under an appropriate global name. \
One can optionally specify a frame (if different from the coordinate frame) \
with respect to which tensor components are to be computed. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe Riemann and Ricci tensor sign conventions used are:  ",
  Cell[BoxData[
      TagBox[\(V\_\(b; c; d\)\),
        DisplayForm]]],
  " - ",
  Cell[BoxData[
      TagBox[\(V\_\(b; d; c\)\),
        DisplayForm]]],
  " = ",
  Cell[BoxData[
      \(V\_a\)]],
  StyleBox[" ",
    FontSize->12],
  Cell[BoxData[
      TagBox[\(\(R\^a\)\_bcd\),
        DisplayForm]]],
  " and ",
  Cell[BoxData[
      \(R\_ab\)]],
  " = ",
  Cell[BoxData[
      TagBox[\(\(R\^s\)\_asb\),
        DisplayForm]]],
  ", so that Einstein's equations are ",
  Cell[BoxData[
      \(R\_ab - \(1\/2\) R\ g\_ab = \(+\[Kappa]\)\ T\_ab\)]],
  " (",
  Cell[BoxData[
      \(\[Kappa] = 8\ \[Pi]\ G/c\^4\)]],
  ")."
}], "Text",
  FontSize->16]
}, Open  ]],

Cell[CellGroupData[{

Cell["  1.1  Basic Input /Output & Notation", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  StyleBox["\t",
    FontWeight->"Bold"],
  "To define the geometry, begin by computing all basic Riemannian Geometry \
tensors for a particular metric. To do this:\n",
  StyleBox["\t ",
    FontWeight->"Bold"],
  "(0) In a new notebook, evaluate the initialization code: ",
  StyleBox["<<EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "\n\t (1) Define a list symbols (coordinate names) and give it a name -- \
say ",
  StyleBox["xIN",
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  StyleBox["=",
    FontFamily->"Courier",
    FontSize->18],
  StyleBox["{t,r,\[Theta],\[Phi]};",
    FontFamily->"Courier"],
  "\n\t (2) Define a symmetric matrix (list of lists) of functions of the \
coordinates (the metric) and give it a name -- say \n",
  StyleBox["gIN",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  "={{1-2M/r,0,0,0},{0,-1/(1-2M/r),0,0},{0,0,-r^2,0},{0,0,0,-(r^2 \
Sin[\[Theta]]^2)}};",
    FontFamily->"Courier"],
  "\n\t(3) Assign appropriate simplification rules to the global list ",
  StyleBox["simpRules",
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"],
  " as needed (see Examples and Usage Tips). For example: ",
  StyleBox["simpRules={",
    FontFamily->"Courier"],
  Cell[BoxData[
      StyleBox[\(Cos[\[Theta]]^2 + Sin[\[Theta]]^2 -> 1\),
        FontFamily->"Courier"]]],
  StyleBox["};",
    FontFamily->"Courier"],
  "\n\t(4) Evaluate ",
  StyleBox["RGtensors[gIN,xIN]",
    FontFamily->"Courier",
    FontSize->18,
    FontWeight->"Bold"]
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  "  computes all common Riemannian Geometry tensors, printing messages along \
the way. It also tests if the space is ",
  StyleBox["Flat,",
    FontSlant->"Italic"],
  " ",
  StyleBox["Conformally Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Ricci Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Einstein Space",
    FontSlant->"Italic"],
  " or ",
  StyleBox["Space of Constant Curvature",
    FontSlant->"Italic"],
  " and, if yes, prints corresponding messages. When it is finished, the \
following \"tensors\" -- nested lists -- are stored in memory and can be used \
in further calculations (the letters U, d  in the tensor names serve as \
mnemonic devices for the position -- ",
  StyleBox["Up",
    FontSlant->"Italic"],
  " or ",
  StyleBox["down",
    FontSlant->"Italic"],
  " -- of the relevant indices) :"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["gdd",
    FontFamily->"Courier"],
  " (covariant form of the metric tensor), with components gdd[[a,b]] = ",
  Cell[BoxData[
      \(g\_ab\)]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["gUU",
    FontFamily->"Courier"],
  " (contravariant form of the metric tensor), with components gUU[[a,b]] = ",
  
  Cell[BoxData[
      \(g\^ab\)]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["GUdd",
    FontFamily->"Courier"],
  " (Christoffel symbols of the 2nd kind), with components GUdd[[a,b,c]] = ",
  Cell[BoxData[
      TagBox[\(\[CapitalGamma]\_bc\%a\),
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Rdddd",
    FontFamily->"Courier"],
  " (covariant form of the Riemann tensor), with components Rdddd[[a,b,c,d]] \
= ",
  Cell[BoxData[
      TagBox[\(R\_abcd\),
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["RUddd",
    FontFamily->"Courier"],
  " (mixed form of the Riemann tensor), with components RUddd[[a,b,c,d]] = ",
  Cell[BoxData[
      TagBox[\(\(R\^a\)\_bcd\),
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Rdd",
    FontFamily->"Courier"],
  " (covariant form of the Ricci tensor), with components Rdd[[a,b]] = ",
  Cell[BoxData[
      \(R\_ab\)]],
  " \[Congruent] ",
  Cell[BoxData[
      TagBox[\(\(R\^s\)\_asb\),
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["EUd",
    FontFamily->"Courier"],
  " (mixed form of the Einstein tensor), with components EUd[[a,b]] = ",
  Cell[BoxData[
      TagBox[\(\(E\^a\)\_b\),
        DisplayForm]]],
  " \[Congruent] ",
  Cell[BoxData[
      TagBox[\(\(R\^a\)\_b\),
        DisplayForm]]],
  "- ",
  StyleBox["R/2",
    FontFamily->"Courier"],
  " ",
  Cell[BoxData[
      \(\(\[Delta]\^a\)\_b\)]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["R",
    FontFamily->"Courier"],
  " is the curvature scalar    (",
  StyleBox["Important: Do not use the symbol R in coordinates or metric!",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ")"
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Wdddd",
    FontFamily->"Courier"],
  " (covariant form of the Weyl tensor), with components Wdddd[[a,b,c,d]] = ",
  
  Cell[BoxData[
      \(W\_abcd\)]]
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tFinally, ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " defines the following global variables: (i) ",
  StyleBox["coordList",
    FontFamily->"Courier"],
  " contains the coordinates defined in (1) above, (ii) ",
  StyleBox["detg",
    FontFamily->"Courier"],
  " is the determinant of the metric, (iii) ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  " stores the dimension of the space and (iv) ",
  StyleBox["LineElement",
    FontFamily->"Courier"],
  " stores, of course, the line element! Tensor components refer to the \
coordinate frame and are numbered ",
  StyleBox["1,...,Dim",
    FontFamily->"Courier"],
  ", rather than ",
  StyleBox["0,...,Dim-1",
    FontFamily->"Courier"],
  ", so that the {i,j...k} component of a tensor is the [[i,j...k]] part of \
the corresponding nested list. See section 5, \"",
  StyleBox["Calculating Tensor Components in an Arbitrary Frame",
    FontSlant->"Italic"],
  "\", on how to do calculations in an arbitrary frame. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note",
    FontSlant->"Italic"],
  ": One can choose to skip the most time consuming computations: RUddd, \
Wdddd or EUd. This can be achieved by calling ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  "  with an optional extra argument -- a list of three numbers ",
  StyleBox["{i,j,k}",
    FontFamily->"Courier"],
  ". When the first number is 0, RUddd is not computed; when the second \
number is 0, Wdddd is not computed; and when the third number is 0, EUd is \
not computed. Thus ",
  StyleBox["RGtensors[gIN,xIN,{1,0,0}]",
    FontFamily->"Courier"],
  "  will compute RUddd but not Wdddd or EUd (See Examples 7 and 8). ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " prints warning messages when some tensors are not computed. When EUd is \
not computed, the tests for ",
  StyleBox["Einstein Space",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Space of Constant Curvature",
    FontSlant->"Italic"],
  " are not performed. For compatibility with previous versions of RGTC, the \
optional extra argument can consist of only two numbers corresponding to \
RUddd and Wdddd. Thus ",
  StyleBox["RGtensors[gIN,xIN,{1,0}]",
    FontFamily->"Courier"],
  " is equivalent to ",
  StyleBox["RGtensors[gIN,xIN,{1,0,1}]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell["\t1.1.1  Totally antisymmetric symbol / tensor", "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t Definitions for the totally antisymmetric symbol ",
  Cell[BoxData[
      \(\[CurlyEpsilon]\_\(\(a1...\) an\)\)]],
  " and tensor  ",
  Cell[BoxData[
      \(\[Eta]\_\(\(a1...\) an\)\)]],
  " are provided, but the tensor is not evaluated unless called by the user. \
As the number of indices on these objects equals the dimension of the \
mannifold, the U/d notation cannot be used. Instead, the following global \
names are used:"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t ",
  StyleBox["epsilon",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a ",
  StyleBox["function",
    FontSlant->"Italic"],
  " that takes ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  " integers as arguments and returns one of { 0, 1, -1} - the sign of the \
permutation of the arguments. For example, in 5 dimensions,"
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["epsilon[1,2,3,4,5]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "returns 1,  ",
  StyleBox["epsilon[1,3,2,4,5]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "returns -1, and  ",
  StyleBox["epsilon[1,2,2,4,5]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "returns 0."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["eta[]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can take 0 to ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  " arguments and returns the ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "-rank antisymmetric tensor with raised indices at the position(s) \
indicated by the argument(s). Thus ",
  StyleBox["eta[]",
    FontFamily->"Courier"],
  " is the totally covariant antisymmetric tensor, with components"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["eta[][[a1,a2,...,an]]=",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(\((\[LeftBracketingBar]detg\[RightBracketingBar])\)\^\(1/2\)\)]],
  StyleBox["epsilon[a1,a2,...,an]",
    FontFamily->"Courier"],
  ", "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "while"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["eta[2,3][[a1,a2,...,an]]=",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(\(\((\[LeftBracketingBar]detg\[RightBracketingBar])\)\^\(1/2\)\) 
        g\^\(a2\ b2\)\)]],
  Cell[BoxData[
      \(g\^\(a3\ b3\)\)]],
  StyleBox["epsilon[a1,b2,b3,..,an]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Warning",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": The evaluation of ",
  StyleBox["eta[]",
    FontFamily->"Courier"],
  " tensors (",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "-fold nested lists) is ",
  StyleBox["very",
    FontSlant->"Italic"],
  " time consuming in high dimensions as the number of components grows as ",
  Cell[BoxData[
      \(Dim\^Dim\)]],
  ". It also requires large amounts of memory. For example, for the simple \
case of a conformally flat metric, the {Time, Storage} requirements for \
computing ",
  StyleBox["each",
    FontSlant->"Italic"],
  " ",
  StyleBox["eta[]",
    FontFamily->"Courier"],
  " grow as follows: ",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "{~1 sec, <1 MB} for ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "=6, {~20 sec, ~7 MB} for ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "=7, and {> 10 min, >120 MB} for ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "=8! Thus, calculations with ",
  StyleBox["eta[]",
    FontFamily->"Courier"],
  " should not be attempted if ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  ">7. Fortunately, for ",
  StyleBox["Dim",
    FontFamily->"Courier"],
  "=4 the requirements are quite modest, even for complicated metrics."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  "\n",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tOnce the basic tensors have been computed, one can use the functions \
defined in the following sections to perform further calculations."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell["  1.2  Manipulation of tensor indices & tensor products", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\tThe ",
  StyleBox["first",
    FontSlant->"Italic"],
  " or ",
  StyleBox["last",
    FontSlant->"Italic"],
  " index of a tensor can be raised / lowered by inner (",
  StyleBox["Dot",
    FontWeight->"Bold"],
  ") multiplication with gUU / gdd:"
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t     ",
  StyleBox["Edd=gdd.EUd",
    FontFamily->"Courier"],
  " has components Edd[[a,b]] = ",
  Cell[BoxData[
      \(E\_ab\)]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t     ",
  StyleBox["WdddU=Wdddd.gUU",
    FontFamily->"Courier"],
  " has components WdddU[[a,b,c,d]] = ",
  Cell[BoxData[
      TagBox[\(W\_abc\^d\),
        DisplayForm]]],
  ".",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tTo manipulate other indices the following functions have been defined:"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["Lower[x_,ni__]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ":: lowers the index (indices) at position(s) ",
  StyleBox["ni",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (assumed U) of the nested list ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " using the matrix  gdd."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["Raise[x_,ni__]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ":: raises the index (indices) at position(s) ",
  StyleBox["ni",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (assumed d) of the nested list ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " using the matrix  gUU."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tFor example, the mixed Riemann tensor with  components ",
  Cell[BoxData[
      \(\(\(R\^a\)\_b\^c\)\_d\)]],
  "  is  ",
  StyleBox["RUdUd=Raise[RUddd,3]",
    FontFamily->"Courier"],
  ", ",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "while  RUUUd",
  StyleBox["=Raise[RUddd,2,3]",
    FontFamily->"Courier"],
  "  has components ",
  Cell[BoxData[
      \(\(R\^abc\)\_d\)]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note",
    FontSlant->"Italic"],
  ": The functions ",
  StyleBox["Raise",
    FontWeight->"Bold"],
  " / ",
  StyleBox["Lower",
    FontWeight->"Bold"],
  " apply the rules in ",
  StyleBox["simpRules",
    FontWeight->"Bold"],
  " and factor the expressions obtained. Thus ",
  StyleBox["Raise[RUddd,4]",
    FontFamily->"Courier"],
  " is equivalent but not identical to ",
  StyleBox["RUddd.gUU",
    FontFamily->"Courier"],
  ". "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tTensor products are obtained by using the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Outer",
    FontWeight->"Bold"],
  ". For example,"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["gg=Outer[Times,gdd,gdd];",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 4th rank (d-type) tensor with components ",
  StyleBox["gg[[a,b,c,d]]=",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\(\ g\_ab\)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(g\_cd\)],
    FontWeight->"Bold"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tUsing the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Transpose",
    FontWeight->"Bold"],
  ",  one can then define the tensor: ",
  StyleBox["gxg",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "=",
  StyleBox["gg-Transpose[gg,{1,3,2,4}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[",",
    FontVariations->{"CompatibilityType"->0}],
  " ",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "which has components  ",
  StyleBox["gxg[[a,b,c,d]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" = ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(g\_ab\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\(g\_cd\ \)\)],
    FontWeight->"Bold"],
  StyleBox["-",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(\(\ g\_ac\)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(g\_bd\)],
    FontWeight->"Bold"],
  ".\n"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell["  1.3  Contraction of tensor indices", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\[FilledSmallCircle]\tThe function  ",
  StyleBox["Contract[x_,{i1_,j1_},{i2_,j2_},..]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  takes as arguments an nth rank tensor ",
  StyleBox["x",
    FontWeight->"Bold"],
  ", and one or more lists of  pairs of numbers, indicating the positions of \
the indices to be contracted. It returns a tensor of rank ",
  StyleBox["n-2k",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is the number of index-pair lists. ",
  StyleBox[
  "It is assumed that the two numbers in each list refer to one U and one d \
type index, in any order",
    FontSlant->"Italic"],
  ".  Examples (the Einstein summation convention holds):"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(a) ",
  StyleBox["Contract[GUdd,{1,3}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  gives a d-type vector with components ",
  Cell[BoxData[
      TagBox[\(\[CapitalGamma]\_ba\%a\),
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(b) ",
  StyleBox["Contract[RUddd,{1,3}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  gives Rdd."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(c) ",
  StyleBox["Contract[Outer[Times,RUddd,RUddd],{1,7},{4,5}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  produces a dddd tensor with components ",
  Cell[BoxData[
      \(\(R\^s\)\_abt\)]],
  Cell[BoxData[
      \(\(R\^t\)\_csd\)]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Note1",
    FontSlant->"Italic"],
  ": Even though the last result can be obtained by calling ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  " twice, each time with a single pair of indices, it is ",
  StyleBox["much",
    FontSlant->"Italic"],
  " more efficient to perform multiple contractions simultaneously, as \
above.",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Note2",
    FontSlant->"Italic"],
  ": The result of (c) can also be obtained as  ",
  StyleBox["Contract[RUddd.RUddd,{1,5}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", since the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Dot",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " performs the ",
  StyleBox["{4,5}",
    FontFamily->"Courier"],
  " contraction of the outer product (last index of first tensor with first \
index of second tensor) giving a 6th rank tensor.",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\[FilledSmallCircle]\tThe function ",
  StyleBox["multiDot[x_,y_,{i1_,j1_},{i2_,j2_},..]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is similar to ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  ", and generalizes the built-in function ",
  StyleBox["Dot",
    FontFamily->"Courier"],
  ".  It takes as arguments ",
  StyleBox["two",
    FontSlant->"Italic"],
  " tensors -- ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " -- and one or more lists of  pairs of numbers.  For each pair of numbers \
",
  StyleBox["{i,j}",
    FontFamily->"Courier"],
  ", it contracts the ",
  StyleBox["i",
    FontWeight->"Bold"],
  "th index of the ",
  StyleBox["first",
    FontSlant->"Italic"],
  " tensor (",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ") with the ",
  StyleBox["j",
    FontWeight->"Bold"],
  "th index of the ",
  StyleBox["second",
    FontSlant->"Italic"],
  " tensor (",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "),  returning a tensor of rank ",
  StyleBox["m+n-2k",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", ",
  StyleBox["n",
    FontSlant->"Italic"],
  " are the ranks of ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", respectively, and ",
  StyleBox["k",
    FontSlant->"Italic"],
  " is the number of index pairs. Again, it is assumed that the indices at ",
  StyleBox["{i,j}",
    FontFamily->"Courier"],
  " are of opposite (U/d) types. Using ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  ", the result of example (c) above can also be obtained as  ",
  StyleBox["multiDot[RUddd,RUddd,{1,3},{4,1}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ".",
  Cell[BoxData[
      FormBox["", TextForm]], ""],
  Cell[BoxData[
      FormBox["", TextForm]], ""]
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["\tNote1:",
    FontSlant->"Italic"],
  " When contracting a product of two tensors, as in example (c), one should \
always use ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  " to perform the contractions, thus avoiding the outer product calculation, \
which is very time / memory consuming. See also Example 1a in section 3 and \
Example 4b in Section 5.1",
  Cell[BoxData[
      FormBox["", TextForm]], 
    "\.02\[YAcute]\t\[OSlash]\.03\.08\[CapitalCCedilla]`\.03\.08\
\[CapitalCCedilla]`"]
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["\tNote2:",
    FontSlant->"Italic"],
  " One can use ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  " and ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  " to contract nested lists with unequal index dimensions (provided, of \
course, that the indices to be contracted have the same dimension); thus, if \
A has dimensions {2, 3, 3, 4} and B {3, 2, 4}, ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  "[A, {2, 3}] will return a tensor with dimensions {2, 4} and ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  "[A, B, {1, 2}, {3, 1}] will return a tensor with dimensions {3, 4, 4}.",
  Cell[BoxData[
      FormBox["", TextForm]], 
    "\.02\[YAcute]\t\[OSlash]\.03\.08\[CapitalCCedilla]`\.03\.08\
\[CapitalCCedilla]`"]
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell["  1.4  Covariant differentiation of tensors", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell["\<\
\tThe following functions, involving differentiations of tensors, \
are defined in RGTC: \
\>", "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "\t (i) The function  ",
  StyleBox["covD[x_,{i___}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  takes two arguments -- an nth rank tensor, ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and a list of numbers indicating the positions of the ",
  StyleBox["contravariant",
    FontSlant->"Italic"],
  "  (U) components of ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " -- and produces an ",
  StyleBox["n+1",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  " rank tensor: the covariant derivative of ",
  StyleBox["x",
    FontWeight->"Bold"],
  ". ",
  StyleBox["The last index is the differentiation index (d type)",
    FontSlant->"Italic"],
  ". If ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " has only d-type components, the second argument (empty list) can be \
omitted. Examples:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["covD[Rdd]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 3rd rank (ddd type) tensor with components ",
  Cell[BoxData[
      TagBox[
        TagBox[\(R\_\(ab; c\)\),
          DisplayForm],
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["covD[RUddd,{1}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 5th rank (Udddd type) tensor with components ",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(R\^a\)\_\(bcd; e\)\),
          DisplayForm],
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(ii) The function ",
  StyleBox["covDiv[x_,{i___,{s_}}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " acting on an nth rank tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " with contravariant indices at positions {i..., s} returns an ",
  StyleBox["n-1",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  " rank tensor: the covariant ",
  StyleBox["divergence",
    FontSlant->"Italic"],
  " of ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " with respect to the contravariant index at position ",
  StyleBox["s",
    FontSlant->"Italic"],
  ". If there is only one contravariant index, the second argument can be \
written simply {s} rather than {{s}}. Examples (the Einstein summation \
convention holds):"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["covDiv[RUddd,{1}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 3rd rank (ddd type) tensor with components ",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(R\^s\)\_\(abc; s\)\),
          DisplayForm],
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["covDiv[RUdUd,{1,{3}}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 3rd rank (Udd type) tensor with components ",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(\(R\^a\)\_b\^s\)\_\(c; s\)\),
          DisplayForm],
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note1",
    FontSlant->"Italic"],
  ": It is ",
  StyleBox["much",
    FontSlant->"Italic"],
  " more efficient to use ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  "  than to use ",
  StyleBox["covD",
    FontFamily->"Courier"],
  "  followed by ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note2",
    FontSlant->"Italic"],
  ": The functions ",
  StyleBox["covD",
    FontFamily->"Courier"],
  "  and ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  "  can be very slow on high-rank tensors in high dimensions. However, they \
remember their values, so calling them again with the same arguments takes no \
time. "
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t(iii)  The function  ",
  StyleBox["LieD[h_,x_,{i___}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " computes the Lie derivative of the tensor ",
  StyleBox["x",
    FontWeight->"Bold"],
  ", having contravariant indices at index positions ",
  StyleBox["i__",
    FontWeight->"Bold"],
  ", with respect to the contravariant (U type) vector ",
  StyleBox["h",
    FontWeight->"Bold"],
  ". The tensor ",
  StyleBox["x",
    FontWeight->"Bold"],
  " can be a tensor-valued p-form, for example the curvature 2-form ",
  Cell[BoxData[
      \(\(R\^a\)\_b\)]],
  "=",
  Cell[BoxData[
      \(\(R\^a\)\_bcd\)]],
  "d[",
  Cell[BoxData[
      \(x\^c\)]],
  "]\[Wedge]d[",
  Cell[BoxData[
      \(x\^d\)]],
  "]. For totally covariant tensors ",
  StyleBox["x ",
    FontWeight->"Bold"],
  "(or scalars), the last argument (empty list) can be omitted. The result of \
",
  StyleBox["LieD",
    FontWeight->"Bold"],
  " is a tensor of the same rank (and type) as ",
  StyleBox["x",
    FontWeight->"Bold"],
  ". As with ",
  StyleBox["covD",
    FontFamily->"Courier"],
  "  and ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  ",  ",
  StyleBox["LieD",
    FontFamily->"Courier"],
  " remembers its values. Examples:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["LieD[{h1,h2,..,hn},gdd]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 2nd rank (dd type) tensor with components ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          TagBox["",
            DisplayForm], \(h\^s\), \(g\_\(ab, s\)\)}], "+", 
        RowBox[{
          TagBox[
            TagBox[\(\(h\^s\)\_\(, a\)\),
              DisplayForm],
            DisplayForm], \(g\_sb\)}], "+", 
        RowBox[{
          TagBox[
            TagBox[\(\(h\^s\)\_\(, b\)\),
              DisplayForm],
            DisplayForm], \(g\_as\)}]}]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t     ",
  StyleBox["LieD[{h1,h2,..,hn},RUddd,{1}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 4th rank (Uddd type) tensor with components ",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(h\^s\) \(R\^a\)\_\(bcd, s\)\),
          DisplayForm],
        DisplayForm]]],
  "+",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(h\^s\)\_\(, b\)\),
          DisplayForm],
        DisplayForm]]],
  Cell[BoxData[
      \(\(R\^a\)\_scd\)]],
  "+",
  Cell[BoxData[
      RowBox[{
        TagBox[
          TagBox[\(\(h\^s\)\_\(, c\)\),
            DisplayForm],
          DisplayForm], \(\(R\^a\)\_bsd\)}]]],
  "+",
  Cell[BoxData[
      TagBox[
        TagBox[\(\(h\^s\)\_\(, d\)\),
          DisplayForm],
        DisplayForm]]],
  Cell[BoxData[
      \(\(R\^a\)\_bcs\)]],
  StyleBox["- ",
    FontFamily->"Geneva"],
  Cell[BoxData[
      TagBox[
        TagBox[\(\(\(h\^a\)\_\(, s\)\) \(R\^s\)\_bcd\),
          DisplayForm],
        DisplayForm]]],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tThe function  ",
  StyleBox["LieDcartan",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["[",
    FontWeight->"Bold"],
  StyleBox["vector_,form_",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  ", introduced in ",
  ButtonBox["EDC 3.8.5",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/EDC/"], None},
    ButtonStyle->"Hyperlink"],
  ", computes the Lie derivative of the differential form expression ",
  StyleBox["form",
    FontWeight->"Bold"],
  " w.r.t. the ",
  StyleBox["vector",
    FontWeight->"Bold"],
  " using the Cartan identity.  It differs from ",
  StyleBox["LieD",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in that it does not treat lists of forms as components of a tensor. See \
the ",
  ButtonBox["EDCmanual.nb",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/EDC/"], None},
    ButtonStyle->"Hyperlink"],
  " (section 2.5) for details."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16]
}, Closed]],

Cell[TextData[{
  "\t(iv) The function  ",
  StyleBox["Laplacian[x_,{i___}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " computes the Laplacian (",
  Cell[BoxData[
      \(\(\( = x\)\^\(; s\)\)\_\(; s\)\)]],
  ") of the tensor ",
  StyleBox["x",
    FontWeight->"Bold"],
  ", having contravariant indices at index positions ",
  StyleBox["i__",
    FontWeight->"Bold"],
  ". Again, for totally covariant tensors ",
  StyleBox["x",
    FontWeight->"Bold"],
  " (or scalars), the last argument (empty list) can be omitted. The result \
of ",
  StyleBox["Laplacian",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a tensor of the same rank (and type) as ",
  StyleBox["x",
    FontWeight->"Bold"],
  ". "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t(v) The function  ",
  StyleBox["Grad2Norm[x__]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " takes either 1 or 2  ",
  StyleBox["scalar",
    FontSlant->"Italic"],
  " functions as arguments and computes the square norm of the gradient of ",
  StyleBox["x",
    FontFamily->"Courier"],
  " (inner product): ",
  StyleBox["Grad2Norm[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "= ",
  Cell[BoxData[
      \(\(g\^ab\) \(x\_\(, a\)\) x\_\(, b\)\)]],
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "and  ",
  StyleBox["Grad2Norm[x,y]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "= ",
  Cell[BoxData[
      \(\(g\^ab\) \(x\_\(, a\)\) y\_\(, b\)\)]],
  "."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(vi) Using ",
  StyleBox["covD",
    FontFamily->"Courier"],
  " and ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  ",  the function ",
  StyleBox["Bianchi[n_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", for n = 0, 1, 2, computes the full, once, twice contracted Bianchi \
identities and returns a list containing any non-vanishing terms. This list \
is normally the empty list, except when the simplification rules used imply \
relations among the 3rd derivatives of the metric functions (see Example 5). \
"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\tEvaluation of the Bianchi Identities takes long: for the metrics in the \
examples, the time needed to evaluate ",
  StyleBox["Bianchi[1]",
    FontFamily->"Courier"],
  " is ~ 1 - 15 times the time taken by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " to compute all basic tensors. ",
  StyleBox["Bianchi[0]",
    FontFamily->"Courier"],
  " takes considerably longer. (For the Bondi metric the times are ~ 12 min, \
6 min, 7 sec). "
}], "Text",
  FontSize->16]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["  1.5  Index of global names / variables", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox[
  "It is essential that, in choosing coordinates and metric functions, one \
avoids using the symbols listed in this subsection, as they are defined by \
(or have special meanings in) RGTC. In particular, the  single-letter symbols \
R, d, e, as well as the greek letters used in the spin coefficient formalism, \
must be avoided-- see subsection 4.0.",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(i) ",
  StyleBox["Riemannian Geometry tensors / scalars",
    FontSlant->"Italic"],
  " "
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["gdd, gUU, GUdd, Rdddd, RUddd, Rdd, EUd, R, Wdddd, detg\t\t",
    FontWeight->"Bold"],
  "(section 1.1)\n\t",
  StyleBox["epsilon, eta\t\t\t\t\t\t\t\t",
    FontWeight->"Bold"],
  "(section 1.1.1)\n\t",
  StyleBox["\[Omega]Ud \t\t\t\t\t\t\t\t\t",
    FontWeight->"Bold"],
  "(section 5.1)\n\t",
  StyleBox["\[Alpha],\[Beta],",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["...,  ",
    FontWeight->"Bold"],
  StyleBox["\[GothicCapitalD][_],\[CapitalDelta][_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["..., \[CapitalPsi][i], \[CapitalPhi][i, j],",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[CapitalLambda]\t\t\t\t",
    FontWeight->"Bold"],
  "(section 5.1.3)"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(ii) ",
  StyleBox["Tensor operations / functions",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  " \t",
  StyleBox["RGtensors\t\t\t\t\t\t\t     ",
    FontWeight->"Bold"],
  "(section 1.1, 5.1, 5.2)\n\t",
  StyleBox["Raise, Lower, Outer, Transpose",
    FontWeight->"Bold"],
  "\t\t\t\t\t(section 1.2) \n\t",
  StyleBox["Contract, Dot, multiDot",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t(section 1.3) \n\t",
  StyleBox["covD, covDiv, LieD, Laplacian, Grad2Norm, Bianchi",
    FontWeight->"Bold"],
  "\t\t(section 1.4)\n\t",
  StyleBox["HStar",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t\t\t(section 5.1.2)\n\t",
  StyleBox["Classify, Plebanski",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t(section 7)"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(iii) ",
  StyleBox["Other global variables",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Dim, coordList, LineElement",
    FontWeight->"Bold"],
  "\t\t\t\t\t(section 1.1)\n\t",
  StyleBox["simpRules, TrigRules, HypTrigRules, varList",
    FontWeight->"Bold"],
  "\t\t\t(section 4.3)\n\t",
  StyleBox["e[], d[]",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t\t\t(section 5.1)\n\t",
  StyleBox["deList, dxRuleList",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t(section 5.2)"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(iv) ",
  StyleBox["Auxiliary functions",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["zeroQ, nonZeroN, nonZeroL, indepTerms, indepCoefs, FacSimp",
    FontWeight->"Bold"],
  "\t(section 4.2)\n\t",
  StyleBox["FuncRepRules\t\t\t\t\t\t\t    \t    ",
    FontWeight->"Bold"],
  "(section 4.4)\n\t",
  StyleBox["eTO$dx, Clear$dx",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t\t(section 5.1.1)\n\t",
  StyleBox["GenCoef, metric",
    FontWeight->"Bold"],
  "\t\t\t\t\t\t\t\t(section 4.2)"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(v) ",
  StyleBox["Functions / variables defined in ",
    FontSlant->"Italic"],
  StyleBox["EDC",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "  \te.g., ",
  StyleBox["Wedge",
    FontWeight->"Bold"],
  ", ",
  StyleBox["d[]",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DeclareForms",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Bar[], DirectSum",
    FontWeight->"Bold"],
  " etc.\t\tsee  ",
  ButtonBox["EDCmanual.nb",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/EDC/"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Important Note:",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "As the behavior of ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " depends on the values of global variables like ",
  StyleBox["simpRules, deList, dxRuleList,",
    FontWeight->"Bold"],
  " one should normally restart the kernel to do calculations with a new \
metric."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell["  1.6  Input Palettes", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\tThe notebooks ",
  StyleBox["OperatorPLT.nb",
    FontWeight->"Bold"],
  " and ",
  StyleBox["NPsymbolPLT.nb",
    FontWeight->"Bold"],
  " are input palettes. The first contains the more common \
functions/variables used in calculations, so they can be entered easily \
without misspellings, while the second contains the symbols for the \
Newman-Penrose variables nd operators (see section 5.1.3). "
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  "\tIt is assumed that the user has a working knowledge of the basic ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " structures used in symbolic calculations -- in particular that he/she \
understands the properties and use of",
  StyleBox[
  " Lists, Patterns, Functions, Transformation Rules and Definitions",
    FontSlant->"Italic"],
  ".  Although not necessary for elementary evaluations, familiarity with \
these structures is needed to make full use of all features of RG&TC."
}], "Text",
  FontSize->16],

Cell[TextData[{
  StyleBox["\t",
    FontSize->14],
  StyleBox["The executable cells in this notebook must be evaluated ",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox["in the order they appear",
    FontSize->16,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", after placing the file",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" ",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[
  "in an appropriate directory. Also read subsection 4.0 before doing \
calculations with a new metric.",
    FontSize->16,
    FontWeight->"Bold"]
}], "Text",
  FontSize->18,
  FontColor->RGBColor[0, 0, 1]]
}, Open  ]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 2  RG&TC-Code",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(<< EDCRGTCcode.m\)], "Input"],

Cell[TextData[{
  "\tThe file ",
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  must be placed in one of the directories that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks at when searching for extra packages (e.g., /Applications/",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "/AddOns/AutoLoad). Such directories can be found by evaluating the command \
",
  StyleBox["$Path",
    FontWeight->"Bold"],
  ":"
}], "Text",
  FontSize->16],

Cell[BoxData[
    \($Path\)], "Input"],

Cell[TextData[{
  "\t",
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  is the ",
  StyleBox["combined",
    FontSlant->"Italic"],
  " EDC and RGTC code, allowing calculations with differential forms, \
symbolic matrices, etc. (See the  ",
  ButtonBox["EDCmanual.nb",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/EDC/"], None},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tEvaluation of ",
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  erases all previous results. Thus it must be evaluated before any  \
calculations are carried out."
}], "Text",
  FontSize->16]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[{
  " 3  Examples (~ 1.5 min) \n",
  StyleBox["(All timings refer to an Apple iBook G3/900 computer running ",
    FontSize->14,
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontSize->14,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" 3.0 under Mac OS 9.2.2)",
    FontSize->14,
    FontWeight->"Plain"]
}], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\n\t",
  StyleBox["In each case, after ",
    FontSize->16],
  StyleBox["RGtensors",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[
  " is finished, examples of further calculations, using the other functions \
defined in the package, are given.",
    FontSize->16]
}], "Text"],

Cell[BoxData[
    \(\(stTim = AbsoluteTime[]; \)\)], "Input"],

Cell[CellGroupData[{

Cell["\<\
 Example 0: Flat spacetime in rotating prolate spheroidal \
coordinates\
\>", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  StyleBox["\t",
    FontWeight->"Bold"],
  "Transform the flat line element from cylindrical coordinates (\[Rho], z, \
phi) to (\[Lambda], \[Mu], \[Phi]), where ",
  Cell[BoxData[
      \(\[Rho]\^2 = \((\[Lambda]\^2 - 1)\)\ \((1 - \[Mu]\^2)\), \ 
      z = \[Lambda]\ \[Mu], \ phi = \[Phi] + \[CapitalOmega]\ t\)]],
  ":"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(xCoord = {t, \[Phi], \[Lambda], \[Mu]}; \)\)], "Input"],

Cell[BoxData[
    \(\(gFLAT
       = {{1 - \[CapitalOmega]^2\ \((\[Lambda]^2 - 1)\) \((1 - \[Mu]^2)\), 
          \(-\[CapitalOmega]\)\ \((\[Lambda]^2 - 1)\) \((1 - \[Mu]^2)\), 0, 
          0}, {\(-\[CapitalOmega]\)\ \((\[Lambda]^2 - 1)\) \((1 - \[Mu]^2)\), 
          \(-\((\[Lambda]^2 - 1)\)\) \((1 - \[Mu]^2)\), 0, 0}, {0, 0, 
          \(-\((\[Lambda]^2 - \[Mu]^2)\)\)/\((\[Lambda]^2 - 1)\), 0}, {0, 0, 
          0, \(-\((\[Lambda]^2 - \[Mu]^2)\)\)/\((1 - \[Mu]^2)\)}}; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gFLAT, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1 - 
                    \((\(-1\) + \[Lambda]\^2)\)\ \((1 - \[Mu]\^2)\)\ 
                      \[CapitalOmega]\^2\), 
                  \(\(-\((\(-1\) + \[Lambda]\^2)\)\)\ \((1 - \[Mu]\^2)\)\ 
                    \[CapitalOmega]\), "0", "0"},
               
                 {\(\(-\((\(-1\) + \[Lambda]\^2)\)\)\ \((1 - \[Mu]\^2)\)\ 
                    \[CapitalOmega]\), 
                  \(\((1 - \[Lambda]\^2)\)\ \((1 - \[Mu]\^2)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\(\(-\[Lambda]\^2\) + \[Mu]\^2\)\/\(\(-1\) + 
                        \[Lambda]\^2\)\), "0"},
               
                 {"0", "0", "0", 
                  \(\(\(-\[Lambda]\^2\) + \[Mu]\^2\)\/\(1 - \[Mu]\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -1, 
              Plus[ -1, 
                Power[ \[Lambda], 2]], 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Power[ \[CapitalOmega], 2]]], 
          Times[ -1, 
            Plus[ -1, 
              Power[ \[Lambda], 2]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ \[Mu], 2]]], \[CapitalOmega]], 0, 0}, {
          Times[ -1, 
            Plus[ -1, 
              Power[ \[Lambda], 2]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ \[Mu], 2]]], \[CapitalOmega]], 
          Times[ 
            Plus[ 1, 
              Times[ -1, 
                Power[ \[Lambda], 2]]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ \[Mu], 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ -1, 
                Power[ \[Lambda], 2]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ \[Lambda], 2]], 
              Power[ \[Mu], 2]]], 0}, {0, 0, 0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ \[Lambda], 2]], 
              Power[ \[Mu], 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\((1 + \[CapitalOmega]\^2 - \[Lambda]\^2\ \[CapitalOmega]\^2 - 
                \[Mu]\^2\ \[CapitalOmega]\^2 + 
                \[Lambda]\^2\ \[Mu]\^2\ \[CapitalOmega]\^2)\)\ d[t]\^2 - 
            \(\((\[Lambda]\^2 - \[Mu]\^2)\)\ d[\[Lambda]]\^2\)\/\(\(-1\) + 
                \[Lambda]\^2\) - 
            \(\((\(-\[Lambda]\^2\) + \[Mu]\^2)\)\ d[\[Mu]]\^2\)\/\(\(-1\) + 
                \[Mu]\^2\) + 
            2\ \((\(-1\) + \[Lambda]\^2)\)\ \((\(-1\) + \[Mu]\^2)\)\ 
              \[CapitalOmega]\ d[t]\ d[\[Phi]] + 
            \((\(-1\) + \[Lambda]\^2)\)\ \((\(-1\) + \[Mu]\^2)\)\ 
              d[\[Phi]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Plus[ 1, 
                Power[ \[CapitalOmega], 2], 
                Times[ -1, 
                  Power[ \[Lambda], 2], 
                  Power[ \[CapitalOmega], 2]], 
                Times[ -1, 
                  Power[ \[Mu], 2], 
                  Power[ \[CapitalOmega], 2]], 
                Times[ 
                  Power[ \[Lambda], 2], 
                  Power[ \[Mu], 2], 
                  Power[ \[CapitalOmega], 2]]], 
              Power[ 
                d[ t], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ -1, 
                  Power[ \[Lambda], 2]], -1], 
              Plus[ 
                Power[ \[Lambda], 2], 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Power[ 
                d[ \[Lambda]], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ -1, 
                  Power[ \[Mu], 2]], -1], 
              Plus[ 
                Times[ -1, 
                  Power[ \[Lambda], 2]], 
                Power[ \[Mu], 2]], 
              Power[ 
                d[ \[Mu]], 2]], 
            Times[ 2, 
              Plus[ -1, 
                Power[ \[Lambda], 2]], 
              Plus[ -1, 
                Power[ \[Mu], 2]], \[CapitalOmega], 
              d[ t], 
              d[ \[Phi]]], 
            Times[ 
              Plus[ -1, 
                Power[ \[Lambda], 2]], 
              Plus[ -1, 
                Power[ \[Mu], 2]], 
              Power[ 
                d[ \[Phi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", \(-\[CapitalOmega]\), "0", "0"},
               
                 {\(-\[CapitalOmega]\), 
                  \(\(1 + \[CapitalOmega]\^2 - 
                        \[Lambda]\^2\ \[CapitalOmega]\^2 - 
                        \[Mu]\^2\ \[CapitalOmega]\^2 + 
                        \[Lambda]\^2\ \[Mu]\^2\ \[CapitalOmega]\^2\)\/\(\((
                          \(-1\) + \[Lambda]\^2)\)\ 
                        \((\(-1\) + \[Mu]\^2)\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(\(-1\) + \[Lambda]\^2\)\/\(\[Lambda]\^2 - 
                          \[Mu]\^2\)\)\), "0"},
               
                 {"0", "0", "0", 
                  \(\(\(-1\) + \[Mu]\^2\)\/\(\[Lambda]\^2 - \[Mu]\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{1, 
          Times[ -1, \[CapitalOmega]], 0, 0}, {
          Times[ -1, \[CapitalOmega]], 
          Times[ 
            Power[ 
              Plus[ -1, 
                Power[ \[Lambda], 2]], -1], 
            Power[ 
              Plus[ -1, 
                Power[ \[Mu], 2]], -1], 
            Plus[ 1, 
              Power[ \[CapitalOmega], 2], 
              Times[ -1, 
                Power[ \[Lambda], 2], 
                Power[ \[CapitalOmega], 2]], 
              Times[ -1, 
                Power[ \[Mu], 2], 
                Power[ \[CapitalOmega], 2]], 
              Times[ 
                Power[ \[Lambda], 2], 
                Power[ \[Mu], 2], 
                Power[ \[CapitalOmega], 2]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Plus[ -1, 
              Power[ \[Lambda], 2]], 
            Power[ 
              Plus[ 
                Power[ \[Lambda], 2], 
                Times[ -1, 
                  Power[ \[Mu], 2]]], -1]], 0}, {0, 0, 0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ \[Lambda], 2], 
                Times[ -1, 
                  Power[ \[Mu], 2]]], -1], 
            Plus[ -1, 
              Power[ \[Mu], 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0833333333333428072`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.083333333333342807, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0833333333333143855`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.083333333333314386, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0500000000000113686`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.050000000000011369, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Flat Space!"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("Aborted after 0.45 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUdd[\([3, 1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(\(\((\(-1\) + \[Lambda])\)\ \[Lambda]\ \((1 + \[Lambda])\)\ 
        \((\(-1\) + \[Mu])\)\ \((1 + \[Mu])\)\ 
        \[CapitalOmega]\)\/\(\((\[Lambda] - \[Mu])\)\ 
        \((\[Lambda] + \[Mu])\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Check covariant derivatives of metric tensor:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(covD[gdd]\)], "Input"],

Cell[BoxData[
    \({{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
          0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(covD[gUU, {1, 2}]\)], "Input"],

Cell[BoxData[
    \({{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
          0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 1: Schwarzschild", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(xCoord = {t, r, \[Theta], \[CurlyPhi]}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = 
      DiagonalMatrix[{1 - 2  M/r, \(-1\)/\((1 - 2  M/r)\), \(-r^2\), 
          \(-r^2\) Sin[\[Theta]]^2}]; \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[TextData[{
  "\t",
  StyleBox["TrigRules are predefined rules to implement the identities ",
    FontSize->16],
  Cell[BoxData[
      StyleBox[\(Cos[\[Theta]]\^2\),
        FontSize->14]]],
  " ",
  StyleBox["+",
    FontSize->16],
  Cell[BoxData[
      RowBox[{" ", 
        StyleBox[\(Sin[\[Theta]]\^2\),
          FontSize->14]}]]],
  StyleBox["=1 and ",
    FontSize->16],
  Cell[BoxData[
      RowBox[{
        StyleBox[\(Csc[\[Theta]]\^2\),
          FontSize->14], " "}]]],
  StyleBox["- ",
    FontSize->16],
  Cell[BoxData[
      \(Cot[\[Theta]]\^2\)],
    FontSize->14],
  StyleBox["=1.",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(1 - \(2\ M\)\/r\), "0", "0", "0"},
                {"0", \(-\(1\/\(1 - \(2\ M\)\/r\)\)\), "0", "0"},
                {"0", "0", \(-r\^2\), "0"},
                {"0", "0", "0", \(\(-r\^2\)\ Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, 
              Power[ r, -1]]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -2, M, 
                  Power[ r, -1]]], -1]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(r\ d[r]\^2\)\/\(2\ M - r\) - \(\((2\ M - r)\)\ d[t]\^2\)\/r - 
            r\^2\ d[\[Theta]]\^2 - 
            r\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ 
                Plus[ 
                  Times[ 2, M], 
                  Times[ -1, r]], -1], r, 
              Power[ 
                d[ r], 2]], 
            Times[ -1, 
              Plus[ 
                Times[ 2, M], 
                Times[ -1, r]], 
              Power[ r, -1], 
              Power[ 
                d[ t], 2]], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-\(r\/\(2\ M - r\)\)\), "0", "0", "0"},
                {"0", \(-\(\(\(-2\)\ M + r\)\/r\)\), "0", "0"},
                {"0", "0", \(-\(1\/r\^2\)\), "0"},
                {"0", "0", "0", \(-\(Csc[\[Theta]]\^2\/r\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              Plus[ 
                Times[ 2, M], 
                Times[ -1, r]], -1], r], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ r, -1], 
            Plus[ 
              Times[ -2, M], r]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.216667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(2\ M\)\/\(\((2\ M - r)\)\ r\^2\)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Check the full Bianchi identities:",
    FontSize->16]
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[0]] // Timing\)], "Input"],

Cell[BoxData[
    \({1.34999999999999431`\ Second, True}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 1a: Schwarzschild with Cosmological Constant", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(xCoord = {t, r, \[Theta], \[CurlyPhi]}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = 
      DiagonalMatrix[{1 - 2  M/r - \[CapitalLambda]\ r^2/3, 
          \(-1\)/\((1 - 2  M/r - \[CapitalLambda]\ r^2/3)\), \(-r^2\), 
          \(-r^2\) Sin[\[Theta]]^2}]; \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1 - \(2\ M\)\/r - \(r\^2\ \[CapitalLambda]\)\/3\), "0", 
                  "0", "0"},
               
                 {"0", \(-
                    \(1\/\(1 - \(2\ M\)\/r - 
                          \(r\^2\ \[CapitalLambda]\)\/3\)\)\), "0", "0"},
                {"0", "0", \(-r\^2\), "0"},
                {"0", "0", "0", \(\(-r\^2\)\ Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, 
              Power[ r, -1]], 
            Times[ 
              Rational[ -1, 3], 
              Power[ r, 2], \[CapitalLambda]]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -2, M, 
                  Power[ r, -1]], 
                Times[ 
                  Rational[ -1, 3], 
                  Power[ r, 2], \[CapitalLambda]]], -1]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(3\ r\ d[r]\^2\)\/\(6\ M - 3\ r + r\^3\ \[CapitalLambda]\) - 
            \(\((6\ M - 3\ r + r\^3\ \[CapitalLambda])\)\ d[t]\^2\)\/\(3\ r
                \) - r\^2\ d[\[Theta]]\^2 - 
            r\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 3, r, 
              Power[ 
                Plus[ 
                  Times[ 6, M], 
                  Times[ -3, r], 
                  Times[ 
                    Power[ r, 3], \[CapitalLambda]]], -1], 
              Power[ 
                d[ r], 2]], 
            Times[ 
              Rational[ -1, 3], 
              Power[ r, -1], 
              Plus[ 
                Times[ 6, M], 
                Times[ -3, r], 
                Times[ 
                  Power[ r, 3], \[CapitalLambda]]], 
              Power[ 
                d[ t], 2]], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(-\(\(3\ r\)\/\(6\ M - 3\ r + r\^3\ \[CapitalLambda]\)\)\),
                   "0", "0", "0"},
               
                 {"0", \(\(6\ M - 3\ r + r\^3\ \[CapitalLambda]\)\/\(3\ r\)\),
                   "0", "0"},
                {"0", "0", \(-\(1\/r\^2\)\), "0"},
                {"0", "0", "0", \(-\(Csc[\[Theta]]\^2\/r\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -3, r, 
            Power[ 
              Plus[ 
                Times[ 6, M], 
                Times[ -3, r], 
                Times[ 
                  Power[ r, 3], \[CapitalLambda]]], -1]], 0, 0, 0}, {0, 
          Times[ 
            Rational[ 1, 3], 
            Power[ r, -1], 
            Plus[ 
              Times[ 6, M], 
              Times[ -3, r], 
              Times[ 
                Power[ r, 3], \[CapitalLambda]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0333333333333598602`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.03333333333335986, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.0499999999999829469`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.049999999999982947, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Einstein Space"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.35 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd[\([3, 3]\)]\)], "Input"],

Cell[BoxData[
    \(r\^2\ \[CapitalLambda]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(R\)], "Input"],

Cell[BoxData[
    \(\(-4\)\ \[CapitalLambda]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[Rdd - R/Dim\ gdd]\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Check the once-contracted Bianchi identities:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[1]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["Use ",
    FontSize->16],
  StyleBox["multiDot",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" and ",
    FontSize->16],
  StyleBox["Contract",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[
  " to compute the quadratic and cubic Weyl tensors and invariants:",
    FontSize->16]
}], "Subsubsection",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>", General::"\<spell1\>"]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(WUUdd = Raise[Wdddd, 1, 2]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", 
        RowBox[{
          RowBox[{"*", " ", 
            StyleBox["W2",
              FontColor->RGBColor[0, 0, 1]]}], 
          StyleBox["=",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(Weyl\ squared\),
            FontColor->RGBColor[0, 0, 1]]}], " ", "**)"}], 
      RowBox[{
        RowBox[{"W2UUdd", "=", 
          StyleBox[\(multiDot[WUUdd, WUUdd, {3, 1}, {4, 2}]\),
            ShowStringCharacters->True,
            NumberMarks->True]}], 
        StyleBox[";",
          ShowStringCharacters->True,
          NumberMarks->True], "\n", 
        RowBox[{"(*", 
          RowBox[{
            RowBox[{"*", " ", 
              StyleBox["W3",
                FontColor->RGBColor[0, 0, 1]]}], 
            StyleBox["=",
              FontColor->RGBColor[0, 0, 1]], 
            StyleBox[\(Weyl\ cubed\),
              FontColor->RGBColor[0, 0, 1]]}], " ", "**)"}], 
        RowBox[{"W3UUdd", "=", 
          StyleBox[\(multiDot[W2UUdd, WUUdd, {3, 1}, {4, 2}]\),
            ShowStringCharacters->True,
            NumberMarks->True]}], 
        StyleBox[";",
          ShowStringCharacters->True,
          NumberMarks->True]}]}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{
      RowBox[{"quadraticInv", "=", 
        RowBox[{
          StyleBox["Contract",
            ShowStringCharacters->True,
            NumberMarks->True], 
          StyleBox["[",
            ShowStringCharacters->True,
            NumberMarks->True], \(W2UUdd, {1, 3}, {2, 4}\), "]"}]}], ";", 
      "\n", 
      RowBox[{"cubicInv", "=", 
        RowBox[{
          StyleBox["Contract",
            ShowStringCharacters->True,
            NumberMarks->True], 
          StyleBox["[",
            ShowStringCharacters->True,
            NumberMarks->True], \(W3UUdd, {1, 3}, {2, 4}\), "]"}]}], ";"}]], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \({quadraticInv, cubicInv, quadraticInv^3/cubicInv^2}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(48\ M\^2\)\/r\^6, \(-\(\(96\ M\^3\)\/r\^9\)\), 12}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["The invariants can be computed directly using ",
    FontSize->16],
  StyleBox["multiDot",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[":",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"{", 
      StyleBox[\(multiDot[WUUdd, WUUdd, {1, 3}, {2, 4}, {3, 1}, {4, 2}], 
        multiDot[W2UUdd, WUUdd, {1, 3}, {2, 4}, {3, 1}, {4, 2}]\),
        ShowStringCharacters->True,
        NumberMarks->True], 
      StyleBox["}",
        ShowStringCharacters->True,
        NumberMarks->True]}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(48\ M\^2\)\/r\^6, \(-\(\(96\ M\^3\)\/r\^9\)\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(On[General::"\<spell\>", General::"\<spell1\>"]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 2: Robertson-Walker", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(xCoord = {t, r, \[Theta], \[CurlyPhi]}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = {{1, 0, 0, 0}, {0, \(-a[t]^2\)/\((1 - k\ r^2)\), 0, 0}, {0, 0, 
          \(-a[t]^2\) r^2, 0}, {0, 0, 0, \(-r^2\) a[t]^2  Sin[\[Theta]]^2}}; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-\(a[t]\^2\/\(1 - k\ r\^2\)\)\), "0", "0"},
                {"0", "0", \(\(-r\^2\)\ a[t]\^2\), "0"},
                {"0", "0", "0", \(\(-r\^2\)\ a[t]\^2\ Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{1, 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -1, k, 
                  Power[ r, 2]]], -1], 
            Power[ 
              a[ t], 2]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, 2], 
            Power[ 
              a[ t], 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, 2], 
            Power[ 
              a[ t], 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(a[t]\^2\ d[r]\^2\)\/\(\(-1\) + k\ r\^2\) + d[t]\^2 - 
            r\^2\ a[t]\^2\ d[\[Theta]]\^2 - 
            r\^2\ a[t]\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ 
                Plus[ -1, 
                  Times[ k, 
                    Power[ r, 2]]], -1], 
              Power[ 
                a[ t], 2], 
              Power[ 
                d[ r], 2]], 
            Power[ 
              d[ t], 2], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                a[ t], 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                a[ t], 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(\(\(-1\) + k\ r\^2\)\/a[t]\^2\), "0", "0"},
                {"0", "0", \(-\(1\/\(r\^2\ a[t]\^2\)\)\), "0"},
                {"0", "0", "0", \(-\(Csc[\[Theta]]\^2\/\(r\^2\ a[t]\^2\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{1, 0, 0, 0}, {0, 
          Times[ 
            Plus[ -1, 
              Times[ k, 
                Power[ r, 2]]], 
            Power[ 
              a[ t], -2]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ r, -2], 
            Power[ 
              a[ t], -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ r, -2], 
            Power[ 
              a[ t], -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.0500000000000113686`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.050000000000011369, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Conformally Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.333333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{"-", 
      FractionBox[
        RowBox[{"3", " ", 
          RowBox[{
            SuperscriptBox["a", "\[DoublePrime]",
              MultilineFunction->None], "[", "t", "]"}]}], \(a[t]\)]}]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EUd[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    FractionBox[
      RowBox[{"3", " ", 
        RowBox[{"(", 
          RowBox[{"k", "+", 
            SuperscriptBox[
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], "2"]}], ")"}]}], 
      \(a[t]\^2\)]], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Check the twice-contracted Bianchi identities:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[2]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 3: Conformally Flat 5-dim metrics", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(xCoord = {x1, x2, x3, x4, x5}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = \[CapitalOmega][x1, x2, x3, x4, x5]^2  IdentityMatrix[5]; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["(1) General Case:",
    FontSize->16]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0", "0", "0", 
                  "0"},
               
                 {"0", \(\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0", "0", 
                  "0"},
               
                 {"0", "0", \(\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0", 
                  "0"},
               
                 {"0", "0", "0", \(\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), 
                  "0"},
               
                 {"0", "0", "0", "0", 
                  \(\[CapitalOmega][x1, x2, x3, x4, x5]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], 2], 0, 0, 0, 0}, {0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], 2], 0, 0, 0}, {0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], 2], 0, 0}, {0, 0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], 2], 0}, {0, 0, 0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], 2]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(d[x1]\^2\ \[CapitalOmega][x1, x2, x3, x4, x5]\^2 + 
            d[x2]\^2\ \[CapitalOmega][x1, x2, x3, x4, x5]\^2 + 
            d[x3]\^2\ \[CapitalOmega][x1, x2, x3, x4, x5]\^2 + 
            d[x4]\^2\ \[CapitalOmega][x1, x2, x3, x4, x5]\^2 + 
            d[x5]\^2\ \[CapitalOmega][x1, x2, x3, x4, x5]\^2\),
          (Short[ #, 40]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ 
                d[ x1], 2], 
              Power[ 
                \[CapitalOmega][ x1, x2, x3, x4, x5], 2]], 
            Times[ 
              Power[ 
                d[ x2], 2], 
              Power[ 
                \[CapitalOmega][ x1, x2, x3, x4, x5], 2]], 
            Times[ 
              Power[ 
                d[ x3], 2], 
              Power[ 
                \[CapitalOmega][ x1, x2, x3, x4, x5], 2]], 
            Times[ 
              Power[ 
                d[ x4], 2], 
              Power[ 
                \[CapitalOmega][ x1, x2, x3, x4, x5], 2]], 
            Times[ 
              Power[ 
                d[ x5], 2], 
              Power[ 
                \[CapitalOmega][ x1, x2, x3, x4, x5], 2]]], 40]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0", "0", 
                  "0", "0"},
               
                 {"0", \(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0", 
                  "0", "0"},
               
                 {"0", "0", \(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), 
                  "0", "0"},
               
                 {"0", "0", "0", 
                  \(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^2\), "0"},
               
                 {"0", "0", "0", "0", 
                  \(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], -2], 0, 0, 0, 0}, {0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], -2], 0, 0, 0}, {0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], -2], 0, 0}, {0, 0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], -2], 0}, {0, 0, 0, 0, 
          Power[ 
            \[CapitalOmega][ x1, x2, x3, x4, x5], -2]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.133333333333354175`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.13333333333335418, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.299999999999982946`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.29999999999998295, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0500000000000113686`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.050000000000011369, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Conformally Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.766667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUdd[\([2, 2, 2]\)]\)], "Input"],

Cell[BoxData[
    FractionBox[
      RowBox[{
        SuperscriptBox["\[CapitalOmega]", 
          TagBox[\((0, 1, 0, 0, 0)\),
            Derivative],
          MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), "]"}], 
      \(\[CapitalOmega][x1, x2, x3, x4, x5]\)]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EUd[\([1, 1]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{\(1\/\[CapitalOmega][x1, x2, x3, x4, x5]\^4\), 
      RowBox[{"(", 
        RowBox[{"3", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{\(\[CapitalOmega][x1, x2, x3, x4, x5]\), " ", 
                RowBox[{
                  SuperscriptBox["\[CapitalOmega]", 
                    TagBox[\((0, 0, 0, 0, 2)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), 
                  "]"}]}], "+", 
              RowBox[{\(\[CapitalOmega][x1, x2, x3, x4, x5]\), " ", 
                RowBox[{
                  SuperscriptBox["\[CapitalOmega]", 
                    TagBox[\((0, 0, 0, 2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), 
                  "]"}]}], "+", 
              RowBox[{\(\[CapitalOmega][x1, x2, x3, x4, x5]\), " ", 
                RowBox[{
                  SuperscriptBox["\[CapitalOmega]", 
                    TagBox[\((0, 0, 2, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), 
                  "]"}]}], "+", 
              RowBox[{\(\[CapitalOmega][x1, x2, x3, x4, x5]\), " ", 
                RowBox[{
                  SuperscriptBox["\[CapitalOmega]", 
                    TagBox[\((0, 2, 0, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), 
                  "]"}]}], "+", 
              RowBox[{"2", " ", 
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox["\[CapitalOmega]", 
                      TagBox[\((1, 0, 0, 0, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(x1, x2, x3, x4, x5\), 
                    "]"}], "2"]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Of the 5^4 components in Rdddd",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(nonZeroN[Rdddd]\)], "Input"],

Cell[BoxData[
    \(280\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["are non-zero, of which ",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[nonZeroL[Rdddd]]\)], "Input"],

Cell[BoxData[
    \(40\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["are different. Of these ",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[indepTerms[Rdddd]]\)], "Input"],

Cell[BoxData[
    \(20\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["are independent (modulo numerical factors).",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t",
  StyleBox["Useful Hint: To find which components of ",
    FontSize->16],
  StyleBox["Rdddd",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" equal a particular expression in ",
    FontSize->16],
  StyleBox["nonZeroL",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[", use the ",
    FontSize->16],
  StyleBox["Mathematica",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[" function ",
    FontSize->16],
  StyleBox["Position",
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[":",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Position[Rdddd, \(nonZeroL[Rdddd]\)[\([1]\)]]\)], "Input"],

Cell[BoxData[
    \({{1, 4, 1, 5}, {1, 5, 1, 4}, {2, 4, 2, 5}, {2, 5, 2, 4}, {3, 4, 3, 5}, {
        3, 5, 3, 4}, {4, 1, 5, 1}, {4, 2, 5, 2}, {4, 3, 5, 3}, {5, 1, 4, 1}, {
        5, 2, 4, 2}, {5, 3, 4, 3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdddd[\([1, 4, 1, 5]\)] === \(nonZeroL[Rdddd]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdddd[\([2, 4, 2, 5]\)] === \(nonZeroL[Rdddd]\)[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["(2) Constant Curvature Case:",
    FontSize->16]
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[
      g /. {\[CapitalOmega][x1, x2, x3, x4, x5] -> 
            1/\((1 + K/4 \((x1^2 + x2^2 + x3^2 + x4^2 + x5^2)\))\)}, xCoord]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1\/\((1 + 
                            1\/4\ K\ \((x1\^2 + x2\^2 + x3\^2 + x4\^2 + x5\^2)
                              \))\)\^2\), "0", "0", "0", "0"},
               
                 {"0", \(1
                      \/\((1 + 
                            1\/4\ K\ \((x1\^2 + x2\^2 + x3\^2 + x4\^2 + x5\^2)
                              \))\)\^2\), "0", "0", "0"},
               
                 {"0", "0", 
                  \(1\/\((1 + 
                            1\/4\ K\ \((x1\^2 + x2\^2 + x3\^2 + x4\^2 + x5\^2)
                              \))\)\^2\), "0", "0"},
               
                 {"0", "0", "0", 
                  \(1\/\((1 + 
                            1\/4\ K\ \((x1\^2 + x2\^2 + x3\^2 + x4\^2 + x5\^2)
                              \))\)\^2\), "0"},
               
                 {"0", "0", "0", "0", 
                  \(1\/\((1 + 
                            1\/4\ K\ \((x1\^2 + x2\^2 + x3\^2 + x4\^2 + x5\^2)
                              \))\)\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Power[ 
            Plus[ 1, 
              Times[ 
                Rational[ 1, 4], K, 
                Plus[ 
                  Power[ x1, 2], 
                  Power[ x2, 2], 
                  Power[ x3, 2], 
                  Power[ x4, 2], 
                  Power[ x5, 2]]]], -2], 0, 0, 0, 0}, {0, 
          Power[ 
            Plus[ 1, 
              Times[ 
                Rational[ 1, 4], K, 
                Plus[ 
                  Power[ x1, 2], 
                  Power[ x2, 2], 
                  Power[ x3, 2], 
                  Power[ x4, 2], 
                  Power[ x5, 2]]]], -2], 0, 0, 0}, {0, 0, 
          Power[ 
            Plus[ 1, 
              Times[ 
                Rational[ 1, 4], K, 
                Plus[ 
                  Power[ x1, 2], 
                  Power[ x2, 2], 
                  Power[ x3, 2], 
                  Power[ x4, 2], 
                  Power[ x5, 2]]]], -2], 0, 0}, {0, 0, 0, 
          Power[ 
            Plus[ 1, 
              Times[ 
                Rational[ 1, 4], K, 
                Plus[ 
                  Power[ x1, 2], 
                  Power[ x2, 2], 
                  Power[ x3, 2], 
                  Power[ x4, 2], 
                  Power[ x5, 2]]]], -2], 0}, {0, 0, 0, 0, 
          Power[ 
            Plus[ 1, 
              Times[ 
                Rational[ 1, 4], K, 
                Plus[ 
                  Power[ x1, 2], 
                  Power[ x2, 2], 
                  Power[ x3, 2], 
                  Power[ x4, 2], 
                  Power[ x5, 2]]]], -2]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(16\ d[x1]\^2\)\/\((
                  4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)
                  \)\^2 + 
            \(16\ d[x2]\^2\)\/\((
                  4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)
                  \)\^2 + 
            \(16\ d[x3]\^2\)\/\((
                  4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)
                  \)\^2 + 
            \(16\ d[x4]\^2\)\/\((
                  4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)
                  \)\^2 + 
            \(16\ d[x5]\^2\)\/\((
                  4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)
                  \)\^2\),
          (Short[ #, 40]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 16, 
              Power[ 
                Plus[ 4, 
                  Times[ K, 
                    Power[ x1, 2]], 
                  Times[ K, 
                    Power[ x2, 2]], 
                  Times[ K, 
                    Power[ x3, 2]], 
                  Times[ K, 
                    Power[ x4, 2]], 
                  Times[ K, 
                    Power[ x5, 2]]], -2], 
              Power[ 
                d[ x1], 2]], 
            Times[ 16, 
              Power[ 
                Plus[ 4, 
                  Times[ K, 
                    Power[ x1, 2]], 
                  Times[ K, 
                    Power[ x2, 2]], 
                  Times[ K, 
                    Power[ x3, 2]], 
                  Times[ K, 
                    Power[ x4, 2]], 
                  Times[ K, 
                    Power[ x5, 2]]], -2], 
              Power[ 
                d[ x2], 2]], 
            Times[ 16, 
              Power[ 
                Plus[ 4, 
                  Times[ K, 
                    Power[ x1, 2]], 
                  Times[ K, 
                    Power[ x2, 2]], 
                  Times[ K, 
                    Power[ x3, 2]], 
                  Times[ K, 
                    Power[ x4, 2]], 
                  Times[ K, 
                    Power[ x5, 2]]], -2], 
              Power[ 
                d[ x3], 2]], 
            Times[ 16, 
              Power[ 
                Plus[ 4, 
                  Times[ K, 
                    Power[ x1, 2]], 
                  Times[ K, 
                    Power[ x2, 2]], 
                  Times[ K, 
                    Power[ x3, 2]], 
                  Times[ K, 
                    Power[ x4, 2]], 
                  Times[ K, 
                    Power[ x5, 2]]], -2], 
              Power[ 
                d[ x4], 2]], 
            Times[ 16, 
              Power[ 
                Plus[ 4, 
                  Times[ K, 
                    Power[ x1, 2]], 
                  Times[ K, 
                    Power[ x2, 2]], 
                  Times[ K, 
                    Power[ x3, 2]], 
                  Times[ K, 
                    Power[ x4, 2]], 
                  Times[ K, 
                    Power[ x5, 2]]], -2], 
              Power[ 
                d[ x5], 2]]], 40]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1\/16\ 
                    \((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + 
                          K\ x5\^2)\)\^2\), "0", "0", "0", "0"},
               
                 {"0", \(1\/16\ 
                    \((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + 
                          K\ x5\^2)\)\^2\), "0", "0", "0"},
               
                 {"0", "0", 
                  \(1\/16\ 
                    \((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + 
                          K\ x5\^2)\)\^2\), "0", "0"},
               
                 {"0", "0", "0", 
                  \(1\/16\ 
                    \((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + 
                          K\ x5\^2)\)\^2\), "0"},
               
                 {"0", "0", "0", "0", 
                  \(1\/16\ 
                    \((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + 
                          K\ x5\^2)\)\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Plus[ 4, 
                Times[ K, 
                  Power[ x1, 2]], 
                Times[ K, 
                  Power[ x2, 2]], 
                Times[ K, 
                  Power[ x3, 2]], 
                Times[ K, 
                  Power[ x4, 2]], 
                Times[ K, 
                  Power[ x5, 2]]], 2]], 0, 0, 0, 0}, {0, 
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Plus[ 4, 
                Times[ K, 
                  Power[ x1, 2]], 
                Times[ K, 
                  Power[ x2, 2]], 
                Times[ K, 
                  Power[ x3, 2]], 
                Times[ K, 
                  Power[ x4, 2]], 
                Times[ K, 
                  Power[ x5, 2]]], 2]], 0, 0, 0}, {0, 0, 
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Plus[ 4, 
                Times[ K, 
                  Power[ x1, 2]], 
                Times[ K, 
                  Power[ x2, 2]], 
                Times[ K, 
                  Power[ x3, 2]], 
                Times[ K, 
                  Power[ x4, 2]], 
                Times[ K, 
                  Power[ x5, 2]]], 2]], 0, 0}, {0, 0, 0, 
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Plus[ 4, 
                Times[ K, 
                  Power[ x1, 2]], 
                Times[ K, 
                  Power[ x2, 2]], 
                Times[ K, 
                  Power[ x3, 2]], 
                Times[ K, 
                  Power[ x4, 2]], 
                Times[ K, 
                  Power[ x5, 2]]], 2]], 0}, {0, 0, 0, 0, 
          Times[ 
            Rational[ 1, 16], 
            Power[ 
              Plus[ 4, 
                Times[ K, 
                  Power[ x1, 2]], 
                Times[ K, 
                  Power[ x2, 2]], 
                Times[ K, 
                  Power[ x3, 2]], 
                Times[ K, 
                  Power[ x4, 2]], 
                Times[ K, 
                  Power[ x5, 2]]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.166666666666685614`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.16666666666668561, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.133333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.13333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0833333333333143855`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.083333333333314386, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.0833333333333428072`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.083333333333342807, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Conformally Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Einstein Space"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("Space of Constant Curvature!"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.616667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 2]\)]\)], "Input"],

Cell[BoxData[
    \(\(16\ K
        \)\/\((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)\)\^2
        \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(R\)], "Input"],

Cell[BoxData[
    \(20\ K\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Of the 5^4 components in RUddd",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(nonZeroN[RUddd]\)], "Input"],

Cell[BoxData[
    \(40\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox[
  "are non-zero, of which the following are independent (modulo numerical \
factors):",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[RUddd]\)], "Input"],

Cell[BoxData[
    \({K\/\((4 + K\ x1\^2 + K\ x2\^2 + K\ x3\^2 + K\ x4\^2 + K\ x5\^2)\)\^2}
      \)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
" Example 4: Kerr in Boyer-Lindquist coordinates (Cos[\[Theta]] -> x): \
Finding Killing Vectors"], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Examples 4a, 4b, 4c are in section 5.1",
    FontSize->16]
}], "Text",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(Clear[x]; xCoord = {t, r, x, \[CurlyPhi]}; \)], "Input"],

Cell[BoxData[
    \(Sigma = r^2 + a^2  x^2; Delta = r^2 + a^2 - 2  M\ r; \)], "Input"],

Cell[BoxData[
    \(\(g = {{1 - 2  M\ r/Sigma, 0, 0, 2  a\ M\ r \((1 - x^2)\)/Sigma}, {0, 
          \(-Sigma\)/Delta, 0, 0}, {0, 0, \(-Sigma\)/\((1 - x^2)\), 0}, {
          2  a\ M\ r \((1 - x^2)\)/Sigma, 0, 0, 
          \(-\((1 - x^2)\)\) 
            \((r^2 + a^2 + 2  a^2  M\ r \((1 - x^2)\)/Sigma)\)}}; \)\)], 
  "Input"],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1 - \(2\ M\ r\)\/\(r\^2 + a\^2\ x\^2\)\), "0", "0", 
                  \(\(2\ a\ M\ r\ \((1 - x\^2)\)\)\/\(r\^2 + a\^2\ x\^2\)\)},
               
                 {"0", \(\(\(-r\^2\) - a\^2\ x\^2\)\/\(a\^2 - 2\ M\ r + 
                        r\^2\)\), "0", "0"},
                {"0", "0", \(\(\(-r\^2\) - a\^2\ x\^2\)\/\(1 - x\^2\)\), "0"},
                
               
                 {\(\(2\ a\ M\ r\ \((1 - x\^2)\)\)\/\(r\^2 + a\^2\ x\^2\)\), 
                  "0", "0", 
                  \(\((\(-1\) + x\^2)\)\ 
                    \((a\^2 + r\^2 + 
                        \(2\ a\^2\ M\ r\ \((1 - x\^2)\)\)\/\(r\^2 + 
                            a\^2\ x\^2\))\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, r, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1]]], 0, 0, 
          Times[ 2, a, M, r, 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]]}, {0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ r, 2]], 
              Times[ -1, 
                Power[ a, 2], 
                Power[ x, 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ r, 2]], 
              Times[ -1, 
                Power[ a, 2], 
                Power[ x, 2]]]], 0}, {
          Times[ 2, a, M, r, 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0, 
          Times[ 
            Plus[ -1, 
              Power[ x, 2]], 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2], 
              Times[ 2, 
                Power[ a, 2], M, r, 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ x, 2]]], 
                Power[ 
                  Plus[ 
                    Power[ r, 2], 
                    Times[ 
                      Power[ a, 2], 
                      Power[ x, 2]]], -1]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((r\^2 + a\^2\ x\^2)\)\ d[r]\^2\)\/\(a\^2 - 2\ M\ r + 
                  r\^2\)\) - 
            \(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ d[t]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\) + 
            \(\((r\^2 + a\^2\ x\^2)\)\ d[x]\^2\)\/\(\(-1\) + x\^2\) - 
            \(4\ a\ M\ r\ \((\(-1\) + x\^2)\)\ d[t]\ 
                d[\[CurlyPhi]]\)\/\(r\^2 + a\^2\ x\^2\) + 
            \(\((\(-1\) + x\^2)\)\ 
                \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                    2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\)\ 
                d[\[CurlyPhi]]\^2\)\/\(r\^2 + a\^2\ x\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ r], 2]], 
            Times[ -1, 
              Plus[ 
                Times[ 2, M, r], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, 
                  Power[ x, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ x], 2]], 
            Times[ -4, a, M, r, 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              d[ t], 
              d[ \[CurlyPhi]]], 
            Times[ 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ x, 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                        2\ a\^2\ M\ r\ x\^2 + 
                        a\^2\ r\^2\ x\^2\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\), "0", "0", 
                  \(\(2\ a\ M\ r\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\)},
               
                 {"0", \(-
                    \(\(a\^2 - 2\ M\ r + r\^2\)\/\(r\^2 + a\^2\ x\^2\)\)\), 
                  "0", "0"},
                {"0", "0", \(\(\(-1\) + x\^2\)\/\(r\^2 + a\^2\ x\^2\)\), "0"},
                
               
                 {\(\(2\ a\ M\ r\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\), "0", "0", 
                  \(\(\(-2\)\ M\ r + r\^2 + 
                        a\^2\ x\^2\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
                        \((\(-1\) + x\^2)\)\ \((r\^2 + a\^2\ x\^2)\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ 2, 
                Power[ a, 2], M, r], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2]], 
              Power[ r, 4], 
              Times[ 
                Power[ a, 4], 
                Power[ x, 2]], 
              Times[ -2, 
                Power[ a, 2], M, r, 
                Power[ x, 2]], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2], 
                Power[ x, 2]]]], 0, 0, 
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]]}, {0, 
          Times[ -1, 
            Plus[ 
              Power[ a, 2], 
              Times[ -2, M, r], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0}, {0, 0, 
          Times[ 
            Plus[ -1, 
              Power[ x, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0}, {
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ -1, 
                Power[ x, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ -2, M, r], 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.166666666666657192`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.16666666666665719, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.25`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.25, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.26666666666667993`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.26666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.483333333333320069`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.48333333333332007, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 1.26667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUdd[\([2, 2, 3]\)]\)], "Input"],

Cell[BoxData[
    \(\(a\^2\ x\)\/\(r\^2 + a\^2\ x\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 3]\)]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(a\^2\ M\ \((3\ a\^2 - 2\ M\ r + 3\ r\^2)\)\ x\ \((
            \(-3\)\ r\^2 + a\^2\ x\^2)\)\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^3\)\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Check the once-contracted Bianchi identities:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[1]] // Timing\)], "Input"],

Cell[BoxData[
    \({1.84999999999999431`\ Second, True}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Bianchi[1]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" calls ",
    FontSize->16],
  StyleBox["covD",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" and ",
    FontSize->16],
  StyleBox["covDiv",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[
  " which remember their values; therefore, calling it again takes no time:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[1]] // Timing\)], "Input"],

Cell[BoxData[
    \({0.0166666666666799301`\ Second, True}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding Killing Vectors", "Subsection",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t",
  StyleBox["Assume (",
    FontSize->16],
  StyleBox["r, x",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[") dependence for the contravariant components of ",
    FontSize->16],
  StyleBox["\[Xi]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[":",
    FontSize->16]
}], "Text",
  FontSize->16,
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(\[Xi]U
       = {\(\[Xi][1]\)[r, x], \(\[Xi][2]\)[r, x], \(\[Xi][3]\)[r, x], 
        \(\[Xi][4]\)[r, x]}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(covD\[Xi]dd = covD[gdd.\[Xi]U]; \) // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.583333333333314385`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"KillingEquations", "=", 
      RowBox[{"Collect", "[", 
        RowBox[{
        \(indepTerms[Flatten[FacSimp[covD\[Xi]dd + Transpose[covD\[Xi]dd]]]]
            \), ",", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                SuperscriptBox[\(\[Xi][_]\), 
                  TagBox[\((__)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}], ",", 
              \(\(\[Xi][_]\)[r, x]\)}], "}"}], ",", "Factor"}], "]"}]}]], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \(\(M\ \((r - a\ x)\)\ \((r + a\ x)\)\ 
              \(\[Xi][2]\)[r, x]\)\/\((r\^2 + a\^2\ x\^2)\)\^2 + 
          \(2\ a\^2\ M\ r\ x\ \(\[Xi][3]\)[r, x]\)\/\((r\^2 + a\^2\ x\^2)\)\^2
              \), ",", 
        \(\(a\ M\ \((\(-1\) + x)\)\ \((1 + x)\)\ \((\(-r\) + a\ x)\)\ 
              \((r + a\ x)\)\ \(\[Xi][2]\)[r, x]\)\/\((r\^2 + a\^2\ x\^2)\)\^2
               + \(2\ a\ M\ r\ \((a\^2 + r\^2)\)\ x\ 
              \(\[Xi][3]\)[r, x]\)\/\((r\^2 + a\^2\ x\^2)\)\^2\), ",", 
        \(\(-\(\(\((\(-1\) + x)\)\ \((1 + x)\)\ 
                  \((a\^2\ M\ r\^2 - r\^5 - a\^4\ M\ x\^2 - 
                      a\^2\ M\ r\^2\ x\^2 - 2\ a\^2\ r\^3\ x\^2 + 
                      a\^4\ M\ x\^4 - a\^4\ r\ x\^4)\)\ 
                  \(\[Xi][2]\)[r, x]\)\/\((r\^2 + a\^2\ x\^2)\)\^2\)\) + 
          \(1\/\((r\^2 + a\^2\ x\^2)\)\^2\((
            x\ \((2\ a\^4\ M\ r + 4\ a\^2\ M\ r\^3 + a\^2\ r\^4 + r\^6 + 
                2\ a\^4\ r\^2\ x\^2 - 4\ a\^2\ M\ r\^3\ x\^2 + 
                2\ a\^2\ r\^4\ x\^2 + a\^6\ x\^4 - 2\ a\^4\ M\ r\ x\^4 + 
                a\^4\ r\^2\ x\^4)\)\ \(\[Xi][3]\)[r, x])\)\)\), ",", 
        RowBox[{
        \(\(r\ \(\[Xi][2]\)[r, x]\)\/\(\((\(-1\) + x)\)\ \((1 + x)\)\)\), "-",
           \(\(\((a\^2 + r\^2)\)\ x\ 
                \(\[Xi][3]\)[r, x]\)\/\(\((\(-1\) + x)\)\^2\ 
                \((1 + x)\)\^2\)\), "+", 
          FractionBox[
            RowBox[{\((r\^2 + a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][3]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(\((\(-1\) + x)\)\ \((1 + x)\)\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{\((2\ M\ r - r\^2 - a\^2\ x\^2)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][1]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(r\^2 + a\^2\ x\^2\)]}], "-", 
          FractionBox[
            RowBox[{
            "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
              \((1 + x)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{
              "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
                \((1 + x)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][1]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(r\^2 + a\^2\ x\^2\)]}], "+", 
          FractionBox[
            RowBox[{
            \((\(-1\) + x)\), " ", \((1 + x)\), " ", 
              \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                  2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
        \(-\(\(\((\(-a\^2\)\ r + M\ r\^2 - a\^2\ M\ x\^2 + a\^2\ r\ x\^2)\)\ 
                  \(\[Xi][2]\)[r, x]\)\/\((a\^2 - 2\ M\ r + r\^2)\)\^2\)\), 
          "+", \(\(a\^2\ x\ \(\[Xi][3]\)[r, x]\)\/\(a\^2 - 2\ M\ r + r\^2\)\),
           "+", 
          FractionBox[
            RowBox[{\((r\^2 + a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][2]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(a\^2 - 2\ M\ r + r\^2\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{\((r\^2 + a\^2\ x\^2)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][2]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(a\^2 - 2\ M\ r + r\^2\)]}], "+", 
          FractionBox[
            RowBox[{\((r\^2 + a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][3]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(\((\(-1\) + x)\)\ \((1 + x)\)\)]}], ",", 
        RowBox[{
          FractionBox[
            RowBox[{\((2\ M\ r - r\^2 - a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][1]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)], "+", 
          FractionBox[
            RowBox[{
            "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
              \((1 + x)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{
              "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
                \((1 + x)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][1]\), 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(r\^2 + a\^2\ x\^2\)]}], "+", 
          FractionBox[
            RowBox[{
            \((\(-1\) + x)\), " ", \((1 + x)\), " ", 
              \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                  2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[%]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(10\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[
      Take[KillingEquations, 2] == 0, {\(\[Xi][2]\)[r, x], 
        \(\[Xi][3]\)[r, x]}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{\(\[Xi][2]\)[r, x] \[Rule] 0, \(\[Xi][3]\)[r, x] \[Rule] 0}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["The function ",
    FontSize->16],
  StyleBox["FuncRepRules",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[
  " generates replacement rules for replacing a function (and its \
derivatives) by its values; see section 4.4.",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Collect", "[", 
      RowBox[{
      \(indepTerms[
          FacSimp[\(KillingEquations /. 
                FuncRepRules[\(\[Xi][2]\)[r, x], 0]\) /. 
              FuncRepRules[\(\[Xi][3]\)[r, x], 0]]]\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][_]\), 
                TagBox[\((__)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], ",", 
            \(\(\[Xi][_]\)[r, x]\)}], "}"}], ",", "Factor"}], "]"}]], "Input",\

  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{\((2\ M\ r - r\^2 - a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][1]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)], "+", 
          FractionBox[
            RowBox[{
            "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
              \((1 + x)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{
              "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
                \((1 + x)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][1]\), 
                    TagBox[\((0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(r\^2 + a\^2\ x\^2\)]}], "+", 
          FractionBox[
            RowBox[{
            \((\(-1\) + x)\), " ", \((1 + x)\), " ", 
              \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                  2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
          FractionBox[
            RowBox[{\((2\ M\ r - r\^2 - a\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][1]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)], "+", 
          FractionBox[
            RowBox[{
            "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
              \((1 + x)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}], ",", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              RowBox[{
              "2", " ", "a", " ", "M", " ", "r", " ", \((\(-1\) + x)\), " ", 
                \((1 + x)\), " ", 
                RowBox[{
                  SuperscriptBox[\(\[Xi][1]\), 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, x\), "]"}]}], 
              \(r\^2 + a\^2\ x\^2\)]}], "+", 
          FractionBox[
            RowBox[{
            \((\(-1\) + x)\), " ", \((1 + x)\), " ", 
              \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                  2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\), " ", 
              RowBox[{
                SuperscriptBox[\(\[Xi][4]\), 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, x\), "]"}]}], 
            \(r\^2 + a\^2\ x\^2\)]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Solve", "[", 
      RowBox[{\(% == 0\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][1]\), 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], ",", 
            RowBox[{
              SuperscriptBox[\(\[Xi][4]\), 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], ",", 
            RowBox[{
              SuperscriptBox[\(\[Xi][1]\), 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], ",", 
            RowBox[{
              SuperscriptBox[\(\[Xi][4]\), 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}]}], "}"}]}], 
      "]"}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][1]\), 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], "\[Rule]", 
            "0"}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][4]\), 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], "\[Rule]", 
            "0"}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][1]\), 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], "\[Rule]", 
            "0"}], ",", 
          RowBox[{
            RowBox[{
              SuperscriptBox[\(\[Xi][4]\), 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, x\), "]"}], "\[Rule]", 
            "0"}]}], "}"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[
      \(\(\(KillingEquations /. FuncRepRules[\(\[Xi][1]\)[r, x], C1]\) /. 
            FuncRepRules[\(\[Xi][2]\)[r, x], 0]\) /. 
          FuncRepRules[\(\[Xi][3]\)[r, x], 0]\) /. 
        FuncRepRules[\(\[Xi][4]\)[r, x], C4]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 0, 0, 0}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lie Derivatives", "Subsection",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t",
  StyleBox["LieD[h_,x__]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[
  " ccomputes the Lie derivative of the tensor x with respect to the ",
    FontSize->16],
  StyleBox["contravariant",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[" vector h:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeLikeKV = {1, 0, 0, 0}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({1, 0, 0, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AxialKV = {0, 0, 0, 1}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0, 0, 0, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GeneralKV = C1\ TimeLikeKV + C2\ AxialKV\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({C1, 0, 0, C2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieD[TimeLikeKV, gdd]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieD[AxialKV, RUddd, {1}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 
            0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
            0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
            0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}, {{{0, 0, 0, 0}, {0, 0, 0, 0}, {
            0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 
            0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {
            0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 
            0, 0}}}, {{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 
            0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{
            0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 
            0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}, {{{0, 0, 0, 
            0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
            0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
            0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 
            0, 0, 0}, {0, 0, 0, 0}}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieD[GeneralKV, gUU, {1, 2}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  " Example 5: Floratos-Kehagias 8-dim Ricci-flat metric (",
  ButtonBox["hep_th/9802107",
    ButtonData:>{
      URL[ "http://arxiv.org/abs/hep-th/9802107"], None},
    ButtonStyle->"Hyperlink"],
  ")"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(Clear[u, g, h, a, b, c]; \)\)], "Input"],

Cell[BoxData[
    \(\(xCoord = {x1, x2, x3, x4, x5, x6, x7, x8}; \)\)], "Input"],

Cell[BoxData[
    \(\(gFloKeh
       = {{u^2\ g^2\ h^2, 0, 0, 0, 0, 0, 0, 0}, {0, u^2\ g^2\ h^2, 0, 0, 0, 
          0, 0, 0}, {0, 0, 1/u^2, 0, 0, 0, 0, 2  a/u^2}, {0, 0, 0, 1/g^2, 
          2  b/g^2, 0, 0, 0}, {0, 0, 0, 2  b/g^2, g^2 + 4  b^2/g^2, 0, 0, 
          0}, {0, 0, 0, 0, 0, h^2 + 4  c^2/h^2, 2  c/h^2, 0}, {0, 0, 0, 0, 0, 
          2  c/h^2, 1/h^2, 0}, {0, 0, 2  a/u^2, 0, 0, 0, 0, 
          4  a^2/u^2 + u^2}}; \)\)], "Input"],

Cell["\tThe symbols u, g, h, a, b, c are functions of  x1, x2 :", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(u = U[x1, x2]; g = G[x1, x2]; h = H[x1, x2]; a = A[x1, x2]; 
    b = B[x1, x2]; c = C[x1, x2]; \)], "Input"],

Cell["\<\
\tThe complex functions u^2 +2 i a, g^2 +2 i b, h^2 +2 i c  are \
assumed to be analytic functions of x1+i x2. Therefore, use simpRules to \
implement the Cauchy-Riemann & harmonic function conditions:\
\>", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"simpRules", "=", 
      RowBox[{"{", 
        RowBox[{
        \(D[a, x1] -> \(-u\)\ D[u, x2]\), ",", \(D[a, x2] -> u\ D[u, x1]\), 
          ",", \(D[b, x1] -> \(-g\)\ D[g, x2]\), ",", 
          \(D[b, x2] -> g\ D[g, x1]\), ",", \(D[c, x1] -> \(-h\)\ D[h, x2]\), 
          ",", \(D[c, x2] -> h\ D[h, x1]\), ",", 
          RowBox[{
            RowBox[{
              RowBox[{"Z_.", 
                TagBox[
                  StyleBox[\(\(\(Derivative[0, 2]\)[G_]\)[x1, x2]\),
                    ShowSpecialCharacters->False,
                    ShowStringCharacters->True],
                  FullForm]}], "+", 
              RowBox[{"Z_.", 
                TagBox[
                  StyleBox[\(\(\(Derivative[2, 0]\)[G_]\)[x1, x2]\),
                    ShowSpecialCharacters->False,
                    ShowStringCharacters->True],
                  FullForm]}]}], ":>", 
            RowBox[{\(-Z\), 
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    RowBox[{
                      TagBox[
                        StyleBox[\(\(\(Derivative[1, 0]\)[G]\)[x1, x2]\),
                          ShowSpecialCharacters->False,
                          ShowStringCharacters->True],
                        FullForm], "^", "2"}], "+", 
                    RowBox[{
                      TagBox[
                        StyleBox[\(\(\(Derivative[0, 1]\)[G]\)[x1, x2]\),
                          ShowSpecialCharacters->False,
                          ShowStringCharacters->True],
                        FullForm], "^", "2"}]}], ")"}], "/", 
                \(G[x1, x2]\)}]}]}]}], "}"}]}]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["A", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(-U[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["U", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["A", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(U[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["U", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["B", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(-G[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["G", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["B", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(G[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["G", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["C", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(-H[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["H", 
                TagBox[\((0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["C", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(x1, x2\), "]"}], "\[Rule]", 
          RowBox[{\(H[x1, x2]\), " ", 
            RowBox[{
              SuperscriptBox["H", 
                TagBox[\((1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], ",", 
        RowBox[{
          RowBox[{
            RowBox[{"Z_.", " ", 
              RowBox[{
                SuperscriptBox["G_", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}], "+", 
            RowBox[{"Z_.", " ", 
              RowBox[{
                SuperscriptBox["G_", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x1, x2\), "]"}]}]}], 
          "\[RuleDelayed]", 
          RowBox[{"-", 
            FractionBox[
              RowBox[{"Z", " ", 
                RowBox[{"(", 
                  RowBox[{
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["G", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x1, x2\), "]"}], 
                      "2"], "+", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["G", 
                          TagBox[\((0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x1, x2\), "]"}], 
                      "2"]}], ")"}]}], \(G[x1, x2]\)]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gFloKeh, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2\), "0", "0", "0",
                   "0", "0", "0", "0"},
               
                 {"0", \(G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2\), "0", "0",
                   "0", "0", "0", "0"},
               
                 {"0", "0", \(1\/U[x1, x2]\^2\), "0", "0", "0", "0", 
                  \(\(2\ A[x1, x2]\)\/U[x1, x2]\^2\)},
               
                 {"0", "0", "0", \(1\/G[x1, x2]\^2\), 
                  \(\(2\ B[x1, x2]\)\/G[x1, x2]\^2\), "0", "0", "0"},
               
                 {"0", "0", "0", \(\(2\ B[x1, x2]\)\/G[x1, x2]\^2\), 
                  \(\(4\ B[x1, x2]\^2\)\/G[x1, x2]\^2 + G[x1, x2]\^2\), "0", 
                  "0", "0"},
               
                 {"0", "0", "0", "0", "0", 
                  \(\(4\ C[x1, x2]\^2\)\/H[x1, x2]\^2 + H[x1, x2]\^2\), 
                  \(\(2\ C[x1, x2]\)\/H[x1, x2]\^2\), "0"},
               
                 {"0", "0", "0", "0", "0", \(\(2\ C[x1, x2]\)\/H[x1, x2]\^2\),
                   \(1\/H[x1, x2]\^2\), "0"},
               
                 {"0", "0", \(\(2\ A[x1, x2]\)\/U[x1, x2]\^2\), "0", "0", "0",
                   "0", \(\(4\ A[x1, x2]\^2\)\/U[x1, x2]\^2 + U[x1, x2]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ 
            Power[ 
              G[ x1, x2], 2], 
            Power[ 
              H[ x1, x2], 2], 
            Power[ 
              U[ x1, x2], 2]], 0, 0, 0, 0, 0, 0, 0}, {0, 
          Times[ 
            Power[ 
              G[ x1, x2], 2], 
            Power[ 
              H[ x1, x2], 2], 
            Power[ 
              U[ x1, x2], 2]], 0, 0, 0, 0, 0, 0}, {0, 0, 
          Power[ 
            U[ x1, x2], -2], 0, 0, 0, 0, 
          Times[ 2, 
            A[ x1, x2], 
            Power[ 
              U[ x1, x2], -2]]}, {0, 0, 0, 
          Power[ 
            G[ x1, x2], -2], 
          Times[ 2, 
            B[ x1, x2], 
            Power[ 
              G[ x1, x2], -2]], 0, 0, 0}, {0, 0, 0, 
          Times[ 2, 
            B[ x1, x2], 
            Power[ 
              G[ x1, x2], -2]], 
          Plus[ 
            Times[ 4, 
              Power[ 
                B[ x1, x2], 2], 
              Power[ 
                G[ x1, x2], -2]], 
            Power[ 
              G[ x1, x2], 2]], 0, 0, 0}, {0, 0, 0, 0, 0, 
          Plus[ 
            Times[ 4, 
              Power[ 
                C[ x1, x2], 2], 
              Power[ 
                H[ x1, x2], -2]], 
            Power[ 
              H[ x1, x2], 2]], 
          Times[ 2, 
            C[ x1, x2], 
            Power[ 
              H[ x1, x2], -2]], 0}, {0, 0, 0, 0, 0, 
          Times[ 2, 
            C[ x1, x2], 
            Power[ 
              H[ x1, x2], -2]], 
          Power[ 
            H[ x1, x2], -2], 0}, {0, 0, 
          Times[ 2, 
            A[ x1, x2], 
            Power[ 
              U[ x1, x2], -2]], 0, 0, 0, 0, 
          Plus[ 
            Times[ 4, 
              Power[ 
                A[ x1, x2], 2], 
              Power[ 
                U[ x1, x2], -2]], 
            Power[ 
              U[ x1, x2], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(d[x4]\^2\/G[x1, x2]\^2 + 
            \(4\ B[x1, x2]\ d[x4]\ d[x5]\)\/G[x1, x2]\^2 + 
            \(d[x5]\^2\ \((4\ B[x1, x2]\^2 + G[x1, x2]\^4)\)\)\/G[x1, x2]\^2
                 + \(4\ C[x1, x2]\ d[x6]\ d[x7]\)\/H[x1, x2]\^2 + 
            d[x7]\^2\/H[x1, x2]\^2 + 
            \(d[x6]\^2\ \((4\ C[x1, x2]\^2 + H[x1, x2]\^4)\)\)\/H[x1, x2]\^2
                 + d[x3]\^2\/U[x1, x2]\^2 + 
            \(4\ A[x1, x2]\ d[x3]\ d[x8]\)\/U[x1, x2]\^2 + 
            d[x1]\^2\ G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2 + 
            d[x2]\^2\ G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2 + 
            \(d[x8]\^2\ \((4\ A[x1, x2]\^2 + U[x1, x2]\^4)\)\)\/U[x1, x2]\^2
                \),
          (Short[ #, 64]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ 
                d[ x4], 2], 
              Power[ 
                G[ x1, x2], -2]], 
            Times[ 4, 
              B[ x1, x2], 
              d[ x4], 
              d[ x5], 
              Power[ 
                G[ x1, x2], -2]], 
            Times[ 
              Power[ 
                d[ x5], 2], 
              Power[ 
                G[ x1, x2], -2], 
              Plus[ 
                Times[ 4, 
                  Power[ 
                    B[ x1, x2], 2]], 
                Power[ 
                  G[ x1, x2], 4]]], 
            Times[ 4, 
              C[ x1, x2], 
              d[ x6], 
              d[ x7], 
              Power[ 
                H[ x1, x2], -2]], 
            Times[ 
              Power[ 
                d[ x7], 2], 
              Power[ 
                H[ x1, x2], -2]], 
            Times[ 
              Power[ 
                d[ x6], 2], 
              Power[ 
                H[ x1, x2], -2], 
              Plus[ 
                Times[ 4, 
                  Power[ 
                    C[ x1, x2], 2]], 
                Power[ 
                  H[ x1, x2], 4]]], 
            Times[ 
              Power[ 
                d[ x3], 2], 
              Power[ 
                U[ x1, x2], -2]], 
            Times[ 4, 
              A[ x1, x2], 
              d[ x3], 
              d[ x8], 
              Power[ 
                U[ x1, x2], -2]], 
            Times[ 
              Power[ 
                d[ x1], 2], 
              Power[ 
                G[ x1, x2], 2], 
              Power[ 
                H[ x1, x2], 2], 
              Power[ 
                U[ x1, x2], 2]], 
            Times[ 
              Power[ 
                d[ x2], 2], 
              Power[ 
                G[ x1, x2], 2], 
              Power[ 
                H[ x1, x2], 2], 
              Power[ 
                U[ x1, x2], 2]], 
            Times[ 
              Power[ 
                d[ x8], 2], 
              Power[ 
                U[ x1, x2], -2], 
              Plus[ 
                Times[ 4, 
                  Power[ 
                    A[ x1, x2], 2]], 
                Power[ 
                  U[ x1, x2], 4]]]], 64]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1\/\(G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2\)\), "0", 
                  "0", "0", "0", "0", "0", "0"},
               
                 {"0", \(1\/\(G[x1, x2]\^2\ H[x1, x2]\^2\ U[x1, x2]\^2\)\), 
                  "0", "0", "0", "0", "0", "0"},
               
                 {"0", "0", 
                  \(\(4\ A[x1, x2]\^2 + U[x1, x2]\^4\)\/U[x1, x2]\^2\), "0", 
                  "0", "0", "0", \(-\(\(2\ A[x1, x2]\)\/U[x1, x2]\^2\)\)},
               
                 {"0", "0", "0", 
                  \(\(4\ B[x1, x2]\^2 + G[x1, x2]\^4\)\/G[x1, x2]\^2\), 
                  \(-\(\(2\ B[x1, x2]\)\/G[x1, x2]\^2\)\), "0", "0", "0"},
               
                 {"0", "0", "0", \(-\(\(2\ B[x1, x2]\)\/G[x1, x2]\^2\)\), 
                  \(1\/G[x1, x2]\^2\), "0", "0", "0"},
               
                 {"0", "0", "0", "0", "0", \(1\/H[x1, x2]\^2\), 
                  \(-\(\(2\ C[x1, x2]\)\/H[x1, x2]\^2\)\), "0"},
               
                 {"0", "0", "0", "0", "0", 
                  \(-\(\(2\ C[x1, x2]\)\/H[x1, x2]\^2\)\), 
                  \(\(4\ C[x1, x2]\^2 + H[x1, x2]\^4\)\/H[x1, x2]\^2\), "0"},
               
                 {"0", "0", \(-\(\(2\ A[x1, x2]\)\/U[x1, x2]\^2\)\), "0", "0",
                   "0", "0", \(1\/U[x1, x2]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ 
              G[ x1, x2], -2], 
            Power[ 
              H[ x1, x2], -2], 
            Power[ 
              U[ x1, x2], -2]], 0, 0, 0, 0, 0, 0, 0}, {0, 
          Times[ 
            Power[ 
              G[ x1, x2], -2], 
            Power[ 
              H[ x1, x2], -2], 
            Power[ 
              U[ x1, x2], -2]], 0, 0, 0, 0, 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              U[ x1, x2], -2], 
            Plus[ 
              Times[ 4, 
                Power[ 
                  A[ x1, x2], 2]], 
              Power[ 
                U[ x1, x2], 4]]], 0, 0, 0, 0, 
          Times[ -2, 
            A[ x1, x2], 
            Power[ 
              U[ x1, x2], -2]]}, {0, 0, 0, 
          Times[ 
            Power[ 
              G[ x1, x2], -2], 
            Plus[ 
              Times[ 4, 
                Power[ 
                  B[ x1, x2], 2]], 
              Power[ 
                G[ x1, x2], 4]]], 
          Times[ -2, 
            B[ x1, x2], 
            Power[ 
              G[ x1, x2], -2]], 0, 0, 0}, {0, 0, 0, 
          Times[ -2, 
            B[ x1, x2], 
            Power[ 
              G[ x1, x2], -2]], 
          Power[ 
            G[ x1, x2], -2], 0, 0, 0}, {0, 0, 0, 0, 0, 
          Power[ 
            H[ x1, x2], -2], 
          Times[ -2, 
            C[ x1, x2], 
            Power[ 
              H[ x1, x2], -2]], 0}, {0, 0, 0, 0, 0, 
          Times[ -2, 
            C[ x1, x2], 
            Power[ 
              H[ x1, x2], -2]], 
          Times[ 
            Power[ 
              H[ x1, x2], -2], 
            Plus[ 
              Times[ 4, 
                Power[ 
                  C[ x1, x2], 2]], 
              Power[ 
                H[ x1, x2], 4]]], 0}, {0, 0, 
          Times[ -2, 
            A[ x1, x2], 
            Power[ 
              U[ x1, x2], -2]], 0, 0, 0, 0, 
          Power[ 
            U[ x1, x2], -2]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0500000000000113686`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.050000000000011369, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.283333333333331438`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.28333333333333144, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]1.65000000000000568`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 1.6500000000000057, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]8.40000000000000568`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 8.4000000000000057, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.233333333333320069`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.23333333333332007, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 10.7333 seconds"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["zeroQ[Bianchi[1]]",
    FontFamily->"Courier"],
  " in this case gives ",
  StyleBox["False",
    FontFamily->"Courier"],
  " (after ~30 sec)! The reason is that the ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " used imply relations among the 3rd derivatives of the functions ",
  StyleBox["U[x1,x2],",
    FontFamily->"Courier"],
  " ",
  StyleBox["G[x1,x2],",
    FontFamily->"Courier"],
  " ",
  StyleBox["H[x1,x2]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["Exercise",
    FontSlant->"Italic"],
  ": Find the additional two rules needed to satisfy the Bianchi identities."
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Solution",
    FontSlant->"Italic"],
  ": See ",
  ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16]
}, Closed]],

Cell[BoxData[
    \(Clear[u, g, h, a, b, c, U, G, H]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 6: Harrison metric II-A-7 (Phys. Rev. 116, 1285)", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell["\<\
\tSee the \"Exact Solutions...\" book: section 15.4 (1st Edition) \
or section 17.3 (2nd Edition)\
\>", "Text",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(Clear[x]; xCoord = {t, x, y, z}; \)], "Input"],

Cell[BoxData[
    RowBox[{\(rt3 = Sqrt[3]\), ";", \(F1 = x/rt3 - t^2/12\), " ", ";", 
      RowBox[{
        RowBox[{
          SuperscriptBox["F2", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "=", 
        \(F2[z] v[z]/z\)}], ";", 
      RowBox[{
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "z", "]"}], "=", 
        \(\((v[z]^2 - 1)\)/\((4  z)\) \((2\ \ v[z]/\((z - 1)\) + 4/rt3)\)\)}],
       ";"}]], "Input"],

Cell[BoxData[
    \(n1[t] = 2 + rt3; n1[x] = 1 + rt3; n1[y] = \(-rt3\); n1[z] = 3 + rt3; 
    \)], "Input"],

Cell[BoxData[
    \(n2[t] = 1 + 2/rt3; n2[x] = 1 + 2/rt3; n2[y] = \(-1\); 
    n2[z] = 1 + 2/rt3; \)], "Input"],

Cell[BoxData[
    \(n3[t] = 1/rt3; n3[x] = \((1 + 1/rt3)\); n3[y] = \(-1\)/rt3; 
    n3[z] = \((2 + 1/rt3)\); \)], "Input"],

Cell[BoxData[
    \(\(g = 
      DiagonalMatrix[{F1^n1[t] F2[z]^n2[t] \((\(-1\)/z)\)^n3[t], 
          \(-F1^n1[x]\) F2[z]^n2[x] \((\(-1\)/z)\)^n3[x], 
          \(-F1^n1[y]\) F2[z]^n2[y] \((\(-1\)/z)\)^n3[y], 
          \(-F1^n1[z]\) F2[z]^n2[z] \((\(-1\)/z)\)^n3[z] 
            \((v[z]^2 - 1)\)/\((z - 1)\)}]; \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(2 + \@3\)\ 
                    \((\(-\(1\/z\)\))\)\^\(1\/\@3\)\ F2[z]\^\(1 + 2\/\@3\)\), 
                  "0", "0", "0"},
               
                 {"0", \(\(-\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(1 + \@3\)\)\ 
                    \((\(-\(1\/z\)\))\)\^\(1 + 1\/\@3\)\ 
                    F2[z]\^\(1 + 2\/\@3\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(-\@3\)\ 
                          \((\(-\(1\/z\)\))\)\^\(-\(1\/\@3\)\)\)\/F2[z]\)\), 
                  "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(3 + \@3\)\ 
                          \((\(-\(1\/z\)\))\)\^\(2 + 1\/\@3\)\ 
                          F2[z]\^\(1 + 2\/\@3\)\ 
                          \((\(-1\) + v[z]\^2)\)\)\/\(\(-1\) + z\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Plus[ 2, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Power[ 3, 
                Rational[ -1, 2]]], 
            Power[ 
              F2[ z], 
              Plus[ 1, 
                Times[ 2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Plus[ 1, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Plus[ 1, 
                Power[ 3, 
                  Rational[ -1, 2]]]], 
            Power[ 
              F2[ z], 
              Plus[ 1, 
                Times[ 2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ -1, 2]]]], 
            Power[ 
              F2[ z], -1]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Plus[ 3, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Power[ 
              Plus[ -1, z], -1], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Plus[ 2, 
                Power[ 3, 
                  Rational[ -1, 2]]]], 
            Power[ 
              F2[ z], 
              Plus[ 1, 
                Times[ 2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]], 
            Plus[ -1, 
              Power[ 
                v[ z], 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(-\@3\)\ 
                  \((\(-\(1\/z\)\))\)\^\(-\(1\/\@3\)\)\ d[y]\^2\)\/F2[z]\) + 
            1\/144\ \((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(\@3\)\ 
              \((t\^2 - 4\ \@3\ x)\)\^2\ \((\(-\(1\/z\)\))\)\^\(1\/\@3\)\ 
              d[t]\^2\ F2[z]\^\(1 + 2\/\@3\) - 
            \(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(\@3\)\ 
                \((t\^2 - 4\ \@3\ x)\)\ \((\(-\(1\/z\)\))\)\^\(1\/\@3\)\ 
                d[x]\^2\ F2[z]\^\(1 + 2\/\@3\)\)\/\(12\ z\) + 
            \(\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(\@3\)\ 
                \((t\^2 - 4\ \@3\ x)\)\^3\ \((\(-\(1\/z\)\))\)\^\(1\/\@3\)\ 
                d[z]\^2\ F2[z]\^\(1 + 2\/\@3\)\ \((\(-1\) + v[z])\)\ 
                \((1 + v[z])\)\)\/\(1728\ \((\(-1\) + z)\)\ z\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Times[ 
                    Rational[ -1, 12], 
                    Power[ t, 2]], 
                  Times[ 
                    Power[ 3, 
                      Rational[ -1, 2]], x]], 
                Times[ -1, 
                  Power[ 3, 
                    Rational[ 1, 2]]]], 
              Power[ 
                Times[ -1, 
                  Power[ z, -1]], 
                Times[ -1, 
                  Power[ 3, 
                    Rational[ -1, 2]]]], 
              Power[ 
                d[ y], 2], 
              Power[ 
                F2[ z], -1]], 
            Times[ 
              Rational[ 1, 144], 
              Power[ 
                Plus[ 
                  Times[ 
                    Rational[ -1, 12], 
                    Power[ t, 2]], 
                  Times[ 
                    Power[ 3, 
                      Rational[ -1, 2]], x]], 
                Power[ 3, 
                  Rational[ 1, 2]]], 
              Power[ 
                Plus[ 
                  Power[ t, 2], 
                  Times[ -4, 
                    Power[ 3, 
                      Rational[ 1, 2]], x]], 2], 
              Power[ 
                Times[ -1, 
                  Power[ z, -1]], 
                Power[ 3, 
                  Rational[ -1, 2]]], 
              Power[ 
                d[ t], 2], 
              Power[ 
                F2[ z], 
                Plus[ 1, 
                  Times[ 2, 
                    Power[ 3, 
                      Rational[ -1, 2]]]]]], 
            Times[ 
              Rational[ -1, 12], 
              Power[ 
                Plus[ 
                  Times[ 
                    Rational[ -1, 12], 
                    Power[ t, 2]], 
                  Times[ 
                    Power[ 3, 
                      Rational[ -1, 2]], x]], 
                Power[ 3, 
                  Rational[ 1, 2]]], 
              Plus[ 
                Power[ t, 2], 
                Times[ -4, 
                  Power[ 3, 
                    Rational[ 1, 2]], x]], 
              Power[ 
                Times[ -1, 
                  Power[ z, -1]], 
                Power[ 3, 
                  Rational[ -1, 2]]], 
              Power[ z, -1], 
              Power[ 
                d[ x], 2], 
              Power[ 
                F2[ z], 
                Plus[ 1, 
                  Times[ 2, 
                    Power[ 3, 
                      Rational[ -1, 2]]]]]], 
            Times[ 
              Rational[ 1, 1728], 
              Power[ 
                Plus[ 
                  Times[ 
                    Rational[ -1, 12], 
                    Power[ t, 2]], 
                  Times[ 
                    Power[ 3, 
                      Rational[ -1, 2]], x]], 
                Power[ 3, 
                  Rational[ 1, 2]]], 
              Power[ 
                Plus[ 
                  Power[ t, 2], 
                  Times[ -4, 
                    Power[ 3, 
                      Rational[ 1, 2]], x]], 3], 
              Power[ 
                Plus[ -1, z], -1], 
              Power[ 
                Times[ -1, 
                  Power[ z, -1]], 
                Power[ 3, 
                  Rational[ -1, 2]]], 
              Power[ z, -2], 
              Power[ 
                d[ z], 2], 
              Power[ 
                F2[ z], 
                Plus[ 1, 
                  Times[ 2, 
                    Power[ 3, 
                      Rational[ -1, 2]]]]], 
              Plus[ -1, 
                v[ z]], 
              Plus[ 1, 
                v[ z]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(144\ \((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(-\@3\)\ 
                        \((t\^8 - 16\ \@3\ t\^6\ x + 288\ t\^4\ x\^2 - 
                            768\ \@3\ t\^2\ x\^3 + 2304\ x\^4)\)\ 
                        \((\(-\(1\/z\)\))\)\^\(-\(1\/\@3\)\)\ 
                        F2[z]\^\(\(-1\) - 2\/\@3\)\)\/\(t\^12 - 
                        24\ \@3\ t\^10\ x + 720\ t\^8\ x\^2 - 
                        3840\ \@3\ t\^6\ x\^3 + 34560\ t\^4\ x\^4 - 
                        55296\ \@3\ t\^2\ x\^5 + 110592\ x\^6\)\), "0", "0", 
                  "0"},
               
                 {"0", \(-
                    \(\(12\ \((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(-\@3\)\ 
                          \((t\^10 - 20\ \@3\ t\^8\ x + 480\ t\^6\ x\^2 - 
                              1920\ \@3\ t\^4\ x\^3 + 11520\ t\^2\ x\^4 - 
                              9216\ \@3\ x\^5)\)\ 
                          \((\(-\(1\/z\)\))\)\^\(-\(1\/\@3\)\)\ z\ 
                          F2[z]\^\(\(-1\) - 2\/\@3\)\)\/\(t\^12 - 
                          24\ \@3\ t\^10\ x + 720\ t\^8\ x\^2 - 
                          3840\ \@3\ t\^6\ x\^3 + 34560\ t\^4\ x\^4 - 
                          55296\ \@3\ t\^2\ x\^5 + 110592\ x\^6\)\)\), "0", 
                  "0"},
               
                 {"0", "0", 
                  \(\(-\((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(\@3\)\)\ 
                    \((\(-\(1\/z\)\))\)\^\(1\/\@3\)\ F2[z]\), "0"},
               
                 {"0", "0", "0", 
                  \(\(1728\ \((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(-\@3\)\ 
                        \((t\^6 - 12\ \@3\ t\^4\ x + 144\ t\^2\ x\^2 - 
                            192\ \@3\ x\^3)\)\ \((\(-1\) + z)\)\ 
                        \((\(-\(1\/z\)\))\)\^\(-\(1\/\@3\)\)\ z\^2\ 
                        F2[z]\^\(\(-1\) - 2\/\@3\)\)\/\(\((
                          t\^12 - 24\ \@3\ t\^10\ x + 720\ t\^8\ x\^2 - 
                            3840\ \@3\ t\^6\ x\^3 + 34560\ t\^4\ x\^4 - 
                            55296\ \@3\ t\^2\ x\^5 + 110592\ x\^6)\)\ 
                        \((\(-1\) + v[z])\)\ \((1 + v[z])\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 144, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Plus[ 
              Power[ t, 8], 
              Times[ -16, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ t, 6], x], 
              Times[ 288, 
                Power[ t, 4], 
                Power[ x, 2]], 
              Times[ -768, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ t, 2], 
                Power[ x, 3]], 
              Times[ 2304, 
                Power[ x, 4]]], 
            Power[ 
              Plus[ 
                Power[ t, 12], 
                Times[ -24, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 10], x], 
                Times[ 720, 
                  Power[ t, 8], 
                  Power[ x, 2]], 
                Times[ -3840, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 6], 
                  Power[ x, 3]], 
                Times[ 34560, 
                  Power[ t, 4], 
                  Power[ x, 4]], 
                Times[ -55296, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 2], 
                  Power[ x, 5]], 
                Times[ 110592, 
                  Power[ x, 6]]], -1], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ -1, 2]]]], 
            Power[ 
              F2[ z], 
              Plus[ -1, 
                Times[ -2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]]], 0, 0, 0}, {0, 
          Times[ -12, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Plus[ 
              Power[ t, 10], 
              Times[ -20, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ t, 8], x], 
              Times[ 480, 
                Power[ t, 6], 
                Power[ x, 2]], 
              Times[ -1920, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ t, 4], 
                Power[ x, 3]], 
              Times[ 11520, 
                Power[ t, 2], 
                Power[ x, 4]], 
              Times[ -9216, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ x, 5]]], 
            Power[ 
              Plus[ 
                Power[ t, 12], 
                Times[ -24, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 10], x], 
                Times[ 720, 
                  Power[ t, 8], 
                  Power[ x, 2]], 
                Times[ -3840, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 6], 
                  Power[ x, 3]], 
                Times[ 34560, 
                  Power[ t, 4], 
                  Power[ x, 4]], 
                Times[ -55296, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 2], 
                  Power[ x, 5]], 
                Times[ 110592, 
                  Power[ x, 6]]], -1], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ -1, 2]]]], z, 
            Power[ 
              F2[ z], 
              Plus[ -1, 
                Times[ -2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Power[ 3, 
                Rational[ 1, 2]]], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Power[ 3, 
                Rational[ -1, 2]]], 
            F2[ z]], 0}, {0, 0, 0, 
          Times[ 1728, 
            Power[ 
              Plus[ 
                Times[ 
                  Rational[ -1, 12], 
                  Power[ t, 2]], 
                Times[ 
                  Power[ 3, 
                    Rational[ -1, 2]], x]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ 1, 2]]]], 
            Plus[ 
              Power[ t, 6], 
              Times[ -12, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ t, 4], x], 
              Times[ 144, 
                Power[ t, 2], 
                Power[ x, 2]], 
              Times[ -192, 
                Power[ 3, 
                  Rational[ 1, 2]], 
                Power[ x, 3]]], 
            Power[ 
              Plus[ 
                Power[ t, 12], 
                Times[ -24, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 10], x], 
                Times[ 720, 
                  Power[ t, 8], 
                  Power[ x, 2]], 
                Times[ -3840, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 6], 
                  Power[ x, 3]], 
                Times[ 34560, 
                  Power[ t, 4], 
                  Power[ x, 4]], 
                Times[ -55296, 
                  Power[ 3, 
                    Rational[ 1, 2]], 
                  Power[ t, 2], 
                  Power[ x, 5]], 
                Times[ 110592, 
                  Power[ x, 6]]], -1], 
            Plus[ -1, z], 
            Power[ 
              Times[ -1, 
                Power[ z, -1]], 
              Times[ -1, 
                Power[ 3, 
                  Rational[ -1, 2]]]], 
            Power[ z, 2], 
            Power[ 
              F2[ z], 
              Plus[ -1, 
                Times[ -2, 
                  Power[ 3, 
                    Rational[ -1, 2]]]]], 
            Power[ 
              Plus[ -1, 
                v[ z]], -1], 
            Power[ 
              Plus[ 1, 
                v[ z]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.433333333333337122`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.43333333333333712, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.633333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.63333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]3.`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 3.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]2.09999999999999431`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 2.0999999999999943, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]1.91666666666668561`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 1.9166666666666856, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 8.21667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(detg\)], "Input"],

Cell[BoxData[
    \(\(1\/\(2985984\ \((\(-1\) + z)\)\ z\^3\)\((
      \((\(-\(t\^2\/12\)\) + x\/\@3)\)\^\(2\ \@3\)\ 
        \((t\^12 - 24\ \@3\ t\^10\ x + 720\ t\^8\ x\^2 - 
            3840\ \@3\ t\^6\ x\^3 + 34560\ t\^4\ x\^4 - 
            55296\ \@3\ t\^2\ x\^5 + 110592\ x\^6)\)\ 
        \((\(-\(1\/z\)\))\)\^\(2\/\@3\)\ F2[z]\^\(2 + 2\ \@3\)\ 
        \((\(-1\) + v[z])\)\ \((1 + v[z])\))\)\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["\tMathematica",
    FontSlant->"Italic"],
  " 4 (or higher) is able to factor the long polynomial (",
  Cell[BoxData[
      RowBox[{
        SuperscriptBox[
          StyleBox["t",
            FontWeight->"Plain",
            FontSlant->"Plain",
            FontTracking->"Plain",
            FontVariations->{"Underline"->False,
            "Outline"->False,
            "Shadow"->False}], "12"], "..."}]], "Input"],
  ")  appearing in ",
  StyleBox["detg",
    FontFamily->"Courier"],
  "  as  ",
  Cell[BoxData[
      \(\((t\^2 - 4\ \@3\ x)\)\^6\)]],
  " (and also the other polynomials in gUU). As a result the calculation is \
completed in 1/3 the time!"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Example 7: Bondi metric (Proc. Roy. Soc. A269, 21) ", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(\(xCoord = {u, r, \[Theta], \[CurlyPhi]}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = {{
          Exp[2\ \[Beta][u, r, \[Theta]]] V[u, r, \[Theta]]/r - 
            r^2  Exp[2  \[Gamma][u, r, \[Theta]]] U[u, r, \[Theta]]^2, 
          Exp[2\ \[Beta][u, r, \[Theta]]], 
          r^2  Exp[2  \[Gamma][u, r, \[Theta]]] U[u, r, \[Theta]], 0}, {
          Exp[2\ \[Beta][u, r, \[Theta]]], 0, 0, 0}, {
          r^2  Exp[2  \[Gamma][u, r, \[Theta]]] U[u, r, \[Theta]], 0, 
          \(-r^2\) Exp[2  \[Gamma][u, r, \[Theta]]], 0}, {0, 0, 0, 
          \(-r^2\) Exp[\(-2\) \[Gamma][u, r, \[Theta]]] Sin[\[Theta]]^2}}; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                      U[u, r, \[Theta]]\^2 + 
                    \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\ 
                        V[u, r, \[Theta]]\)\/r\), 
                  \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), 
                  \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0"},
                {\(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), "0", "0", "0"},
               
                 {\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0", 
                  \(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\), "0"},
               
                 {"0", "0", "0", 
                  \(\(-E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                    Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                U[ u, r, \[Theta]], 2]], 
            Times[ 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              Power[ r, -1], 
              V[ u, r, \[Theta]]]], 
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0}, {
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0, 0}, {
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(2\ E\^\(2\ \[Beta][u, r, \[Theta]]\)\ d[r]\ d[u] - 
            E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[Theta]]\^2 - 
            E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[CurlyPhi]]\^2\ 
              Sin[\[Theta]]\^2 + 
            2\ E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[u]\ d[\[Theta]]\ 
              U[u, r, \[Theta]] - 
            \(d[u]\^2\ 
                \((E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^3\ 
                      U[u, r, \[Theta]]\^2 - 
                    E\^\(2\ \[Beta][u, r, \[Theta]]\)\ V[u, r, \[Theta]])
                  \)\)\/r\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              d[ r], 
              d[ u]], 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ E, 
                Times[ -2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              d[ u], 
              d[ \[Theta]], 
              U[ u, r, \[Theta]]], 
            Times[ -1, 
              Power[ r, -1], 
              Power[ 
                d[ u], 2], 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, 
                      \[Gamma][ u, r, \[Theta]]]], 
                  Power[ r, 3], 
                  Power[ 
                    U[ u, r, \[Theta]], 2]], 
                Times[ -1, 
                  Power[ E, 
                    Times[ 2, 
                      \[Beta][ u, r, \[Theta]]]], 
                  V[ u, r, \[Theta]]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), "0", "0"},
               
                 {\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), 
                  \(-\(\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                          V[u, r, \[Theta]]\)\/r\)\), 
                  \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), "0"},
               
                 {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), 
                  \(-\(E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\/r\^2\)\), 
                  "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ 
                          Csc[\[Theta]]\^2\)\/r\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0}, {
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            Power[ r, -1], 
            V[ u, r, \[Theta]]], 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 0}, {0, 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0166666666666799301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.01666666666667993, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.383333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.38333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]1.68333333333333712`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 1.6833333333333371, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]6.38333333333332575`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 6.3833333333333258, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]2.5833333333333428`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 2.5833333333333428, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]5.59999999999999431`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 5.5999999999999943, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]1.96666666666666856`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 1.9666666666666686, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 18.6667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUdd[\([2, 2, 3]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{\(1\/2\), " ", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), " ", 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", 
            RowBox[{
              SuperscriptBox["\[Beta]", 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}]}], 
          "+", 
          RowBox[{
          \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^2\), " ", 
            RowBox[{
              SuperscriptBox["U", 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}]}]}], 
        ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd[\([2, 2]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{"-", 
      FractionBox[
        RowBox[{"2", " ", 
          RowBox[{"(", 
            RowBox[{
              RowBox[{\(-2\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{"r", " ", 
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      TagBox[\((0, 1, 0)\),
                        Derivative],
                      MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                    "]"}], "2"]}]}], ")"}]}], "r"]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EUd[\([2, 3]\)]\)], "Input"],

Cell[BoxData[
    RowBox[{\(1\/\(2\ r\^2\)\), 
      RowBox[{"(", 
        RowBox[{\(E\^\(\(-4\)\ \[Beta][u, r, \[Theta]]\)\), " ", 
          RowBox[{"(", 
            RowBox[{
            \(2\ E\^\(2\ \[Beta][u, r, \[Theta]]\)\ r\^2\ U[u, r, \[Theta]]\),
               "-", 
              RowBox[{\(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", 
                RowBox[{
                  SuperscriptBox["V", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(Cot[\[Theta]]\), " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", 
                \(V[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "6", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(Cot[\[Theta]]\), " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(U[u, r, \[Theta]]\), " ", 
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox["\[Gamma]", 
                      TagBox[\((0, 0, 1)\),
                        Derivative],
                      MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                    "]"}], "2"]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 0, 2)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 0, 2)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\), " ", 
                \(Cot[\[Theta]]\), " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\),
                 " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\),
                 " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\),
                 " ", \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                
                RowBox[{
                  SuperscriptBox["V", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                \(Cot[\[Theta]]\), " ", \(V[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                
                RowBox[{
                  SuperscriptBox["V", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                \(V[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\), " ", 
                \(U[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{\(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                RowBox[{
                  SuperscriptBox["V", 
                    TagBox[\((0, 1, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                \(V[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((0, 1, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", "r", " ", 
                \(V[u, r, \[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 1, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\),
                 " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((1, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", \(Cot[\[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((1, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "4", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((1, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\),
                 " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), "]"}], 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((1, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Beta]", 
                    TagBox[\((1, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "+", 
              RowBox[{
              "2", " ", \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), " ", \(r\^2\), 
                " ", 
                RowBox[{
                  SuperscriptBox["\[Gamma]", 
                    TagBox[\((1, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}], "-", 
              RowBox[{
              \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\), " ", \(r\^4\), " ", 
                RowBox[{
                  SuperscriptBox["U", 
                    TagBox[\((1, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(u, r, \[Theta]\), 
                  "]"}]}]}], ")"}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(covD[gdd]\)], "Input"],

Cell[BoxData[
    \({{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
          0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LieD[{0, 0, 0, 1}, Rdd]\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox[
  "Verification of the Bianchi identities for this metric takes ~ 19 min \
(12.5 min + 6 min + 7 sec).",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\n\t",
  StyleBox[
  "One can choose to skip the time consuming RUddd, Wdddd or EUd computations \
by calling ",
    FontSize->16],
  StyleBox["RGtensors",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" wirh a 3rd argument -- a list of 2 or 3 integers:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord, {0, 0}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                      U[u, r, \[Theta]]\^2 + 
                    \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\ 
                        V[u, r, \[Theta]]\)\/r\), 
                  \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), 
                  \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0"},
                {\(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), "0", "0", "0"},
               
                 {\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0", 
                  \(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\), "0"},
               
                 {"0", "0", "0", 
                  \(\(-E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                    Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                U[ u, r, \[Theta]], 2]], 
            Times[ 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              Power[ r, -1], 
              V[ u, r, \[Theta]]]], 
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0}, {
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0, 0}, {
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(2\ E\^\(2\ \[Beta][u, r, \[Theta]]\)\ d[r]\ d[u] - 
            E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[Theta]]\^2 - 
            E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[CurlyPhi]]\^2\ 
              Sin[\[Theta]]\^2 + 
            2\ E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[u]\ d[\[Theta]]\ 
              U[u, r, \[Theta]] - 
            \(d[u]\^2\ 
                \((E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^3\ 
                      U[u, r, \[Theta]]\^2 - 
                    E\^\(2\ \[Beta][u, r, \[Theta]]\)\ V[u, r, \[Theta]])
                  \)\)\/r\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              d[ r], 
              d[ u]], 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ E, 
                Times[ -2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              d[ u], 
              d[ \[Theta]], 
              U[ u, r, \[Theta]]], 
            Times[ -1, 
              Power[ r, -1], 
              Power[ 
                d[ u], 2], 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, 
                      \[Gamma][ u, r, \[Theta]]]], 
                  Power[ r, 3], 
                  Power[ 
                    U[ u, r, \[Theta]], 2]], 
                Times[ -1, 
                  Power[ E, 
                    Times[ 2, 
                      \[Beta][ u, r, \[Theta]]]], 
                  V[ u, r, \[Theta]]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), "0", "0"},
               
                 {\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), 
                  \(-\(\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                          V[u, r, \[Theta]]\)\/r\)\), 
                  \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), "0"},
               
                 {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), 
                  \(-\(E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\/r\^2\)\), 
                  "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ 
                          Csc[\[Theta]]\^2\)\/r\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0}, {
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            Power[ r, -1], 
            V[ u, r, \[Theta]]], 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 0}, {0, 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.416666666666657192`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.41666666666665719, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]1.68333333333333712`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 1.6833333333333371, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("RUddd not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]2.56666666666666287`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 2.5666666666666629, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]1.98333333333334849`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 1.9833333333333485, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 6.83333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord, {1, 0, 0}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                      U[u, r, \[Theta]]\^2 + 
                    \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\ 
                        V[u, r, \[Theta]]\)\/r\), 
                  \(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), 
                  \(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0"},
                {\(E\^\(2\ \[Beta][u, r, \[Theta]]\)\), "0", "0", "0"},
               
                 {\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ 
                    U[u, r, \[Theta]]\), "0", 
                  \(\(-E\^\(2\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\), "0"},
               
                 {"0", "0", "0", 
                  \(\(-E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\)\ r\^2\ 
                    Sin[\[Theta]]\^2\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                U[ u, r, \[Theta]], 2]], 
            Times[ 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              Power[ r, -1], 
              V[ u, r, \[Theta]]]], 
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0}, {
          Power[ E, 
            Times[ 2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0, 0}, {
          Times[ 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            U[ u, r, \[Theta]]], 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(2\ E\^\(2\ \[Beta][u, r, \[Theta]]\)\ d[r]\ d[u] - 
            E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[Theta]]\^2 - 
            E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[\[CurlyPhi]]\^2\ 
              Sin[\[Theta]]\^2 + 
            2\ E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^2\ d[u]\ d[\[Theta]]\ 
              U[u, r, \[Theta]] - 
            \(d[u]\^2\ 
                \((E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ r\^3\ 
                      U[u, r, \[Theta]]\^2 - 
                    E\^\(2\ \[Beta][u, r, \[Theta]]\)\ V[u, r, \[Theta]])
                  \)\)\/r\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Beta][ u, r, \[Theta]]]], 
              d[ r], 
              d[ u]], 
            Times[ -1, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ E, 
                Times[ -2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 2, 
              Power[ E, 
                Times[ 2, 
                  \[Gamma][ u, r, \[Theta]]]], 
              Power[ r, 2], 
              d[ u], 
              d[ \[Theta]], 
              U[ u, r, \[Theta]]], 
            Times[ -1, 
              Power[ r, -1], 
              Power[ 
                d[ u], 2], 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, 
                      \[Gamma][ u, r, \[Theta]]]], 
                  Power[ r, 3], 
                  Power[ 
                    U[ u, r, \[Theta]], 2]], 
                Times[ -1, 
                  Power[ E, 
                    Times[ 2, 
                      \[Beta][ u, r, \[Theta]]]], 
                  V[ u, r, \[Theta]]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), "0", "0"},
               
                 {\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\), 
                  \(-\(\(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                          V[u, r, \[Theta]]\)\/r\)\), 
                  \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), "0"},
               
                 {"0", \(E\^\(\(-2\)\ \[Beta][u, r, \[Theta]]\)\ 
                    U[u, r, \[Theta]]\), 
                  \(-\(E\^\(\(-2\)\ \[Gamma][u, r, \[Theta]]\)\/r\^2\)\), 
                  "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(E\^\(2\ \[Gamma][u, r, \[Theta]]\)\ 
                          Csc[\[Theta]]\^2\)\/r\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 0, 0}, {
          Power[ E, 
            Times[ -2, 
              \[Beta][ u, r, \[Theta]]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            Power[ r, -1], 
            V[ u, r, \[Theta]]], 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 0}, {0, 
          Times[ 
            Power[ E, 
              Times[ -2, 
                \[Beta][ u, r, \[Theta]]]], 
            U[ u, r, \[Theta]]], 
          Times[ -1, 
            Power[ E, 
              Times[ -2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, 
                \[Gamma][ u, r, \[Theta]]]], 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.416666666666685614`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.41666666666668561, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]1.6833333333333087`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 1.6833333333333087, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]6.51666666666667993`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 6.5166666666666799, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]2.64999999999997726`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 2.6499999999999773, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("Einstein tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 11.4167 seconds"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
" Example 8: Kerr with Cos[\[Theta]],  Sin[\[Theta]]"], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\tTransform Boyer-Lindquist t, \[CurlyPhi]BL coordinates: ",
  StyleBox[
  " d[t]->d[u]+(r^2+a^2) d[r]/(r^2-2M*r+a^2), \
d[\[CurlyPhi]BL]->d[\[CurlyPhi]]+a d[r]/(r^2-2M*r+a^2)",
    FontFamily->"Courier",
    FontSize->14],
  StyleBox[";",
    FontSize->14]
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(xCoord = {u, r, \[Theta], \[CurlyPhi]}; \)\)], "Input"],

Cell[BoxData[
    \(\(g = {{1 - \(2\ M\ r\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\), 1, 0, 
          \(2  a\ \ M\ r\ Sin[\[Theta]]^2\)\/\(r\^2 + 
              a\^2\ Cos[\[Theta]]\^2\)}, {1, 0, 0, 
          \(-a\)\ \ Sin[\[Theta]]^2}, {0, 0, 
          \(-\((r^2 + a^2  Cos[\[Theta]]^2)\)\), 0}, {
          \(2  a\ \ M\ r\ Sin[\[Theta]]^2\)\/\(r\^2 + 
              a\^2\ Cos[\[Theta]]\^2\), \(-a\)\ \ Sin[\[Theta]]^2, 0, 
          \(-Sin[\[Theta]]^2\) 
            \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + 
                  a\^2\ \((a\^2 - 2\ M\ r + r\^2)\)\ Cos[\[Theta]]\^2)\)/
              \((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)}}; \)\)], "Input"],

Cell[TextData[{
  "\n\n\t",
  StyleBox[
  "(1)  Use TrigRules in simpRules and do not compute theWeyl tensor:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord, {1, 0, 0}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1 - \(2\ M\ r\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\), "1",
                   "0", \(\(2\ a\ M\ r\ Sin[\[Theta]]\^2\)\/\(r\^2 + 
                        a\^2\ Cos[\[Theta]]\^2\)\)},
                {"1", "0", "0", \(\(-a\)\ Sin[\[Theta]]\^2\)},
                {"0", "0", \(\(-r\^2\) - a\^2\ Cos[\[Theta]]\^2\), "0"},
               
                 {\(\(2\ a\ M\ r\ Sin[\[Theta]]\^2\)\/\(r\^2 + 
                        a\^2\ Cos[\[Theta]]\^2\)\), 
                  \(\(-a\)\ Sin[\[Theta]]\^2\), "0", 
                  \(-\(\(\((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + 
                              a\^2\ \((a\^2 - 2\ M\ r + r\^2)\)\ 
                                Cos[\[Theta]]\^2)\)\ 
                          Sin[\[Theta]]\^2\)\/\(r\^2 + 
                          a\^2\ Cos[\[Theta]]\^2\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, r, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1]]], 1, 0, 
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Power[ 
              Sin[ \[Theta]], 2]]}, {1, 0, 0, 
          Times[ -1, a, 
            Power[ 
              Sin[ \[Theta]], 2]]}, {0, 0, 
          Plus[ 
            Times[ -1, 
              Power[ r, 2]], 
            Times[ -1, 
              Power[ a, 2], 
              Power[ 
                Cos[ \[Theta]], 2]]], 0}, {
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Power[ 
              Sin[ \[Theta]], 2]], 
          Times[ -1, a, 
            Power[ 
              Sin[ \[Theta]], 2]], 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Plus[ 
              Times[ 2, 
                Power[ a, 2], M, r], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2]], 
              Power[ r, 4], 
              Times[ 
                Power[ a, 2], 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], 
                Power[ 
                  Cos[ \[Theta]], 2]]], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((2\ M\ r - r\^2 - a\^2\ Cos[\[Theta]]\^2)\)\ 
                  d[u]\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\) + 
            \((\(-r\^2\) - a\^2\ Cos[\[Theta]]\^2)\)\ d[\[Theta]]\^2 + 
            \(4\ a\ M\ r\ d[u]\ d[\[CurlyPhi]]\ Sin[\[Theta]]\^2\)\/\(r\^2 + 
                a\^2\ Cos[\[Theta]]\^2\) - 
            \(\((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ Cos[\[Theta]]\^2 - 
                    2\ a\^2\ M\ r\ Cos[\[Theta]]\^2 + 
                    a\^2\ r\^2\ Cos[\[Theta]]\^2)\)\ d[\[CurlyPhi]]\^2\ 
                Sin[\[Theta]]\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\) + 
            d[r]\ \((2\ d[u] - 2\ a\ d[\[CurlyPhi]]\ Sin[\[Theta]]\^2)\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Plus[ 
                Times[ 2, M, r], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              Power[ 
                d[ u], 2]], 
            Times[ 
              Plus[ 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ 4, a, M, r, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              d[ u], 
              d[ \[CurlyPhi]], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ 
                    Cos[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ 
                    Cos[ \[Theta]], 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 
              d[ r], 
              Plus[ 
                Times[ 2, 
                  d[ u]], 
                Times[ -2, a, 
                  d[ \[CurlyPhi]], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(a\^2\ Sin[\[Theta]]\^2\)\/\(\(-a\^2\) - r\^2 + 
                        a\^2\ Sin[\[Theta]]\^2\)\), 
                  \(-\(\(a\^2 + r\^2\)\/\(\(-a\^2\) - r\^2 + 
                          a\^2\ Sin[\[Theta]]\^2\)\)\), "0", 
                  \(a\/\(\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2\)\)},
               
                 {\(-\(\(a\^2 + r\^2\)\/\(\(-a\^2\) - r\^2 + 
                          a\^2\ Sin[\[Theta]]\^2\)\)\), 
                  \(\(a\^2 - 2\ M\ r + r\^2\)\/\(\(-a\^2\) - r\^2 + 
                        a\^2\ Sin[\[Theta]]\^2\)\), "0", 
                  \(-\(a\/\(\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2\)\)\)},
               
                 {"0", "0", \(-\(1\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\)\), 
                  "0"},
               
                 {\(a\/\(\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2\)\), 
                  \(-\(a\/\(\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2\)\)\), 
                  "0", \(Csc[\[Theta]]\^2\/\(\(-a\^2\) - r\^2 + 
                        a\^2\ Sin[\[Theta]]\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ a, 2], 
            Power[ 
              Sin[ \[Theta]], 2], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 
          Times[ -1, 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 0, 
          Times[ a, 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]]}, {
          Times[ -1, 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 
          Times[ 
            Plus[ 
              Power[ a, 2], 
              Times[ -2, M, r], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 0, 
          Times[ -1, a, 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]]}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 0}, {
          Times[ a, 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 
          Times[ -1, a, 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]], 0, 
          Times[ 
            Power[ 
              Csc[ \[Theta]], 2], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2]], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.483333333333348491`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.48333333333334849, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.5`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.5, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]1.83333333333331438`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 1.8333333333333144, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]11.0666666666666624`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 11.066666666666663, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]4.71666666666666856`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 4.7166666666666686, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("Einstein tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 18.6833 seconds"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Note that, using TrigRules, ",
    FontSize->16],
  StyleBox["RGtensors",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" is unable to verify that the metric is Ricci-Flat. ",
    FontSize->16],
  StyleBox["Rdd",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[" has two independent non-vanishing components:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[Rdd]\)], "Input"],

Cell[BoxData[
    \({\((
          a\^2\ Cos[\[Theta]]\ 
            \((2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                2\ a\^6\ M\ r\^2\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                4\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                9\ a\^4\ M\ r\^4\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                3\ a\^4\ r\^5\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                4\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                4\ a\^2\ M\ r\^6\ Cos[\[Theta]]\ Cot[\[Theta]] + 
                2\ a\^2\ r\^7\ Cos[\[Theta]]\ Cot[\[Theta]] - 
                5\ M\ r\^8\ Cos[\[Theta]]\ Cot[\[Theta]] - 
                r\^9\ Cos[\[Theta]]\ Cot[\[Theta]] - 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^3\ Cot[\[Theta]] + 
                a\^6\ M\ r\^2\ Cos[\[Theta]]\^3\ Cot[\[Theta]] + 
                3\ a\^6\ r\^3\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                2\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                4\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                2\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                11\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                3\ a\^2\ r\^7\ Cos[\[Theta]]\^3\ Cot[\[Theta]] - 
                a\^8\ M\ Cos[\[Theta]]\^5\ Cot[\[Theta]] + 
                a\^8\ r\ Cos[\[Theta]]\^5\ Cot[\[Theta]] - 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^5\ Cot[\[Theta]] - 
                2\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^5\ Cot[\[Theta]] - 
                2\ a\^6\ r\^3\ Cos[\[Theta]]\^5\ Cot[\[Theta]] - 
                7\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^5\ Cot[\[Theta]] - 
                3\ a\^4\ r\^5\ Cos[\[Theta]]\^5\ Cot[\[Theta]] + 
                a\^8\ M\ Cos[\[Theta]]\^7\ Cot[\[Theta]] - 
                a\^8\ r\ Cos[\[Theta]]\^7\ Cot[\[Theta]] + 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^7\ Cot[\[Theta]] - 
                a\^6\ M\ r\^2\ Cos[\[Theta]]\^7\ Cot[\[Theta]] - 
                a\^6\ r\^3\ Cos[\[Theta]]\^7\ Cot[\[Theta]] - 
                2\ a\^4\ M\^2\ r\^3\ Csc[\[Theta]] + 
                2\ a\^4\ M\ r\^4\ Csc[\[Theta]] - 
                2\ a\^2\ M\^2\ r\^5\ Csc[\[Theta]] + 
                7\ a\^2\ M\ r\^6\ Csc[\[Theta]] + a\^2\ r\^7\ Csc[\[Theta]] + 
                5\ M\ r\^8\ Csc[\[Theta]] + r\^9\ Csc[\[Theta]] + 
                4\ a\^4\ M\^2\ r\^3\ Sin[\[Theta]] - 
                6\ a\^4\ M\ r\^4\ Sin[\[Theta]] + 
                2\ a\^2\ M\^2\ r\^5\ Sin[\[Theta]] - 
                13\ a\^2\ M\ r\^6\ Sin[\[Theta]] - 
                a\^2\ r\^7\ Sin[\[Theta]] - 5\ M\ r\^8\ Sin[\[Theta]] - 
                r\^9\ Sin[\[Theta]] - 
                6\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                6\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                6\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                17\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                3\ a\^4\ r\^5\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                2\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                5\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^2\ Sin[\[Theta]] - 
                3\ a\^2\ r\^7\ Cos[\[Theta]]\^2\ Sin[\[Theta]] + 
                4\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^4\ Sin[\[Theta]] - 
                3\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4\ Sin[\[Theta]] - 
                3\ a\^6\ r\^3\ Cos[\[Theta]]\^4\ Sin[\[Theta]] + 
                2\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^4\ Sin[\[Theta]] + 
                3\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^4\ Sin[\[Theta]] - 
                3\ a\^4\ r\^5\ Cos[\[Theta]]\^4\ Sin[\[Theta]] + 
                a\^8\ M\ Cos[\[Theta]]\^6\ Sin[\[Theta]] - 
                a\^8\ r\ Cos[\[Theta]]\^6\ Sin[\[Theta]] + 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^6\ Sin[\[Theta]] + 
                3\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^6\ Sin[\[Theta]] - 
                a\^6\ r\^3\ Cos[\[Theta]]\^6\ Sin[\[Theta]] - 
                2\ a\^4\ M\^2\ r\^3\ Sin[\[Theta]]\^3 + 
                6\ a\^4\ M\ r\^4\ Sin[\[Theta]]\^3 + 
                6\ a\^2\ M\ r\^6\ Sin[\[Theta]]\^3 + 
                6\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^3 + 
                6\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^3 + 
                2\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^3 + 
                8\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^3 - 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^3 + 
                2\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^3 - 
                2\ a\^4\ M\ r\^4\ Sin[\[Theta]]\^5 - 
                2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^5 - 
                2\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^5)\))\)/
        \((\((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\^4\ 
            \((\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2)\)\^2)\), 
      \((a\^2\ r\ \((
            \(-3\)\ a\^2\ M\ r\^6 - a\^2\ r\^7 + M\ r\^8 + 
              16\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2 + 
              6\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2 + 
              24\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2 + 
              15\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2 - 
              3\ a\^4\ r\^5\ Cos[\[Theta]]\^2 + 
              10\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^2 + 
              18\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^2 - 
              2\ a\^2\ r\^7\ Cos[\[Theta]]\^2 + M\ r\^8\ Cos[\[Theta]]\^2 + 
              8\ a\^8\ M\ Cos[\[Theta]]\^4 + 
              19\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4 - 
              3\ a\^6\ r\^3\ Cos[\[Theta]]\^4 - 
              18\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^4 + 
              22\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^4 - 
              10\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^4 - 
              5\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^4 + 
              3\ a\^2\ r\^7\ Cos[\[Theta]]\^4 + a\^8\ M\ Cos[\[Theta]]\^6 - 
              a\^8\ r\ Cos[\[Theta]]\^6 - 
              18\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^6 + 
              4\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^6 + 
              2\ a\^6\ r\^3\ Cos[\[Theta]]\^6 - 
              6\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^6 - 
              17\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^6 + 
              3\ a\^4\ r\^5\ Cos[\[Theta]]\^6 - a\^8\ M\ Cos[\[Theta]]\^8 + 
              a\^8\ r\ Cos[\[Theta]]\^8 + 
              2\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^8 - 
              15\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^8 + 
              a\^6\ r\^3\ Cos[\[Theta]]\^8 - 4\ a\^8\ M\ Cos[\[Theta]]\^10 - 
              4\ a\^6\ M\^2\ r\ Cot[\[Theta]]\^2 - 
              8\ a\^4\ M\^2\ r\^3\ Cot[\[Theta]]\^2 - 
              4\ a\^2\ M\^2\ r\^5\ Cot[\[Theta]]\^2 - 
              4\ a\^2\ M\ r\^6\ Cot[\[Theta]]\^2 - 
              2\ M\ r\^8\ Cot[\[Theta]]\^2 - 
              4\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 + 
              8\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 - 
              8\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 + 
              8\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 - 
              2\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 + 
              2\ M\ r\^8\ Cos[\[Theta]]\^2\ Cot[\[Theta]]\^2 - 
              2\ a\^8\ M\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 + 
              8\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 - 
              4\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 + 
              8\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 + 
              4\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 - 
              4\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 + 
              6\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^4\ Cot[\[Theta]]\^2 + 
              6\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^6\ Cot[\[Theta]]\^2 - 
              8\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^6\ Cot[\[Theta]]\^2 + 
              6\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^6\ Cot[\[Theta]]\^2 + 
              2\ a\^8\ M\ Cos[\[Theta]]\^8\ Cot[\[Theta]]\^2 - 
              4\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^8\ Cot[\[Theta]]\^2 + 
              2\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^8\ Cot[\[Theta]]\^2 - 
              2\ a\^4\ M\ r\^4\ Csc[\[Theta]]\^2 + 
              6\ a\^4\ M\ r\^4\ Sin[\[Theta]]\^2 + 
              7\ a\^2\ M\ r\^6\ Sin[\[Theta]]\^2 + 
              3\ a\^2\ r\^7\ Sin[\[Theta]]\^2 - M\ r\^8\ Sin[\[Theta]]\^2 - 
              24\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              18\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              24\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              23\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 + 
              9\ a\^4\ r\^5\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              6\ a\^2\ M\^2\ r\^5\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              15\ a\^2\ M\ r\^6\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 + 
              a\^2\ r\^7\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2 - 
              24\ a\^8\ M\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 - 
              27\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 + 
              9\ a\^6\ r\^3\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 + 
              10\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 - 
              15\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 - 
              3\ a\^4\ r\^5\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^2 + 
              3\ a\^8\ M\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^2 + 
              3\ a\^8\ r\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^2 + 
              10\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^2 + 
              a\^6\ M\ r\^2\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^2 - 
              5\ a\^6\ r\^3\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^2 + 
              2\ a\^8\ M\ Cos[\[Theta]]\^8\ Sin[\[Theta]]\^2 - 
              2\ a\^8\ r\ Cos[\[Theta]]\^8\ Sin[\[Theta]]\^2 - 
              6\ a\^4\ M\ r\^4\ Sin[\[Theta]]\^4 - 
              4\ a\^2\ M\ r\^6\ Sin[\[Theta]]\^4 - 
              2\ a\^2\ r\^7\ Sin[\[Theta]]\^4 + 
              16\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^4 + 
              18\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^4 + 
              8\ a\^4\ M\^2\ r\^3\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^4 + 
              10\ a\^4\ M\ r\^4\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^4 - 
              6\ a\^4\ r\^5\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^4 + 
              24\ a\^8\ M\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^4 + 
              12\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^4 - 
              6\ a\^6\ r\^3\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^4 - 
              2\ a\^8\ M\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^4 - 
              2\ a\^8\ r\ Cos[\[Theta]]\^6\ Sin[\[Theta]]\^4 + 
              2\ a\^4\ M\ r\^4\ Sin[\[Theta]]\^6 - 
              4\ a\^6\ M\^2\ r\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^6 - 
              6\ a\^6\ M\ r\^2\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^6 - 
              8\ a\^8\ M\ Cos[\[Theta]]\^4\ Sin[\[Theta]]\^6)\))\)/
        \((\((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\^4\ 
            \((a\^2 + r\^2 - a\^2\ Sin[\[Theta]]\^2)\)\^2)\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[BoxData[
    \({0, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 3]\)]\)], "Input"],

Cell[BoxData[
    \(\((a\^2\ M\ Cos[\[Theta]]\ Sin[\[Theta]]\ 
          \((8\ a\^2\ r\^2 + 3\ r\^4 - 2\ a\^4\ Cos[\[Theta]]\^2 - 
              6\ a\^2\ r\^2\ Cos[\[Theta]]\^2 + a\^4\ Cos[\[Theta]]\^4 - 
              8\ a\^2\ r\^2\ Sin[\[Theta]]\^2 + 
              2\ a\^4\ Cos[\[Theta]]\^2\ Sin[\[Theta]]\^2)\))\)/
      \((\((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\^3\ 
          \((\(-a\^2\) - r\^2 + a\^2\ Sin[\[Theta]]\^2)\))\)\)], "Output"]
}, Open  ]],

Cell["", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox[
  "(2)  To simplify denominators in gUU and elsewhere, use extra rule in \
simpRules:",
    FontSize->16]
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(simpRules = 
      Join[TrigRules, {
          Sin[\[Theta]]\^n_ :> 
            \(Sin[\[Theta]]\^\(n - 2\)\) \((1 - Cos[\[Theta]]\^2)\) /; n > 1}]
        \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({Cos[h_]\^2\ x_. + x_.\ Sin[h_]\^2 \[RuleDelayed] x, 
      Cot[h_]\^2\ x_. + Csc[h_]\^2\ y_. \[RuleDelayed] y /; x + y === 0, 
      \((Cot[h_] - Csc[h_])\)\ \((Cot[h_] + Csc[h_])\) \[Rule] \(-1\), 
      Sin[\[Theta]]\^n_ \[RuleDelayed] 
        Sin[\[Theta]]\^\(n - 2\)\ \((1 - Cos[\[Theta]]\^2)\) /; n > 1}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(1 - \(2\ M\ r\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\), "1",
                   "0", \(\(2\ a\ M\ r\ Sin[\[Theta]]\^2\)\/\(r\^2 + 
                        a\^2\ Cos[\[Theta]]\^2\)\)},
                {"1", "0", "0", \(\(-a\)\ Sin[\[Theta]]\^2\)},
                {"0", "0", \(\(-r\^2\) - a\^2\ Cos[\[Theta]]\^2\), "0"},
               
                 {\(\(2\ a\ M\ r\ Sin[\[Theta]]\^2\)\/\(r\^2 + 
                        a\^2\ Cos[\[Theta]]\^2\)\), 
                  \(\(-a\)\ Sin[\[Theta]]\^2\), "0", 
                  \(-\(\(\((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + 
                              a\^2\ \((a\^2 - 2\ M\ r + r\^2)\)\ 
                                Cos[\[Theta]]\^2)\)\ 
                          Sin[\[Theta]]\^2\)\/\(r\^2 + 
                          a\^2\ Cos[\[Theta]]\^2\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, r, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1]]], 1, 0, 
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Power[ 
              Sin[ \[Theta]], 2]]}, {1, 0, 0, 
          Times[ -1, a, 
            Power[ 
              Sin[ \[Theta]], 2]]}, {0, 0, 
          Plus[ 
            Times[ -1, 
              Power[ r, 2]], 
            Times[ -1, 
              Power[ a, 2], 
              Power[ 
                Cos[ \[Theta]], 2]]], 0}, {
          Times[ 2, a, M, r, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Power[ 
              Sin[ \[Theta]], 2]], 
          Times[ -1, a, 
            Power[ 
              Sin[ \[Theta]], 2]], 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1], 
            Plus[ 
              Times[ 2, 
                Power[ a, 2], M, r], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2]], 
              Power[ r, 4], 
              Times[ 
                Power[ a, 2], 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], 
                Power[ 
                  Cos[ \[Theta]], 2]]], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((2\ M\ r - r\^2 - a\^2\ Cos[\[Theta]]\^2)\)\ 
                  d[u]\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\) + 
            \((\(-r\^2\) - a\^2\ Cos[\[Theta]]\^2)\)\ d[\[Theta]]\^2 - 
            \(4\ a\ M\ r\ \((\(-1\) + Cos[\[Theta]])\)\ 
                \((1 + Cos[\[Theta]])\)\ d[u]\ d[\[CurlyPhi]]\)\/\(r\^2 + 
                a\^2\ Cos[\[Theta]]\^2\) + 
            \(\((\(-1\) + Cos[\[Theta]])\)\ \((1 + Cos[\[Theta]])\)\ 
                \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + 
                    a\^4\ Cos[\[Theta]]\^2 - 
                    2\ a\^2\ M\ r\ Cos[\[Theta]]\^2 + 
                    a\^2\ r\^2\ Cos[\[Theta]]\^2)\)\ 
                d[\[CurlyPhi]]\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\) + 
            d[r]\ \((
                2\ d[u] + 
                  2\ a\ \((\(-1\) + Cos[\[Theta]])\)\ 
                    \((1 + Cos[\[Theta]])\)\ d[\[CurlyPhi]])\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Plus[ 
                Times[ 2, M, r], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              Power[ 
                d[ u], 2]], 
            Times[ 
              Plus[ 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ -4, a, M, r, 
              Plus[ -1, 
                Cos[ \[Theta]]], 
              Plus[ 1, 
                Cos[ \[Theta]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              d[ u], 
              d[ \[CurlyPhi]]], 
            Times[ 
              Plus[ -1, 
                Cos[ \[Theta]]], 
              Plus[ 1, 
                Cos[ \[Theta]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ 
                      Cos[ \[Theta]], 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ 
                    Cos[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ 
                    Cos[ \[Theta]], 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2]], 
            Times[ 
              d[ r], 
              Plus[ 
                Times[ 2, 
                  d[ u]], 
                Times[ 2, a, 
                  Plus[ -1, 
                    Cos[ \[Theta]]], 
                  Plus[ 1, 
                    Cos[ \[Theta]]], 
                  d[ \[CurlyPhi]]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(a\^2\ \((\(-1\) + Cos[\[Theta]])\)\ 
                        \((1 + Cos[\[Theta]])\)\)\/\(r\^2 + 
                        a\^2\ Cos[\[Theta]]\^2\)\), 
                  \(\(a\^2 + r\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\), "0",
                   \(-\(a\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\)\)},
               
                 {\(\(a\^2 + r\^2\)\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\), 
                  \(-\(\(a\^2 - 2\ M\ r + r\^2\)\/\(r\^2 + 
                          a\^2\ Cos[\[Theta]]\^2\)\)\), "0", 
                  \(a\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\)},
               
                 {"0", "0", \(-\(1\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\)\), 
                  "0"},
               
                 {\(-\(a\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\)\), 
                  \(a\/\(r\^2 + a\^2\ Cos[\[Theta]]\^2\)\), "0", 
                  \(1\/\(\((\(-1\) + Cos[\[Theta]])\)\ 
                        \((1 + Cos[\[Theta]])\)\ 
                        \((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ a, 2], 
            Plus[ -1, 
              Cos[ \[Theta]]], 
            Plus[ 1, 
              Cos[ \[Theta]]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 
          Times[ 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 0, 
          Times[ -1, a, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]]}, {
          Times[ 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 
          Times[ -1, 
            Plus[ 
              Power[ a, 2], 
              Times[ -2, M, r], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 0, 
          Times[ a, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]]}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 0}, {
          Times[ -1, a, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 
          Times[ a, 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]], 0, 
          Times[ 
            Power[ 
              Plus[ -1, 
                Cos[ \[Theta]]], -1], 
            Power[ 
              Plus[ 1, 
                Cos[ \[Theta]]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ 
                    Cos[ \[Theta]], 2]]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.516666666666651508`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.51666666666665151, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.366666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.36666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.483333333333320069`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.48333333333332007, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.916666666666685614`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.91666666666668561, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0333333333333314385`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.033333333333331439, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 2.48333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUdd[\([2, 2, 3]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(a\^2\ Cos[\[Theta]]\ Sin[\[Theta]]\)\/\(r\^2 + 
            a\^2\ Cos[\[Theta]]\^2\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 3]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(a\^2\ M\ Cos[\[Theta]]\ \((\(-3\)\ r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\ 
        Sin[\[Theta]]\)\/\((r\^2 + a\^2\ Cos[\[Theta]]\^2)\)\^3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Note the speed improvement with the extra simplification rule!",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"]
}, Closed]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print["\<Total time = \>", Round[AbsoluteTime[] - stTim], "\< sec\>"]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Total time = "\[InvisibleSpace]94\[InvisibleSpace]" sec"\),
      SequenceForm[ "Total time = ", 94, " sec"],
      Editable->False]], "Print"]
}, Open  ]],

Cell[TextData[{
  "\n\t",
  StyleBox[
  "Sections 5 and 6 contain examples illustrating more advanced features of \
RG&TC. The examples in each subsection must be evaluated in sequence as some \
definitions given in the first one are also used later.\n\t\n\tMore \
complicated examples can be found in ",
    FontSize->16],
  StyleBox[ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSize->16],
  StyleBox[".",
    FontSize->16]
}], "Text"]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 4  Usage Tips & Auxiliary Functions",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.0  Do not use symbols defined in RGtensors "
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe most common cause of unexpected behavior or meaningless results is \
the inappropriate use, in the coordinates or the metric, of a symbol that is \
defined by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  ". For example, if one's metric contains the function ",
  StyleBox["R[x,y...]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " will go in an infinite loop trying to define the scalar curvature, \
denoted by R, in terms of the metric function ",
  StyleBox["R[x,y...]",
    FontFamily->"Courier"],
  "! The same will happen if the symbol ",
  StyleBox["R",
    FontFamily->"Courier"],
  " is used as a coordinate. The situation is worse when an NP frame is used, \
where several more single-letter symbols are defined by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " (the spin coefficients and ",
  StyleBox["\[CapitalLambda]",
    FontFamily->"Courier"],
  ", \[CapitalPhi]  and ",
  StyleBox["\[CapitalPsi]",
    FontFamily->"Courier"],
  ") or have special meanings (d, e). ",
  StyleBox[
  "One must, therefore, make sure that the symbols used in one's coordinates, \
metric or frame are distinct from (or are consistent with) the global \
variables listed in section 1.5",
    FontSlant->"Italic"],
  "."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.1  Avoid displaying long expressions & keep intermediate results"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe most important thing to keep in mind when working with nested lists \
is that one can easily generate huge outputs that can tax the graphics \
capabilities of any system and may even cause ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to crash. Besides, not much is gained by viewing on screen deeply nested \
lists containing mostly zeros! Thus, as a general rule, ",
  StyleBox["never evaluate an input line that does not end in a semi-colon",
    FontSlant->"Italic"],
  "(",
  StyleBox[";",
    FontFamily->"Courier"],
  "). As a safeguard, the printed form of any expression that exceeds 200 KB \
is shortened, occasionally resulting in the output <<1>> (which means \"too \
big to be displayed\"). One can still use this quantity in calculations, \
however, and display parts of it."
}], "Text",
  FontSize->16],

Cell["\<\
\tOne must, therefore, get used to working with symbols \
representing tensors and only occasionally view individual components or \
subparts. Also, because operations on lists are time-consuming, one must save \
intermediate results in case they are needed later on. For these reasons, a \
consistent system of naming tensors is necessary to keep track of what has \
been calculated.\
\>", "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe U/d naming convention used here is reasonably short and visually \
conveys the properties (rank, index type) of the tensor represented. For \
contractions, the convention can be extended by using the same letter in \
upper/lower case (S, s) for pairs of contracted indices. Finally, for \
covariant derivatives, one can use the letter j (resembling ",
  StyleBox[";",
    FontFamily->"Courier"],
  ") to separate covariant differentiation indices. For example, the symbol \
RUdddjd is an obvious candidate for ",
  StyleBox["covD[RUddd,{1}]",
    FontFamily->"Courier"],
  ", while RSdddjs can be used for ",
  StyleBox["covDiv[RUddd,{1}]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tAnother notation, similar to the one used for ",
  StyleBox["eta",
    FontFamily->"Courier"],
  " (Section 1.1.1), is to define an appropriately named ",
  StyleBox["function",
    FontSlant->"Italic"],
  " for each tensor, with arguments the positions of the contravariant \
indices. For example, for the Riemann tensor, the definition"
}], "Text",
  FontSize->16],

Cell[BoxData[
    \(Riem[] = Rdddd; Riem[a__] := \(Riem[a] = Raise[Rdddd, a]\); \)], "Input"],

Cell[TextData[{
  "would enable one to use the notation ",
  StyleBox["Riem[1]",
    FontFamily->"Courier"],
  " for the tensor ",
  StyleBox["RUddd",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Riem[3,4]",
    FontFamily->"Courier"],
  " for the tensor ",
  StyleBox["RddUU",
    FontFamily->"Courier"],
  ", etc. Of course, all these are just ",
  StyleBox["names",
    FontSlant->"Italic"],
  " for referring to nested lists stored in memory; any name that is \
meaningful to the user can be used!"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.2  Auxiliary functions for examining and simplifying lists"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe following auxiliary functions have been defined and are useful in \
examining high rank tensors:"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(1) ",
  StyleBox["zeroQ[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " tests if the tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the zero tensor, returning ",
  StyleBox["True",
    FontFamily->"Courier"],
  " or ",
  StyleBox["False",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(2) ",
  StyleBox["nonZeroN[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the ",
  StyleBox["Number",
    FontSlant->"Italic"],
  " of non-zero components of the tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(3) ",
  StyleBox["nonZeroL[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a ",
  StyleBox["List",
    FontSlant->"Italic"],
  " containing the ",
  StyleBox["distinct ",
    FontSlant->"Italic"],
  "non-zero components of the tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (if ",
  StyleBox["Z",
    FontFamily->"Courier"],
  " is any expression, ",
  StyleBox["Z,-Z,2Z",
    FontFamily->"Courier"],
  "  are considered distinct). ",
  StyleBox["To find which components of ",
    FontSize->16],
  StyleBox["x",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" equal a particular element of ",
    FontSize->16],
  StyleBox["nonZeroL[x]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[", use the ",
    FontSize->16],
  StyleBox["Mathematica",
    FontSize->16,
    FontSlant->"Italic"],
  StyleBox[" function ",
    FontSize->16],
  StyleBox["Position",
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  StyleBox[". Thus, ",
    FontSize->16],
  StyleBox["Position[Rdddd,nonZeroL[Rdddd][[1]]]",
    FontFamily->"Courier"],
  " will produce a list of the indices -- components of ",
  StyleBox["Rdddd",
    FontFamily->"Courier"],
  " -- which are equal to the second argument of ",
  StyleBox["Position",
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  ". ",
  StyleBox["See Example 3 (1).",
    FontSize->16]
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(4) ",
  StyleBox["indepTerms[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a list of the \"independent\" components of the tensor ",
  StyleBox["x",
    FontWeight->"Bold"],
  ". Independent here means not equal to  \[PlusMinus]  a numerical multiple \
of another component. Note that ",
  StyleBox["indepTerms",
    FontFamily->"Courier"],
  " does not perform any reductions:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[{2  a + 2  b, a + b}]\)], "Input"],

Cell[BoxData[
    \({a + b, 2\ a + 2\ b}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[{2 \((a + b)\), a + b}]\)], "Input"],

Cell[BoxData[
    \({a + b}\)], "Output"]
}, Open  ]],

Cell["nor does it test for linear dependence:", "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[{a - b, b - c, c - a}]\)], "Input"],

Cell[BoxData[
    \({a - b, b - c, \(-a\) + c}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plus@@%\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["indepTerms",
    FontFamily->"Courier"],
  " can take an optional second argument - a list of symbols or expressions \
which, when appearing as overall factors, can be ignored in testing \
equivalence.  Consider, for example, the following list ",
  StyleBox["S",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (Z can be any expression):"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox["S",
        FontFamily->"Courier"], 
      StyleBox["=",
        FontFamily->"Courier"], 
      RowBox[{
        StyleBox["{",
          FontFamily->"Courier"], 
        RowBox[{
          StyleBox["Z",
            FontFamily->"Courier"], 
          StyleBox[",",
            FontFamily->"Courier"], 
          RowBox[{\(a\^2\), 
            StyleBox["Z",
              FontFamily->"Courier"]}], 
          StyleBox[",",
            FontFamily->"Courier"], 
          StyleBox[\(2 a*M*Z\),
            FontFamily->"Courier"], 
          StyleBox[",",
            FontFamily->"Courier"], 
          StyleBox[\(\(-2\) Sin[th] Cos[th] Z\),
            FontFamily->"Courier"], 
          StyleBox[",",
            FontFamily->"Courier"], 
          RowBox[{\(Sin[th]\^2\), 
            StyleBox["Z",
              FontFamily->"Courier"]}]}], 
        StyleBox["}",
          FontFamily->"Courier"]}]}]], "Input"],

Cell[BoxData[
    \({Z, a\^2\ Z, 2\ a\ M\ Z, \(-2\)\ Z\ Cos[th]\ Sin[th], Z\ Sin[th]\^2}\)],
   "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(indepTerms[S]\),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    \({Z, a\^2\ Z, a\ M\ Z, Z\ Cos[th]\ Sin[th], Z\ Sin[th]\^2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(indepTerms[S, {a, Sin[th]}]\),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    \({Z, M\ Z, Z\ Cos[th]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(indepTerms[S, {a, M, Sin[th], Cos[th]}]\),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    \({Z}\)], "Output"]
}, Open  ]],

Cell["\<\
This option can be useful in reducing the number of independent \
components of a tensor.\
\>", "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t(5) The function ",
  StyleBox["indepCoefs",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["[",
    FontFamily->"Courier"],
  StyleBox["x_",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["]",
    FontFamily->"Courier"],
  "  returns a list of the \"independent\" ",
  StyleBox["coefficients",
    FontSlant->"Italic"],
  " of all symbolic differential forms, symbolic matrices or wedge-products \
in the elements of the list ",
  StyleBox["x",
    FontWeight->"Bold"],
  ". Independent here means not equal to  \[PlusMinus]  a numerical multiple \
of another coefficient. "
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextAlignment->Left,
  TextJustification->0,
  FontSize->16],

Cell["\<\
The symbols e[i] have been defined as symbolic 1-forms in \
RGTC.\
\>", "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepCoefs[a[1]\ e[1] + a[2]\ e[2] + a[3]\ e[3]]\)], "Input"],

Cell[BoxData[
    \({a[1], a[2], a[3]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepCoefs[
      \((a[2] + a[3])\)\ e[2]\[Wedge]e[3] + 
        \((a[3] + a[1])\)\ e[3]\[Wedge]e[1] + 
        \((a[1] - a[2])\)\ e[1]\[Wedge]e[2]]\)], "Input"],

Cell[BoxData[
    \({a[1] - a[2], \(-a[1]\) - a[3], a[2] + a[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Like ",
  StyleBox["indepTerms",
    FontFamily->"Courier"],
  ", ",
  StyleBox["indepCoefs",
    FontFamily->"Courier"],
  " does not test for linear dependence:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plus@@%\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["indepCoefs",
    FontFamily->"Courier"],
  " has no effect on expressions that are not differential forms:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepCoefs[a[1]\ b[1] + a[2]\ b[2] + a[3]\ b[3]]\)], "Input"],

Cell[BoxData[
    \({a[1]\ b[1] + a[2]\ b[2] + a[3]\ b[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["indepCoefs",
    FontFamily->"Courier"],
  " can be applied to lists:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(sym33mat = 
      Table[\((i + j)\) \((a[i] - a[j])\) e[i]\[Wedge]e[j], {i, 3}, {j, 3}]
        \)], "Input"],

Cell[BoxData[
    \({{0, 3\ \((a[1] - a[2])\)\ e[1]\[Wedge]e[2], 
        4\ \((a[1] - a[3])\)\ e[1]\[Wedge]e[3]}, {
        \(-3\)\ \((\(-a[1]\) + a[2])\)\ e[1]\[Wedge]e[2], 0, 
        5\ \((a[2] - a[3])\)\ e[2]\[Wedge]e[3]}, {
        \(-4\)\ \((\(-a[1]\) + a[3])\)\ e[1]\[Wedge]e[3], 
        \(-5\)\ \((\(-a[2]\) + a[3])\)\ e[2]\[Wedge]e[3], 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepCoefs[%]\)], "Input"],

Cell[BoxData[
    \({a[1] - a[2], a[1] - a[3], a[2] - a[3]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Note that ",
  StyleBox["indepTerms",
    FontFamily->"Courier"],
  " does not recognize that ",
  StyleBox["(-a[1]+a[2])=-(a[1]-a[2])",
    FontFamily->"Courier"],
  ", as it does not carry out any simplifications:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  TextJustification->0,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[sym33mat]\)], "Input"],

Cell[BoxData[
    \({\((a[1] - a[2])\)\ e[1]\[Wedge]e[2], 
      \((\(-a[1]\) + a[2])\)\ e[1]\[Wedge]e[2], 
      \((a[1] - a[3])\)\ e[1]\[Wedge]e[3], 
      \((\(-a[1]\) + a[3])\)\ e[1]\[Wedge]e[3], 
      \((a[2] - a[3])\)\ e[2]\[Wedge]e[3], 
      \((\(-a[2]\) + a[3])\)\ e[2]\[Wedge]e[3]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(indepTerms[FacSimp[sym33mat]]\)], "Input"],

Cell[BoxData[
    \({\((a[1] - a[2])\)\ e[1]\[Wedge]e[2], 
      \((a[1] - a[3])\)\ e[1]\[Wedge]e[3], 
      \((a[2] - a[3])\)\ e[2]\[Wedge]e[3]}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(6) ",
  StyleBox["FacSimp[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " applies the simplification rules defined in ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " and factors each component of the tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". All basic tensors calculated initially by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " as well as those returned by the functions ",
  StyleBox["Raise",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Lower",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  ", ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  ", ",
  StyleBox["covD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  " , ",
  StyleBox["LieD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Laplacian",
    FontFamily->"Courier"],
  " , ",
  StyleBox["Grad2Norm",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Bianchi",
    FontFamily->"Courier"],
  " have been simplified using ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  ". Even though it can be very slow on high-rank tensors and /or when ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " contains many rules, ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  " should ",
  StyleBox["always",
    FontSlant->"Italic"],
  " be used to simplify sums and products (",
  StyleBox["Dot",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Outer",
    FontFamily->"Courier"],
  ") of these tensors. (see section 4.5 \"Taking advantage of symmetries\")"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIf ",
  StyleBox["zeroQ[expr]",
    FontFamily->"Courier"],
  " on an expression that is expected to vanish gives ",
  StyleBox["False",
    FontFamily->"Courier"],
  ",  try ",
  StyleBox["zeroQ[FacSimp[expr]]",
    FontFamily->"Courier"],
  " or,  for high-rank tensors with symmetries,  ",
  StyleBox["zeroQ[FacSimp[indepTerms[expr]]]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(7) ",
  StyleBox["GenCoef[x_,y_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (\"Generalized Coefficient\") is very similar to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Coefficient[x_, y_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". Unlike ",
  StyleBox["Coefficient",
    FontFamily->"Courier"],
  " however, ",
  StyleBox["GenCoef",
    FontFamily->"Courier"],
  " returns a series when ",
  StyleBox["x",
    FontFamily->"Courier"],
  " is a series and, when both ",
  StyleBox["x",
    FontFamily->"Courier"],
  " and ",
  StyleBox["y",
    FontFamily->"Courier"],
  " are Lists, returns a nested List:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(seriesExpr = Series[Sum[\((a + b)\)^k*x^k, {k, 0, 3}], {x, 0, 3}]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "1", "+", \(\((a + b)\)\ x\), "+", \(\((a + b)\)\^2\ x\^2\), "+", 
        \(\((a + b)\)\^3\ x\^3\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 0, 4, 1]]}],
      SeriesData[ x, 0, {1, 
        Plus[ a, b], 
        Power[ 
          Plus[ a, b], 2], 
        Power[ 
          Plus[ a, b], 3]}, 0, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[seriesExpr, b]\)], "Input"],

Cell[BoxData[
    \(x + 2\ a\ x\^2 + 3\ a\^2\ x\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[seriesExpr, b, 2]\)], "Input"],

Cell[BoxData[
    \(x\^2 + 3\ a\ x\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[seriesExpr, b]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"x", "+", \(2\ a\ x\^2\), "+", \(3\ a\^2\ x\^3\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 1, 4, 1]]}],
      SeriesData[ x, 0, {1, 
        Times[ 2, a], 
        Times[ 3, 
          Power[ a, 2]]}, 1, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[seriesExpr, b, 2]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(x\^2\), "+", \(3\ a\ x\^3\), "+", 
        InterpretationBox[\(O[x]\^4\),
          SeriesData[ x, 0, {}, 2, 4, 1]]}],
      SeriesData[ x, 0, {1, 
        Times[ 3, a]}, 2, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[{a[1] x + a[2] y, b[1] x + b[2] y}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({a[1], b[2]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[{a[1] x + a[2] y, b[1] x + b[2] y}, {x, y}]\)], "Input"],

Cell[BoxData[
    \({{a[1], a[2]}, {b[1], b[2]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThus ",
  StyleBox["GenCoef[LinearEquations_List,unknowns_List]",
    FontFamily->"Courier"],
  " gives directly the matrix of coefficients of the unknowns in the given \
equations. "
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(8) ",
  StyleBox["metric[ds2_,xIN_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " constructs the metric tensor from the line element (ds2) and the list of \
coordinates (xIN) or the coframe:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"metric", " ", "[", 
      RowBox[{
        RowBox[{\(2  d[u] d[r]\), "+", \(\((1 - 2  M/r)\) d[u]^2\), "-", 
          RowBox[{\(r^2\), 
            RowBox[{
              RowBox[{"d", "[", 
                StyleBox["\[Theta]",
                  FontFamily->"Courier"], "]"}], "^", "2"}]}], "-", 
          RowBox[{\(r^2\), 
            RowBox[{
              RowBox[{"Sin", "[", 
                StyleBox["\[Theta]",
                  FontFamily->"Courier"], "]"}], "^", "2"}], 
            RowBox[{
              RowBox[{"d", "[", 
                StyleBox["\[Phi]",
                  FontFamily->"Courier"], "]"}], "^", "2"}]}]}], ",", 
        RowBox[{"{", 
          RowBox[{"u", ",", "r", ",", 
            StyleBox["\[Theta]",
              FontFamily->"Courier"], ",", 
            StyleBox["\[Phi]",
              FontFamily->"Courier"]}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
    \({{\(-\(\(2\ M - r\)\/r\)\), 1, 0, 0}, {1, 0, 0, 0}, {0, 0, \(-r\^2\), 
        0}, {0, 0, 0, \(-r\^2\)\ Sin[\[Theta]]\^2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"metric", " ", "[", 
      RowBox[{\(2  e[1] e[2] - 2  e[3] e[4]\), ",", 
        StyleBox[\(e/@{1, 2, 3, 4}\),
          FontFamily->"Courier"]}], "]"}]], "Input"],

Cell[BoxData[
    \({{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, \(-1\), 0}}\)], 
  "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.3  Choosing simpRules and using varList"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIt is impossible to overemphasize the importance of choosing appropriate \
simplification rules in the global variable ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " to be applied by ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  ". As ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  " is used repeatedly by all functions, minor changes in ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " can have dramatic effects. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tRGTC  has two predefined sets of rules for basic simplification of \
expressions depending on trigonometric (ordinary or hyperbolic) functions: ",
  StyleBox["TrigRules",
    FontFamily->"Courier"],
  " and ",
  StyleBox["HypTrigRules",
    FontFamily->"Courier"],
  ". For metrics depending on such functions, one should set \
simpRules=TrigRules (or HypTrigRules)."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tWhen applying ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " to a new metric, it may not be clear what, if any, ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " should be used. In such cases, start with no rules and abort ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " after Gamma has been computed. Look at the expressions for gUU and GUdd: \
apart from being factored, are they as simple as they can be? Could a simple \
substitution rule further simplify these expressions? If yes, include it in ",
  
  StyleBox["simpRules",
    FontFamily->"Courier"],
  ". As gUU and GUdd are used repeatedly by other functions, even minor \
improvements can have significant effects (see Example 8, and Example 4b in \
section 5.1)."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["Exercise",
    FontSlant->"Italic"],
  ": Find the ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " that must be used in order that ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " prints ",
  StyleBox["Ricci Flat",
    FontSlant->"Italic"],
  " when applied to the Kruskal form of the Schwarzschild metric:"
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    StyleBox[
      \(gKRUSKAL
         = {{0, \(-8\) M^2 \((1 - 2 M/r[u, v])\)/\((u*v)\), 0, 0}, {
            \(-8\) M^2 \((1 - 2 M/r[u, v])\)/\((u*v)\), 0, 0, 0}, {0, 0, 
            \(-r[u, v]^2\), 0}, {0, 0, 0, \(-r[u, v]^2\) Sin[\[Theta]]^2}}; 
      \),
      FontFamily->"Courier"]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    StyleBox[\(xCoord = {u, v, \[Theta], \[CurlyPhi]}; \),
      FontFamily->"Courier"]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[TextData[{
  "\tWhere ",
  StyleBox["r[u,v]",
    FontFamily->"Courier"],
  " is related to the coordinates ",
  StyleBox["u,v",
    FontFamily->"Courier"],
  " by the equation ",
  StyleBox["(2M-r[u,v])Exp[r[u,v]/(2M)]-2M*u*v=0",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\t",
  StyleBox["Solution",
    FontSlant->"Italic"],
  ": See ",
  ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIn formulating substitution rules it is better to use many specific \
rules rather than few general ones. The reason is that a general pattern will \
match more instances (even if it fails) and thus slow down the computation. \
For rules and patterns see the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Book, chapters 2.3 and 2.4 (=2.5 in version 5)."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "\tThe global variable ",
  StyleBox["varList",
    FontFamily->"Courier"],
  " is a list of variables/patterns that, when non-empty, is used by ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  " to group terms. It can be useful in cases like (see also Example 4c after \
section 5.1.3):"
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(varList\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(expr = 
      FacSimp[\((1 + x\ y)\)^2 \((x - y)\)^3 + 
          Sqrt[\((1 - x^2)\)] Sum[y^n, {n, 5}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(x\^3 - 3\ x\^2\ y + 2\ x\^4\ y + \@\(1 - x\^2\)\ y + 3\ x\ y\^2 - 
      6\ x\^3\ y\^2 + x\^5\ y\^2 + \@\(1 - x\^2\)\ y\^2 - y\^3 + 
      6\ x\^2\ y\^3 - 3\ x\^4\ y\^3 + \@\(1 - x\^2\)\ y\^3 - 2\ x\ y\^4 + 
      3\ x\^3\ y\^4 + \@\(1 - x\^2\)\ y\^4 - x\^2\ y\^5 + 
      \@\(1 - x\^2\)\ y\^5\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[expr] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.0833333333333712289`\ Second, 
      x\^5\ y\^2 + x\^4\ \((2\ y - 3\ y\^3)\) + x\ \((3\ y\^2 - 2\ y\^4)\) - 
        x\^2\ y\ \((3 - 6\ y\^2 + y\^4)\) + 
        x\^3\ \((1 - 6\ y\^2 + 3\ y\^4)\) + 
        y\ \((\@\(1 - x\^2\) + \@\(1 - x\^2\)\ y + 
            \((\(-1\) + \@\(1 - x\^2\))\)\ y\^2 + \@\(1 - x\^2\)\ y\^3 + 
            \@\(1 - x\^2\)\ y\^4)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[expr] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({1.36666666666667424`\ Second, 
      x\^3 + x\^2\ \((\(-3\) + 2\ x\^2)\)\ y + 
        x\ \((3 - 6\ x\^2 + x\^4)\)\ y\^2 - 
        \((1 - 6\ x\^2 + 3\ x\^4)\)\ y\^3 + x\ \((\(-2\) + 3\ x\^2)\)\ y\^4 - 
        x\^2\ y\^5 + \@\(1 - x\^2\)\ y\ \((1 + y + y\^2 + y\^3 + y\^4)\)}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[\(varList = {\@\(1 - x\^2\)}\),
        FontColor->RGBColor[1, 0, 0]], 
      StyleBox[";",
        FontColor->RGBColor[1, 0, 0]], \(FacSimp[expr] // Timing\)}]], "Input"],

Cell[BoxData[
    \({0.`\ Second, 
      \((x - y)\)\^3\ \((1 + x\ y)\)\^2 + 
        \@\(1 - x\^2\)\ y\ \((1 + y + y\^2 + y\^3 + y\^4)\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(varList = {}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[expr]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(x\^3 - 3\ x\^2\ y + 2\ x\^4\ y + \@\(1 - x\^2\)\ y + 3\ x\ y\^2 - 
      6\ x\^3\ y\^2 + x\^5\ y\^2 + \@\(1 - x\^2\)\ y\^2 - y\^3 + 
      6\ x\^2\ y\^3 - 3\ x\^4\ y\^3 + \@\(1 - x\^2\)\ y\^3 - 2\ x\ y\^4 + 
      3\ x\^3\ y\^4 + \@\(1 - x\^2\)\ y\^4 - x\^2\ y\^5 + 
      \@\(1 - x\^2\)\ y\^5\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Warning:",
    FontWeight->"Bold"],
  " Inappropriate choice of ",
  StyleBox["varList",
    FontFamily->"Courier"],
  " variables can prevent cancellations and slow down ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  ". It should be used with caution. A good check, before calling ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  ", is to see the effect of particular ",
  StyleBox["varList",
    FontFamily->"Courier"],
  " variable(s) on the expression for the inverse metric ",
  StyleBox["FacSimp[Inverse[gIN]]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note",
    FontWeight->"Bold"],
  ": The global variables ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " and ",
  StyleBox["varList",
    FontFamily->"Courier"],
  " are assumed to be lists. Therefore, one must never use Clear[...] for \
these variables. One should instead set them equal to the empty list {}."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.4  Substituting new functions"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe function ",
  StyleBox["FuncRepRules[f[x__],g_,n_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (\"Function Replacement Rules\") generates a list of rules for replacing \
the function ",
  StyleBox["f[x]",
    FontFamily->"Courier"],
  " ",
  StyleBox["and all its derivatives up to order n",
    FontSlant->"Italic"],
  " by ",
  StyleBox["g",
    FontFamily->"Courier"],
  " and the corresponding derivatives of ",
  StyleBox["g",
    FontFamily->"Courier"],
  ", where ",
  StyleBox["g",
    FontFamily->"Courier"],
  " can be any expression. The third argument (",
  StyleBox["n",
    FontFamily->"Courier"],
  ") is optional. When it is omitted, rules up to the second derivatives are \
generated. For example:"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FuncRepRules[f[x], u[x]/x]\),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(f[x] \[Rule] u[x]\/x\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{\(-\(u[x]\/x\^2\)\), "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "x"]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{\(\(2\ u[x]\)\/x\^3\), "-", 
            FractionBox[
              RowBox[{"2", " ", 
                RowBox[{
                  SuperscriptBox["u", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], \(x\^2\)], 
            "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], "x"]}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FuncRepRules[f[x], u[x]/x, 3]\),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(f[x] \[Rule] u[x]\/x\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{\(-\(u[x]\/x\^2\)\), "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "x"]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{\(\(2\ u[x]\)\/x\^3\), "-", 
            FractionBox[
              RowBox[{"2", " ", 
                RowBox[{
                  SuperscriptBox["u", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], \(x\^2\)], 
            "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], "x"]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}], "\[Rule]", 
          RowBox[{\(-\(\(6\ u[x]\)\/x\^4\)\), "+", 
            FractionBox[
              RowBox[{"6", " ", 
                RowBox[{
                  SuperscriptBox["u", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], \(x\^3\)], 
            "-", 
            FractionBox[
              RowBox[{"3", " ", 
                RowBox[{
                  SuperscriptBox["u", "\[DoublePrime]",
                    MultilineFunction->None], "[", "x", "]"}]}], \(x\^2\)], 
            "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}], "x"]}]}]}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FuncRepRules[U[t, r], \((f1[r - t] + f2[r + t])\)/r]\),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(U[t, r] \[Rule] \(f1[r - t] + f2[r + t]\)\/r\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["U", 
              TagBox[\((0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(t, r\), "]"}], "\[Rule]", 
          RowBox[{\(-\(f1[r - t]\/r\^2\)\), "-", \(f2[r + t]\/r\^2\), "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["f1", "\[Prime]",
                  MultilineFunction->None], "[", \(r - t\), "]"}], "r"], "+", 
            
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[Prime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], "r"]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["U", 
              TagBox[\((0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(t, r\), "]"}], "\[Rule]", 
          RowBox[{
          \(\(2\ f1[r - t]\)\/r\^3\), "+", \(\(2\ f2[r + t]\)\/r\^3\), "-", 
            FractionBox[
              RowBox[{"2", " ", 
                RowBox[{
                  SuperscriptBox["f1", "\[Prime]",
                    MultilineFunction->None], "[", \(r - t\), "]"}]}], 
              \(r\^2\)], "-", 
            FractionBox[
              RowBox[{"2", " ", 
                RowBox[{
                  SuperscriptBox["f2", "\[Prime]",
                    MultilineFunction->None], "[", \(r + t\), "]"}]}], 
              \(r\^2\)], "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["f1", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r - t\), "]"}], "r"], "+", 
            
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], "r"]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["U", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(t, r\), "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{"-", 
              FractionBox[
                RowBox[{
                  SuperscriptBox["f1", "\[Prime]",
                    MultilineFunction->None], "[", \(r - t\), "]"}], "r"]}], 
            "+", 
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[Prime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], "r"]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["U", 
              TagBox[\((1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(t, r\), "]"}], "\[Rule]", 
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox["f1", "\[Prime]",
                  MultilineFunction->None], "[", \(r - t\), "]"}], \(r\^2\)], 
            "-", 
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[Prime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], \(r\^2\)], 
            "-", 
            FractionBox[
              RowBox[{
                SuperscriptBox["f1", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r - t\), "]"}], "r"], "+", 
            
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], "r"]}]}], 
        ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["U", 
              TagBox[\((2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(t, r\), "]"}], "\[Rule]", 
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox["f1", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r - t\), "]"}], "r"], "+", 
            
            FractionBox[
              RowBox[{
                SuperscriptBox["f2", "\[DoublePrime]",
                  MultilineFunction->None], "[", \(r + t\), "]"}], "r"]}]}]}],
       "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FuncRepRules[H[u, x, y], a[u] \((x^2 - y^2)\) + 2 b[u] x\ y]\),
      
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \(H[u, x, y] \[Rule] \((x\^2 - y\^2)\)\ a[u] + 2\ x\ y\ b[u]\), ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          \(\(-2\)\ y\ a[u] + 2\ x\ b[u]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((0, 0, 2)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          \(\(-2\)\ a[u]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          \(2\ x\ a[u] + 2\ y\ b[u]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((0, 1, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          \(2\ b[u]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((0, 2, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          \(2\ a[u]\)}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((1, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "-", 
            RowBox[{\(y\^2\), " ", 
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "+", 
            RowBox[{"2", " ", "x", " ", "y", " ", 
              RowBox[{
                SuperscriptBox["b", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((1, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{\(-2\), " ", "y", " ", 
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "+", 
            RowBox[{"2", " ", "x", " ", 
              RowBox[{
                SuperscriptBox["b", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((1, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{"2", " ", "x", " ", 
              RowBox[{
                SuperscriptBox["a", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "+", 
            RowBox[{"2", " ", "y", " ", 
              RowBox[{
                SuperscriptBox["b", "\[Prime]",
                  MultilineFunction->None], "[", "u", "]"}]}]}]}], ",", 
        RowBox[{
          RowBox[{
            SuperscriptBox["H", 
              TagBox[\((2, 0, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(u, x, y\), "]"}], "\[Rule]", 
          RowBox[{
            RowBox[{\(x\^2\), " ", 
              RowBox[{
                SuperscriptBox["a", "\[DoublePrime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "-", 
            RowBox[{\(y\^2\), " ", 
              RowBox[{
                SuperscriptBox["a", "\[DoublePrime]",
                  MultilineFunction->None], "[", "u", "]"}]}], "+", 
            RowBox[{"2", " ", "x", " ", "y", " ", 
              RowBox[{
                SuperscriptBox["b", "\[DoublePrime]",
                  MultilineFunction->None], "[", "u", "]"}]}]}]}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tOne can thus compute the Ricci tensor for a metric that depends on \
arbitrary functions of the coordinates and then use ",
  StyleBox["FuncRepRules",
    FontFamily->"Courier"],
  " to substitute specific functions / functional forms to search for \
solutions. "
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.5  Taking advantage of symmetries"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe greatest drawback of the functions defined in this package is that \
they do not take advantage of the symmetry properties of tensors to reduce \
the amount (and time) of a computation. (This is not true of the main \
procedure -- ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " -- but this is called only once!). Thus, ",
  StyleBox["FacSimp[Rdddd]",
    FontFamily->"Courier"],
  " factors ",
  StyleBox["every component",
    FontSlant->"Italic"],
  " of the Riemann tensor! As a result, high rank tensor calculations tend to \
be very slow, especially in high dimensions."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tIn such cases one should define a temporary function for the components \
of the tensor to be computed, having the correct symmetries, and then use ",
  StyleBox["Array",
    FontFamily->"Courier"],
  " to construct the tensor (see how Rdddd, RUddd, Rdd, Wdddd are computed by \
",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  "). ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  " should always be applied to the independent components only!"
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  4.6  When the results appear wrong: Can I trust the results of RGTC?"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe basic functions defined in RGTC have been tested on a large number \
of metrics using different frames and always give correct results. Successive \
versions have improved the performance and have corrected even some very rare \
bugs (like the one affecting ",
  StyleBox["HStar",
    FontFamily->"Courier"],
  " when acting on some ",
  StyleBox["SeriesData",
    FontFamily->"Courier"],
  " objects).  Of course, one can never claim that a piece of software is \
completely bug-free. However, if one encounters unexpected results, there are \
several checks one can make before concluding that there is a bug involved."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(i) Make sure no symbols defined by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " are used in the coordinates or metric --  see section 4.0 above. Repeat \
the calculation using different notation and a fresh Kernel. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(ii) Common mistakes that can lead to erroneous results are: (a) in ",
  StyleBox["covD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  ", ",
  StyleBox["LieD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Laplacian",
    FontFamily->"Courier"],
  ", etc. -- not giving the correct positions of contravariant indices as \
second arguments, and (b) in ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  " -- giving wrong index positions or index pairs of the same type {U,U} or \
{d,d}. Double check such inputs."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(iii) Unexpected results can often be due to inadequate simplification: \
it is possible that ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " does ",
  StyleBox["not",
    FontWeight->"Bold"],
  " print ",
  StyleBox["Ricci Flat",
    FontSlant->"Italic"],
  " (or ",
  StyleBox["Conformally Flat",
    FontSlant->"Italic"],
  ") for a metric that is known to have this property; or that it fails to \
recognize that a given set of 2-forms ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and coordinate differential rules ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " define a closed implicit coframe basis (see section 5.2) and thus aborts \
evaluation. This can happen when ",
  StyleBox["simpRules",
    FontFamily->"Courier"],
  " are used to simplify calculations in complicated metrics, particularly \
ones involving trigonometric functions. \n\nThe case when ",
  StyleBox["Rdd",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Wdddd",
    FontFamily->"Courier"],
  " does not get simplified sufficiently to give a zero tensor is easy to \
deal with: just use ",
  StyleBox["FacSimp",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Simplify",
    FontFamily->"Courier"],
  " repeatedly to check if the expressions returned by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  "  actually do vanish (or repeat the calculation adding extra \
simplification rules as in example 8 of section 3). This is illustrated with \
the metrics on n-dimensional spheres, where ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " fails to print ",
  StyleBox["Conformally Flat",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Einstein Space",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Space of Constant Curvature",
    FontSlant->"Italic"],
  " for ",
  StyleBox["n>4",
    FontFamily->"Courier"],
  " -- see the notebook ",
  StyleBox["nDimSpheres.nb",
    FontWeight->"Bold"],
  " ",
  StyleBox[" in ",
    FontSize->16],
  StyleBox[ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSize->16],
  StyleBox[".",
    FontSize->16],
  " \n\nIn the case when ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " does not recognize that the given ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " is closed, and therefore stops the calculation, it is best if one changes \
coordinates to eliminate the trigonometric functions. For an ",
  StyleBox["ad-hoc",
    FontSlant->"Italic"],
  " example where this happens see the notebook ",
  StyleBox["EliminateTrigFunctions.nb",
    FontWeight->"Bold"],
  " ",
  StyleBox[" in ",
    FontSize->16],
  StyleBox[ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSize->16],
  StyleBox[".",
    FontSize->16]
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(iv) Differential Geometry provides a number of identities one can use \
to check the validity of the results returned by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " and the other functions defined in RGTC (",
  StyleBox["covD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Contract",
    FontFamily->"Courier"],
  ", etc.). Such identities follow from (1) the vanishing of the covariant \
derivatives of the metric tensor and the Bianchi identities, (2) properties \
of special vector fields (geodesics, Killing vectors) that may be present in \
particular metrics, and (3) agreement of the results obtained using different \
coordinate systems or frames or different ways of computing the same tensors \
/ invariants. For an example of the latter see the notebook ",
  StyleBox["KerrInvariants.nb",
    FontWeight->"Bold"],
  " ",
  StyleBox[" in ",
    FontSize->16],
  StyleBox[ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontSize->16],
  StyleBox[".",
    FontSize->16]
}], "Text",
  FontSize->16]
}, Closed]]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1],
  CellTags->"blank 4"],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 5  Tensor Components in an Arbitrary Frame",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t",
  StyleBox["Warning",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": It is best to study the Examples in Section 3 and become familiar with \
calculations in the default coordinate-frame ",
  StyleBox["before reading this section",
    FontSlant->"Italic"],
  ". Otherwise, it may appear very confusing!"
}], "Text",
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe computation of tensor components in an arbitrary frame involves some \
elementary operations of exterior differential calculus. We use the notation \
and conventions of the package ",
  ButtonBox["Exterior Differential Calculus",
    ButtonData:>{
      URL[ "http://www.inp.demokritos.gr/~sbonano/EDC/"], None},
    ButtonStyle->"Hyperlink"],
  " (EDC). Familiarity with that package is not required, unless one wants to \
do further calculations with the connection 1-form tensor \[Omega]Ud which is \
computed by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  ".  "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tThe intialization file ",
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  evaluated in Section 2 above contains the combined EDC and RGTC code, \
allowing the complete functionality of the EDC package to be used."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[StyleBox["  5.1  Explicit Frame Calculations",
  FontWeight->"Bold"]], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->18,
  FontWeight->"Plain"],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIn this case, one must"
}], "Text",
  FontSize->16],

Cell[TextData[{
  "(i) Define, in addition to the coordinates (",
  StyleBox["xIN",
    FontWeight->"Bold"],
  ") and the metric (",
  StyleBox["gIN",
    FontWeight->"Bold"],
  "),  a list of 1-forms (",
  StyleBox["eIN",
    FontWeight->"Bold"],
  ") -- the coframe -- written as linear combinations of the coordinate \
differentials d[x",
  Cell[BoxData[
      \(\^a\)]],
  "]. The components of ",
  StyleBox["gIN",
    FontWeight->"Bold"],
  " must, of course, be given with respect to the coframe ",
  StyleBox["eIN",
    FontWeight->"Bold"],
  ". "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "(ii) Evaluate ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " with the coframe list as a third argument: ",
  StyleBox["RGtensors[gIN,xIN,eIN]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " now computes all tensor components with respect to the given frame. (The \
same holds true, of course, for all other tensor functions -- ",
  StyleBox["covD",
    FontFamily->"Courier"],
  ", ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  ", etc.). When it is finished, in addition to the other global tensors \
(Rdddd, Rdd, etc.), the connection 1-form tensor \[Omega]Ud with components  \
\[Omega]Ud[[a,b]] =",
  Cell[BoxData[
      \(\(\ \(\[Omega]\^a\)\_b\)\)]],
  " is now stored in memory. \[Omega]Ud satisfies the equation  d[eIN]+\
\[Omega]Ud\[Wedge]eIN= 0, or, in components, d[e",
  Cell[BoxData[
      \(\^a\)]],
  "]+",
  Cell[BoxData[
      \(\(\[Omega]\^a\)\_b\)]],
  "\[Wedge]e",
  Cell[BoxData[
      \(\^b\)]],
  "= 0, where e",
  Cell[BoxData[
      \(\^a\)]],
  "=eIN[[a]]. (Wedge multiplication of lists acts like ",
  StyleBox["Dot",
    FontFamily->"Courier"],
  ": it sums the last index of the first list with the first index of the \
second list). The notation ",
  StyleBox["e[a]",
    FontFamily->"Courier"],
  " is used for e",
  Cell[BoxData[
      \(\^a\)]],
  " and all differential forms are written as linear combinations of the \
bases ",
  StyleBox["e[a]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["e[a]\[Wedge]e[b]",
    FontFamily->"Courier"],
  ", etc. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note",
    FontSlant->"Italic"],
  ": The exterior derivative operator ",
  StyleBox["d[]",
    FontFamily->"Courier"],
  " treats all symbols as variables. Therefore, constants must be explicitly \
defined to have zero exterior derivative, e.g., ",
  StyleBox["d[a]=0",
    FontFamily->"Courier"],
  " and ",
  StyleBox["d[M]=0",
    FontFamily->"Courier"],
  " for the Kerr metric. Otherwise, warning messages are generated and \
calculations take longer."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"  \[FilledSmallSquare]   Example 4a: Kerr (Example 4)  @ \"rotating \
coordinate frame\"",
  FontWeight->"Bold"]], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(xCoord = {t, r, x, \[CurlyPhi]}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(coFrame
       = {d[t] + 
          2  a\ M\ r \((1 - x^2)\)/\((Sigma - 2  M\ r)\) d[\[CurlyPhi]], 
        d[r], d[x], d[\[CurlyPhi]]}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(Sigma = r^2 + a^2  x^2; Delta = r^2 + a^2 - 2  M\ r; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(g = 
      DiagonalMatrix[{1 - 2  M\ r/Sigma, \(-Sigma\)/Delta, 
          \(-Sigma\)/\((1 - x^2)\), 
          \(-Delta\)\ Sigma \((1 - x^2)\)/\((Sigma - 2  M\ r)\)}]; \)\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(d[a] = 0; d[M] = 0; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord, coFrame]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(1 - \(2\ M\ r\)\/\(r\^2 + a\^2\ x\^2\)\), "0", "0", "0"},
               
                 {"0", \(\(\(-r\^2\) - a\^2\ x\^2\)\/\(a\^2 - 2\ M\ r + 
                        r\^2\)\), "0", "0"},
                {"0", "0", \(\(\(-r\^2\) - a\^2\ x\^2\)\/\(1 - x\^2\)\), "0"},
                
               
                 {"0", "0", "0", 
                  \(\(\((\(-a\^2\) + 2\ M\ r - r\^2)\)\ \((1 - x\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\/\(\(-2\)\ M\ r + r\^2 + 
                        a\^2\ x\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 1, 
            Times[ -2, M, r, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1]]], 0, 0, 0}, {0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ r, 2]], 
              Times[ -1, 
                Power[ a, 2], 
                Power[ x, 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ r, 2]], 
              Times[ -1, 
                Power[ a, 2], 
                Power[ x, 2]]]], 0}, {0, 0, 0, 
          Times[ 
            Plus[ 
              Times[ -1, 
                Power[ a, 2]], 
              Times[ 2, M, r], 
              Times[ -1, 
                Power[ r, 2]]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Plus[ 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Times[ -2, M, r], 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((r\^2 + a\^2\ x\^2)\)\ d[r]\^2\)\/\(a\^2 - 2\ M\ r + 
                  r\^2\)\) - 
            \(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ d[t]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\) + 
            \(\((r\^2 + a\^2\ x\^2)\)\ d[x]\^2\)\/\(\(-1\) + x\^2\) - 
            \(4\ a\ M\ r\ \((\(-1\) + x\^2)\)\ d[t]\ 
                d[\[CurlyPhi]]\)\/\(r\^2 + a\^2\ x\^2\) + 
            \(\((\(-1\) + x\^2)\)\ 
                \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                    2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\)\ 
                d[\[CurlyPhi]]\^2\)\/\(r\^2 + a\^2\ x\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ r], 2]], 
            Times[ -1, 
              Plus[ 
                Times[ 2, M, r], 
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, 
                  Power[ x, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ x], 2]], 
            Times[ -4, a, M, r, 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              d[ t], 
              d[ \[CurlyPhi]]], 
            Times[ 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ x, 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
               
                 {\(\(r\^2 + a\^2\ x\^2\)\/\(\(-2\)\ M\ r + r\^2 + 
                        a\^2\ x\^2\)\), "0", "0", "0"},
               
                 {"0", \(-
                    \(\(a\^2 - 2\ M\ r + r\^2\)\/\(r\^2 + a\^2\ x\^2\)\)\), 
                  "0", "0"},
                {"0", "0", \(\(\(-1\) + x\^2\)\/\(r\^2 + a\^2\ x\^2\)\), "0"},
                
               
                 {"0", "0", "0", 
                  \(\(\(-2\)\ M\ r + r\^2 + 
                        a\^2\ x\^2\)\/\(\((a\^2 - 2\ M\ r + r\^2)\)\ 
                        \((\(-1\) + x\^2)\)\ \((r\^2 + a\^2\ x\^2)\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Plus[ 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Times[ -2, M, r], 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0, 0}, {0, 
          Times[ -1, 
            Plus[ 
              Power[ a, 2], 
              Times[ -2, M, r], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0}, {0, 0, 
          Times[ 
            Plus[ -1, 
              Power[ x, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0}, {0, 0, 0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ -1, 
                Power[ x, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ -2, M, r], 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.183333333333337122`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.18333333333333712, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.400000000000034106`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.40000000000003411, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.516666666666651508`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.51666666666665151, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.316666666666662877`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.31666666666666288, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 1.73333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(detg\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\((r\^2 + a\^2\ x\^2)\)\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RUddd[\([1, 2, 1, 2]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(M\ r\ \((r\^2 - 3\ a\^2\ x\^2)\)\ 
            \((\(-3\)\ a\^2 + 4\ M\ r - 2\ r\^2 + a\^2\ x\^2)\)\)\/\(\((
              \(-a\^2\) + 2\ M\ r - r\^2)\)\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^2\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]Ud[\([1, 2]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(M\ \((r - a\ x)\)\ \((r + a\ x)\)\ 
              e[1]\)\/\(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
              \((r\^2 + a\^2\ x\^2)\)\)\)\) - 
      \(a\ M\ \((\(-1\) + x)\)\ \((1 + x)\)\ \((\(-r\) + a\ x)\)\ 
          \((r + a\ x)\)\ e[4]\)\/\((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\^2
          \)], "Output"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIt is still possible to skip computation of RUddd,Wdddd or EUd by \
calling ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " with an extra (fourth!) argument of the form ",
  StyleBox["{i,j}",
    FontFamily->"Courier"],
  " or ",
  StyleBox["{i,j,k}",
    FontFamily->"Courier"],
  " (see note at the end of section 1.1). Thus ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " can be called with 2, 3 or 4 arguments, in the following order:"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t ",
  StyleBox["RGtensors[gIN,xIN]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " - computes all tensors in the coordinate frame"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t ",
  StyleBox["RGtensors[gIN,xIN,{1,0}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " - computes all tensors except Wdddd in the coordinate frame"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t ",
  StyleBox["RGtensors[gIN,xIN,eIN]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " - computes all tensors in the co-frame specified by eIN"
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t ",
  StyleBox["RGtensors[gIN,xIN,eIN,{1,0,0}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " - computes all tensors except Wdddd and EUd in the co-frame specified by \
eIN"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "   5.1.1   ",
  StyleBox["Important note on repeated frame calculations:",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "   eTO$dx  and  Clear$dx"
}], "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  CellTags->"sec 5"],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tAfter a calculation in a particular frame, the coordinate differentials \
are stored as linear combinations of the coframe basis e[a]. Thus, after \
Example 4a:"
}], "Text",
  FontSize->16,
  CellTags->"sec 5"],

Cell[CellGroupData[{

Cell[BoxData[
    \({d[t], d[t]\[Wedge]d[r]}\)], "Input",
  CellTags->"sec 5"],

Cell[BoxData[
    \({e[1] + 
        \(2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ e[4]\)\/\(\(-2\)\ M\ r + 
            r\^2 + a\^2\ x\^2\), 
      e[1]\[Wedge]e[2] - 
        \(2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            e[2]\[Wedge]e[4]\)\/\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  " The global variable ",
  StyleBox["eTO$dx",
    FontFamily->"Courier"],
  " is a list of substitution rules, defined by ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  ", that remembers the original frame definitions in terms of the coordinate \
differentials -- with \[ScriptD]  used in place of d. It is useful in \
converting differential forms from the e[i]\[Wedge]e[j] basis to the d[xi]\
\[Wedge]d[xj] basis. For example "
}], "Text",
  FontSize->16,
  CellTags->"sec 5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[% /. eTO$dx]\)], "Input"],

Cell[BoxData[
    \({\[ScriptD][t], \(-\((\[ScriptD][r]\[Wedge]\[ScriptD][t])\)\)}\)], 
  "Output"]
}, Open  ]],

Cell["\<\
Setting the differentials of the coordinates equal to their \
expressions in terms of the e[a] makes calculations involving \
differentiations in this frame more efficient. However, if a subsequent \
calculation in a different frame is to be carried out, these values must be \
cleared. This can be done by evaluating:\
\>", "Text",
  FontSize->16,
  CellTags->"sec 5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input"],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  " \tThis procedure clears the coordinate differentials and ",
  StyleBox["eTO$dx",
    FontFamily->"Courier"],
  ". Now"
}], "Text",
  FontSize->16,
  CellTags->"sec 5"],

Cell[CellGroupData[{

Cell[BoxData[
    \({d[t], d[r]}\)], "Input"],

Cell[BoxData[
    \({d[t], d[r]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  " \tIt is always safer, however, to reevaluate the initialization code ",
  StyleBox["EDCRGTCcode.m",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  -- which clears ALL variables -- before starting a calculation with a \
new frame (or metric)."
}], "Text",
  FontSize->16,
  CellTags->"sec 5"]
}, Closed]],

Cell[CellGroupData[{

Cell["   5.1.2   Hodge Duality", "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "\tA new function that can be used now is ",
  StyleBox["HStar[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ":: applied to any ",
  StyleBox["p",
    FontSlant->"Italic"],
  "-form scalar or tensor expression ",
  StyleBox["x",
    FontFamily->"Courier"],
  ", it gives the \"Hodge Dual\" of ",
  StyleBox["x",
    FontFamily->"Courier"],
  ", i.e., the result of replacing each ",
  StyleBox["p",
    FontSlant->"Italic"],
  "-form basis ",
  StyleBox["e[a1]\[Wedge]e[a2]\[Wedge]...\[Wedge]e[ap] ",
    FontFamily->"Courier"],
  "by (the Einstein summation convention holds)"
}], "Text",
  FontSize->16],

Cell[TextData[Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
        \(\(\((\[LeftBracketingBar]detg\[RightBracketingBar])\)\^\(1/2\)\) 
              \(g\^\(a1\ b1\)\) g\^\(a2\ b2\)..\), \(g\^\(ap\ bp\)\), 
          StyleBox[\(epsilon[b1, b2, \(.. bp\), bp + 1, .., Dim]\),
            FontFamily->"Courier"], 
          StyleBox[\(e[bp + 1]\[Wedge]\),
            FontFamily->"Courier"]}], 
        StyleBox["..",
          FontFamily->"Courier"]}], 
      StyleBox["\[Wedge]",
        FontFamily->"Courier"], 
      StyleBox[\(e[Dim]/\(\((Dim - p)\)!\)\),
        FontFamily->"Courier"]}]]]], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Note",
    FontSlant->"Italic"],
  ": The default volume ",
  StyleBox["Dim",
    FontSlant->"Italic"],
  "-form used as the ",
  StyleBox["definition",
    FontSlant->"Italic"],
  " of ",
  StyleBox["HStar[1]",
    FontFamily->"Courier"],
  " is  ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          RowBox[{
          \(\((\[LeftBracketingBar]detg\[RightBracketingBar])\)\^\(1/2\)\), 
            StyleBox[\(e[1]\[Wedge]e[2]\[Wedge]\),
              FontFamily->"Courier"]}], 
          StyleBox["...",
            FontFamily->"Courier"]}], 
        StyleBox["\[Wedge]",
          FontFamily->"Courier"], 
        StyleBox[\(e[Dim]\),
          FontFamily->"Courier"]}]]],
  ", except in the case of a Newman-Penrose null frame (see section 5.1.3) \
where the (real) volume 4-form  ",
  StyleBox["I",
    FontFamily->"Courier"],
  " ",
  StyleBox["e[1]\[Wedge]e[2]\[Wedge]e[3]\[Wedge]e[4]",
    FontFamily->"Courier"],
  " is used.  If in a particular case (to agree with the user's conventions) \
a different volume form must be used as the definition of ",
  StyleBox["HStar[1]",
    FontFamily->"Courier"],
  ", one must define a new ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function for Hodge-Dual, as a simple multiple of ",
  StyleBox["HStar",
    FontFamily->"Courier"],
  ": ",
  StyleBox["newHstar[x_]:= \[Alpha]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["HStar[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", where ",
  StyleBox["\[Alpha]",
    FontWeight->"Bold"],
  " is the ratio newVolumeForm / defaultVolumeForm."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"  \[FilledSmallSquare]   Example 4b: Kerr (Example 4)  @  orthonormal frame",
  
  FontWeight->"Bold"]], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ONframe", "=", 
      RowBox[{"FacSimp", "[", 
        RowBox[{
          RowBox[{"DiagonalMatrix", "[", 
            RowBox[{"PowerExpand", "[", 
              RowBox[{"{", 
                RowBox[{
                \(Sqrt[\((Sigma - 2  M\ r)\)/Sigma]\), ",", 
                  \(Sqrt[Sigma/Delta]\), ",", 
                  RowBox[{"Sqrt", "[", 
                    RowBox[{"Sigma", "/", 
                      RowBox[{"(", 
                        StyleBox[\(1 - x^2\),
                          FontFamily->"Courier"], ")"}]}], "]"}], ",", 
                  RowBox[{"Sqrt", "[", 
                    RowBox[{"Delta", " ", "Sigma", 
                      RowBox[{
                        StyleBox[\((1 - x^2)\),
                          FontFamily->"Courier"], "/", 
                        \((Sigma - 2  M\ r)\)}]}], "]"}]}], "}"}], "]"}], 
            "]"}], ".", "coFrame"}], "]"}]}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ 
            d[t]\)\/\@\(r\^2 + a\^2\ x\^2\) - 
        \(2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            d[\[CurlyPhi]]\)\/\(\@\(r\^2 + a\^2\ x\^2\)\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[r]\)\/\@\(a\^2 - 2\ M\ r + r\^2\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[x]\)\/\@\(1 - x\^2\), 
      \(\@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
          d[\[CurlyPhi]]\)\/\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Note",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": ",
  StyleBox["PowerExpand",
    FontFamily->"Courier"],
  " must always be used when the argument of ",
  StyleBox["Sqrt",
    FontFamily->"Courier"],
  " is a product of factors.  Otherwise simplifications cannot be carried \
out.  "
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(gON = DiagonalMatrix[{1, \(-1\), \(-1\), \(-1\)}]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(simpRules
       = {\((\(-1\) + x)\) \((1 + x)\)/\@\(1 - x\^2\) -> \(-\@\(1 - x\^2\)\), 
        \((\@\(r\^2 + a\^2\ x\^2\) - \@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\))
              \) \((\@\(r\^2 + a\^2\ x\^2\) + 
                \@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\))\) -> 2\ M\ r}; \)\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell["\<\
\tThis example illustrates the use of particular simpRules, chosen \
after looking at inadequately simplified expressions in GUdd when evaluated \
with no simpRules, as suggested in section 4.3.  \
\>", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gON, xCoord, ONframe, {0, 0}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((r\^2 + a\^2\ x\^2)\)\ d[r]\^2\)\/\(a\^2 - 2\ M\ r + 
                  r\^2\)\) + 
            \(\((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\ d[t]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\) + 
            \(\((r\^2 + a\^2\ x\^2)\)\ d[x]\^2\)\/\(\(-1\) + x\^2\) - 
            \(4\ a\ M\ r\ \((\(-1\) + x\^2)\)\ d[t]\ 
                d[\[CurlyPhi]]\)\/\(r\^2 + a\^2\ x\^2\) + 
            \(\((\(-1\) + x\^2)\)\ 
                \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                    2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\)\ 
                d[\[CurlyPhi]]\^2\)\/\(r\^2 + a\^2\ x\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ r], 2]], 
            Times[ 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ -2, M, r], 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, 
                  Power[ x, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ x], 2]], 
            Times[ -4, a, M, r, 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              d[ t], 
              d[ \[CurlyPhi]]], 
            Times[ 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ x, 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.550000000000011368`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.55000000000001137, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.199999999999988631`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.19999999999998863, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]2.55000000000001136`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 2.5500000000000114, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("RUddd not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0500000000000113686`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.050000000000011369, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 3.58333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(detg\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-1\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdddd[\([1, 2, 1, 2]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(M\ r\ \((r\^2 - 3\ a\^2\ x\^2)\)\ 
        \((\(-3\)\ a\^2 + 4\ M\ r - 2\ r\^2 + a\^2\ x\^2)\)\)\/\(\((
          2\ M\ r - r\^2 - a\^2\ x\^2)\)\ \((r\^2 + a\^2\ x\^2)\)\^3\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]Ud[\([1, 2]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(M\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \((\(-r\) + a\ x)\)\ \((r + a\ x)\)\ 
          e[1]\)\/\(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
          \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\) - 
      \(a\ M\ \((\(-r\) + a\ x)\)\ \((r + a\ x)\)\ \@\(1 - x\^2\)\ 
          e[4]\)\/\(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
          \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "        \[FilledSmallSquare]   ",
  StyleBox[
  "Sample calculations with tensor-valued differential forms and use of \
HStar:",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t\[FilledSmallCircle] Construct the (rank-2) 2-form curvature tensor \
\[CapitalOmega]Ud with components \[CapitalOmega]Ud[[a,b]] =",
  Cell[BoxData[
      \(\(\ \(\[CapitalOmega]\^a\)\_b\)\)]],
  Cell[BoxData[
      \(\( = \(1\/2\) \(\(R\^a\)\_bcd\) e\^c\)\)]],
  Cell[BoxData[
      \(\(\[Wedge]e\^d\)\)]],
  "  (eUU is the 2-form-basis tensor: eUU[[a,b]]=e[a]\[Wedge]e[b])."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(eUU = Outer[Wedge, e/@{1, 2, 3, 4}, e/@{1, 2, 3, 4}]; 
    Off[General::"\<spell\>", General::"\<spell1\>"]; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\[CapitalOmega]Ud = multiDot[gUU.Rdddd/2, eUU, {3, 1}, {4, 2}]; \) // 
      Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.5`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t\[FilledSmallCircle] Verify that  ",
  Cell[BoxData[
      \(\(\[CapitalOmega]\^a\)\_b\)]],
  " equals  d[",
  Cell[BoxData[
      \(\(\[Omega]\^a\)\_b\)]],
  "]+",
  Cell[BoxData[
      \(\(\[Omega]\^a\)\_s\)]],
  "\[Wedge]",
  Cell[BoxData[
      \(\(\[Omega]\^s\)\_b\)]],
  ". (Wedge multiplication of tensors acts like ",
  StyleBox["Dot",
    FontFamily->"Courier"],
  " - contracts last index of first tensor with first index of second \
tensor)."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[
        FacSimp[d[\[Omega]Ud] + \[Omega]Ud\[Wedge]\[Omega]Ud - 
            \[CapitalOmega]Ud]] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({8.81666666666666287`\ Second, True}\)], "Output"]
}, Open  ]],

Cell[TextData[
"\t\[FilledSmallCircle] Verify Bianchi identities using \[CapitalOmega]Ud:"], 
  "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[
        FacSimp[d[\[CapitalOmega]Ud] + \[Omega]Ud\[Wedge]\[CapitalOmega]Ud - 
            \[CapitalOmega]Ud\[Wedge]\[Omega]Ud]] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({21.8166666666666619`\ Second, True}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "         \[FilledSmallCircle] If both tensors to be contracted with ",
  StyleBox["multiDot",
    FontFamily->"Courier"],
  " are differential form-valued, then their components are multiplied using \
Wedge:"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(multiDot[\[CapitalOmega]Ud, \[CapitalOmega]Ud, {1, 2}, {2, 1}] // Timing
      \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.833333333333314385`\ Second, 
      \(48\ a\ M\^2\ r\ x\ \((\(-3\)\ r\^2 + a\^2\ x\^2)\)\ 
          \((\(-r\^2\) + 3\ a\^2\ x\^2)\)\ 
          e[1]\[Wedge]e[2]\[Wedge]e[3]\[Wedge]e[4]\)\/\((r\^2 + a\^2\ x\^2)
            \)\^6}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t\[FilledSmallCircle] ",
  StyleBox["HStar",
    FontFamily->"Courier"],
  " gives the Hodge-dual:"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pseudoScalar = HStar[%[\([2]\)]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(48\ a\ M\^2\ r\ x\ \((r\^2 - 3\ a\^2\ x\^2)\)\ 
        \((\(-3\)\ r\^2 + a\^2\ x\^2)\)\)\/\((r\^2 + a\^2\ x\^2)\)\^6\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t\[FilledSmallCircle] This invariant equals ",
  Cell[BoxData[
      \(\(-\(1\/4\)\) \(R\^ab\)\_cd\)]],
  Cell[BoxData[
      \(\(\(R\^cd\)\_ef\) \(\[Eta]\^ef\)\_ab\)]],
  "  and can also be obtained (using ",
  StyleBox["eta[1,2]",
    FontFamily->"Courier"],
  ") as follows:"
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(RUUdd = Raise[Rdddd, 1, 2]; \) // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.800000000000011368`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(RstarUUdd = multiDot[RUUdd/2, eta[1, 2], {3, 1}, {4, 2}]; \) // Timing
      \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0.816666666666662877`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(multiDot[\(-RUUdd\)/2, RstarUUdd, {1, 3}, {2, 4}, {3, 1}, {4, 2}]\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(48\ a\ M\^2\ r\ x\ \((\(-3\)\ r\^2 + a\^2\ x\^2)\)\ 
            \((\(-r\^2\) + 3\ a\^2\ x\^2)\)\)\/\((r\^2 + a\^2\ x\^2)\)\^6
            \)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[% - pseudoScalar]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[TextData[{
  "\t\[FilledSmallCircle] The invariant  ",
  Cell[BoxData[
      \(\(1\/2\) \(R\^ab\)\_cd\)]],
  Cell[BoxData[
      \(\(R\^cd\)\_ab\)]],
  "  can be obtained either as:"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(multiDot[RUUdd, RUUdd, {1, 3}, {2, 4}, {3, 1}, {4, 2}]/2\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(24\ M\^2\ \((r - a\ x)\)\ \((r + a\ x)\)\ 
        \((r\^2 - 4\ a\ r\ x + a\^2\ x\^2)\)\ 
        \((r\^2 + 4\ a\ r\ x + a\^2\ x\^2)\)\)\/\((r\^2 + a\^2\ x\^2)\)\^6\)],
   "Output"]
}, Open  ]],

Cell[TextData[{
  "or, using \[CapitalOmega]Ud and ",
  StyleBox["HStar",
    FontFamily->"Courier"],
  ", as:"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(HStar[
        multiDot[\[CapitalOmega]Ud, HStar[\[CapitalOmega]Ud], {1, 2}, {2, 1}]]
         // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({1.33333333333331438`\ Second, 
      \(-\(\(24\ M\^2\ \((r - a\ x)\)\ \((r + a\ x)\)\ 
              \((\(-r\^2\) - 4\ a\ r\ x - a\^2\ x\^2)\)\ 
              \((r\^2 - 4\ a\ r\ x + a\^2\ x\^2)\)\)\/\((r\^2 + a\^2\ x\^2)
                \)\^6\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Factor[%[\([2]\)] - %%]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(On[General::"\<spell\>", General::"\<spell1\>"]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["   5.1.3   Newman-Penrose Null Frame", "Subsubsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tWhen the metric equals ",
  StyleBox["{{0,1,0,0},{1,0,0,0},{0,0,0,-1},{0,0,-1,0}}",
    FontFamily->"Courier"],
  ", ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " assigns values to a number of new symbols (global variables):\n\t(i)   \
the spin coefficents:  ",
  StyleBox[
  "\[Tau], \[Kappa], \[Rho], \[Sigma], \[Gamma], \[Epsilon], \[Alpha], \
\[Beta], \[Nu], $\[Pi], \[Lambda], \[Mu]",
    FontFamily->"Courier"],
  "\n\t(ii)  the Ricci and Weyl scalars:  \[CapitalPhi][",
  StyleBox["i,j]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\[CapitalLambda]",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\[CapitalPsi][i]",
    FontFamily->"Courier"],
  " for the Newman-Penrose scalars ",
  Cell[BoxData[
      \(\[CapitalPhi]\_ij\)]],
  ", ",
  StyleBox["\[CapitalLambda]",
    FontFamily->"Courier"],
  ", and ",
  Cell[BoxData[
      \(\[CapitalPsi]\_i\)]],
  ",\nand defines the differential operators:  ",
  StyleBox[
  "{\[GothicCapitalD][_], \[CapitalDelta][_], \[Delta][_], \[Delta]B[_]}",
    FontFamily->"Courier"],
  ", \n",
  StyleBox["assuming that the null basis given in the coframe is",
    FontSlant->"Italic"],
  " ",
  StyleBox["{\[DoubleStruckL],\[DoubleStruckN],\[DoubleStruckM],",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(\[DoubleStruckM]\&_\)]],
  StyleBox["}",
    FontFamily->"Courier"],
  " (standard NP notation). \n\n\t",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " prints messages after each set of NP symbols is defined. Differential \
forms are still written in the ",
  StyleBox["e[i]",
    FontFamily->"Courier"],
  " notation, where ",
  StyleBox["e[1]",
    FontFamily->"Courier"],
  "=",
  StyleBox["\[DoubleStruckL],e[2]",
    FontFamily->"Courier"],
  "=",
  StyleBox["\[DoubleStruckN]",
    FontFamily->"Courier"],
  ", etc. The only other differences from the standard notation are the use \
of ",
  StyleBox["$\[Pi]",
    FontFamily->"Courier"],
  " in place of ",
  StyleBox["\[Pi]",
    FontFamily->"Courier"],
  " (which in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the constant 3.14159...), the use of the Gothic D - ",
  StyleBox["\[GothicCapitalD]",
    FontFamily->"Courier"],
  " - for the NP differential operator D (to distinguish it from the built-in \
operator D) and the use of  ",
  StyleBox["\[Delta]B",
    FontFamily->"Courier"],
  " instead of ",
  StyleBox["OverBar[\[Delta]]",
    FontFamily->"Courier"],
  " (easier to write and to  see!). The palette ",
  StyleBox["NPsymbolPLT.nb",
    FontWeight->"Bold"],
  "  facilitates entering these NP symbols/operators."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tThe function ",
  StyleBox["Bar",
    FontFamily->"Courier"],
  " now knows the reality conditions of the frame, e.g., that ",
  StyleBox["Bar[e[1]]=e[1]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Bar[e[3]]=e[4]",
    FontFamily->"Courier"],
  ",  etc., but assumes that all other symbols used are real (the spin \
coefficients are ",
  StyleBox["names",
    FontSlant->"Italic"],
  " that refer to expressions in terms of the coordinates which may contain \
the imaginary unit ",
  StyleBox["I",
    FontFamily->"Courier"],
  "). Thus, if complex symbols are to be used in an NP frame, their ",
  StyleBox["Bar[]",
    FontFamily->"Courier"],
  " relations must be defined ",
  StyleBox["before",
    FontSlant->"Italic"],
  " calling ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  "."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"  \[FilledSmallSquare]   Example 4c: Kerr (Example 4)  @ NP[(1,2), (3,4)] \
frame",
  FontWeight->"Bold"]], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPframe = 
      FacSimp[{\((ONframe[\([1]\)] - ONframe[\([2]\)])\)/\@2, 
          \((ONframe[\([1]\)] + ONframe[\([2]\)])\)/\@2, 
          \((ONframe[\([3]\)] + I\ ONframe[\([4]\)])\)/\@2, 
          \((ONframe[\([3]\)] - I\ ONframe[\([4]\)])\)/\@2}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(-
          \(\(\@\(r\^2 + a\^2\ x\^2\)\ d[r]\)\/\(\@2\ 
                \@\(a\^2 - 2\ M\ r + r\^2\)\)\)\) + 
        \(\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ d[t]\)\/\(\@2\ 
            \@\(r\^2 + a\^2\ x\^2\)\) - 
        \(\@2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            d[\[CurlyPhi]]\)\/\(\@\(r\^2 + a\^2\ x\^2\)\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[r]\)\/\(\@2\ 
            \@\(a\^2 - 2\ M\ r + r\^2\)\) + 
        \(\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ d[t]\)\/\(\@2\ 
            \@\(r\^2 + a\^2\ x\^2\)\) - 
        \(\@2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            d[\[CurlyPhi]]\)\/\(\@\(r\^2 + a\^2\ x\^2\)\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[x]\)\/\(\@2\ \@\(1 - x\^2\)\) + 
        \(I\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
            \@\(r\^2 + a\^2\ x\^2\)\ d[\[CurlyPhi]]\)\/\(\@2\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[x]\)\/\(\@2\ \@\(1 - x\^2\)\) - 
        \(I\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
            \@\(r\^2 + a\^2\ x\^2\)\ d[\[CurlyPhi]]\)\/\(\@2\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"gNP", "=", 
        StyleBox[
          \({{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, \(-1\), 0}}
            \),
          FontFamily->"Courier"]}], 
      StyleBox[";",
        FontFamily->"Courier"]}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(varList = {\@\(a\^2 - 2\ M\ r + r\^2\)}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\@\(a\^2 - 2\ M\ r + r\^2\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\tThis is an example where using ",
  StyleBox["varList",
    FontFamily->"Courier"],
  " is essential (see section 4.3). With the default empty list, ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " seems to get stuck (more than 10 minutes with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4) in computing Rdddd (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 actually gets stuck -- cannot be aborted!). "
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gNP, xCoord, NPframe, {0, 0}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - \(\((r\^2 + a\^2\ x\^2)\)\ d[r]\^2\)\/\(a\^2 - 2\ M\ r + 
                  r\^2\)\) + 
            \(\((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\ d[t]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\) + 
            \(\((r\^2 + a\^2\ x\^2)\)\ d[x]\^2\)\/\(\(-1\) + x\^2\) - 
            \(4\ a\ M\ r\ \((\(-1\) + x\^2)\)\ d[t]\ 
                d[\[CurlyPhi]]\)\/\(r\^2 + a\^2\ x\^2\) + 
            \(\((\(-1\) + x\^2)\)\ 
                \((2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + a\^4\ x\^2 - 
                    2\ a\^2\ M\ r\ x\^2 + a\^2\ r\^2\ x\^2)\)\ 
                d[\[CurlyPhi]]\^2\)\/\(r\^2 + a\^2\ x\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ a, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ r], 2]], 
            Times[ 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ -2, M, r], 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, 
                  Power[ x, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ x], 2]], 
            Times[ -4, a, M, r, 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              d[ t], 
              d[ \[CurlyPhi]]], 
            Times[ 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ x, 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ \[CurlyPhi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Computing d[coframe]..."\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]2.03333333333330301`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 2.033333333333303, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]1.05000000000001136`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 1.0500000000000114, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Spin coefficients \[Tau], \[Kappa], \[Rho], \[Sigma], \[Gamma], \
\[Epsilon], \[Alpha], \[Beta], \[Nu], $\[Pi], \[Lambda], \[Mu] defined"\)], 
  "Print"],

Cell[BoxData[
    \("Differential Operators \[GothicCapitalD][x_], \[CapitalDelta][x_], \
\[Delta][x_], \[Delta]B[x_] defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]36.25`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 36.25, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("RUddd not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("NP variables \[CapitalPhi][i,j], \[CapitalLambda] defined"\)], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 40.6833 seconds"\)], "Print"]
}, Open  ]],

Cell["\<\
\tUse the input palette NPsymbolPLT.nb to enter the spin \
coefficients.\
\>", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Kappa]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(a\ \((r - I\ a\ x)\)\^2\ \((\(-I\)\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
            \((\(-2\)\ M\ r + 2\ I\ a\ M\ x - I\ a\ r\ x + a\^2\ x\^2)
              \)\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Bar[\[Kappa]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(a\ \((r + I\ a\ x)\)\^2\ \((I\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
            \((\(-2\)\ M\ r - 2\ I\ a\ M\ x + I\ a\ r\ x + a\^2\ x\^2)
              \)\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(phi00 = 
        \[GothicCapitalD][\[Rho]] - \[Delta]B[\[Kappa]] - 
          \((\[Rho]^2 + \[Sigma]\ Bar[\[Sigma]] + 
              \((\[Epsilon] + Bar[\[Epsilon]])\) \[Rho] - 
              Bar[\[Kappa]] \[Tau] - 
              \[Kappa] \((3  \[Alpha] + Bar[\[Beta]] - $\[Pi])\))\); \) // 
      Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({3.46666666666664013`\ Second, Null}\)], "Output"]
}, Open  ]],

Cell[TextData[
"\tThis takes long because the expressions for \[Rho] and \[Kappa]  are being \
differentiated."], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ByteCount[phi00]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(37984\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[phi00] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({1.11666666666667424`\ Second, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "\t",
  StyleBox["Bar",
    FontFamily->"Courier"],
  " works as expected with exterior and partial differentiation:"
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(drho = FacSimp[d[\[Rho]]]; Imrho = FacSimp[\[Rho] - Bar[\[Rho]]]; \)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[drho - Bar[drho] - d[Imrho]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[
"i.e., the imaginary part of the 1-form d[\[Rho]] equals the exterior \
derivative of the imaginary part of the scalar \[Rho]. Similarly:"], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(rhor = D[\[Rho], r]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[rhor - Bar[rhor] - D[Imrho, r]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdddd[\([1, 2, 1, 2]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(M\ r\ \((\(-3\)\ a\^2 + 4\ M\ r - 2\ r\^2 + a\^2\ x\^2)\)\ 
        \((\(-r\^2\) + 3\ a\^2\ x\^2)\)\)\/\(\((r\^2 + a\^2\ x\^2)\)\^3\ 
        \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Omega]Ud[\([1, 3]\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-\(\(a\^2\ x\ \@\(1 - x\^2\)\ e[1]\)\/\(2\ \@2\ 
              \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
              \@\(r\^2 + a\^2\ x\^2\)\)\)\) - 
      \(a\ \((r + I\ a\ x)\)\^2\ \((I\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
          \((\(-2\)\ M\ r - 2\ I\ a\ M\ x + I\ a\ r\ x + a\^2\ x\^2)\)\ 
          e[2]\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
          \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) - 
      \(a\^2\ \((M - r)\)\ \((\(-1\) + x)\)\ \((1 + x)\)\ e[3]\)\/\(2\ \@2\ 
          \@\(a\^2 - 2\ M\ r + r\^2\)\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
          \@\(r\^2 + a\^2\ x\^2\)\) + 
      \((\@\(r\^2 + a\^2\ x\^2\)\ 
            \((\(-3\)\ a\^2\ M\ r + a\^2\ r\^2 + 8\ M\^2\ r\^2 - 8\ M\ r\^3 + 
                2\ r\^4 - I\ a\^3\ M\ x - I\ a\^3\ r\ x + 
                4\ I\ a\ M\ r\^2\ x - 2\ I\ a\ r\^3\ x - a\^2\ M\ r\ x\^2 + 
                a\^2\ r\^2\ x\^2 + I\ a\^3\ M\ x\^3 - I\ a\^3\ r\ x\^3)\)\ 
            e[4])\)/\((
          2\ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \((r - I\ a\ x)\)\^2\ 
            \((r + I\ a\ x)\)\ \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\))\)\)], 
  "Output"]
}, Open  ]],

Cell["\<\
\tOne can also define other NP quantities, say the spin connection \
1-form \
\>", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SpinOmega01 = 
      FacSimp[\[Gamma]\ e[1] + \[Epsilon]\ e[2] - \[Alpha]\ e[3] - 
          \[Beta]\ e[4]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(M\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ e[1]\)\/\(2\ 
          \@2\ \((r + I\ a\ x)\)\^2\ 
          \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) + 
      \(M\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ e[2]\)\/\(2\ 
          \@2\ \((r + I\ a\ x)\)\^2\ 
          \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) - 
      \((\((r - I\ a\ x)\)\^2\ \((\(-I\)\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
            \((a\ M\ r - I\ a\^2\ M\ x + 2\ I\ M\ r\^2\ x - I\ r\^3\ x - 
                3\ a\ M\ r\ x\^2 + a\ r\^2\ x\^2 + I\ a\^2\ M\ x\^3 - 
                I\ a\^2\ r\ x\^3 + a\^3\ x\^4)\)\ e[3])\)/
        \((2\ \@2\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\))\) + 
      \((\((r - I\ a\ x)\)\^2\ \((\(-I\)\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
            \((a\ M\ r - I\ a\^2\ M\ x + 2\ I\ M\ r\^2\ x - I\ r\^3\ x - 
                3\ a\ M\ r\ x\^2 + a\ r\^2\ x\^2 + I\ a\^2\ M\ x\^3 - 
                I\ a\^2\ r\ x\^3 + a\^3\ x\^4)\)\ e[4])\)/
        \((2\ \@2\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\))\)\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["  5.2  Implicit Frame Calculations",
  FontWeight->"Bold"]], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->18,
  FontWeight->"Plain"],

Cell[TextData[{
  "\tFor some problems, giving the explicit form of the coframe (in terms of \
the coordinate differentials) is not the most efficient way of doing the \
calculations. This is particularly true if the exterior derivatives of the \
coframe satisfy simple expressions, not involving the coordinates, as in the \
Bianchi cosmological models, for which d[e",
  Cell[BoxData[
      \(\^a\)]],
  "]= -",
  Cell[BoxData[
      \(\(1\/2\) \(C\^a\)\_bc\)]],
  "e",
  Cell[BoxData[
      \(\^b\)]],
  "\[Wedge]e",
  Cell[BoxData[
      \(\^c\)]],
  "  with ",
  Cell[BoxData[
      \(\(C\^a\)\_bc\)]],
  "=constants. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\tTo do the calculations in such cases, ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " makes use of two global variables -- ",
  StyleBox["deList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " -- which must be defined by the user. The first (",
  StyleBox["deList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ") must be set equal to the expressions for ",
  StyleBox["d[e",
    FontFamily->"Courier"],
  Cell[BoxData[
      \(\^a\)]],
  StyleBox["]",
    FontFamily->"Courier"],
  " (in terms of  ",
  StyleBox["e[a]\[Wedge]e[b]",
    FontFamily->"Courier"],
  "),  and the second (",
  StyleBox["dxRuleList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ") must be set equal to a list of rules for replacing the coordinate \
differentials in terms of the ",
  StyleBox["e[a]",
    FontFamily->"Courier"],
  " basis. Actually, only the differentials of  those coordinates that appear \
in the metric and in the expressions for ",
  StyleBox["d[e[a]]",
    FontFamily->"Courier"],
  " need to be included in ",
  StyleBox["dxRuleList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". Finally, one must call ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " with ",
  StyleBox["{e[]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as third argument: ",
  StyleBox["RGtensors[gIN,xIN,{e[]}]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". The coframe thus remains undefined in terms of the coordinate \
differentials, but its exterior derivative is known. "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "           ",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "For the last example (4c), the lists ",
  StyleBox["dxRuleList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["deList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be obtained as follows:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input"],

Cell[BoxData[
    \("varList cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[BoxData[
    \(\(varList = {\@\(a\^2 - 2\ M\ r + r\^2\)}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPframe\)], "Input"],

Cell[BoxData[
    \({\(-
          \(\(\@\(r\^2 + a\^2\ x\^2\)\ d[r]\)\/\(\@2\ 
                \@\(a\^2 - 2\ M\ r + r\^2\)\)\)\) + 
        \(\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ d[t]\)\/\(\@2\ 
            \@\(r\^2 + a\^2\ x\^2\)\) - 
        \(\@2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            d[\[CurlyPhi]]\)\/\(\@\(r\^2 + a\^2\ x\^2\)\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[r]\)\/\(\@2\ 
            \@\(a\^2 - 2\ M\ r + r\^2\)\) + 
        \(\@\(\(-2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ d[t]\)\/\(\@2\ 
            \@\(r\^2 + a\^2\ x\^2\)\) - 
        \(\@2\ a\ M\ r\ \((\(-1\) + x)\)\ \((1 + x)\)\ 
            d[\[CurlyPhi]]\)\/\(\@\(r\^2 + a\^2\ x\^2\)\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[x]\)\/\(\@2\ \@\(1 - x\^2\)\) + 
        \(I\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
            \@\(r\^2 + a\^2\ x\^2\)\ d[\[CurlyPhi]]\)\/\(\@2\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      \(\@\(r\^2 + a\^2\ x\^2\)\ d[x]\)\/\(\@2\ \@\(1 - x\^2\)\) - 
        \(I\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
            \@\(r\^2 + a\^2\ x\^2\)\ d[\[CurlyPhi]]\)\/\(\@2\ 
            \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d[xCoord]\)], "Input"],

Cell[BoxData[
    \({d[t], d[r], d[x], d[\[CurlyPhi]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dxRuleList = 
      FacSimp[\(Solve[NPframe \[Equal] e/@{1, 2, 3, 4}, d[xCoord]]\)[\([1]\)]]
        \)], "Input"],

Cell[BoxData[
    \({d[x] \[Rule] 
        \(\@\(1 - x\^2\)\ e[3]\)\/\(\@2\ \@\(r\^2 + a\^2\ x\^2\)\) + 
          \(\@\(1 - x\^2\)\ e[4]\)\/\(\@2\ \@\(r\^2 + a\^2\ x\^2\)\), 
      d[t] \[Rule] 
        \(\@\(r\^2 + a\^2\ x\^2\)\ e[1]\)\/\(\@2\ 
              \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\) + 
          \(\@\(r\^2 + a\^2\ x\^2\)\ e[2]\)\/\(\@2\ 
              \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\) + 
          \(I\ \@2\ a\ M\ r\ \@\(1 - x\^2\)\ 
              e[3]\)\/\(\@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
              \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\) - 
          \(I\ \@2\ a\ M\ r\ \@\(1 - x\^2\)\ 
              e[4]\)\/\(\@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
              \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\), 
      d[r] \[Rule] 
        \(-\(\(\@\(a\^2 - 2\ M\ r + r\^2\)\ e[1]\)\/\(\@2\ 
                  \@\(r\^2 + a\^2\ x\^2\)\)\)\) + 
          \(\@\(a\^2 - 2\ M\ r + r\^2\)\ e[2]\)\/\(\@2\ 
              \@\(r\^2 + a\^2\ x\^2\)\), 
      d[\[CurlyPhi]] \[Rule] 
        \(-\(\(I\ \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ e[3]\)\/\(\@2\ 
                  \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
                  \@\(r\^2 + a\^2\ x\^2\)\)\)\) + 
          \(I\ \@\(\( - 2\)\ M\ r + r\^2 + a\^2\ x\^2\)\ e[4]\)\/\(\@2\ 
              \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(1 - x\^2\)\ 
              \@\(r\^2 + a\^2\ x\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(deList = FacSimp[d[NPframe] /. dxRuleList]\)], "Input"],

Cell[BoxData[
    \({\(-
          \(\(M\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \((r\^2 - a\^2\ x\^2)\)\ 
                e[1]\[Wedge]e[2]\)\/\(\@2\ \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
                \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\)\)\) + 
        \(I\ a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ M\ r\^2 - I\ a\ r\^2\ x - 2\ a\^2\ M\ x\^2 - I\ a\^3\ x\^3)
              \)\ e[1]\[Wedge]e[3]\)\/\(2\ \@2\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) - 
        \(I\ a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ M\ r\^2 + I\ a\ r\^2\ x - 2\ a\^2\ M\ x\^2 + I\ a\^3\ x\^3)
              \)\ e[1]\[Wedge]e[4]\)\/\(2\ \@2\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\^2\ \@\(1 - x\^2\)\ 
            \((\(-2\)\ I\ M\ r + 2\ a\ M\ x - a\ r\ x + I\ a\^2\ x\^2)\)\ 
            e[2]\[Wedge]e[3]\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(a\ \((r - I\ a\ x)\)\^2\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ I\ M\ r + 2\ a\ M\ x - a\ r\ x - I\ a\^2\ x\^2)\)\ 
            e[2]\[Wedge]e[4]\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(2\ I\ \@2\ a\ M\ r\ \@\(a\^2 - 2\ M\ r + r\^2\)\ x\ 
            e[3]\[Wedge]e[4]\)\/\(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\), 
      \(-\(\(M\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \((r\^2 - a\^2\ x\^2)\)\ 
                e[1]\[Wedge]e[2]\)\/\(\@2\ \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
                \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\)\)\) + 
        \(a\ \((r - I\ a\ x)\)\^2\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ I\ M\ r + 2\ a\ M\ x - a\ r\ x - I\ a\^2\ x\^2)\)\ 
            e[1]\[Wedge]e[3]\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\^2\ \@\(1 - x\^2\)\ 
            \((\(-2\)\ I\ M\ r + 2\ a\ M\ x - a\ r\ x + I\ a\^2\ x\^2)\)\ 
            e[1]\[Wedge]e[4]\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) - 
        \(I\ a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ M\ r\^2 + I\ a\ r\^2\ x - 2\ a\^2\ M\ x\^2 + I\ a\^3\ x\^3)
              \)\ e[2]\[Wedge]e[3]\)\/\(2\ \@2\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(I\ a\ \((r - I\ a\ x)\)\ \((r + I\ a\ x)\)\ \@\(1 - x\^2\)\ 
            \((2\ M\ r\^2 - I\ a\ r\^2\ x - 2\ a\^2\ M\ x\^2 - I\ a\^3\ x\^3)
              \)\ e[2]\[Wedge]e[4]\)\/\(2\ \@2\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\) + 
        \(2\ I\ \@2\ a\ M\ r\ \@\(a\^2 - 2\ M\ r + r\^2\)\ x\ 
            e[3]\[Wedge]e[4]\)\/\(\((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\), 
      \(-\(\((\((\(-3\)\ a\^2\ M\ r\^2 + a\^2\ r\^3 + 8\ M\^2\ r\^3 - 
                    8\ M\ r\^4 + 2\ r\^5 + a\^4\ M\ x\^2 + a\^4\ r\ x\^2 - 
                    5\ a\^2\ M\ r\^2\ x\^2 + 3\ a\^2\ r\^3\ x\^2 - 
                    a\^4\ M\ x\^4 + a\^4\ r\ x\^4)\)\ e[1]\[Wedge]e[3])\)/
            \((2\ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ 
                \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
                \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\))\)\)\) + 
        \(a\^2\ \((\(-M\) + r)\)\ \((\(-1\) + x\^2)\)\ e[1]\[Wedge]e[4]\)\/\(2
            \ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
            \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) + 
        \((\((\(-3\)\ a\^2\ M\ r\^2 + a\^2\ r\^3 + 8\ M\^2\ r\^3 - 
                  8\ M\ r\^4 + 2\ r\^5 + a\^4\ M\ x\^2 + a\^4\ r\ x\^2 - 
                  5\ a\^2\ M\ r\^2\ x\^2 + 3\ a\^2\ r\^3\ x\^2 - 
                  a\^4\ M\ x\^4 + a\^4\ r\ x\^4)\)\ e[2]\[Wedge]e[3])\)/
          \((2\ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ 
              \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
              \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\))\) - 
        \(a\^2\ \((\(-M\) + r)\)\ \((\(-1\) + x\^2)\)\ e[2]\[Wedge]e[4]\)\/\(2
            \ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
            \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) + 
        \(x\ \((\(-2\)\ a\^2\ M\ r + 2\ M\ r\^3 - r\^4 + 
              4\ a\^2\ M\ r\ x\^2 - 2\ a\^2\ r\^2\ x\^2 - a\^4\ x\^4)\)\ 
            e[3]\[Wedge]e[4]\)\/\(\@2\ \@\(1 - x\^2\)\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\), 
      \(a\^2\ \((\(-M\) + r)\)\ \((\(-1\) + x\^2)\)\ e[1]\[Wedge]e[3]\)\/\(2\ 
            \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
            \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) - 
        \((\((\(-3\)\ a\^2\ M\ r\^2 + a\^2\ r\^3 + 8\ M\^2\ r\^3 - 
                  8\ M\ r\^4 + 2\ r\^5 + a\^4\ M\ x\^2 + a\^4\ r\ x\^2 - 
                  5\ a\^2\ M\ r\^2\ x\^2 + 3\ a\^2\ r\^3\ x\^2 - 
                  a\^4\ M\ x\^4 + a\^4\ r\ x\^4)\)\ e[1]\[Wedge]e[4])\)/
          \((2\ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ 
              \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
              \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\))\) - 
        \(a\^2\ \((\(-M\) + r)\)\ \((\(-1\) + x\^2)\)\ e[2]\[Wedge]e[3]\)\/\(2
            \ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ \@\(r\^2 + a\^2\ x\^2\)\ 
            \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\)\) + 
        \((\((\(-3\)\ a\^2\ M\ r\^2 + a\^2\ r\^3 + 8\ M\^2\ r\^3 - 
                  8\ M\ r\^4 + 2\ r\^5 + a\^4\ M\ x\^2 + a\^4\ r\ x\^2 - 
                  5\ a\^2\ M\ r\^2\ x\^2 + 3\ a\^2\ r\^3\ x\^2 - 
                  a\^4\ M\ x\^4 + a\^4\ r\ x\^4)\)\ e[2]\[Wedge]e[4])\)/
          \((2\ \@2\ \@\(a\^2 - 2\ M\ r + r\^2\)\ 
              \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\ 
              \((\(-2\)\ M\ r + r\^2 + a\^2\ x\^2)\))\) - 
        \(x\ \((\(-2\)\ a\^2\ M\ r + 2\ M\ r\^3 - r\^4 + 
              4\ a\^2\ M\ r\ x\^2 - 2\ a\^2\ r\^2\ x\^2 - a\^4\ x\^4)\)\ 
            e[3]\[Wedge]e[4]\)\/\(\@2\ \@\(1 - x\^2\)\ 
            \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(3/2\)\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tNow ",
  StyleBox["RGtensors[gNP,xCoord,{e[]},{0,0}]",
    FontFamily->"Courier"],
  " gives the same results faster, except for the line element, which is just \
\[InvisibleSpace]2 e[1] e[2]-2 e[3] e[4]. "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(RGtensors[gNP, xCoord, {e[]}, {0, 0}]\),
      FontFamily->"Courier"]], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[\(2\ e[1]\ e[2] - 2\ e[3]\ e[4]\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              e[ 1], 
              e[ 2]], 
            Times[ -2, 
              e[ 3], 
              e[ 4]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Warning: deList closure not tested"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]1.05000000000006821`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 1.0500000000000682, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Spin coefficients \[Tau], \[Kappa], \[Rho], \[Sigma], \[Gamma], \
\[Epsilon], \[Alpha], \[Beta], \[Nu], $\[Pi], \[Lambda], \[Mu] defined"\)], 
  "Print"],

Cell[BoxData[
    \("Differential Operators \[GothicCapitalD][x_], \[CapitalDelta][x_], \
\[Delta][x_], \[Delta]B[x_] defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]31.9666666666665832`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 31.966666666666583, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    \("RUddd not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Weyl tensor not computed"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("NP variables \[CapitalPhi][i,j], \[CapitalLambda] defined"\)], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 34.2 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Kappa]\)], "Input"],

Cell[BoxData[
    \(\(-\(\(a\ \((r - I\ a\ x)\)\^2\ \((\(-I\)\ r + a\ x)\)\ \@\(1 - x\^2\)\ 
            \((\(-2\)\ M\ r + 2\ I\ a\ M\ x - I\ a\ r\ x + a\^2\ x\^2)
              \)\)\/\(2\ \@2\ \((2\ M\ r - r\^2 - a\^2\ x\^2)\)\ 
            \((r\^2 + a\^2\ x\^2)\)\^\(5/2\)\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input"],

Cell[BoxData[
    \("varList cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[BoxData[
    \(d[a] =. ; d[M] =. ; \)], "Input"]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Warning",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": When the differentials of only ",
  StyleBox["some",
    FontSlant->"Italic"],
  " of the coordinates are included in ",
  StyleBox["dxRuleList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["covD",
    FontFamily->"Courier"],
  " and ",
  StyleBox["covDiv",
    FontFamily->"Courier"],
  " behave as if differentiations with respect to the remaining coordinates \
give zero. "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 9: Diagonal, Class-A, Bianchi Cosmological \
Models "], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(\(xCoord = {x1, x2, x3, t}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(g = {{\(-A[t]\), 0, 0, 0}, {0, \(-B[t]\), 0, 0}, {0, 0, \(-C[t]\), 
          0}, {0, 0, 0, F[t]}}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[TextData[{
  "\tThe components of ",
  StyleBox["g",
    FontFamily->"Courier"],
  " refer to an undefined coframe ",
  StyleBox["{e[1],e[2],....,e[Dim]}",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(dxRuleList = {d[t] -> e[4]}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(deList
       = {n[1] e[2]\[Wedge]e[3], n[2] e[3]\[Wedge]e[1], 
        n[3] e[1]\[Wedge]e[2], 0}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({n[1]\ e[2]\[Wedge]e[3], \(-n[2]\)\ e[1]\[Wedge]e[3], 
      n[3]\ e[1]\[Wedge]e[2], 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\tThe elements of ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " are, by definition, ",
  StyleBox["{d[e[1]],d[e[2]],....,d[e[Dim]]}",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \( (*\(*\ d[n[_]]\) = 0; \ **) \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[TextData[{
  "\t",
  StyleBox["d[n[_]]",
    FontFamily->"Courier"],
  " is left undefined intentionally to generate a warning message."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[g, xCoord, {e[]}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-A[t]\), "0", "0", "0"},
                {"0", \(-B[t]\), "0", "0"},
                {"0", "0", \(-C[t]\), "0"},
                {"0", "0", "0", \(F[t]\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, 
            A[ t]], 0, 0, 0}, {0, 
          Times[ -1, 
            B[ t]], 0, 0}, {0, 0, 
          Times[ -1, 
            C[ t]], 0}, {0, 0, 0, 
          F[ t]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - A[t]\)\ e[1]\^2 - B[t]\ e[2]\^2 - C[t]\ e[3]\^2 + 
            e[4]\^2\ F[t]\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              A[ t], 
              Power[ 
                e[ 1], 2]], 
            Times[ -1, 
              B[ t], 
              Power[ 
                e[ 2], 2]], 
            Times[ -1, 
              C[ t], 
              Power[ 
                e[ 3], 2]], 
            Times[ 
              Power[ 
                e[ 4], 2], 
              F[ t]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-\(1\/A[t]\)\), "0", "0", "0"},
                {"0", \(-\(1\/B[t]\)\), "0", "0"},
                {"0", "0", \(-\(1\/C[t]\)\), "0"},
                {"0", "0", "0", \(1\/F[t]\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              A[ t], -1]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              B[ t], -1]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ 
              C[ t], -1]], 0}, {0, 0, 0, 
          Power[ 
            F[ t], -1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Warning: deList not closed! d[deList]="\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \({d[n[1]]\[Wedge]e[2]\[Wedge]e[3], 
      \(-\((d[n[2]]\[Wedge]e[1]\[Wedge]e[3])\)\), 
      d[n[3]]\[Wedge]e[1]\[Wedge]e[2], 0}\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.133333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.13333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0833333333333712289`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.299999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.29999999999995453, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0833333333333712289`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.85 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["Clear$dx",
    FontFamily->"Courier"],
  " clears ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " also, so they must be redefined."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell["\<\
 

\tChoosing n[i_] and A[t], B[t], C[t], F[t] appropriately, particular models \
can be selected: \
\>", "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell["Taub (Bianchi type IX)", "Subsection",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    RowBox[{\(dxRuleList = {d[t] -> e[4]}\), ";", 
      RowBox[{"deList", "=", 
        RowBox[{
        \({n[1] e[2]\[Wedge]e[3], n[2] e[3]\[Wedge]e[1], 
            n[3] e[1]\[Wedge]e[2], 0}\), 
          StyleBox["/.",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[\(n[_] -> \(-1\)\),
            FontColor->RGBColor[1, 0, 0]]}]}], ";"}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[
      g /. {A[t] -> 1 + t^2, B[t] -> 1 + t^2, 
          C[t] -> 4 \((1 + 2  a\ t - t^2)\)/\((1 + t^2)\), 
          F[t] -> \((1 + t^2)\)/\((1 + 2  a\ t - t^2)\)}, xCoord, {e[]}]\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(\(-1\) - t\^2\), "0", "0", "0"},
                {"0", \(\(-1\) - t\^2\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(4\ \((1 + 2\ a\ t - t\^2)\)\)\/\(1 + t\^2\)\)\), 
                  "0"},
                {"0", "0", "0", \(\(1 + t\^2\)\/\(1 + 2\ a\ t - t\^2\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ -1, 
            Times[ -1, 
              Power[ t, 2]]], 0, 0, 0}, {0, 
          Plus[ -1, 
            Times[ -1, 
              Power[ t, 2]]], 0, 0}, {0, 0, 
          Times[ -4, 
            Plus[ 1, 
              Times[ 2, a, t], 
              Times[ -1, 
                Power[ t, 2]]], 
            Power[ 
              Plus[ 1, 
                Power[ t, 2]], -1]], 0}, {0, 0, 0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ 2, a, t], 
                Times[ -1, 
                  Power[ t, 2]]], -1], 
            Plus[ 1, 
              Power[ t, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\((\(-1\) - t\^2)\)\ e[1]\^2 + \((\(-1\) - t\^2)\)\ e[2]\^2 - 
            \(4\ \((1 + 2\ a\ t - t\^2)\)\ e[3]\^2\)\/\(1 + t\^2\) + 
            \(\((1 + t\^2)\)\ e[4]\^2\)\/\(1 + 2\ a\ t - t\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Plus[ -1, 
                Times[ -1, 
                  Power[ t, 2]]], 
              Power[ 
                e[ 1], 2]], 
            Times[ 
              Plus[ -1, 
                Times[ -1, 
                  Power[ t, 2]]], 
              Power[ 
                e[ 2], 2]], 
            Times[ -4, 
              Plus[ 1, 
                Times[ 2, a, t], 
                Times[ -1, 
                  Power[ t, 2]]], 
              Power[ 
                Plus[ 1, 
                  Power[ t, 2]], -1], 
              Power[ 
                e[ 3], 2]], 
            Times[ 
              Power[ 
                Plus[ 1, 
                  Times[ 2, a, t], 
                  Times[ -1, 
                    Power[ t, 2]]], -1], 
              Plus[ 1, 
                Power[ t, 2]], 
              Power[ 
                e[ 4], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-\(1\/\(1 + t\^2\)\)\), "0", "0", "0"},
                {"0", \(-\(1\/\(1 + t\^2\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(1 + t\^2\)\/\(4\ \((1 + 2\ a\ t - t\^2)\)\)\)\), 
                  "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(\(-1\) - 2\ a\ t + t\^2\)\/\(1 + t\^2\)\)\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Power[ t, 2]], -1]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Power[ t, 2]], -1]], 0, 0}, {0, 0, 
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Plus[ 1, 
                Times[ 2, a, t], 
                Times[ -1, 
                  Power[ t, 2]]], -1], 
            Plus[ 1, 
              Power[ t, 2]]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Power[ t, 2]], -1], 
            Plus[ -1, 
              Times[ -2, a, t], 
              Power[ t, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0500000000000682121`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Warning: d[] on some symbols not defined!"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \({\(t\ d[a]\)\/\(1 + t\^2\), 
      \(t\ \((1 + t\^2)\)\ d[a]\)\/\((\(-1\) - 2\ a\ t + t\^2)\)\^2}\)], 
  "Print"],

Cell[BoxData[
    \("deList closure verified"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0500000000000682121`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0666666666667197205`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.416667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[0]] // Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({2.80000000000006821`\ Second, True}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Kasner (Bianchi type I)", "Subsection",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    RowBox[{\(d[u] = 0\), ";", 
      RowBox[{"(*", 
        RowBox[{"*", " ", 
          StyleBox["u",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["is",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["a",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["constant",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["parameter",
            FontColor->RGBColor[0, 0, 1]]}], " ", "**)"}], 
      \(dxRuleList = {d[t] -> e[4]}\), ";", "\n", 
      RowBox[{"deList", "=", 
        RowBox[{
        \({n[1] e[2]\[Wedge]e[3], n[2] e[3]\[Wedge]e[1], 
            n[3] e[1]\[Wedge]e[2], 0}\), 
          StyleBox["/.",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[\(n[_] -> 0\),
            FontColor->RGBColor[1, 0, 0]]}]}], ";"}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[
      g /. {F[t] -> 1, A[t] -> t^\((\(-2\) u/\((1 + u + u^2)\))\), 
          B[t] -> t^\((2 \((1 + u)\)/\((1 + u + u^2)\))\), 
          C[t] -> t^\((2  u \((1 + u)\)/\((1 + u + u^2)\))\)}, xCoord, {e[]}]
      \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-t\^\(-\(\(2\ u\)\/\(1 + u + u\^2\)\)\)\), "0", "0", "0"},
               
                 {"0", \(-t\^\(\(2\ \((1 + u)\)\)\/\(1 + u + u\^2\)\)\), "0", 
                  "0"},
               
                 {"0", "0", 
                  \(-t\^\(\(2\ u\ \((1 + u)\)\)\/\(1 + u + u\^2\)\)\), "0"},
                {"0", "0", "0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ t, 
              Times[ -2, u, 
                Power[ 
                  Plus[ 1, u, 
                    Power[ u, 2]], -1]]]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ t, 
              Times[ 2, 
                Plus[ 1, u], 
                Power[ 
                  Plus[ 1, u, 
                    Power[ u, 2]], -1]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ t, 
              Times[ 2, u, 
                Plus[ 1, u], 
                Power[ 
                  Plus[ 1, u, 
                    Power[ u, 2]], -1]]]], 0}, {0, 0, 0, 1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\( - t\^\(-\(\(2\ u\)\/\(1 + u + u\^2\)\)\)\)\ e[1]\^2 - 
            t\^\(2\/\(1 + u + u\^2\) + \(2\ u\)\/\(1 + u + u\^2\)\)\ 
              e[2]\^2 - 
            t\^\(\(2\ u\ \((1 + u)\)\)\/\(1 + u + u\^2\)\)\ e[3]\^2 + 
            e[4]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ t, 
                Times[ -2, u, 
                  Power[ 
                    Plus[ 1, u, 
                      Power[ u, 2]], -1]]], 
              Power[ 
                e[ 1], 2]], 
            Times[ -1, 
              Power[ t, 
                Plus[ 
                  Times[ 2, 
                    Power[ 
                      Plus[ 1, u, 
                        Power[ u, 2]], -1]], 
                  Times[ 2, u, 
                    Power[ 
                      Plus[ 1, u, 
                        Power[ u, 2]], -1]]]], 
              Power[ 
                e[ 2], 2]], 
            Times[ -1, 
              Power[ t, 
                Times[ 2, u, 
                  Plus[ 1, u], 
                  Power[ 
                    Plus[ 1, u, 
                      Power[ u, 2]], -1]]], 
              Power[ 
                e[ 3], 2]], 
            Power[ 
              e[ 4], 2]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {\(-t\^\(\(2\ u\)\/\(1 + u + u\^2\)\)\), "0", "0", "0"},
               
                 {"0", \(-
                    t\^\(\(-\(2\/\(1 + u + u\^2\)\)\) - 
                        \(2\ u\)\/\(1 + u + u\^2\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-t\^\(-\(\(2\ u\ \((1 + u)\)\)\/\(1 + u + u\^2\)\)\)\), 
                  "0"},
                {"0", "0", "0", "1"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ t, 
              Times[ 2, u, 
                Power[ 
                  Plus[ 1, u, 
                    Power[ u, 2]], -1]]]], 0, 0, 0}, {0, 
          Times[ -1, 
            Power[ t, 
              Plus[ 
                Times[ -2, 
                  Power[ 
                    Plus[ 1, u, 
                      Power[ u, 2]], -1]], 
                Times[ -2, u, 
                  Power[ 
                    Plus[ 1, u, 
                      Power[ u, 2]], -1]]]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ t, 
              Times[ -2, u, 
                Plus[ 1, u], 
                Power[ 
                  Plus[ 1, u, 
                    Power[ u, 2]], -1]]]], 0}, {0, 0, 0, 1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("deList closure verified"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0500000000000682121`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.333333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Bianchi[1]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx; Clear[n, g]; d[u] =. ; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]]
}, Closed]],

Cell["\tSee also Example 12 in Section 6.", "Text",
  FontSize->16]
}, Closed]]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 6  Approximations - Series Expansions",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Series[f,{x,x0,n}]",
    FontFamily->"Courier"],
  ", which gives the series expansion of the function ",
  StyleBox["f",
    FontFamily->"Courier"],
  " around ",
  StyleBox["x0",
    FontFamily->"Courier"],
  " up to order ",
  StyleBox["n",
    FontFamily->"Courier"],
  ", can be applied to lists, and thus to tensors. ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " and the other functions defined in this package can handle ",
  StyleBox["SeriesData",
    FontFamily->"Courier"],
  " objects as input data -- ",
  StyleBox["gIN",
    FontFamily->"Courier"],
  " (metric) and ",
  StyleBox["eIN",
    FontFamily->"Courier"],
  " (coframe) --  and thus allow approximate calculations (perturbations of a \
given solution, asymptotic expansion of the metric or the coframe, etc.).\n\n\
",
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThere are several points, however, that must be kept in mind in doing \
calculations with series: "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "  6.1  Be aware of how your version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " handles series"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t There are significant differences in the way different versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " handle series. Under ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0, algebraically equivalent expressions do not have identical series \
approximations at infinity (this problem does not arise in version 4.0 or \
higher):"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Series[1 - 2  m/r + a^2/r^2, {r, #, 2}]&\)/@{0, Infinity}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{\(a\^2\/r\^2\), "-", \(\(2\ m\)\/r\), "+", "1", "+", 
            InterpretationBox[\(O[r]\^3\),
              SeriesData[ r, 0, {}, -2, 3, 1]]}],
          SeriesData[ r, 0, {
            Power[ a, 2], 
            Times[ -2, m], 1}, -2, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{
          "1", "-", \(\(2\ m\)\/r\), "+", \(a\^2\ \((1\/r)\)\^2\), "+", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 0, 3, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ -2, m], 
            Power[ a, 2]}, 0, 3, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Series[\((r - 2  m + a^2/r)\)/r, {r, #, 2}]&\)/@{0, Infinity}\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{\(a\^2\/r\^2\), "-", \(\(2\ m\)\/r\), "+", "1", "+", 
            InterpretationBox[\(O[r]\^3\),
              SeriesData[ r, 0, {}, -2, 3, 1]]}],
          SeriesData[ r, 0, {
            Power[ a, 2], 
            Times[ -2, m], 1}, -2, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{"1", "-", \(\(2\ m\)\/r\), "+", 
            InterpretationBox[\(O[1\/r]\^2\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 0, 2, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ -2, m]}, 0, 2, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Series[\((r^2 - 2  m\ r + a^2)\)/r^2, {r, #, 2}]&\)/@{0, Infinity}\)],
   "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{\(a\^2\/r\^2\), "-", \(\(2\ m\)\/r\), "+", "1", "+", 
            InterpretationBox[\(O[r]\^3\),
              SeriesData[ r, 0, {}, -2, 3, 1]]}],
          SeriesData[ r, 0, {
            Power[ a, 2], 
            Times[ -2, m], 1}, -2, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{"1", "+", 
            InterpretationBox[\(O[1\/r]\^1\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 0, 1, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {1}, 0, 1, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tAs a consequence, with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0, calculations with such expansions may not have the correct accuracy \
-- see Example 12 below. "
}], "Text",
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tRGTC corrects some of the notorious bugs of SeriesData objects  in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 and 4. For example, ",
  StyleBox["before evaluating EDCRGTCcode",
    FontSlant->"Italic"],
  ", multiplication of a series by zero gives a non-zero result"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(0*Series[1 + a\ x + b\ x^2, {x, 0, 2}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\(O[x]\^3\),
      SeriesData[ x, 0, {}, 3, 3, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions 5 or higher correct this and other problems, but cannot handle \
substitutions of series expressions in the coefficients of a series, a \
situation that arises in local frame transformations. For example, given a \
series"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(ser1 = Series[Sum[c[k] x^k, {k, 4}], {x, 0, 4}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(c[1]\ x\), "+", \(c[2]\ x\^2\), "+", \(c[3]\ x\^3\), "+", 
        \(c[4]\ x\^4\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 1, 5, 1]]}],
      SeriesData[ x, 0, {
        c[ 1], 
        c[ 2], 
        c[ 3], 
        c[ 4]}, 1, 5, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "suppose one needs to substitute new ",
  StyleBox["series expansions",
    FontSlant->"Italic"],
  " for the coefficients:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(serRules
       = {c[k_] \[RuleDelayed] 
          Series[Sum[b[m, k]/x^m, {m, \(-2\), 2}], {x, 0, 4}]}\)], "Input"],

Cell[BoxData[
    \({c[k_] \[RuleDelayed] 
        Series[\[Sum]\+\(m = \(-2\)\)\%2 b[m, k]\/x\^m, {x, 0, 4}]}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(c[1] /. serRules\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(b[2, 1]\/x\^2\), "+", \(b[1, 1]\/x\), "+", \(b[0, 1]\), "+", 
        \(b[\(-1\), 1]\ x\), "+", \(b[\(-2\), 1]\ x\^2\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, -2, 5, 1]]}],
      SeriesData[ x, 0, {
        b[ 2, 1], 
        b[ 1, 1], 
        b[ 0, 1], 
        b[ -1, 1], 
        b[ -2, 1]}, -2, 5, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " leaves such expressions unevaluated:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[ser1 /. serRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{
              \(b[2, 1]\/x\^2\), "+", \(b[1, 1]\/x\), "+", \(b[0, 1]\), "+", 
                \(b[\(-1\), 1]\ x\), "+", \(b[\(-2\), 1]\ x\^2\), "+", 
                InterpretationBox[\(O[x]\^5\),
                  SeriesData[ x, 0, {}, -2, 5, 1]]}],
              SeriesData[ x, 0, {
                b[ 2, 1], 
                b[ 1, 1], 
                b[ 0, 1], 
                b[ -1, 1], 
                b[ -2, 1]}, -2, 5, 1]], ")"}], " ", "x"}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{
              \(b[2, 2]\/x\^2\), "+", \(b[1, 2]\/x\), "+", \(b[0, 2]\), "+", 
                \(b[\(-1\), 2]\ x\), "+", \(b[\(-2\), 2]\ x\^2\), "+", 
                InterpretationBox[\(O[x]\^5\),
                  SeriesData[ x, 0, {}, -2, 5, 1]]}],
              SeriesData[ x, 0, {
                b[ 2, 2], 
                b[ 1, 2], 
                b[ 0, 2], 
                b[ -1, 2], 
                b[ -2, 2]}, -2, 5, 1]], ")"}], " ", \(x\^2\)}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{
              \(b[2, 3]\/x\^2\), "+", \(b[1, 3]\/x\), "+", \(b[0, 3]\), "+", 
                \(b[\(-1\), 3]\ x\), "+", \(b[\(-2\), 3]\ x\^2\), "+", 
                InterpretationBox[\(O[x]\^5\),
                  SeriesData[ x, 0, {}, -2, 5, 1]]}],
              SeriesData[ x, 0, {
                b[ 2, 3], 
                b[ 1, 3], 
                b[ 0, 3], 
                b[ -1, 3], 
                b[ -2, 3]}, -2, 5, 1]], ")"}], " ", \(x\^3\)}], "+", 
        RowBox[{
          RowBox[{"(", 
            InterpretationBox[
              RowBox[{
              \(b[2, 4]\/x\^2\), "+", \(b[1, 4]\/x\), "+", \(b[0, 4]\), "+", 
                \(b[\(-1\), 4]\ x\), "+", \(b[\(-2\), 4]\ x\^2\), "+", 
                InterpretationBox[\(O[x]\^5\),
                  SeriesData[ x, 0, {}, -2, 5, 1]]}],
              SeriesData[ x, 0, {
                b[ 2, 4], 
                b[ 1, 4], 
                b[ 0, 4], 
                b[ -1, 4], 
                b[ -2, 4]}, -2, 5, 1]], ")"}], " ", \(x\^4\)}], "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, 1, 5, 1]]}],
      SeriesData[ x, 0, {
        SeriesData[ x, 0, {
          b[ 2, 1], 
          b[ 1, 1], 
          b[ 0, 1], 
          b[ -1, 1], 
          b[ -2, 1]}, -2, 5, 1], 
        SeriesData[ x, 0, {
          b[ 2, 2], 
          b[ 1, 2], 
          b[ 0, 2], 
          b[ -1, 2], 
          b[ -2, 2]}, -2, 5, 1], 
        SeriesData[ x, 0, {
          b[ 2, 3], 
          b[ 1, 3], 
          b[ 0, 3], 
          b[ -1, 3], 
          b[ -2, 3]}, -2, 5, 1], 
        SeriesData[ x, 0, {
          b[ 2, 4], 
          b[ 1, 4], 
          b[ 0, 4], 
          b[ -1, 4], 
          b[ -2, 4]}, -2, 5, 1]}, 1, 5, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "RGTC enables Series to handle such expressions. Thus, ",
  StyleBox["after evaluating EDCRGTCcode",
    FontSlant->"Italic"],
  ", one gets:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[ser1 /. serRules]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(b[2, 1]\/x\), "+", \((b[1, 1] + b[2, 2])\), "+", 
        \(\((b[0, 1] + b[1, 2] + b[2, 3])\)\ x\), "+", 
        \(\((b[\(-1\), 1] + b[0, 2] + b[1, 3] + b[2, 4])\)\ x\^2\), "+", 
        \(\((b[\(-2\), 1] + b[\(-1\), 2] + b[0, 3] + b[1, 4])\)\ x\^3\), "+", 
        \(\((b[\(-2\), 2] + b[\(-1\), 3] + b[0, 4])\)\ x\^4\), "+", 
        InterpretationBox[\(O[x]\^5\),
          SeriesData[ x, 0, {}, -1, 5, 1]]}],
      SeriesData[ x, 0, {
        b[ 2, 1], 
        Plus[ 
          b[ 1, 1], 
          b[ 2, 2]], 
        Plus[ 
          b[ 0, 1], 
          b[ 1, 2], 
          b[ 2, 3]], 
        Plus[ 
          b[ -1, 1], 
          b[ 0, 2], 
          b[ 1, 3], 
          b[ 2, 4]], 
        Plus[ 
          b[ -2, 1], 
          b[ -1, 2], 
          b[ 0, 3], 
          b[ 1, 4]], 
        Plus[ 
          b[ -2, 2], 
          b[ -1, 3], 
          b[ 0, 4]]}, -1, 5, 1]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "\tAlso ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions 5 or higher are considerably slower in handling series \
expressions. In some cases, they can be more than 10 ",
  StyleBox["times",
    FontSlant->"Italic"],
  " slower compared to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4 (substitution of series expansions in complicated expressions -- see \
alternate ways to verify the Tomimatsu-Sato solutions,  ",
  StyleBox["TS123AltEV.nb",
    FontWeight->"Bold"],
  ",  in ",
  ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
  ".). The time taken to complete all calculations in this section differ \
significantly between versions:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    RowBox[{"\t\t", 
      RowBox[{
        StyleBox[GridBox[{
              {"MathematicaVersion", "3", "4", "5", "6", "7", "8"},
              {\(Time \((sec)\)\), "11", "13", "21", "18", "18", "21"}
              },
            RowLines->True,
            ColumnLines->True],
          FontWeight->"Bold"], 
        StyleBox[";",
          FontColor->GrayLevel[1]], 
        StyleBox[
          RowBox[{"On", "[", 
            RowBox[{
              StyleBox["General",
                FontColor->GrayLevel[1]], "::", 
              StyleBox[\("spell1"\),
                FontColor->GrayLevel[1]]}], "]"}],
          FontColor->GrayLevel[1]], 
        StyleBox[";",
          FontColor->GrayLevel[1]]}]}]], "Text"]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe slower times in later versions is probably due to the fact that \
newer ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions keep terms to higher order than ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 or 4. For the examples in the next two subsections, the results (",
  StyleBox["Rdd",
    FontFamily->"Courier"],
  ", ",
  StyleBox["LineElement",
    FontFamily->"Courier"],
  ") are identical between versions 3 and 4, and between all versions 5 or \
higher. However, the version 5 or higher results are given to higher order \
(at least for some tensor components) than those of version 4. Thus, for a \
given required accuracy in the result (Rdd), lower order expansions of the \
metric are needed in later versions."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell["  6.2  Series expansion of the metric and /or coframe", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tLet us consider a metric depending on a parameter b, which reduces to \
Schwarzschild when b=0:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(xCoord = {t, r, \[Theta], \[CurlyPhi]}; simpRules = TrigRules; \)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(A[r] = 1 - 2  m\ \ r/\((r^2 - b^2)\); B[r] = Exp[2  b/r]; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gPERT = 
      DiagonalMatrix[{A[r], \(-1\)/A[r], \(-r^2\)/B[r], 
          \(-r^2\) B[r] Sin[\[Theta]]^2}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\), 0, 0, 0}, {0, 
        \(-\(1\/\(1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\)\)\)\), 0, 0}, {0, 0, 
        \(-E\^\(-\(\(2\ b\)\/r\)\)\)\ r\^2, 0}, {0, 0, 0, 
        \(-E\^\(\(2\ b\)\/r\)\)\ r\^2\ Sin[\[Theta]]\^2}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "We can use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["Series",
    FontWeight->"Bold"],
  " to find its series expansion around b=0 to any order:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(gSERb0[n_] := FacSimp[Series[gPERT, {b, 0, n}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gSERb0[3]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ m - r\)\/r\)\), "-", \(\(2\ m\ b\^2\)\/r\^3\), "+", 
                InterpretationBox[\(O[b]\^4\),
                  SeriesData[ b, 0, {}, 0, 4, 1]]}],
              SeriesData[ b, 0, {
                Times[ -1, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -1]], 0, 
                Times[ -2, m, 
                  Power[ r, -3]]}, 0, 4, 1]], ",", "0", ",", "0", ",", "0"}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[
              RowBox[{
              \(r\/\(2\ m - r\)\), "-", 
                \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "+", 
                InterpretationBox[\(O[b]\^4\),
                  SeriesData[ b, 0, {}, 0, 4, 1]]}],
              SeriesData[ b, 0, {
                Times[ 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], r], 0, 
                Times[ -2, m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -1]]}, 0, 4, 1]], ",", "0", ",", "0"}], "}"}], 
        ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
            InterpretationBox[
              RowBox[{
              \(-r\^2\), "+", \(2\ r\ b\), "-", \(2\ b\^2\), "+", 
                \(\(4\ b\^3\)\/\(3\ r\)\), "+", 
                InterpretationBox[\(O[b]\^4\),
                  SeriesData[ b, 0, {}, 0, 4, 1]]}],
              SeriesData[ b, 0, {
                Times[ -1, 
                  Power[ r, 2]], 
                Times[ 2, r], -2, 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ r, -1]]}, 0, 4, 1]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
            InterpretationBox[
              RowBox[{
              \(-\(r\^2\ Sin[\[Theta]]\^2\)\), "-", 
                \(2\ \((r\ Sin[\[Theta]]\^2)\)\ b\), "-", 
                \(2\ Sin[\[Theta]]\^2\ b\^2\), "-", 
                \(\(4\ Sin[\[Theta]]\^2\ b\^3\)\/\(3\ r\)\), "+", 
                InterpretationBox[\(O[b]\^4\),
                  SeriesData[ b, 0, {}, 0, 4, 1]]}],
              SeriesData[ b, 0, {
                Times[ -1, 
                  Power[ r, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ -2, r, 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ r, -1], 
                  Power[ 
                    Sin[ \[Theta]], 2]]}, 0, 4, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "Using this series expansion for the metric in ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " results in all tensor components being computed as series expansions to \
the appropriate order:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 10a: Expansion of a \"perturbed \
Schwarzschild\" metric around b=0"], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gSERb0[4], xCoord]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    \(-\(\(2\ m - r\)\/r\)\), "-", \(\(2\ m\ b\^2\)\/r\^3\), 
                      "-", \(\(2\ m\ b\^4\)\/r\^5\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Plus[ 
                          Times[ 2, m], 
                          Times[ -1, r]], 
                        Power[ r, -1]], 0, 
                      Times[ -2, m, 
                        Power[ r, -3]], 0, 
                      Times[ -2, m, 
                        Power[ r, -5]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(r\/\(2\ m - r\)\), "-", 
                      \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "+", 
                      \(\(2\ m\ b\^4\)\/\(\((2\ m - r)\)\^3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -1], r], 0, 
                      Times[ -2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -2], 
                        Power[ r, -1]], 0, 
                      Times[ 2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -3], 
                        Power[ r, -2]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-r\^2\), "+", \(2\ r\ b\), "-", \(2\ b\^2\), "+", 
                      \(\(4\ b\^3\)\/\(3\ r\)\), "-", 
                      \(\(2\ b\^4\)\/\(3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ r, 2]], 
                      Times[ 2, r], -2, 
                      Times[ 
                        Rational[ 4, 3], 
                        Power[ r, -1]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ r, -2]]}, 0, 5, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(r\^2\ Sin[\[Theta]]\^2\)\), "-", 
                      \(2\ \((r\ Sin[\[Theta]]\^2)\)\ b\), "-", 
                      \(2\ Sin[\[Theta]]\^2\ b\^2\), "-", 
                      \(\(4\ Sin[\[Theta]]\^2\ b\^3\)\/\(3\ r\)\), "-", 
                      \(\(2\ Sin[\[Theta]]\^2\ b\^4\)\/\(3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ r, 2], 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ -2, r, 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ -2, 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -4, 3], 
                        Power[ r, -1], 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ r, -2], 
                        Power[ 
                          Sin[ \[Theta]], 2]]}, 0, 5, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          SeriesData[ b, 0, {
            Times[ -1, 
              Plus[ 
                Times[ 2, m], 
                Times[ -1, r]], 
              Power[ r, -1]], 0, 
            Times[ -2, m, 
              Power[ r, -3]], 0, 
            Times[ -2, m, 
              Power[ r, -5]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ b, 0, {
            Times[ 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -1], r], 0, 
            Times[ -2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -2], 
              Power[ r, -1]], 0, 
            Times[ 2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -3], 
              Power[ r, -2]]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ r, 2]], 
            Times[ 2, r], -2, 
            Times[ 
              Rational[ 4, 3], 
              Power[ r, -1]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ r, -2]]}, 0, 5, 1], 0}, {0, 0, 0, 
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ r, 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ -2, r, 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ -2, 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 
              Rational[ -4, 3], 
              Power[ r, -1], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ r, -2], 
              Power[ 
                Sin[ \[Theta]], 2]]}, 0, 5, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \((\(r\ d[r]\^2\)\/\(2\ m - r\) + 
                \(\((\(-2\)\ m + r)\)\ d[t]\^2\)\/r - r\^2\ d[\[Theta]]\^2 - 
                r\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\((2\ r\ d[\[Theta]]\^2 - 
                    2\ r\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ b\), "+", 
              \(\((\(-\(\(2\ m\ d[r]\^2\)\/\(\((2\ m - r)\)\^2\ r\)\)\) - 
                    \(2\ m\ d[t]\^2\)\/r\^3 - 2\ d[\[Theta]]\^2 - 
                    2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ b\^2\), "+", 
              \(\((\(4\ d[\[Theta]]\^2\)\/\(3\ r\) - 
                    \(4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(3\ r\))\)\ 
                b\^3\), "+", 
              \(\((\(2\ m\ d[r]\^2\)\/\(\((2\ m - r)\)\^3\ r\^2\) - 
                    \(2\ m\ d[t]\^2\)\/r\^5 - 
                    \(2\ d[\[Theta]]\^2\)\/\(3\ r\^2\) - 
                    \(2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(3\ r\^2\))
                  \)\ b\^4\), "+", 
              InterpretationBox[\(O[b]\^5\),
                SeriesData[ b, 0, {}, 0, 5, 1]]}],
            SeriesData[ b, 0, {
              Plus[ 
                Times[ 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], r, 
                  Power[ 
                    d[ r], 2]], 
                Times[ 
                  Power[ r, -1], 
                  Plus[ 
                    Times[ -2, m], r], 
                  Power[ 
                    d[ t], 2]], 
                Times[ -1, 
                  Power[ r, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ r, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, r, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, r, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -1], 
                  Power[ 
                    d[ r], 2]], 
                Times[ -2, m, 
                  Power[ r, -3], 
                  Power[ 
                    d[ t], 2]], 
                Times[ -2, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ r, -1], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ r, -1], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -3], 
                  Power[ r, -2], 
                  Power[ 
                    d[ r], 2]], 
                Times[ -2, m, 
                  Power[ r, -5], 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ r, -2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ r, -2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, 0, 5, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ b, 0, {
            Plus[ 
              Times[ 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -1], r, 
                Power[ 
                  d[ r], 2]], 
              Times[ 
                Power[ r, -1], 
                Plus[ 
                  Times[ -2, m], r], 
                Power[ 
                  d[ t], 2]], 
              Times[ -1, 
                Power[ r, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ r, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, r, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, r, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, m, 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -2], 
                Power[ r, -1], 
                Power[ 
                  d[ r], 2]], 
              Times[ -2, m, 
                Power[ r, -3], 
                Power[ 
                  d[ t], 2]], 
              Times[ -2, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 
                Rational[ 4, 3], 
                Power[ r, -1], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ r, -1], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, m, 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -3], 
                Power[ r, -2], 
                Power[ 
                  d[ r], 2]], 
              Times[ -2, m, 
                Power[ r, -5], 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ r, -2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ r, -2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, 0, 5, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    \(-\(r\/\(2\ m - r\)\)\), "+", 
                      \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "-", 
                      \(\(2\ m\ b\^4\)\/\(\((2\ m - r)\)\^3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -1], r], 0, 
                      Times[ 2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -2], 
                        Power[ r, -1]], 0, 
                      Times[ -2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -3], 
                        Power[ r, -2]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(\(2\ m - r\)\/r\), "+", \(\(2\ m\ b\^2\)\/r\^3\), "+", 
                      \(\(2\ m\ b\^4\)\/r\^5\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ 
                        Plus[ 
                          Times[ 2, m], 
                          Times[ -1, r]], 
                        Power[ r, -1]], 0, 
                      Times[ 2, m, 
                        Power[ r, -3]], 0, 
                      Times[ 2, m, 
                        Power[ r, -5]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(1\/r\^2\)\), "-", \(\(2\ b\)\/r\^3\), "-", 
                      \(\(2\ b\^2\)\/r\^4\), "-", 
                      \(\(4\ b\^3\)\/\(3\ r\^5\)\), "-", 
                      \(\(2\ b\^4\)\/\(3\ r\^6\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ r, -2]], 
                      Times[ -2, 
                        Power[ r, -3]], 
                      Times[ -2, 
                        Power[ r, -4]], 
                      Times[ 
                        Rational[ -4, 3], 
                        Power[ r, -5]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ r, -6]]}, 0, 5, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(Csc[\[Theta]]\^2\/r\^2\)\), "+", 
                      \(\(2\ Csc[\[Theta]]\^2\ b\)\/r\^3\), "-", 
                      \(\(2\ Csc[\[Theta]]\^2\ b\^2\)\/r\^4\), "+", 
                      \(\(4\ Csc[\[Theta]]\^2\ b\^3\)\/\(3\ r\^5\)\), "-", 
                      \(\(2\ Csc[\[Theta]]\^2\ b\^4\)\/\(3\ r\^6\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ r, -2], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 2, 
                        Power[ r, -3], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ -2, 
                        Power[ r, -4], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ 4, 3], 
                        Power[ r, -5], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ r, -6], 
                        Power[ 
                          Csc[ \[Theta]], 2]]}, 0, 5, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -1], r], 0, 
            Times[ 2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -2], 
              Power[ r, -1]], 0, 
            Times[ -2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -3], 
              Power[ r, -2]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ b, 0, {
            Times[ 
              Plus[ 
                Times[ 2, m], 
                Times[ -1, r]], 
              Power[ r, -1]], 0, 
            Times[ 2, m, 
              Power[ r, -3]], 0, 
            Times[ 2, m, 
              Power[ r, -5]]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ r, -2]], 
            Times[ -2, 
              Power[ r, -3]], 
            Times[ -2, 
              Power[ r, -4]], 
            Times[ 
              Rational[ -4, 3], 
              Power[ r, -5]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ r, -6]]}, 0, 5, 1], 0}, {0, 0, 0, 
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ r, -2], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 2, 
              Power[ r, -3], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ -2, 
              Power[ r, -4], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 
              Rational[ 4, 3], 
              Power[ r, -5], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ r, -6], 
              Power[ 
                Csc[ \[Theta]], 2]]}, 0, 5, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.149999999999977262`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.14999999999997726, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0833333333333712289`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.133333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.13333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.233333333333348491`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.23333333333334849, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.399999999999977262`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.39999999999997726, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.21667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              \(\(6\ m\ \((2\ m - r)\)\ b\^2\)\/r\^6\), "+", 
                \(\(4\ m\ \((13\ m - 5\ r)\)\ b\^4\)\/r\^8\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 2, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 6, m, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -6]], 0, 
                Times[ 4, m, 
                  Plus[ 
                    Times[ 13, m], 
                    Times[ -5, r]], 
                  Power[ r, -8]]}, 2, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ \((5\ m - r)\)\ b\^2\)\/\(\((2\ m - r)\)\ r\^4\)\)\), 
                "-", \(\(4\ \((m\ \((7\ m - 5\ r)\))\)\ 
                      b\^4\)\/\(\((2\ m - r)\)\^2\ r\^6\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 2, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ -2, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], 
                  Plus[ 
                    Times[ 5, m], 
                    Times[ -1, r]], 
                  Power[ r, -4]], 0, 
                Times[ -4, m, 
                  Plus[ 
                    Times[ 7, m], 
                    Times[ -5, r]], 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -6]]}, 2, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(\(2\ Cot[\[Theta]]\ b\)\/r\^2\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -2], 
                  Cot[ \[Theta]]]}, 1, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(\(2\ Cot[\[Theta]]\ b\)\/r\^2\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -2], 
                  Cot[ \[Theta]]]}, 1, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ \((m - r)\)\ b\)\/r\^2\)\), "-", 
                \(\(2\ b\^2\)\/r\^2\), "-", 
                \(\(2\ \((3\ m - 2\ r)\)\ b\^3\)\/\(3\ r\^4\)\), "-", 
                \(\(2\ \((2\ m + r)\)\ b\^4\)\/\(3\ r\^5\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ -2, 
                  Plus[ m, 
                    Times[ -1, r]], 
                  Power[ r, -2]], 
                Times[ -2, 
                  Power[ r, -2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Plus[ 
                    Times[ 3, m], 
                    Times[ -2, r]], 
                  Power[ r, -4]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ r, -5], 
                  Plus[ 
                    Times[ 2, m], r]]}, 1, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ \((m + r)\)\ Sin[\[Theta]]\^2\ b\)\/r\^2\), "+", 
                \(\(6\ Sin[\[Theta]]\^2\ b\^2\)\/r\^2\), "+", 
                \(\(2\ \((3\ m + 14\ r)\)\ Sin[\[Theta]]\^2\ b\^3\)\/\(3\ 
                      r\^4\)\), "-", 
                \(\(2\ \((\((2\ m - 15\ r)\)\ Sin[\[Theta]]\^2)\)\ b\^4\)\/\(3
                      \ r\^5\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -2], 
                  Plus[ m, r], 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 6, 
                  Power[ r, -2], 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 
                  Rational[ 2, 3], 
                  Power[ r, -4], 
                  Plus[ 
                    Times[ 3, m], 
                    Times[ 14, r]], 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -15, r]], 
                  Power[ r, -5], 
                  Power[ 
                    Sin[ \[Theta]], 2]]}, 1, 5, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. b \[Rule] 0\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe expansion parameter b has been set equal to a constant by \
RGtensors:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d[b]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell["", "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->10],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tOne can also expand the metric with respect to one of the coordinates to \
examine the geometry near a hypersurface. In this case the notation ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  " for the differential of that coordinate cannot be used because ",
  StyleBox["Series",
    FontFamily->"Courier"],
  " will consider ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  " a function of ",
  StyleBox["x",
    FontFamily->"Courier"],
  " and formally expand it (using ",
  StyleBox["d[0]=0",
    FontFamily->"Courier"],
  "):"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[d[x]/\((1 - x)\), {x, 0, 2}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SuperscriptBox["d", "\[Prime]",
              MultilineFunction->None], "[", "0", "]"}], " ", "x"}], "+", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                SuperscriptBox["d", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "+", 
              FractionBox[
                RowBox[{
                  SuperscriptBox["d", "\[DoublePrime]",
                    MultilineFunction->None], "[", "0", "]"}], "2"]}], ")"}], 
          " ", \(x\^2\)}], "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 1, 3, 1]]}],
      SeriesData[ x, 0, {
        Derivative[ 1][ d][ 0], 
        Plus[ 
          Derivative[ 1][ d][ 0], 
          Times[ 
            Rational[ 1, 2], 
            Derivative[ 2][ d][ 0]]]}, 1, 3, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  " When such an expansion of the metric w.r.t. a coordinate is used in the \
default coordinate frame, ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " will automatically introduce the notation ",
  StyleBox["dx",
    FontFamily->"Courier"],
  " for ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  ". The symbol ",
  StyleBox["dx",
    FontFamily->"Courier"],
  " will then be treated correctly as a closed 1-form. The user can still \
input ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  "."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 10b: Expansion of a \"perturbed \
Schwarzschild\" metric as r\[RightArrow]\[Infinity]"], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(gSERrInf[n_] := FacSimp[Series[gPERT, {r, Infinity, n}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gSERrInf[3]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              "1", "-", \(\(2\ m\)\/r\), "-", 
                \(2\ \((b\^2\ m)\)\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 0, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {1, 
                Times[ -2, m], 0, 
                Times[ -2, 
                  Power[ b, 2], m]}, 0, 4, 1]], ",", "0", ",", "0", ",", 
            "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[
              RowBox[{
              \(-1\), "-", \(\(2\ m\)\/r\), "-", \(4\ m\^2\ \((1\/r)\)\^2\), 
                "-", \(2\ \((m\ \((b\^2 + 4\ m\^2)\))\)\ \((1\/r)\)\^3\), "+",
                 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 0, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {-1, 
                Times[ -2, m], 
                Times[ -4, 
                  Power[ m, 2]], 
                Times[ -2, m, 
                  Plus[ 
                    Power[ b, 2], 
                    Times[ 4, 
                      Power[ m, 2]]]]}, 0, 4, 1]], ",", "0", ",", "0"}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
            InterpretationBox[
              RowBox[{
              \(-\(1\/\((1\/r)\)\^2\)\), "+", \(\(2\ b\)\/\(1\/r\)\), "-", 
                \(2\ b\^2\), "+", \(\(4\ b\^3\)\/\(3\ r\)\), "+", 
                InterpretationBox[\(O[1\/r]\^2\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, -2, 2, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {-1, 
                Times[ 2, b], 
                Times[ -2, 
                  Power[ b, 2]], 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ b, 3]]}, -2, 2, 1]], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
            InterpretationBox[
              RowBox[{
              \(-\(Sin[\[Theta]]\^2\/\((1\/r)\)\^2\)\), "-", 
                \(\(2\ \((b\ Sin[\[Theta]]\^2)\)\)\/\(1\/r\)\), "-", 
                \(2\ \((b\^2\ Sin[\[Theta]]\^2)\)\), "-", 
                \(\(4\ \((b\^3\ Sin[\[Theta]]\^2)\)\)\/\(3\ r\)\), "+", 
                InterpretationBox[\(O[1\/r]\^2\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, -2, 2, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ -1, 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ -2, b, 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    Sin[ \[Theta]], 2]]}, -2, 2, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["RGtensors introduces the symbol ",
    FontSize->16],
  StyleBox["dr",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox["  for ",
    FontSize->16],
  StyleBox["d[r]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[". Note its use in LineElement:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gSERrInf[4], xCoord]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    "1", "-", \(\(2\ m\)\/r\), "-", 
                      \(2\ \((b\^2\ m)\)\ \((1\/r)\)\^3\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ -2, m], 0, 
                      Times[ -2, 
                        Power[ b, 2], m]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(-1\), "-", \(\(2\ m\)\/r\), "-", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "-", 
                      \(2\ \((m\ \((b\^2 + 4\ m\^2)\))\)\ \((1\/r)\)\^3\), 
                      "-", \(8\ \((m\^2\ \((b\^2 + 2\ m\^2)\))\)\ 
                        \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ -2, m], 
                      Times[ -4, 
                        Power[ m, 2]], 
                      Times[ -2, m, 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 4, 
                            Power[ m, 2]]]], 
                      Times[ -8, 
                        Power[ m, 2], 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 2, 
                            Power[ m, 2]]]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(1\/\((1\/r)\)\^2\)\), "+", \(\(2\ b\)\/\(1\/r\)\), 
                      "-", \(2\ b\^2\), "+", \(\(4\ b\^3\)\/\(3\ r\)\), "-", 
                      \(2\/3\ b\^4\ \((1\/r)\)\^2\), "+", 
                      InterpretationBox[\(O[1\/r]\^3\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, -2, 3, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ 2, b], 
                      Times[ -2, 
                        Power[ b, 2]], 
                      Times[ 
                        Rational[ 4, 3], 
                        Power[ b, 3]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ b, 4]]}, -2, 3, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(Sin[\[Theta]]\^2\/\((1\/r)\)\^2\)\), "-", 
                      \(\(2\ \((b\ Sin[\[Theta]]\^2)\)\)\/\(1\/r\)\), "-", 
                      \(2\ \((b\^2\ Sin[\[Theta]]\^2)\)\), "-", 
                      \(\(4\ \((b\^3\ Sin[\[Theta]]\^2)\)\)\/\(3\ r\)\), "-", 
                      \(2\/3\ \((b\^4\ Sin[\[Theta]]\^2)\)\ \((1\/r)\)\^2\), 
                      "+", 
                      InterpretationBox[\(O[1\/r]\^3\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, -2, 3, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {
                      Times[ -1, 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ -2, b, 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ -2, 
                        Power[ b, 2], 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -4, 3], 
                        Power[ b, 3], 
                        Power[ 
                          Sin[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ b, 4], 
                        Power[ 
                          Sin[ \[Theta]], 2]]}, -2, 3, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ -2, m], 0, 
            Times[ -2, 
              Power[ b, 2], m]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ -2, m], 
            Times[ -4, 
              Power[ m, 2]], 
            Times[ -2, m, 
              Plus[ 
                Power[ b, 2], 
                Times[ 4, 
                  Power[ m, 2]]]], 
            Times[ -8, 
              Power[ m, 2], 
              Plus[ 
                Power[ b, 2], 
                Times[ 2, 
                  Power[ m, 2]]]]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ 2, b], 
            Times[ -2, 
              Power[ b, 2]], 
            Times[ 
              Rational[ 4, 3], 
              Power[ b, 3]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ b, 4]]}, -2, 3, 1], 0}, {0, 0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ -2, b, 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ -2, 
              Power[ b, 2], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 
              Rational[ -4, 3], 
              Power[ b, 3], 
              Power[ 
                Sin[ \[Theta]], 2]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ b, 4], 
              Power[ 
                Sin[ \[Theta]], 2]]}, -2, 3, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \(\(\( - d[\[Theta]]\^2\) - 
                    d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^2\), 
              "+", \(\(2\ b\ d[\[Theta]]\^2 - 
                    2\ b\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(1\/r\)\), 
              "+", \((\(-dr\^2\) + d[t]\^2 - 2\ b\^2\ d[\[Theta]]\^2 - 
                  2\ b\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\(\(-2\)\ dr\^2\ m - 2\ m\ d[t]\^2 + 
                    4\/3\ b\^3\ d[\[Theta]]\^2 - 
                    4\/3\ b\^3\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/r\), 
              "+", \(\((
                  \(-4\)\ dr\^2\ m\^2 - 2\/3\ b\^4\ d[\[Theta]]\^2 - 
                    2\/3\ b\^4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ 
                \((1\/r)\)\^2\), "+", 
              InterpretationBox[\(O[1\/r]\^3\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, -2, 3, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, b, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, b, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -1, 
                  Power[ dr, 2]], 
                Power[ 
                  d[ t], 2], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m], 
                Times[ -2, m, 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -4, 
                  Power[ dr, 2], 
                  Power[ m, 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, -2, 3, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, b, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, b, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -1, 
                Power[ dr, 2]], 
              Power[ 
                d[ t], 2], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m], 
              Times[ -2, m, 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ 4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -4, 
                Power[ dr, 2], 
                Power[ m, 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, -2, 3, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    "1", "+", \(\(2\ m\)\/r\), "+", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "+", 
                      \(2\ m\ \((b\^2 + 4\ m\^2)\)\ \((1\/r)\)\^3\), "+", 
                      \(8\ m\^2\ \((b\^2 + 2\ m\^2)\)\ \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ 2, m], 
                      Times[ 4, 
                        Power[ m, 2]], 
                      Times[ 2, m, 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 4, 
                            Power[ m, 2]]]], 
                      Times[ 8, 
                        Power[ m, 2], 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 2, 
                            Power[ m, 2]]]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(-1\), "+", \(\(2\ m\)\/r\), "+", 
                      \(2\ b\^2\ m\ \((1\/r)\)\^3\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ 2, m], 0, 
                      Times[ 2, 
                        Power[ b, 2], m]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\((1\/r)\)\^2\), "-", \(2\ b\ \((1\/r)\)\^3\), "-", 
                      \(2\ b\^2\ \((1\/r)\)\^4\), "-", 
                      \(4\/3\ b\^3\ \((1\/r)\)\^5\), "-", 
                      \(2\/3\ b\^4\ \((1\/r)\)\^6\), "+", 
                      InterpretationBox[\(O[1\/r]\^7\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 2, 7, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ -2, b], 
                      Times[ -2, 
                        Power[ b, 2]], 
                      Times[ 
                        Rational[ -4, 3], 
                        Power[ b, 3]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ b, 4]]}, 2, 7, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{
                    \(-\(Csc[\[Theta]]\^2\ \((1\/r)\)\^2\)\), "+", 
                      \(2\ b\ Csc[\[Theta]]\^2\ \((1\/r)\)\^3\), "-", 
                      \(2\ \((b\^2\ Csc[\[Theta]]\^2)\)\ \((1\/r)\)\^4\), "+",
                       \(4\/3\ b\^3\ Csc[\[Theta]]\^2\ \((1\/r)\)\^5\), "-", 
                      \(2\/3\ \((b\^4\ Csc[\[Theta]]\^2)\)\ \((1\/r)\)\^6\), 
                      "+", 
                      InterpretationBox[\(O[1\/r]\^7\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 2, 7, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {
                      Times[ -1, 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 2, b, 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ -2, 
                        Power[ b, 2], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ 4, 3], 
                        Power[ b, 3], 
                        Power[ 
                          Csc[ \[Theta]], 2]], 
                      Times[ 
                        Rational[ -2, 3], 
                        Power[ b, 4], 
                        Power[ 
                          Csc[ \[Theta]], 2]]}, 2, 7, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ 2, m], 
            Times[ 4, 
              Power[ m, 2]], 
            Times[ 2, m, 
              Plus[ 
                Power[ b, 2], 
                Times[ 4, 
                  Power[ m, 2]]]], 
            Times[ 8, 
              Power[ m, 2], 
              Plus[ 
                Power[ b, 2], 
                Times[ 2, 
                  Power[ m, 2]]]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ 2, m], 0, 
            Times[ 2, 
              Power[ b, 2], m]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ -2, b], 
            Times[ -2, 
              Power[ b, 2]], 
            Times[ 
              Rational[ -4, 3], 
              Power[ b, 3]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ b, 4]]}, 2, 7, 1], 0}, {0, 0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 2, b, 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ -2, 
              Power[ b, 2], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 
              Rational[ 4, 3], 
              Power[ b, 3], 
              Power[ 
                Csc[ \[Theta]], 2]], 
            Times[ 
              Rational[ -2, 3], 
              Power[ b, 4], 
              Power[ 
                Csc[ \[Theta]], 2]]}, 2, 7, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.100000000000022737`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.10000000000002274, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.183333333333393966`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.18333333333339397, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.666667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[
              RowBox[{\(-\(2\ b\^2\ \((1\/r)\)\^4\)\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 4, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ -2, 
                  Power[ b, 2]]}, 4, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^2\), "+", 
                InterpretationBox[\(O[1\/r]\^6\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 2, 6, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 2, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^2\), "+", 
                InterpretationBox[\(O[1\/r]\^6\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 2, 6, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 2, 6, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ b\)\/r\), "-", 
                \(2\ \((b\ \((b + m)\))\)\ \((1\/r)\)\^2\), "+", 
                InterpretationBox[\(O[1\/r]\^3\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 1, 3, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b], 
                Times[ -2, b, 
                  Plus[ b, m]]}, 1, 3, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ b\ Sin[\[Theta]]\^2\)\/r\), "+", 
                \(2\ b\ \((3\ b + m)\)\ Sin[\[Theta]]\^2\ \((1\/r)\)\^2\), 
                "+", 
                InterpretationBox[\(O[1\/r]\^3\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 1, 3, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Power[ 
                    Sin[ \[Theta]], 2]], 
                Times[ 2, b, 
                  Plus[ 
                    Times[ 3, b], m], 
                  Power[ 
                    Sin[ \[Theta]], 2]]}, 1, 3, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["When b=0 the metric is Ricci-flat:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"RGtensors", "[", 
      RowBox[{
        RowBox[{\(gSERrInf[4]\), 
          StyleBox["/.",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[\(b \[Rule] 0\),
            FontColor->RGBColor[1, 0, 0]]}], ",", "xCoord"}], "]"}]], "Input",\

  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{"1", "-", \(\(2\ m\)\/r\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ -2, m]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(-1\), "-", \(\(2\ m\)\/r\), "-", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "-", 
                      \(8\ m\^3\ \((1\/r)\)\^3\), "-", 
                      \(16\ m\^4\ \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ -2, m], 
                      Times[ -4, 
                        Power[ m, 2]], 
                      Times[ -8, 
                        Power[ m, 3]], 
                      Times[ -16, 
                        Power[ m, 4]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{\(-\(1\/\((1\/r)\)\^2\)\), "+", 
                      InterpretationBox[\(O[1\/r]\^3\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, -2, 3, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1}, -2, 3, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{\(-\(Sin[\[Theta]]\^2\/\((1\/r)\)\^2\)\), "+", 
                      InterpretationBox[\(O[1\/r]\^3\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, -2, 3, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {
                      Times[ -1, 
                        Power[ 
                          Sin[ \[Theta]], 2]]}, -2, 3, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ -2, m]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ -2, m], 
            Times[ -4, 
              Power[ m, 2]], 
            Times[ -8, 
              Power[ m, 3]], 
            Times[ -16, 
              Power[ m, 4]]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1}, -2, 3, 1], 0}, {0, 0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 
                Sin[ \[Theta]], 2]]}, -2, 3, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \(\(\( - d[\[Theta]]\^2\) - 
                    d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^2\), 
              "+", \((\(-dr\^2\) + d[t]\^2)\), "+", 
              \(\(\(-2\)\ dr\^2\ m - 2\ m\ d[t]\^2\)\/r\), "-", 
              \(4\ \((dr\^2\ m\^2)\)\ \((1\/r)\)\^2\), "+", 
              InterpretationBox[\(O[1\/r]\^3\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, -2, 3, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 0, 
              Plus[ 
                Times[ -1, 
                  Power[ dr, 2]], 
                Power[ 
                  d[ t], 2]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m], 
                Times[ -2, m, 
                  Power[ 
                    d[ t], 2]]], 
              Times[ -4, 
                Power[ dr, 2], 
                Power[ m, 2]]}, -2, 3, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 0, 
            Plus[ 
              Times[ -1, 
                Power[ dr, 2]], 
              Power[ 
                d[ t], 2]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m], 
              Times[ -2, m, 
                Power[ 
                  d[ t], 2]]], 
            Times[ -4, 
              Power[ dr, 2], 
              Power[ m, 2]]}, -2, 3, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    "1", "+", \(\(2\ m\)\/r\), "+", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "+", 
                      \(8\ m\^3\ \((1\/r)\)\^3\), "+", 
                      \(16\ m\^4\ \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ 2, m], 
                      Times[ 4, 
                        Power[ m, 2]], 
                      Times[ 8, 
                        Power[ m, 3]], 
                      Times[ 16, 
                        Power[ m, 4]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{\(-1\), "+", \(\(2\ m\)\/r\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ 2, m]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{\(-\((1\/r)\)\^2\), "+", 
                      InterpretationBox[\(O[1\/r]\^7\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 2, 7, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1}, 2, 7, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{\(-\(Csc[\[Theta]]\^2\ \((1\/r)\)\^2\)\), "+", 
                      InterpretationBox[\(O[1\/r]\^7\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 2, 7, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {
                      Times[ -1, 
                        Power[ 
                          Csc[ \[Theta]], 2]]}, 2, 7, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ 2, m], 
            Times[ 4, 
              Power[ m, 2]], 
            Times[ 8, 
              Power[ m, 3]], 
            Times[ 16, 
              Power[ m, 4]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ 2, m]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1}, 2, 7, 1], 0}, {0, 0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 
                Csc[ \[Theta]], 2]]}, 2, 7, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333334167036`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333416704, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0500000000000682121`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat to order 4 or higher"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.3 seconds"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox[
  "The \"order n\" refers to the components of the mixed tensor RUd:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 3, 3, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 3, 3, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gUU.Rdd\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^7\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 7, 7, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^8\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 8, 8, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^7\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 7, 7, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^7\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 7, 7, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^8\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 8, 8, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^7\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 7, 7, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]]
}, Closed]],

Cell["", "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->10],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tOf course, one can use any coframe to do this calculation. In that case \
the coframe must be expanded in a series also. But since the coframe depends \
on the differentials of the coordinates, when expanding with respect to the \
coordinate ",
  StyleBox["x",
    FontFamily->"Courier"],
  ", the user must introduce the symbol ",
  StyleBox["dx",
    FontFamily->"Courier"],
  "  for ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["before",
    FontSlant->"Italic"],
  StyleBox[" expanding the coframe",
    FontSlant->"Italic"],
  ". This is achieved with the following commands (where ",
  StyleBox["x",
    FontFamily->"Courier"],
  " is the symbol for the expansion coordinate) :"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeclareForms[1, dx]; d[x] = dx; d[dx] = 0; \)], "Input"],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  " Then ",
  StyleBox["Series",
    FontFamily->"Courier"],
  " does not expand ",
  StyleBox["d[x]",
    FontFamily->"Courier"],
  " (= ",
  StyleBox["dx",
    FontFamily->"Courier"],
  "):"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Series[d[x]/\((1 - x)\), {x, 0, 2}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"dx", "+", \(dx\ x\), "+", \(dx\ x\^2\), "+", 
        InterpretationBox[\(O[x]\^3\),
          SeriesData[ x, 0, {}, 0, 3, 1]]}],
      SeriesData[ x, 0, {dx, dx, dx}, 0, 3, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  " And ",
  StyleBox["dx",
    FontFamily->"Courier"],
  " is treated correctly as a closed 1-form:  "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(d[%]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\(O[x]\^2\),
      SeriesData[ x, 0, {}, 2, 2, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%%\[Wedge]%%\)], "Input"],

Cell[BoxData[
    InterpretationBox[\(O[x]\^3\),
      SeriesData[ x, 0, {}, 3, 3, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 11: Example 10b in an orthonormal frame "], 
  "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(d[m] = 0; d[a] = 0; d[b] = 0; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(ONframe = 
      PowerExpand[{Sqrt[A[r]] d[t], d[r]/Sqrt[A[r]], 
          r\ d[\[Theta]]/Sqrt[B[r]], 
          r\ Sin[\[Theta]] Sqrt[B[r]] d[\[CurlyPhi]]}]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(gON = DiagonalMatrix[{1, \(-1\), \(-1\), \(-1\)}]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[TextData[{
  "\t",
  StyleBox["To expand with respect to the coordinate ",
    FontSize->16],
  StyleBox["r",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[", the notation ",
    FontSize->16],
  StyleBox["dr",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox["  for ",
    FontSize->16],
  StyleBox["d[r]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" must be used:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeclareForms[1, dr]; d[r] = dr; d[dr] = 0; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(ONfrSerInf[n_] := FacSimp[Series[ONframe, {r, Infinity, n}]]\)], "Input",\

  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ONfrSerInf[4]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{
          \(d[t]\), "-", \(\(m\ d[t]\)\/r\), "-", 
            \(1\/2\ \((m\^2\ d[t])\)\ \((1\/r)\)\^2\), "-", 
            \(1\/2\ \((m\ \((2\ b\^2 + m\^2)\)\ d[t])\)\ \((1\/r)\)\^3\), "-",
             \(1\/8\ \((m\^2\ \((8\ b\^2 + 5\ m\^2)\)\ d[t])\)\ 
              \((1\/r)\)\^4\), "+", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 0, 5, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            d[ t], 
            Times[ -1, m, 
              d[ t]], 
            Times[ 
              Rational[ -1, 2], 
              Power[ m, 2], 
              d[ t]], 
            Times[ 
              Rational[ -1, 2], m, 
              Plus[ 
                Times[ 2, 
                  Power[ b, 2]], 
                Power[ m, 2]], 
              d[ t]], 
            Times[ 
              Rational[ -1, 8], 
              Power[ m, 2], 
              Plus[ 
                Times[ 8, 
                  Power[ b, 2]], 
                Times[ 5, 
                  Power[ m, 2]]], 
              d[ t]]}, 0, 5, 1]], ",", 
        InterpretationBox[
          RowBox[{
          "dr", "+", \(\(dr\ m\)\/r\), "+", \(3\/2\ dr\ m\^2\ \((1\/r)\)\^2\),
             "+", \(1\/2\ dr\ m\ \((2\ b\^2 + 5\ m\^2)\)\ \((1\/r)\)\^3\), 
            "+", \(1\/8\ dr\ m\^2\ \((24\ b\^2 + 35\ m\^2)\)\ \((1\/r)\)\^4\),
             "+", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 0, 5, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {dr, 
            Times[ dr, m], 
            Times[ 
              Rational[ 3, 2], dr, 
              Power[ m, 2]], 
            Times[ 
              Rational[ 1, 2], dr, m, 
              Plus[ 
                Times[ 2, 
                  Power[ b, 2]], 
                Times[ 5, 
                  Power[ m, 2]]]], 
            Times[ 
              Rational[ 1, 8], dr, 
              Power[ m, 2], 
              Plus[ 
                Times[ 24, 
                  Power[ b, 2]], 
                Times[ 35, 
                  Power[ m, 2]]]]}, 0, 5, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(d[\[Theta]]\/\(1\/r\)\), "-", \(b\ d[\[Theta]]\), "+", 
            \(\(b\^2\ d[\[Theta]]\)\/\(2\ r\)\), "-", 
            \(1\/6\ \((b\^3\ d[\[Theta]])\)\ \((1\/r)\)\^2\), "+", 
            \(1\/24\ b\^4\ d[\[Theta]]\ \((1\/r)\)\^3\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, -1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            d[ \[Theta]], 
            Times[ -1, b, 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ b, 2], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ -1, 6], 
              Power[ b, 3], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ b, 4], 
              d[ \[Theta]]]}, -1, 4, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(\(d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\(1\/r\)\), "+", 
            \(b\ d[\[CurlyPhi]]\ Sin[\[Theta]]\), "+", 
            \(\(b\^2\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\(2\ r\)\), "+", 
            \(1\/6\ b\^3\ d[\[CurlyPhi]]\ Sin[\[Theta]]\ \((1\/r)\)\^2\), "+",
             \(1\/24\ b\^4\ d[\[CurlyPhi]]\ Sin[\[Theta]]\ \((1\/r)\)\^3\), 
            "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, -1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ b, 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ b, 2], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 6], 
              Power[ b, 3], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ b, 4], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]]}, -1, 4, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gON, xCoord, ONfrSerInf[4]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \(\(\( - d[\[Theta]]\^2\) - 
                    d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^2\), 
              "+", \(\(2\ b\ d[\[Theta]]\^2 - 
                    2\ b\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(1\/r\)\), 
              "+", \((\(-dr\^2\) + d[t]\^2 - 2\ b\^2\ d[\[Theta]]\^2 - 
                  2\ b\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\(\(-2\)\ dr\^2\ m - 2\ m\ d[t]\^2 + 
                    4\/3\ b\^3\ d[\[Theta]]\^2 - 
                    4\/3\ b\^3\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/r\), 
              "+", \(\((
                  \(-4\)\ dr\^2\ m\^2 - 2\/3\ b\^4\ d[\[Theta]]\^2 - 
                    2\/3\ b\^4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ 
                \((1\/r)\)\^2\), "+", 
              InterpretationBox[\(O[1\/r]\^3\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, -2, 3, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, b, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, b, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -1, 
                  Power[ dr, 2]], 
                Power[ 
                  d[ t], 2], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m], 
                Times[ -2, m, 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -4, 
                  Power[ dr, 2], 
                  Power[ m, 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, -2, 3, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, b, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, b, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -1, 
                Power[ dr, 2]], 
              Power[ 
                d[ t], 2], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m], 
              Times[ -2, m, 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ 4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -4, 
                Power[ dr, 2], 
                Power[ m, 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, -2, 3, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.333333333333371228`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.33333333333337123, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0333333333334167036`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333416704, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.0833333333333712289`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.783333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(-\(2\ b\^2\ \((1\/r)\)\^4\)\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 4, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ -2, 
                  Power[ b, 2]]}, 4, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 3, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 3, 4, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b]}, 3, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b]}, 3, 4, 1]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. b \[Rule] 0\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox[
  "After a frame calculation, the coordinate differentials are expressed in \
terms of the coframe:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d[r]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(e[2]\), "-", \(\(m\ e[2]\)\/r\), "-", 
        \(1\/2\ \((m\^2\ e[2])\)\ \((1\/r)\)\^2\), "-", 
        \(1\/2\ \((m\ \((2\ b\^2 + m\^2)\)\ e[2])\)\ \((1\/r)\)\^3\), "-", 
        \(1\/8\ \((m\^2\ \((8\ b\^2 + 5\ m\^2)\)\ e[2])\)\ \((1\/r)\)\^4\), 
        "+", 
        InterpretationBox[\(O[1\/r]\^5\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 0, 5, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        e[ 2], 
        Times[ -1, m, 
          e[ 2]], 
        Times[ 
          Rational[ -1, 2], 
          Power[ m, 2], 
          e[ 2]], 
        Times[ 
          Rational[ -1, 2], m, 
          Plus[ 
            Times[ 2, 
              Power[ b, 2]], 
            Power[ m, 2]], 
          e[ 2]], 
        Times[ 
          Rational[ -1, 8], 
          Power[ m, 2], 
          Plus[ 
            Times[ 8, 
              Power[ b, 2]], 
            Times[ 5, 
              Power[ m, 2]]], 
          e[ 2]]}, 0, 5, 1]]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIf repeated calculations (e.g., for different orders) are to be \
performed, the differentials of the coordinates (and of the symbol dx) must \
be cleared before each new calculation.This is accomplished with the command \
",
  StyleBox["Clear$dx",
    FontFamily->"Courier"],
  "  - see section 5.1.1 \"",
  ButtonBox["Note on repeated frame calculations",
    ButtonData:>"sec 5",
    ButtonStyle->"Hyperlink"],
  "\"."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx; d[r]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"],

Cell[BoxData[
    \(dr\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", 
        RowBox[{"*", 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["Order",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["5",
            FontColor->RGBColor[0, 0, 1]]}], " ", "**)"}], 
      \(RGtensors[gON, xCoord, ONfrSerInf[5]]\)}]], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \(\(\( - d[\[Theta]]\^2\) - 
                    d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^2\), 
              "+", \(\(2\ b\ d[\[Theta]]\^2 - 
                    2\ b\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(1\/r\)\), 
              "+", \((\(-dr\^2\) + d[t]\^2 - 2\ b\^2\ d[\[Theta]]\^2 - 
                  2\ b\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\(\(-2\)\ dr\^2\ m - 2\ m\ d[t]\^2 + 
                    4\/3\ b\^3\ d[\[Theta]]\^2 - 
                    4\/3\ b\^3\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/r\), 
              "+", \(\((
                  \(-4\)\ dr\^2\ m\^2 - 2\/3\ b\^4\ d[\[Theta]]\^2 - 
                    2\/3\ b\^4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ 
                \((1\/r)\)\^2\), "+", 
              \(\((\(-2\)\ dr\^2\ m\ \((b\^2 + 4\ m\^2)\) - 
                    2\ b\^2\ m\ d[t]\^2 + 4\/15\ b\^5\ d[\[Theta]]\^2 - 
                    4\/15\ b\^5\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ 
                \((1\/r)\)\^3\), "+", 
              InterpretationBox[\(O[1\/r]\^4\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, -2, 4, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, b, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, b, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -1, 
                  Power[ dr, 2]], 
                Power[ 
                  d[ t], 2], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m], 
                Times[ -2, m, 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -4, 
                  Power[ dr, 2], 
                  Power[ m, 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m, 
                  Plus[ 
                    Power[ b, 2], 
                    Times[ 4, 
                      Power[ m, 2]]]], 
                Times[ -2, 
                  Power[ b, 2], m, 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ 4, 15], 
                  Power[ b, 5], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 15], 
                  Power[ b, 5], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, -2, 4, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, b, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, b, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -1, 
                Power[ dr, 2]], 
              Power[ 
                d[ t], 2], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m], 
              Times[ -2, m, 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ 4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -4, 
                Power[ dr, 2], 
                Power[ m, 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m, 
                Plus[ 
                  Power[ b, 2], 
                  Times[ 4, 
                    Power[ m, 2]]]], 
              Times[ -2, 
                Power[ b, 2], m, 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ 4, 15], 
                Power[ b, 5], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 15], 
                Power[ b, 5], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, -2, 4, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"1", "0", "0", "0"},
                {"0", \(-1\), "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.56666666666671972`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.56666666666671972, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.100000000000022737`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.10000000000002274, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.11667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(-\(2\ b\^2\ \((1\/r)\)\^4\)\), "+", 
                \(10\ b\^2\ m\ \((1\/r)\)\^5\), "+", 
                InterpretationBox[\(O[1\/r]\^6\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 4, 6, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ -2, 
                  Power[ b, 2]], 
                Times[ 10, 
                  Power[ b, 2], m]}, 4, 6, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                \(2\ b\ \((b - m)\)\ Cot[\[Theta]]\ \((1\/r)\)\^4\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]], 
                Times[ 2, b, 
                  Plus[ b, 
                    Times[ -1, m]], 
                  Cot[ \[Theta]]]}, 3, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                \(2\ b\ \((b - m)\)\ Cot[\[Theta]]\ \((1\/r)\)\^4\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]], 
                Times[ 2, b, 
                  Plus[ b, 
                    Times[ -1, m]], 
                  Cot[ \[Theta]]]}, 3, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(2\ b\ \((1\/r)\)\^3\), "+", 
                \(2\ b\ \((b - m)\)\ \((1\/r)\)\^4\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b], 
                Times[ 2, b, 
                  Plus[ b, 
                    Times[ -1, m]]]}, 3, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^6\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 6, 6, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(2\ b\ \((1\/r)\)\^3\), "+", 
                \(2\ b\ \((b + m)\)\ \((1\/r)\)\^4\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b], 
                Times[ 2, b, 
                  Plus[ b, m]]}, 3, 5, 1]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox[
  "Remember that the coordinate differentials have been set equal to their \
expressions in terms of the ",
    FontSize->16],
  StyleBox["e[i]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" everywhere. To recover the original expressions use ",
    FontSize->16],
  StyleBox["eTO$dx",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" (see section 5.1.1):",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LineElement\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \((e[1]\^2 - e[2]\^2 - e[3]\^2 - e[4]\^2)\), "+", 
        \(\((\(-2\)\ b\^2\ m\ e[1]\^2 - 5\ m\^3\ e[1]\^2 + 
              m\ \((2\ b\^2 + 5\ m\^2)\)\ e[1]\^2 + 7\ m\^3\ e[2]\^2 + 
              m\ \((2\ b\^2 + m\^2)\)\ e[2]\^2 - 
              2\ m\ \((b\^2 + 4\ m\^2)\)\ e[2]\^2)\)\ \((1\/r)\)\^3\), "+", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 0, 4, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        Plus[ 
          Power[ 
            e[ 1], 2], 
          Times[ -1, 
            Power[ 
              e[ 2], 2]], 
          Times[ -1, 
            Power[ 
              e[ 3], 2]], 
          Times[ -1, 
            Power[ 
              e[ 4], 2]]], 0, 0, 
        Plus[ 
          Times[ -2, 
            Power[ b, 2], m, 
            Power[ 
              e[ 1], 2]], 
          Times[ -5, 
            Power[ m, 3], 
            Power[ 
              e[ 1], 2]], 
          Times[ m, 
            Plus[ 
              Times[ 2, 
                Power[ b, 2]], 
              Times[ 5, 
                Power[ m, 2]]], 
            Power[ 
              e[ 1], 2]], 
          Times[ 7, 
            Power[ m, 3], 
            Power[ 
              e[ 2], 2]], 
          Times[ m, 
            Plus[ 
              Times[ 2, 
                Power[ b, 2]], 
              Power[ m, 2]], 
            Power[ 
              e[ 2], 2]], 
          Times[ -2, m, 
            Plus[ 
              Power[ b, 2], 
              Times[ 4, 
                Power[ m, 2]]], 
            Power[ 
              e[ 2], 2]]]}, 0, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[LineElement]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\((e[1]\^2 - e[2]\^2 - e[3]\^2 - e[4]\^2)\), "+", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 0, 4, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        Plus[ 
          Power[ 
            e[ 1], 2], 
          Times[ -1, 
            Power[ 
              e[ 2], 2]], 
          Times[ -1, 
            Power[ 
              e[ 3], 2]], 
          Times[ -1, 
            Power[ 
              e[ 4], 2]]]}, 0, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[LineElement /. eTO$dx]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(\(\(-\[ScriptD][\[Theta]]\^2\) - 
              Sin[\[Theta]]\^2\ \[ScriptD][\[CurlyPhi]]\^2\)\/\((1\/r)\)\^2\),
         "+", \(\(2\ b\ \((
              \[ScriptD][\[Theta]] - Sin[\[Theta]]\ \[ScriptD][\[CurlyPhi]])
              \)\ \((\[ScriptD][\[Theta]] + 
                  Sin[\[Theta]]\ \[ScriptD][\[CurlyPhi]])\)\)\/\(1\/r\)\), 
        "+", \((\(-\[ScriptD]r\^2\) + \[ScriptD][t]\^2 - 
            2\ b\^2\ \[ScriptD][\[Theta]]\^2 - 
            2\ b\^2\ Sin[\[Theta]]\^2\ \[ScriptD][\[CurlyPhi]]\^2)\), "-", 
        \(\(2\ \((
                3\ m\ \[ScriptD]r\^2 + 3\ m\ \[ScriptD][t]\^2 - 
                  2\ b\^3\ \[ScriptD][\[Theta]]\^2 + 
                  2\ b\^3\ Sin[\[Theta]]\^2\ \[ScriptD][\[CurlyPhi]]\^2)
                \)\)\/\(3\ r\)\), "-", 
        \(2\/3\ \((
            6\ m\^2\ \[ScriptD]r\^2 + b\^4\ \[ScriptD][\[Theta]]\^2 + 
              b\^4\ Sin[\[Theta]]\^2\ \[ScriptD][\[CurlyPhi]]\^2)\)\ 
          \((1\/r)\)\^2\), "-", 
        \(2\/15\ \((
            15\ b\^2\ m\ \[ScriptD]r\^2 + 60\ m\^3\ \[ScriptD]r\^2 + 
              15\ b\^2\ m\ \[ScriptD][t]\^2 - 
              2\ b\^5\ \[ScriptD][\[Theta]]\^2 + 
              2\ b\^5\ Sin[\[Theta]]\^2\ \[ScriptD][\[CurlyPhi]]\^2)\)\ 
          \((1\/r)\)\^3\), "+", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, -2, 4, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {
        Plus[ 
          Times[ -1, 
            Power[ 
              \[ScriptD][ \[Theta]], 2]], 
          Times[ -1, 
            Power[ 
              Sin[ \[Theta]], 2], 
            Power[ 
              \[ScriptD][ \[CurlyPhi]], 2]]], 
        Times[ 2, b, 
          Plus[ 
            \[ScriptD][ \[Theta]], 
            Times[ -1, 
              Sin[ \[Theta]], 
              \[ScriptD][ \[CurlyPhi]]]], 
          Plus[ 
            \[ScriptD][ \[Theta]], 
            Times[ 
              Sin[ \[Theta]], 
              \[ScriptD][ \[CurlyPhi]]]]], 
        Plus[ 
          Times[ -1, 
            Power[ \[ScriptD]r, 2]], 
          Power[ 
            \[ScriptD][ t], 2], 
          Times[ -2, 
            Power[ b, 2], 
            Power[ 
              \[ScriptD][ \[Theta]], 2]], 
          Times[ -2, 
            Power[ b, 2], 
            Power[ 
              Sin[ \[Theta]], 2], 
            Power[ 
              \[ScriptD][ \[CurlyPhi]], 2]]], 
        Times[ 
          Rational[ -2, 3], 
          Plus[ 
            Times[ 3, m, 
              Power[ \[ScriptD]r, 2]], 
            Times[ 3, m, 
              Power[ 
                \[ScriptD][ t], 2]], 
            Times[ -2, 
              Power[ b, 3], 
              Power[ 
                \[ScriptD][ \[Theta]], 2]], 
            Times[ 2, 
              Power[ b, 3], 
              Power[ 
                Sin[ \[Theta]], 2], 
              Power[ 
                \[ScriptD][ \[CurlyPhi]], 2]]]], 
        Times[ 
          Rational[ -2, 3], 
          Plus[ 
            Times[ 6, 
              Power[ m, 2], 
              Power[ \[ScriptD]r, 2]], 
            Times[ 
              Power[ b, 4], 
              Power[ 
                \[ScriptD][ \[Theta]], 2]], 
            Times[ 
              Power[ b, 4], 
              Power[ 
                Sin[ \[Theta]], 2], 
              Power[ 
                \[ScriptD][ \[CurlyPhi]], 2]]]], 
        Times[ 
          Rational[ -2, 15], 
          Plus[ 
            Times[ 15, 
              Power[ b, 2], m, 
              Power[ \[ScriptD]r, 2]], 
            Times[ 60, 
              Power[ m, 3], 
              Power[ \[ScriptD]r, 2]], 
            Times[ 15, 
              Power[ b, 2], m, 
              Power[ 
                \[ScriptD][ t], 2]], 
            Times[ -2, 
              Power[ b, 5], 
              Power[ 
                \[ScriptD][ \[Theta]], 2]], 
            Times[ 2, 
              Power[ b, 5], 
              Power[ 
                Sin[ \[Theta]], 2], 
              Power[ 
                \[ScriptD][ \[CurlyPhi]], 2]]]]}, -2, 4, 1]]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[%, \[ScriptD][r]^2]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(-1\) - \(2\ b\^2\ m\)\/r\^3 - \(8\ m\^3\)\/r\^3 - \(4\ m\^2\)\/r\^2 - 
      \(2\ m\)\/r\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "\t",
  StyleBox["The function ",
    FontSize->16],
  StyleBox["GenCoef[x_,y_]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[
  " (\"GeneralizedCoefficient\") returns a series for the coefficient of y in \
x when x is a series:",
    FontSize->16]
}], "Text",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[%%, \[ScriptD][r]^2]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      \(-1\), "-", \(\(2\ m\)\/r\), "-", \(4\ m\^2\ \((1\/r)\)\^2\), "-", 
        \(2\ \((m\ \((b\^2 + 4\ m\^2)\))\)\ \((1\/r)\)\^3\), "+", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 0, 4, 1]]}],
      SeriesData[ r, 
        DirectedInfinity[ 1], {-1, 
        Times[ -2, m], 
        Times[ -4, 
          Power[ m, 2]], 
        Times[ -2, m, 
          Plus[ 
            Power[ b, 2], 
            Times[ 4, 
              Power[ m, 2]]]]}, 0, 4, 1]]], "Output"]
}, Open  ]]
}, Closed]],

Cell["", "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->10],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIt is also possible to do the calculation with both the metric and the \
coframe expanded in series:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 11a: Examples 10a,b in a \"special\" frame \
"], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(\(SPECframe = 
      PowerExpand[{d[t], d[r], r\ d[\[Theta]]/Sqrt[B[r]], 
          r\ Sin[\[Theta]] Sqrt[B[r]] d[\[CurlyPhi]]}]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(gSPEC = DiagonalMatrix[{A[r], \(-1\)/A[r], \(-1\), \(-1\)}]; \)\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(i) Expand both frame and metric around b=0:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(SPECframeb0[n_] := FacSimp[Series[SPECframe, {b, 0, n}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(gSPECb0[n_] := FacSimp[Series[gSPEC, {b, 0, n}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SPECframeb0[4]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(d[t]\), ",", "dr", ",", 
        InterpretationBox[
          RowBox[{
          \(r\ d[\[Theta]]\), "-", \(d[\[Theta]]\ b\), "+", 
            \(\(d[\[Theta]]\ b\^2\)\/\(2\ r\)\), "-", 
            \(\(d[\[Theta]]\ b\^3\)\/\(6\ r\^2\)\), "+", 
            \(\(d[\[Theta]]\ b\^4\)\/\(24\ r\^3\)\), "+", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 0, 5, 1]]}],
          SeriesData[ b, 0, {
            Times[ r, 
              d[ \[Theta]]], 
            Times[ -1, 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ r, -1], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ -1, 6], 
              Power[ r, -2], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ r, -3], 
              d[ \[Theta]]]}, 0, 5, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(r\ d[\[CurlyPhi]]\ Sin[\[Theta]]\), "+", 
            \(d[\[CurlyPhi]]\ Sin[\[Theta]]\ b\), "+", 
            \(\(d[\[CurlyPhi]]\ Sin[\[Theta]]\ b\^2\)\/\(2\ r\)\), "+", 
            \(\(d[\[CurlyPhi]]\ Sin[\[Theta]]\ b\^3\)\/\(6\ r\^2\)\), "+", 
            \(\(d[\[CurlyPhi]]\ Sin[\[Theta]]\ b\^4\)\/\(24\ r\^3\)\), "+", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 0, 5, 1]]}],
          SeriesData[ b, 0, {
            Times[ r, 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ r, -1], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 6], 
              Power[ r, -2], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ r, -3], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]]}, 0, 5, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gSPECb0[4]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ m - r\)\/r\)\), "-", \(\(2\ m\ b\^2\)\/r\^3\), "-", 
                \(\(2\ m\ b\^4\)\/r\^5\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 0, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ -1, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -1]], 0, 
                Times[ -2, m, 
                  Power[ r, -3]], 0, 
                Times[ -2, m, 
                  Power[ r, -5]]}, 0, 5, 1]], ",", "0", ",", "0", ",", "0"}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[
              RowBox[{
              \(r\/\(2\ m - r\)\), "-", 
                \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "+", 
                \(\(2\ m\ b\^4\)\/\(\((2\ m - r)\)\^3\ r\^2\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 0, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], r], 0, 
                Times[ -2, m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -1]], 0, 
                Times[ 2, m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -3], 
                  Power[ r, -2]]}, 0, 5, 1]], ",", "0", ",", "0"}], "}"}], 
        ",", \({0, 0, \(-1\), 0}\), ",", \({0, 0, 0, \(-1\)}\)}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gSPECb0[4], xCoord, SPECframeb0[4]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    \(-\(\(2\ m - r\)\/r\)\), "-", \(\(2\ m\ b\^2\)\/r\^3\), 
                      "-", \(\(2\ m\ b\^4\)\/r\^5\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Plus[ 
                          Times[ 2, m], 
                          Times[ -1, r]], 
                        Power[ r, -1]], 0, 
                      Times[ -2, m, 
                        Power[ r, -3]], 0, 
                      Times[ -2, m, 
                        Power[ r, -5]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(r\/\(2\ m - r\)\), "-", 
                      \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "+", 
                      \(\(2\ m\ b\^4\)\/\(\((2\ m - r)\)\^3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -1], r], 0, 
                      Times[ -2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -2], 
                        Power[ r, -1]], 0, 
                      Times[ 2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -3], 
                        Power[ r, -2]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          SeriesData[ b, 0, {
            Times[ -1, 
              Plus[ 
                Times[ 2, m], 
                Times[ -1, r]], 
              Power[ r, -1]], 0, 
            Times[ -2, m, 
              Power[ r, -3]], 0, 
            Times[ -2, m, 
              Power[ r, -5]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ b, 0, {
            Times[ 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -1], r], 0, 
            Times[ -2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -2], 
              Power[ r, -1]], 0, 
            Times[ 2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -3], 
              Power[ r, -2]]}, 0, 5, 1], 0, 0}, {0, 0, -1, 0}, {0, 0, 0,
           -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \((\(dr\^2\ r\)\/\(2\ m - r\) + 
                \(\((\(-2\)\ m + r)\)\ d[t]\^2\)\/r - r\^2\ d[\[Theta]]\^2 - 
                r\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\((2\ r\ d[\[Theta]]\^2 - 
                    2\ r\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ b\), "+", 
              \(\((\(-\(\(2\ dr\^2\ m\)\/\(\((2\ m - r)\)\^2\ r\)\)\) - 
                    \(2\ m\ d[t]\^2\)\/r\^3 - 2\ d[\[Theta]]\^2 - 
                    2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ b\^2\), "+", 
              \(\((\(4\ d[\[Theta]]\^2\)\/\(3\ r\) - 
                    \(4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(3\ r\))\)\ 
                b\^3\), "+", 
              \(\((\(2\ dr\^2\ m\)\/\(\((2\ m - r)\)\^3\ r\^2\) - 
                    \(2\ m\ d[t]\^2\)\/r\^5 - 
                    \(2\ d[\[Theta]]\^2\)\/\(3\ r\^2\) - 
                    \(2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(3\ r\^2\))
                  \)\ b\^4\), "+", 
              InterpretationBox[\(O[b]\^5\),
                SeriesData[ b, 0, {}, 0, 5, 1]]}],
            SeriesData[ b, 0, {
              Plus[ 
                Times[ 
                  Power[ dr, 2], 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], r], 
                Times[ 
                  Power[ r, -1], 
                  Plus[ 
                    Times[ -2, m], r], 
                  Power[ 
                    d[ t], 2]], 
                Times[ -1, 
                  Power[ r, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ r, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, r, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, r, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -1]], 
                Times[ -2, m, 
                  Power[ r, -3], 
                  Power[ 
                    d[ t], 2]], 
                Times[ -2, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ r, -1], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ r, -1], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, 
                  Power[ dr, 2], m, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -3], 
                  Power[ r, -2]], 
                Times[ -2, m, 
                  Power[ r, -5], 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ r, -2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ r, -2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, 0, 5, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ b, 0, {
            Plus[ 
              Times[ 
                Power[ dr, 2], 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -1], r], 
              Times[ 
                Power[ r, -1], 
                Plus[ 
                  Times[ -2, m], r], 
                Power[ 
                  d[ t], 2]], 
              Times[ -1, 
                Power[ r, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ r, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, r, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, r, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m, 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -2], 
                Power[ r, -1]], 
              Times[ -2, m, 
                Power[ r, -3], 
                Power[ 
                  d[ t], 2]], 
              Times[ -2, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 
                Rational[ 4, 3], 
                Power[ r, -1], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ r, -1], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, 
                Power[ dr, 2], m, 
                Power[ 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], -3], 
                Power[ r, -2]], 
              Times[ -2, m, 
                Power[ r, -5], 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ r, -2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ r, -2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, 0, 5, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    \(-\(r\/\(2\ m - r\)\)\), "+", 
                      \(\(2\ m\ b\^2\)\/\(\((2\ m - r)\)\^2\ r\)\), "-", 
                      \(\(2\ m\ b\^4\)\/\(\((2\ m - r)\)\^3\ r\^2\)\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ -1, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -1], r], 0, 
                      Times[ 2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -2], 
                        Power[ r, -1]], 0, 
                      Times[ -2, m, 
                        Power[ 
                          Plus[ 
                            Times[ 2, m], 
                            Times[ -1, r]], -3], 
                        Power[ r, -2]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(\(2\ m - r\)\/r\), "+", \(\(2\ m\ b\^2\)\/r\^3\), "+", 
                      \(\(2\ m\ b\^4\)\/r\^5\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {
                      Times[ 
                        Plus[ 
                          Times[ 2, m], 
                          Times[ -1, r]], 
                        Power[ r, -1]], 0, 
                      Times[ 2, m, 
                        Power[ r, -3]], 0, 
                      Times[ 2, m, 
                        Power[ r, -5]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{\(-1\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {-1}, 0, 5, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{\(-1\), "+", 
                      InterpretationBox[\(O[b]\^5\),
                        SeriesData[ b, 0, {}, 0, 5, 1]]}],
                    SeriesData[ b, 0, {-1}, 0, 5, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          SeriesData[ b, 0, {
            Times[ -1, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -1], r], 0, 
            Times[ 2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -2], 
              Power[ r, -1]], 0, 
            Times[ -2, m, 
              Power[ 
                Plus[ 
                  Times[ 2, m], 
                  Times[ -1, r]], -3], 
              Power[ r, -2]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ b, 0, {
            Times[ 
              Plus[ 
                Times[ 2, m], 
                Times[ -1, r]], 
              Power[ r, -1]], 0, 
            Times[ 2, m, 
              Power[ r, -3]], 0, 
            Times[ 2, m, 
              Power[ r, -5]]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ b, 0, {-1}, 0, 5, 1], 0}, {0, 0, 0, 
          SeriesData[ b, 0, {-1}, 0, 5, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0500000000000682121`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.166666666666628771`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.16666666666662877, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.149999999999977262`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.14999999999997726, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.233333333333348491`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.23333333333334849, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.03333 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              \(\(6\ m\ \((2\ m - r)\)\ b\^2\)\/r\^6\), "+", 
                \(\(4\ m\ \((13\ m - 5\ r)\)\ b\^4\)\/r\^8\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 2, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 6, m, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -6]], 0, 
                Times[ 4, m, 
                  Plus[ 
                    Times[ 13, m], 
                    Times[ -5, r]], 
                  Power[ r, -8]]}, 2, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ \((5\ m - r)\)\ b\^2\)\/\(\((2\ m - r)\)\ r\^4\)\)\), 
                "-", \(\(4\ \((m\ \((7\ m - 5\ r)\))\)\ 
                      b\^4\)\/\(\((2\ m - r)\)\^2\ r\^6\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 2, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ -2, 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -1], 
                  Plus[ 
                    Times[ 5, m], 
                    Times[ -1, r]], 
                  Power[ r, -4]], 0, 
                Times[ -4, m, 
                  Plus[ 
                    Times[ 7, m], 
                    Times[ -5, r]], 
                  Power[ 
                    Plus[ 
                      Times[ 2, m], 
                      Times[ -1, r]], -2], 
                  Power[ r, -6]]}, 2, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ Cot[\[Theta]]\ b\)\/r\^3\), "+", 
                \(\(2\ Cot[\[Theta]]\ b\^2\)\/r\^4\), "+", 
                \(\(Cot[\[Theta]]\ b\^3\)\/r\^5\), "+", 
                \(\(Cot[\[Theta]]\ b\^4\)\/\(3\ r\^6\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -3], 
                  Cot[ \[Theta]]], 
                Times[ 2, 
                  Power[ r, -4], 
                  Cot[ \[Theta]]], 
                Times[ 
                  Power[ r, -5], 
                  Cot[ \[Theta]]], 
                Times[ 
                  Rational[ 1, 3], 
                  Power[ r, -6], 
                  Cot[ \[Theta]]]}, 1, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ Cot[\[Theta]]\ b\)\/r\^3\), "+", 
                \(\(2\ Cot[\[Theta]]\ b\^2\)\/r\^4\), "+", 
                \(\(Cot[\[Theta]]\ b\^3\)\/r\^5\), "+", 
                \(\(Cot[\[Theta]]\ b\^4\)\/\(3\ r\^6\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -3], 
                  Cot[ \[Theta]]], 
                Times[ 2, 
                  Power[ r, -4], 
                  Cot[ \[Theta]]], 
                Times[ 
                  Power[ r, -5], 
                  Cot[ \[Theta]]], 
                Times[ 
                  Rational[ 1, 3], 
                  Power[ r, -6], 
                  Cot[ \[Theta]]]}, 1, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(-\(\(2\ \((m - r)\)\ b\)\/r\^4\)\), "-", 
                \(\(2\ \((2\ m - r)\)\ b\^2\)\/r\^5\), "-", 
                \(\(2\ \((9\ m - 2\ r)\)\ b\^3\)\/\(3\ r\^6\)\), "-", 
                \(\(2\ \((12\ m - r)\)\ b\^4\)\/\(3\ r\^7\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ -2, 
                  Plus[ m, 
                    Times[ -1, r]], 
                  Power[ r, -4]], 
                Times[ -2, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -5]], 
                Times[ 
                  Rational[ -2, 3], 
                  Plus[ 
                    Times[ 9, m], 
                    Times[ -2, r]], 
                  Power[ r, -6]], 
                Times[ 
                  Rational[ -2, 3], 
                  Plus[ 
                    Times[ 12, m], 
                    Times[ -1, r]], 
                  Power[ r, -7]]}, 1, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[b]\^5\),
              SeriesData[ b, 0, {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{
              \(\(2\ \((m + r)\)\ b\)\/r\^4\), "-", 
                \(\(2\ \((2\ m - r)\)\ b\^2\)\/r\^5\), "+", 
                \(\(2\ \((9\ m + 2\ r)\)\ b\^3\)\/\(3\ r\^6\)\), "-", 
                \(\(2\ \((12\ m - r)\)\ b\^4\)\/\(3\ r\^7\)\), "+", 
                InterpretationBox[\(O[b]\^5\),
                  SeriesData[ b, 0, {}, 1, 5, 1]]}],
              SeriesData[ b, 0, {
                Times[ 2, 
                  Power[ r, -4], 
                  Plus[ m, r]], 
                Times[ -2, 
                  Plus[ 
                    Times[ 2, m], 
                    Times[ -1, r]], 
                  Power[ r, -5]], 
                Times[ 
                  Rational[ 2, 3], 
                  Power[ r, -6], 
                  Plus[ 
                    Times[ 9, m], 
                    Times[ 2, r]]], 
                Times[ 
                  Rational[ -2, 3], 
                  Plus[ 
                    Times[ 12, m], 
                    Times[ -1, r]], 
                  Power[ r, -7]]}, 1, 5, 1]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. b \[Rule] 0\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t(ii) Expand both frame and metric for r\[RightArrow]\[Infinity]:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "\t",
  StyleBox["Again the notation ",
    FontSize->16],
  StyleBox["dr",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox["  for ",
    FontSize->16],
  StyleBox["d[r]",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[" must be introduced before expanding the coframe w.r.t. ",
    FontSize->16],
  StyleBox["r",
    FontFamily->"Courier",
    FontSize->16],
  StyleBox[":",
    FontSize->16]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeclareForms[1, dr]; d[r] = dr; d[dr] = 0; \)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(SPECframeINF[n_] := FacSimp[Series[SPECframe, {r, Infinity, n}]]\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(gSPECinf[n_] := FacSimp[Series[gSPEC, {r, Infinity, n}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SPECframeINF[4]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(d[t]\), ",", "dr", ",", 
        InterpretationBox[
          RowBox[{
          \(d[\[Theta]]\/\(1\/r\)\), "-", \(b\ d[\[Theta]]\), "+", 
            \(\(b\^2\ d[\[Theta]]\)\/\(2\ r\)\), "-", 
            \(1\/6\ \((b\^3\ d[\[Theta]])\)\ \((1\/r)\)\^2\), "+", 
            \(1\/24\ b\^4\ d[\[Theta]]\ \((1\/r)\)\^3\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, -1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            d[ \[Theta]], 
            Times[ -1, b, 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ b, 2], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ -1, 6], 
              Power[ b, 3], 
              d[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ b, 4], 
              d[ \[Theta]]]}, -1, 4, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(\(d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\(1\/r\)\), "+", 
            \(b\ d[\[CurlyPhi]]\ Sin[\[Theta]]\), "+", 
            \(\(b\^2\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\(2\ r\)\), "+", 
            \(1\/6\ b\^3\ d[\[CurlyPhi]]\ Sin[\[Theta]]\ \((1\/r)\)\^2\), "+",
             \(1\/24\ b\^4\ d[\[CurlyPhi]]\ Sin[\[Theta]]\ \((1\/r)\)\^3\), 
            "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, -1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ b, 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ b, 2], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 6], 
              Power[ b, 3], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]], 
            Times[ 
              Rational[ 1, 24], 
              Power[ b, 4], 
              d[ \[CurlyPhi]], 
              Sin[ \[Theta]]]}, -1, 4, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gSPECinf[4]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[
              RowBox[{
              "1", "-", \(\(2\ m\)\/r\), "-", 
                \(2\ \((b\^2\ m)\)\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 0, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {1, 
                Times[ -2, m], 0, 
                Times[ -2, 
                  Power[ b, 2], m]}, 0, 5, 1]], ",", "0", ",", "0", ",", 
            "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            InterpretationBox[
              RowBox[{
              \(-1\), "-", \(\(2\ m\)\/r\), "-", \(4\ m\^2\ \((1\/r)\)\^2\), 
                "-", \(2\ \((m\ \((b\^2 + 4\ m\^2)\))\)\ \((1\/r)\)\^3\), "-",
                 \(8\ \((m\^2\ \((b\^2 + 2\ m\^2)\))\)\ \((1\/r)\)\^4\), "+", 
                
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 0, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {-1, 
                Times[ -2, m], 
                Times[ -4, 
                  Power[ m, 2]], 
                Times[ -2, m, 
                  Plus[ 
                    Power[ b, 2], 
                    Times[ 4, 
                      Power[ m, 2]]]], 
                Times[ -8, 
                  Power[ m, 2], 
                  Plus[ 
                    Power[ b, 2], 
                    Times[ 2, 
                      Power[ m, 2]]]]}, 0, 5, 1]], ",", "0", ",", "0"}], 
          "}"}], ",", \({0, 0, \(-1\), 0}\), ",", \({0, 0, 0, \(-1\)}\)}], 
      "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gSPECinf[4], xCoord, SPECframeINF[4]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    "1", "-", \(\(2\ m\)\/r\), "-", 
                      \(2\ \((b\^2\ m)\)\ \((1\/r)\)\^3\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ -2, m], 0, 
                      Times[ -2, 
                        Power[ b, 2], m]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(-1\), "-", \(\(2\ m\)\/r\), "-", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "-", 
                      \(2\ \((m\ \((b\^2 + 4\ m\^2)\))\)\ \((1\/r)\)\^3\), 
                      "-", \(8\ \((m\^2\ \((b\^2 + 2\ m\^2)\))\)\ 
                        \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ -2, m], 
                      Times[ -4, 
                        Power[ m, 2]], 
                      Times[ -2, m, 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 4, 
                            Power[ m, 2]]]], 
                      Times[ -8, 
                        Power[ m, 2], 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 2, 
                            Power[ m, 2]]]]}, 0, 5, 1]], "0", "0"},
                {"0", "0", \(-1\), "0"},
                {"0", "0", "0", \(-1\)}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ -2, m], 0, 
            Times[ -2, 
              Power[ b, 2], m]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ -2, m], 
            Times[ -4, 
              Power[ m, 2]], 
            Times[ -2, m, 
              Plus[ 
                Power[ b, 2], 
                Times[ 4, 
                  Power[ m, 2]]]], 
            Times[ -8, 
              Power[ m, 2], 
              Plus[ 
                Power[ b, 2], 
                Times[ 2, 
                  Power[ m, 2]]]]}, 0, 5, 1], 0, 0}, {0, 0, -1, 0}, {0, 0, 0,
           -1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          InterpretationBox[
            RowBox[{
            \(\(\( - d[\[Theta]]\^2\) - 
                    d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\((1\/r)\)\^2\), 
              "+", \(\(2\ b\ d[\[Theta]]\^2 - 
                    2\ b\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/\(1\/r\)\), 
              "+", \((\(-dr\^2\) + d[t]\^2 - 2\ b\^2\ d[\[Theta]]\^2 - 
                  2\ b\^2\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\), "+", 
              \(\(\(-2\)\ dr\^2\ m - 2\ m\ d[t]\^2 + 
                    4\/3\ b\^3\ d[\[Theta]]\^2 - 
                    4\/3\ b\^3\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2\)\/r\), 
              "+", \(\((
                  \(-4\)\ dr\^2\ m\^2 - 2\/3\ b\^4\ d[\[Theta]]\^2 - 
                    2\/3\ b\^4\ d[\[CurlyPhi]]\^2\ Sin[\[Theta]]\^2)\)\ 
                \((1\/r)\)\^2\), "+", 
              InterpretationBox[\(O[1\/r]\^3\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, -2, 3, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -1, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ 2, b, 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, b, 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -1, 
                  Power[ dr, 2]], 
                Power[ 
                  d[ t], 2], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ -2, 
                  Power[ b, 2], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -2, 
                  Power[ dr, 2], m], 
                Times[ -2, m, 
                  Power[ 
                    d[ t], 2]], 
                Times[ 
                  Rational[ 4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -4, 3], 
                  Power[ b, 3], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]], 
              Plus[ 
                Times[ -4, 
                  Power[ dr, 2], 
                  Power[ m, 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[Theta]], 2]], 
                Times[ 
                  Rational[ -2, 3], 
                  Power[ b, 4], 
                  Power[ 
                    d[ \[CurlyPhi]], 2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]}, -2, 3, 1]],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -1, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ 2, b, 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, b, 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -1, 
                Power[ dr, 2]], 
              Power[ 
                d[ t], 2], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ -2, 
                Power[ b, 2], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -2, 
                Power[ dr, 2], m], 
              Times[ -2, m, 
                Power[ 
                  d[ t], 2]], 
              Times[ 
                Rational[ 4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -4, 3], 
                Power[ b, 3], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]], 
            Plus[ 
              Times[ -4, 
                Power[ dr, 2], 
                Power[ m, 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[Theta]], 2]], 
              Times[ 
                Rational[ -2, 3], 
                Power[ b, 4], 
                Power[ 
                  d[ \[CurlyPhi]], 2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]}, -2, 3, 1], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {
                  InterpretationBox[
                    RowBox[{
                    "1", "+", \(\(2\ m\)\/r\), "+", 
                      \(4\ m\^2\ \((1\/r)\)\^2\), "+", 
                      \(2\ m\ \((b\^2 + 4\ m\^2)\)\ \((1\/r)\)\^3\), "+", 
                      \(8\ m\^2\ \((b\^2 + 2\ m\^2)\)\ \((1\/r)\)\^4\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {1, 
                      Times[ 2, m], 
                      Times[ 4, 
                        Power[ m, 2]], 
                      Times[ 2, m, 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 4, 
                            Power[ m, 2]]]], 
                      Times[ 8, 
                        Power[ m, 2], 
                        Plus[ 
                          Power[ b, 2], 
                          Times[ 2, 
                            Power[ m, 2]]]]}, 0, 5, 1]], "0", "0", "0"},
                {"0", 
                  InterpretationBox[
                    RowBox[{
                    \(-1\), "+", \(\(2\ m\)\/r\), "+", 
                      \(2\ b\^2\ m\ \((1\/r)\)\^3\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1, 
                      Times[ 2, m], 0, 
                      Times[ 2, 
                        Power[ b, 2], m]}, 0, 5, 1]], "0", "0"},
                {"0", "0", 
                  InterpretationBox[
                    RowBox[{\(-1\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1}, 0, 5, 1]], "0"},
                {"0", "0", "0", 
                  InterpretationBox[
                    RowBox[{\(-1\), "+", 
                      InterpretationBox[\(O[1\/r]\^5\),
                        SeriesData[ r, 
                          DirectedInfinity[ 1], {}, 0, 5, 1]]}],
                    SeriesData[ r, 
                      DirectedInfinity[ 1], {-1}, 0, 5, 1]]}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          SeriesData[ r, 
            DirectedInfinity[ 1], {1, 
            Times[ 2, m], 
            Times[ 4, 
              Power[ m, 2]], 
            Times[ 2, m, 
              Plus[ 
                Power[ b, 2], 
                Times[ 4, 
                  Power[ m, 2]]]], 
            Times[ 8, 
              Power[ m, 2], 
              Plus[ 
                Power[ b, 2], 
                Times[ 2, 
                  Power[ m, 2]]]]}, 0, 5, 1], 0, 0, 0}, {0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1, 
            Times[ 2, m], 0, 
            Times[ 2, 
              Power[ b, 2], m]}, 0, 5, 1], 0, 0}, {0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1}, 0, 5, 1], 0}, {0, 0, 0, 
          SeriesData[ r, 
            DirectedInfinity[ 1], {-1}, 0, 5, 1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0499999999999545252`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("d[coframe] computed in "\[InvisibleSpace]0.133333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "d[coframe] computed in ", 0.13333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0666666666667197205`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.0833333333333712289`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.0999999999999090505`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.099999999999909051, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.666667 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(-\(2\ b\^2\ \((1\/r)\)\^4\)\), "+", 
                InterpretationBox[\(O[1\/r]\^5\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 4, 5, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ -2, 
                  Power[ b, 2]]}, 4, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 3, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ Cot[\[Theta]]\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b, 
                  Cot[ \[Theta]]]}, 3, 4, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b]}, 3, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[
              RowBox[{\(2\ b\ \((1\/r)\)\^3\), "+", 
                InterpretationBox[\(O[1\/r]\^4\),
                  SeriesData[ r, 
                    DirectedInfinity[ 1], {}, 3, 4, 1]]}],
              SeriesData[ r, 
                DirectedInfinity[ 1], {
                Times[ 2, b]}, 3, 4, 1]]}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. b \[Rule] 0\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^5\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 5, 5, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
  6.3  Expanding deList and dxRuleList in implicit frame \
calculations\
\>", "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIf an implicit frame is used (see Section 5.2), then, in addition to the \
metric, the expressions in ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " must be expanded in a series, especially if they are complicated. The \
reason is that before a normal expression can be multiplied by a series, it \
must be expanded itself in a series. Thus, if ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " are given as normal expressions, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will keep expanding these expressions again and again every time it \
performs a differentiation, causing the calculations to proceed very slowly."
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[
"  \[FilledSmallSquare]   Example 12: Example 10b in an implicit NP null \
frame"], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("OK"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPframe = 
      FacSimp[{\((ONframe[\([1]\)] - ONframe[\([2]\)])\)/\@2, 
          \((ONframe[\([1]\)] + ONframe[\([2]\)])\)/\@2, 
          \((ONframe[\([3]\)] + I\ ONframe[\([4]\)])\)/\@2, 
          \((ONframe[\([3]\)] - I\ ONframe[\([4]\)])\)/\@2}]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(-\(dr\/\(\@2\ \@\(1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\)\)\)\)\) + 
        \(\@\(1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\)\)\ d[t]\)\/\@2, 
      dr\/\(\@2\ \@\(1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\)\)\) + 
        \(\@\(1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\)\)\ d[t]\)\/\@2, 
      \(E\^\(-\(b\/r\)\)\ r\ d[\[Theta]]\)\/\@2 + 
        \(I\ E\^\(b/r\)\ r\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\@2, 
      \(E\^\(-\(b\/r\)\)\ r\ d[\[Theta]]\)\/\@2 - 
        \(I\ E\^\(b/r\)\ r\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\@2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPframe = 
      NPframe /. 
        Power[1 - \(2\ m\ r\)\/\(\(-b\^2\) + r\^2\), n_] \[RuleDelayed] \ 
          Power[\(-b\^2\) - 2\ m\ r + r\^2, n] 
            Power[\(-b\^2\) + r\^2, \(-n\)]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(-
          \(\(dr\ \@\(\( - b\^2\) + r\^2\)\)\/\(\@2\ 
                \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\)\)\) + 
        \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ d[t]\)\/\(\@2\ 
            \@\(\( - b\^2\) + r\^2\)\), 
      \(dr\ \@\(\( - b\^2\) + r\^2\)\)\/\(\@2\ 
            \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\) + 
        \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ d[t]\)\/\(\@2\ 
            \@\(\( - b\^2\) + r\^2\)\), 
      \(E\^\(-\(b\/r\)\)\ r\ d[\[Theta]]\)\/\@2 + 
        \(I\ E\^\(b/r\)\ r\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\@2, 
      \(E\^\(-\(b\/r\)\)\ r\ d[\[Theta]]\)\/\@2 - 
        \(I\ E\^\(b/r\)\ r\ d[\[CurlyPhi]]\ Sin[\[Theta]]\)\/\@2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dxTOe = 
      FacSimp[\(Solve[
            NPframe == {e[1], e[2], e[3], e[4]}, {d[t], d[r], d[\[Theta]], 
              d[\[CurlyPhi]]}]\)[\([1]\)]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({d[\[Theta]] \[Rule] 
        \(E\^\(b/r\)\ e[3]\)\/\(\@2\ r\) + \(E\^\(b/r\)\ e[4]\)\/\(\@2\ r\), 
      d[\[CurlyPhi]] \[Rule] 
        \(-\(\(I\ E\^\(-\(b\/r\)\)\ Csc[\[Theta]]\ e[3]\)\/\(\@2\ r\)\)\) + 
          \(I\ E\^\(-\(b\/r\)\)\ Csc[\[Theta]]\ e[4]\)\/\(\@2\ r\), 
      d[t] \[Rule] 
        \(\@\(\(-b\^2\) + r\^2\)\ e[1]\)\/\(\@2\ 
              \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\) + 
          \(\@\(\(-b\^2\) + r\^2\)\ e[2]\)\/\(\@2\ 
              \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\), 
      dr \[Rule] 
        \(-\(\(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[1]\)\/\(\@2\ 
                  \@\(\( - b\^2\) + r\^2\)\)\)\) + 
          \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[2]\)\/\(\@2\ 
              \@\(\( - b\^2\) + r\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dNPframeTOee = FacSimp[d[NPframe] /. dxTOe]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(-
        \(\(m\ \((b\^2 + r\^2)\)\ e[1]\[Wedge]e[2]\)\/\(\@2\ 
              \((\(-b\^2\) + r\^2)\)\^\(3/2\)\ 
              \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\)\)\), 
      \(-\(\(m\ \((b\^2 + r\^2)\)\ e[1]\[Wedge]e[2]\)\/\(\@2\ 
              \((\(-b\^2\) + r\^2)\)\^\(3/2\)\ 
              \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\)\)\), 
      \(-\(\(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[1]\[Wedge]e[3]\)\/\(\@2\ r\ 
                \@\(\( - b\^2\) + r\^2\)\)\)\) - 
        \(b\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ e[1]\[Wedge]e[4]\)\/\(\@2\ 
            r\^2\ \@\(\( - b\^2\) + r\^2\)\) + 
        \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[2]\[Wedge]e[3]\)\/\(\@2\ r\ 
            \@\(\( - b\^2\) + r\^2\)\) + 
        \(b\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ e[2]\[Wedge]e[4]\)\/\(\@2\ 
            r\^2\ \@\(\( - b\^2\) + r\^2\)\) - 
        \(E\^\(b/r\)\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\(\@2\ r\), 
      \(-\(\(b\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
                e[1]\[Wedge]e[3]\)\/\(\@2\ r\^2\ 
                \@\(\( - b\^2\) + r\^2\)\)\)\) - 
        \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[1]\[Wedge]e[4]\)\/\(\@2\ r\ 
            \@\(\( - b\^2\) + r\^2\)\) + 
        \(b\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ e[2]\[Wedge]e[3]\)\/\(\@2\ 
            r\^2\ \@\(\( - b\^2\) + r\^2\)\) + 
        \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[2]\[Wedge]e[4]\)\/\(\@2\ r\ 
            \@\(\( - b\^2\) + r\^2\)\) + 
        \(E\^\(b/r\)\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\(\@2\ r\)}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tFor implicit frame calculations, the user must define the global \
variables ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  ". For this problem, only the ",
  StyleBox["\[Theta]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["r",
    FontFamily->"Courier"],
  " differentials need to be included in ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " :"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \(\(deList = dNPframeTOee; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(\(dxTOe2 = Drop[dxTOe, {2, 3}]; \)\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dxRuleList = dxTOe2\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({d[\[Theta]] \[Rule] 
        \(E\^\(b/r\)\ e[3]\)\/\(\@2\ r\) + \(E\^\(b/r\)\ e[4]\)\/\(\@2\ r\), 
      dr \[Rule] 
        \(-\(\(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[1]\)\/\(\@2\ 
                  \@\(\( - b\^2\) + r\^2\)\)\)\) + 
          \(\@\(\(-b\^2\) - 2\ m\ r + r\^2\)\ e[2]\)\/\(\@2\ 
              \@\(\( - b\^2\) + r\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tOne should check that ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " is a set of closed 2-forms, giving the ",
  StyleBox["d[e[i]]",
    FontFamily->"Courier"],
  ":"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(checkClosure = 
      FacSimp[\(d[deList] /. d[e[i_]] :> deList[\([i]\)]\) /. dxRuleList] // 
        Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({1.18333333333339396`\ Second, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\t"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell["\t(1)  Exact calculation", "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"RGtensors", "[", 
      RowBox[{
        StyleBox[
          \({{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, \(-1\), 0}}
            \),
          FontFamily->"Courier"], ",", "xCoord", ",", \({e[]}\)}], "]"}]], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[\(2\ e[1]\ e[2] - 2\ e[3]\ e[4]\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              e[ 1], 
              e[ 2]], 
            Times[ -2, 
              e[ 3], 
              e[ 4]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0166666666666515084`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Warning: deList closure not tested"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.0666666666667197205`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Spin coefficients \[Tau], \[Kappa], \[Rho], \[Sigma], \[Gamma], \
\[Epsilon], \[Alpha], \[Beta], \[Nu], $\[Pi], \[Lambda], \[Mu] defined"\)], 
  "Print"],

Cell[BoxData[
    \("Differential Operators \[GothicCapitalD][x_], \[CapitalDelta][x_], \
\[Delta][x_], \[Delta]B[x_] defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.549999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.54999999999995453, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.133333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.13333333333332575, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.0666666666667197205`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.200000000000045474`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.20000000000004547, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("NP variables \[CapitalPhi][i,j], \[CapitalLambda] and \[CapitalPsi][i] \
defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.100000000000022737`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.10000000000002274, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.33333 seconds"\)], "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExactRdd = Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({{\(-
          \(\(b\^2\ \((b\^2 + 2\ m\ r - r\^2)\)\)\/\(\((b - r)\)\ r\^4\ \((
                b + r)\)\)\)\), 
        \(b\^2\ \((
            b\^6 + 2\ b\^4\ m\ r - 3\ b\^4\ r\^2 - 2\ b\^2\ m\ r\^3 + 
              3\ b\^2\ r\^4 + 8\ m\ r\^5 - r\^6)\)\)\/\(\((b - r)\)\^3\ r\^4\ 
            \((b + r)\)\^3\), 
        \(-\(\(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
                Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\)\)\), 
        \(-\(\(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
                Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\)\)\)}, {
        \(b\^2\ \((
            b\^6 + 2\ b\^4\ m\ r - 3\ b\^4\ r\^2 - 2\ b\^2\ m\ r\^3 + 
              3\ b\^2\ r\^4 + 8\ m\ r\^5 - r\^6)\)\)\/\(\((b - r)\)\^3\ r\^4\ 
            \((b + r)\)\^3\), 
        \(-\(\(b\^2\ \((b\^2 + 2\ m\ r - r\^2)\)\)\/\(\((b - r)\)\ r\^4\ \((
                b + r)\)\)\)\), 
        \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
            Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\), 
        \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
            Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\)}, {
        \(-\(\(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
                Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\)\)\), 
        \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
            Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\), 
        \(-\(\(2\ b\ m\ \((b\^2 + r\^2)\)\)\/\(\((b - r)\)\^2\ r\^2\ 
                \((b + r)\)\^2\)\)\), 
        \(\(-b\^4\) + b\^4\ E\^\(\(2\ b\)\/r\) - 4\ b\^2\ m\ r + 
            2\ b\^2\ r\^2 - 2\ b\^2\ E\^\(\(2\ b\)\/r\)\ r\^2 - r\^4 + 
            E\^\(\(2\ b\)\/r\)\ r\^4\)\/\(\((b - r)\)\^2\ r\^2\ 
            \((b + r)\)\^2\)}, {
        \(-\(\(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
                Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\)\)\), 
        \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
            Cot[\[Theta]]\)\/\(r\^3\ \@\(\( - b\^2\) + r\^2\)\), 
        \(\(-b\^4\) + b\^4\ E\^\(\(2\ b\)\/r\) - 4\ b\^2\ m\ r + 
            2\ b\^2\ r\^2 - 2\ b\^2\ E\^\(\(2\ b\)\/r\)\ r\^2 - r\^4 + 
            E\^\(\(2\ b\)\/r\)\ r\^4\)\/\(\((b - r)\)\^2\ r\^2\ 
            \((b + r)\)\^2\), 
        \(-\(\(2\ b\ m\ \((b\^2 + r\^2)\)\)\/\(\((b - r)\)\^2\ r\^2\ 
                \((b + r)\)\^2\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({\[CapitalPhi][0, 0], \[CapitalPhi][0, 2], \[CapitalPhi][1, 2]}\)], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({\(-
        \(\(b\^2\ \((b\^2 + 2\ m\ r - r\^2)\)\)\/\(2\ \((b - r)\)\ r\^4\ \((
              b + r)\)\)\)\), 
      \(-\(\(b\ m\ \((b\^2 + r\^2)\)\)\/\(\((b - r)\)\^2\ r\^2\ 
              \((b + r)\)\^2\)\)\), 
      \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
          Cot[\[Theta]]\)\/\(2\ r\^3\ \@\(\( - b\^2\) + r\^2\)\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExactPSI = \[CapitalPsi]/@{0, 1, 2, 3, 4}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0, 
      \(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
          Cot[\[Theta]]\)\/\(2\ r\^3\ \@\(\( - b\^2\) + r\^2\)\), 
      \(-\(1\/\(6\ \((b - r)\)\^3\ r\^4\ \((b + r)\)\^3\)\((
          2\ b\^8 + 4\ b\^6\ m\ r - 7\ b\^6\ r\^2 + 
            b\^6\ E\^\(\(2\ b\)\/r\)\ r\^2 - 8\ b\^4\ m\ r\^3 + 
            9\ b\^4\ r\^4 - 3\ b\^4\ E\^\(\(2\ b\)\/r\)\ r\^4 + 
            2\ b\^2\ m\ r\^5 - 5\ b\^2\ r\^6 + 
            3\ b\^2\ E\^\(\(2\ b\)\/r\)\ r\^6 - 6\ m\ r\^7 + r\^8 - 
            E\^\(\(2\ b\)\/r\)\ r\^8)\)\)\), 
      \(-\(\(b\ E\^\(b/r\)\ \@\(\( - b\^2\) - 2\ m\ r + r\^2\)\ 
              Cot[\[Theta]]\)\/\(2\ r\^3\ \@\(\( - b\^2\) + r\^2\)\)\)\), 0}
      \)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\n\)], "Input"],

Cell[CellGroupData[{

Cell["\t(1)  Approximate calculation", "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tAfter an implicit frame calculation, ",
  StyleBox["Clear$dx",
    FontFamily->"Courier"],
  " clears ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " and ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " also."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(deList = FacSimp[Series[dNPframeTOee, {r, Infinity, 3}]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[
          RowBox[{\(-\(\(m\ e[1]\[Wedge]e[2]\ \((1\/r)\)\^2\)\/\@2\)\), "+", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 2, 3, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 2, 
                Rational[ -1, 2]], m, 
              Wedge[ 
                e[ 1], 
                e[ 2]]]}, 2, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{\(-\(\(m\ e[1]\[Wedge]e[2]\ \((1\/r)\)\^2\)\/\@2\)\), "+", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 2, 3, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 2, 
                Rational[ -1, 2]], m, 
              Wedge[ 
                e[ 1], 
                e[ 2]]]}, 2, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(\(\(-\(\(e[1]\[Wedge]e[3]\)\/\@2\)\) + 
                  \(e[2]\[Wedge]e[3]\)\/\@2 - 
                  \(Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\@2\)\/r\), "+", 
            \(\((\(m\ e[1]\[Wedge]e[3]\)\/\@2 - 
                  \(b\ e[1]\[Wedge]e[4]\)\/\@2 - 
                  \(m\ e[2]\[Wedge]e[3]\)\/\@2 + 
                  \(b\ e[2]\[Wedge]e[4]\)\/\@2 - 
                  \(b\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\@2)\)\ 
              \((1\/r)\)\^2\), "+", 
            \(\((\(m\^2\ e[1]\[Wedge]e[3]\)\/\(2\ \@2\) + 
                  \(b\ m\ e[1]\[Wedge]e[4]\)\/\@2 - 
                  \(m\^2\ e[2]\[Wedge]e[3]\)\/\(2\ \@2\) - 
                  \(b\ m\ e[2]\[Wedge]e[4]\)\/\@2 - 
                  \(b\^2\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\(2\ \@2\))\)\ 
              \((1\/r)\)\^3\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Wedge[ 
                  e[ 1], 
                  e[ 3]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Wedge[ 
                  e[ 2], 
                  e[ 3]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]], 
            Plus[ 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], m, 
                Wedge[ 
                  e[ 1], 
                  e[ 3]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Wedge[ 
                  e[ 1], 
                  e[ 4]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], m, 
                Wedge[ 
                  e[ 2], 
                  e[ 3]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Wedge[ 
                  e[ 2], 
                  e[ 4]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]], 
            Plus[ 
              Times[ 
                Rational[ 1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ m, 2], 
                Wedge[ 
                  e[ 1], 
                  e[ 3]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], b, m, 
                Wedge[ 
                  e[ 1], 
                  e[ 4]]], 
              Times[ 
                Rational[ -1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ m, 2], 
                Wedge[ 
                  e[ 2], 
                  e[ 3]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], b, m, 
                Wedge[ 
                  e[ 2], 
                  e[ 4]]], 
              Times[ 
                Rational[ -1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ b, 2], 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]]}, 1, 4, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(\(\(-\(\(e[1]\[Wedge]e[4]\)\/\@2\)\) + 
                  \(e[2]\[Wedge]e[4]\)\/\@2 + 
                  \(Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\@2\)\/r\), "+", 
            \(\((\(-\(\(b\ e[1]\[Wedge]e[3]\)\/\@2\)\) + 
                  \(m\ e[1]\[Wedge]e[4]\)\/\@2 + 
                  \(b\ e[2]\[Wedge]e[3]\)\/\@2 - 
                  \(m\ e[2]\[Wedge]e[4]\)\/\@2 + 
                  \(b\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\@2)\)\ 
              \((1\/r)\)\^2\), "+", 
            \(\((\(b\ m\ e[1]\[Wedge]e[3]\)\/\@2 + 
                  \(m\^2\ e[1]\[Wedge]e[4]\)\/\(2\ \@2\) - 
                  \(b\ m\ e[2]\[Wedge]e[3]\)\/\@2 - 
                  \(m\^2\ e[2]\[Wedge]e[4]\)\/\(2\ \@2\) + 
                  \(b\^2\ Cot[\[Theta]]\ e[3]\[Wedge]e[4]\)\/\(2\ \@2\))\)\ 
              \((1\/r)\)\^3\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Plus[ 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Wedge[ 
                  e[ 1], 
                  e[ 4]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Wedge[ 
                  e[ 2], 
                  e[ 4]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]], 
            Plus[ 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Wedge[ 
                  e[ 1], 
                  e[ 3]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], m, 
                Wedge[ 
                  e[ 1], 
                  e[ 4]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Wedge[ 
                  e[ 2], 
                  e[ 3]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], m, 
                Wedge[ 
                  e[ 2], 
                  e[ 4]]], 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], b, 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]], 
            Plus[ 
              Times[ 
                Power[ 2, 
                  Rational[ -1, 2]], b, m, 
                Wedge[ 
                  e[ 1], 
                  e[ 3]]], 
              Times[ 
                Rational[ 1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ m, 2], 
                Wedge[ 
                  e[ 1], 
                  e[ 4]]], 
              Times[ -1, 
                Power[ 2, 
                  Rational[ -1, 2]], b, m, 
                Wedge[ 
                  e[ 2], 
                  e[ 3]]], 
              Times[ 
                Rational[ -1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ m, 2], 
                Wedge[ 
                  e[ 2], 
                  e[ 4]]], 
              Times[ 
                Rational[ 1, 2], 
                Power[ 2, 
                  Rational[ -1, 2]], 
                Power[ b, 2], 
                Cot[ \[Theta]], 
                Wedge[ 
                  e[ 3], 
                  e[ 4]]]]}, 1, 4, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(dxRuleList = 
      Map[Rule[#[\([1]\)], FacSimp[Series[#[\([2]\)], {r, Infinity, 3}]]]&, 
        dxTOe2]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{\(d[\[Theta]]\), "\[Rule]", 
          InterpretationBox[
            RowBox[{
            \(\(e[3]\/\@2 + e[4]\/\@2\)\/r\), "+", 
              \(\((\(b\ e[3]\)\/\@2 + \(b\ e[4]\)\/\@2)\)\ \((1\/r)\)\^2\), 
              "+", \(\((
                  \(b\^2\ e[3]\)\/\(2\ \@2\) + \(b\^2\ e[4]\)\/\(2\ \@2\))\)\ 
                \((1\/r)\)\^3\), "+", 
              InterpretationBox[\(O[1\/r]\^4\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, 1, 4, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  e[ 3]], 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  e[ 4]]], 
              Plus[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], b, 
                  e[ 3]], 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], b, 
                  e[ 4]]], 
              Plus[ 
                Times[ 
                  Rational[ 1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Power[ b, 2], 
                  e[ 3]], 
                Times[ 
                  Rational[ 1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Power[ b, 2], 
                  e[ 4]]]}, 1, 4, 1]]}], ",", 
        RowBox[{"dr", "\[Rule]", 
          InterpretationBox[
            RowBox[{
            \((\(-\(e[1]\/\@2\)\) + e[2]\/\@2)\), "+", 
              \(\(\(m\ e[1]\)\/\@2 - \(m\ e[2]\)\/\@2\)\/r\), "+", 
              \(\((\(m\^2\ e[1]\)\/\(2\ \@2\) - \(m\^2\ e[2]\)\/\(2\ \@2\))
                  \)\ \((1\/r)\)\^2\), "+", 
              \(\((\(m\ \((2\ b\^2 + m\^2)\)\ e[1]\)\/\(2\ \@2\) - 
                    \(m\ \((2\ b\^2 + m\^2)\)\ e[2]\)\/\(2\ \@2\))\)\ 
                \((1\/r)\)\^3\), "+", 
              InterpretationBox[\(O[1\/r]\^4\),
                SeriesData[ r, 
                  DirectedInfinity[ 1], {}, 0, 4, 1]]}],
            SeriesData[ r, 
              DirectedInfinity[ 1], {
              Plus[ 
                Times[ -1, 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  e[ 1]], 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  e[ 2]]], 
              Plus[ 
                Times[ 
                  Power[ 2, 
                    Rational[ -1, 2]], m, 
                  e[ 1]], 
                Times[ -1, 
                  Power[ 2, 
                    Rational[ -1, 2]], m, 
                  e[ 2]]], 
              Plus[ 
                Times[ 
                  Rational[ 1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Power[ m, 2], 
                  e[ 1]], 
                Times[ 
                  Rational[ -1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], 
                  Power[ m, 2], 
                  e[ 2]]], 
              Plus[ 
                Times[ 
                  Rational[ 1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], m, 
                  Plus[ 
                    Times[ 2, 
                      Power[ b, 2]], 
                    Power[ m, 2]], 
                  e[ 1]], 
                Times[ 
                  Rational[ -1, 2], 
                  Power[ 2, 
                    Rational[ -1, 2]], m, 
                  Plus[ 
                    Times[ 2, 
                      Power[ b, 2]], 
                    Power[ m, 2]], 
                  e[ 2]]]}, 0, 4, 1]]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(checkClosure = 
      FacSimp[\(d[deList] /. d[e[i_]] :> deList[\([i]\)]\) /. dxRuleList] // 
        Timing\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(1.75`\ Second\), ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 3, 3, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^3\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 3, 3, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["GenCoef[x_,y_]",
    FontFamily->"Courier"],
  " returns the correct series coefficient of y in x, when x is a series -- \
otherwise acts as ",
  StyleBox["FacSimp[Coefficient[x_,y_]]",
    FontFamily->"Courier"]
}], "Text",
  CellFrame->True,
  ShowGroupOpenCloseIcon->True,
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coefficient[deList, e[1]\[Wedge]e[3]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0, 0, m\^2\/\(2\ \@2\ r\^3\) + m\/\(\@2\ r\^2\) - 1\/\(\@2\ r\), 
      \(b\ m\)\/\(\@2\ r\^3\) - b\/\(\@2\ r\^2\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[deList, e[1]\[Wedge]e[3]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(O[1\/r]\^3\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 3, 3, 1]], ",", 
        InterpretationBox[\(O[1\/r]\^3\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 3, 3, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(-\(1\/\(\@2\ r\)\)\), "+", \(\(m\ \((1\/r)\)\^2\)\/\@2\), "+", 
            \(\(m\^2\ \((1\/r)\)\^3\)\/\(2\ \@2\)\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 1, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 2, 
                Rational[ -1, 2]]], 
            Times[ 
              Power[ 2, 
                Rational[ -1, 2]], m], 
            Times[ 
              Rational[ 1, 2], 
              Power[ 2, 
                Rational[ -1, 2]], 
              Power[ m, 2]]}, 1, 4, 1]], ",", 
        InterpretationBox[
          RowBox[{
          \(-\(\(b\ \((1\/r)\)\^2\)\/\@2\)\), "+", 
            \(\(b\ m\ \((1\/r)\)\^3\)\/\@2\), "+", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 2, 4, 1]]}],
          SeriesData[ r, 
            DirectedInfinity[ 1], {
            Times[ -1, 
              Power[ 2, 
                Rational[ -1, 2]], b], 
            Times[ 
              Power[ 2, 
                Rational[ -1, 2]], b, m]}, 2, 4, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FacSimp[%%]\)], "Input"],

Cell[BoxData[
    \({0, 0, \(m\^2 + 2\ m\ r - 2\ r\^2\)\/\(2\ \@2\ r\^3\), 
      \(b\ \((m - r)\)\)\/\(\@2\ r\^3\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenCoef[Normal[deList], e[1]\[Wedge]e[3]]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \({0, 0, \(m\^2 + 2\ m\ r - 2\ r\^2\)\/\(2\ \@2\ r\^3\), 
      \(b\ \((m - r)\)\)\/\(\@2\ r\^3\)}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"RGtensors", "[", 
      RowBox[{
        StyleBox[
          \({{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, \(-1\), 0}}
            \),
          FontFamily->"Courier"], ",", "xCoord", ",", \({e[]}\)}], "]"}]], 
  "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[\(2\ e[1]\ e[2] - 2\ e[3]\ e[4]\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 2, 
              e[ 1], 
              e[ 2]], 
            Times[ -2, 
              e[ 3], 
              e[ 4]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", GridBox[{
                {"0", "1", "0", "0"},
                {"1", "0", "0", "0"},
                {"0", "0", "0", \(-1\)},
                {"0", "0", \(-1\), "0"}
                }], ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[
         {{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, -1}, {0, 0, -1, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.0333333333333030168`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Warning: deList closure not tested"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Spin coefficients \[Tau], \[Kappa], \[Rho], \[Sigma], \[Gamma], \
\[Epsilon], \[Alpha], \[Beta], \[Nu], $\[Pi], \[Lambda], \[Mu] defined"\)], 
  "Print"],

Cell[BoxData[
    \("Differential Operators \[GothicCapitalD][x_], \[CapitalDelta][x_], \
\[Delta][x_], \[Delta]B[x_] defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.150000000000090949`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.15000000000009095, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.0666666666666060336`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.116666666666674245`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("NP variables \[CapitalPhi][i,j], \[CapitalLambda] and \[CapitalPsi][i] \
defined"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.85 seconds"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear$dx\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \("deList and dxRuleList also cleared"\)], "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExactRdd - Rdd\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
            InterpretationBox[\(O[1\/r]\^4\),
              SeriesData[ r, 
                DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}]}], "}"}]], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tThe function ",
  StyleBox["zeroQ[]",
    FontFamily->"Courier"],
  " ignores ",
  Cell[BoxData[
      \(O[1\/r]\^n\)]],
  " terms:"
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[%]\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExactPSI - \[CapitalPsi]/@{0, 1, 2, 3, 4}\)], "Input",
  FontColor->GrayLevel[0.333333]],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 4, 4, 1]], ",", 
        InterpretationBox[\(O[1\/r]\^4\),
          SeriesData[ r, 
            DirectedInfinity[ 1], {}, 4, 4, 1]]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.0 (or higher) has better handling of SeriesData objects. As a result it \
returns ",
  Cell[BoxData[
      InterpretationBox[\(O[1\/r]\^5\),
        SeriesData[ r, 
          DirectedInfinity[ 1], {}, 5, 5, 1]]]],
  " for all elements in the last two lists."
}], "Text",
  FontSize->16,
  FontColor->RGBColor[0, 0, 1]]
}, Closed]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tIf only ",
  StyleBox["deList",
    FontFamily->"Courier"],
  " is expanded, ",
  StyleBox["RGtensors",
    FontFamily->"Courier"],
  " takes ~20% longer, while if only ",
  StyleBox["dxRuleList",
    FontFamily->"Courier"],
  " is expanded, it takes ~100% longer!"
}], "Text",
  FontSize->16]
}, Closed]]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[" 7  Classification of Weyl and Ricci Tensors",
  FontWeight->"Bold"]], "Section",
  ShowGroupOpenCloseIcon->True,
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "\tBeginning with RGTC version 3.6.5, the new function ",
  StyleBox["Classify[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " carries out the Petrov-Penrose classification when ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 4th-rank tensor with the symmetries of the Weyl tensor (Wdddd), and \
the Plebanski-Segre classification when ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is a 2nd-rank symmetric tensor (Rdd). ",
  StyleBox["Classify is defined for 4-dimensional spaces only",
    FontSlant->"Italic"],
  ". Classify tests that the given tensor has the correct symmetry for its \
rank before classifying it. ",
  StyleBox["The tensors must be given with all indices covariant (down)",
    FontSlant->"Italic"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "Classify[Wdddd] prints the Petrov-Penrose type (",
  StyleBox["I, II, IID, III, N, O",
    FontFamily->"Courier"],
  ") and returns a list containing one of the numbers (",
  StyleBox["1111, 211, 22, 31, 4, 0",
    FontFamily->"Courier"],
  ") describing the alignment of principal null directions."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "Classify[Rdd] prints the correponding Segre type (in the notation of the ",
  
  ButtonBox["Exact Solutions Book",
    ButtonData:>"ExactSolBook",
    ButtonStyle->"Hyperlink"],
  ") and additional information if Rdd is traceless, has zero as an \
eigenvalue, or corresponds to a physical energy momentum tensor. As the \
complete Plebanski-Segre classification requires, in some cases, deciding \
whether an expression is positive or negative (real or complex eigenvalues, \
timelike or spacelike character of eigenvectors), it cannot be carried out \
completely on a computer. Thus Classify[Rdd] will print multiple Segre types \
in such cases."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "Classify[Rdd] returns a symbol indicating the highest root multiplicity \
and the degree and structure of the minimal polynomial. The first part of the \
symbol is a roman numeral (as in the Petrov-Penrose case) indicating the root \
multiplicity. Next is the letter M -- minimal -- followed by an integer, ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", indicating the degree of the minimal polynomial (except when the minimal \
polynomial coincides with the characteristic polynomial in which case the \
letter G -- general -- is used). Finally, in parenthesis, there are ",
  StyleBox["n",
    FontSlant->"Italic"],
  " digits (0's or 1's), which correspond to the coefficients ",
  Cell[BoxData[
      \(c\_k\)]],
  " of different powers in the minimal polynomial: ",
  Cell[BoxData[
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              InterpretationBox[\(x\^n\),
                Superscript[ x, n],
                Editable->False], "-", \(\(c\_\(n - 1\)\) x\^\(n - 1\)\), "-",
               \(\(c\_\(n - 2\)\) x\^\(n - 2\)\), "-"}], "..."}], "-", 
          RowBox[{\(c\_0\), " ", 
            InterpretationBox[\(x\^0\),
              Superscript[ x, 0],
              Editable->False]}]}], "=", "0"}]]],
  ". A zero digit signifies that the corresponding coefficient vanishes. The  \
following examples explain the notation:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  "The symbol ",
  StyleBox["II-M3(010)",
    FontFamily->"Courier"],
  " means there is one double root (II), the minimal polynomial is cubic (M3) \
and has the form ",
  Cell[BoxData[
      \(x\^3 - \(c\_1\) x = 0\)]],
  ", i.e., the coefficients ",
  Cell[BoxData[
      \(c\_2\)]],
  " and ",
  Cell[BoxData[
      \(c\_0\)]],
  " vanish (010)."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "The symbol ",
  StyleBox["IID-M3(011)",
    FontFamily->"Courier"],
  " means there are two double roots (IID), the minimal polynomial is cubic \
(M3) and has the form ",
  Cell[BoxData[
      \(x\^3 - \(c\_1\) x - c\_0 = 0\)]],
  ", i.e., the coefficient ",
  Cell[BoxData[
      \(c\_2\)]],
  " vanishes (011)."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "The symbol ",
  StyleBox["II-G(0100)",
    FontFamily->"Courier"],
  " means there is one double root (II), the minimal polynomial is quartic \
(G) and has the form ",
  Cell[BoxData[
      \(x\^4 - \(c\_2\) x\^2 = 0\)]],
  ", i.e., the coefficients ",
  Cell[BoxData[
      \(c\_\(\(3, \)\ \)\)]],
  Cell[BoxData[
      \(c\_\(1\ \)\)]],
  "and ",
  Cell[BoxData[
      \(c\_0\)]],
  " vanish (0100)."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "The symbol ",
  StyleBox["IV-M2(01)",
    FontFamily->"Courier"],
  " means there is a quadruple root (IV), the minimal polynomial is quadratic \
(M2) and has the form ",
  Cell[BoxData[
      \(x\^2 - c\_0 = 0\)]],
  ", i.e., the coefficient ",
  Cell[BoxData[
      \(c\_1\)]],
  " vanishes (01)."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "The different combinations of non-vanishing coefficients (for the same \
root multiplicity and polynomial degree) define invariant subclasses for each \
Segre type: they imply algebraic relations between the eigenvalues",
  StyleBox[" ",
    FontSlant->"Italic"],
  "which do not change the multiplicity. Note that, unlike the root \
multiplicity and the degree of the minimal polynomial, the digits in \
parenthesis can change when a term proportional to the metric is added to \
Rdd. Thus, to classify the energy-momentum tensor, one must use \
Classify[Rdd-1/2R gdd] or Classify[gdd.EUd]. And, of course, the minimal \
polynomial for a tensor Tdd translates to a matrix identity relating \
different powers of the 4x4 matrix TUd=gUU.Tdd."
}], "Text",
  FontSize->16]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Another new (in version 3.6.5) function is ",
  StyleBox["Plebanski[x_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which constructs the Plebanski tensor (4th-rank covariant tensor \
quadratic in ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " with the symmetries and trace properties of the Weyl tensor) associated \
to the symmetric covariant 2nd-rank tensor ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Plebanski",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is defined for any space dimension. ",
  StyleBox["Plebanski",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is also defined with two symmetric tensors as arguments: ",
  StyleBox["Plebanski[x_,y_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the unique 4th-rank covariant tensor bilinear and symmetric in ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " with the symmetries and trace properties of the Weyl tensor. The \
definition of P(X,Y) in terms of components is:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[TextData[{
  Cell[BoxData[
      \(\(\(P\_abcd\) \((X, Y)\) = 
        \(X\_ac\) Y\_bd - \(X\_bc\) Y\_ad - \(X\_ad\) Y\_bc + 
          \(X\_bd\) Y\_ac + 
          \(1\/\(n - 2\)\) 
            \((\(g\_ac\) Z\_bd - \(g\_bc\) Z\_ad - \(g\_ad\) Z\_bc + 
                \(g\_bd\) Z\_ac)\) + 
          \(2\/\(\((n - 1)\) \((n - 2)\)\)\) 
            \((X\ Y - \(\(X\^e\)\_f\) \(Y\^f\)\_e)\) 
            \((\(g\_ac\) g\_bd - \(g\_bc\) g\_ad)\), \)\)]],
  "\nwhere ",
  Cell[BoxData[
      \(Z\_ab = 
        \(X\_af\) \(Y\^f\)\_b + \(Y\_af\) \(X\^f\)\_b - X\ Y\_ab - Y\ X\_ab, 
      \ X = \(X\^a\)\_a, \ Y = \(Y\^a\)\_a\)]],
  ",. When ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "=",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "  ",
  StyleBox["Plebanski",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " satisfies the identity ",
  StyleBox["Plebanski[x,x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "=2*",
  StyleBox["Plebanski[x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", while when ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (or ",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ") is the metric tensor ",
  StyleBox["Plebanski[x,g]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " vanishes."
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[{
  "In 4 dimensions, if ",
  StyleBox["y",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is the square of the ",
  StyleBox["traceless part",
    FontSlant->"Italic"],
  " of ",
  StyleBox["x",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", then ",
  StyleBox["Plebanski[x,y]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is identically zero as follows from the 3rd order tensor identity \
discussed in ",
  ButtonBox["this artticle",
    ButtonData:>{
      URL[ "http://www.springerlink.com/content/n2j492qh6pn1172m/"], None},
    ButtonStyle->"Hyperlink"],
  ". For example:"
}], "Text",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[BoxData[
    \(Dim = 4; gdd = DiagonalMatrix[{\(-1\), 1, 1, 1}]; gUU = gdd; \)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[i_, j_] := s[j, i] /; i > j; SS = Array[s, {4, 4}]\)], "Input"],

Cell[BoxData[
    \({{s[1, 1], s[1, 2], s[1, 3], s[1, 4]}, {s[1, 2], s[2, 2], s[2, 3], 
        s[2, 4]}, {s[1, 3], s[2, 3], s[3, 3], s[3, 4]}, {s[1, 4], s[2, 4], 
        s[3, 4], s[4, 4]}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(SS0 = SS - tr[SS.gUU]/4  gdd; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroQ[Plebanski[SS, SS0.gUU.SS0]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[TextData[{
  "Both ",
  StyleBox["Classify",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Plebanski",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " use the metric ",
  StyleBox["gdd",
    FontWeight->"Bold"],
  ", ",
  StyleBox["gUU",
    FontWeight->"Bold"],
  " (and ",
  StyleBox["eta[..]",
    FontWeight->"Bold"],
  " for the Weyl classification) defined by ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " to raise indices, construct duals or form tensor products. Thus, these \
functions must be defined separately if one wishes to classify a particular \
Weyl- or Ricci-like tensor without calling ",
  StyleBox["RGtensors",
    FontWeight->"Bold"],
  " (see the preliminary definitions in the \"Canonical Forms\" section of \
the examples). "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "In the examples below, use is made of a new auxiliary function defined in \
version 3.6.5 (see Section 4.2), ",
  StyleBox["metric[ds2_, xIN_]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which constructs the metric tensor from the line element (ds2) and the \
list of coordinates or coframe (xIN). All calculations are carried out in the \
coordinate frame, as the classification algorithm does not depend on \
relations between components in a particular frame (e.g., NP frame). Use of \
an appropriate frame in each case would speed up the calculations \
considerably! "
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"  Examples from the Exact Solutions Book (Second Edition)",
  FontWeight->"Bold"]], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->18,
  FontWeight->"Plain"],

Cell[TextData[{
  "The examples are referred to by their equation number in the book: H \
Stephani, D. Kramer, M. A. H. MacCallum, C. Hoenselaers, E. Herlt, ",
  StyleBox["Exact Solutions of Einstein's Field Equations",
    FontSlant->"Italic"],
  ", Second Edition, Cambridge University Press, 2003."
}], "Text",
  FontSize->16,
  CellTags->"ExactSolBook"],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  7.1  Canonical Forms of the Ricci Tensor (Eq. 5.3a - 5.3d)"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell["Preliminary definitions", "Subsubsection",
  FontSize->14],

Cell["\<\
To classify a given tensor we must first define the global \
variables gdd, gUU and Dim (the space dimension). As the canonical forms are \
given with respect to unit vectors in an orthonormal frame, we define  \
\>", 
  "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dim = 4; gdd = DiagonalMatrix[{1, 1, 1, \(-1\)}]\)], "Input"],

Cell[BoxData[
    \({{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, \(-1\)}}\)], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(gUU = gdd; \)\)], "Input"],

Cell["\<\
We also need the definition of eta[..], to be able to classify the \
Weyl tensor.\
\>", "Text",
  FontSize->16],

Cell[BoxData[
    \(eta[] := \(eta[] = Array[Signature[{##}]&, Table[4, {4}]]\); 
    eta[a__] := \(eta[a] = Raise[eta[], a]\); \)], "Input"],

Cell["\<\
To construct the canonical forms, we need to define unit (or \
special null) vectors along the frame axes and the operation of symmetric \
tensor product of 2 vectors (SymProd[x_, y_]).\
\>", "Text",
  FontSize->16],

Cell[BoxData[
    \(Xd = {1, 0, 0, 0}; Yd = {0, 1, 0, 0}; Zd = {0, 0, 1, 0}; 
    Ud = {0, 0, 0, 1}; \)], "Input"],

Cell[BoxData[
    \(Kd = \((Ud - Zd)\)/Sqrt[2]; Ld = \((Ud + Zd)\)/Sqrt[2]; \)], "Input"],

Cell[BoxData[
    \(SymProd[x_, y_] := \((Outer[Times, x, y] + Outer[Times, y, x])\)/2\)], 
  "Input"],

Cell[BoxData[
    \(\(Clear[A1, A2, A3, B, \[Lambda]]; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["A1 class (5.3a)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(A1 = 
      \[Lambda][1]*SymProd[Xd, Xd] + \[Lambda][2]*SymProd[Yd, Yd] + 
        \[Lambda][3]*SymProd[Zd, Zd] - \[Lambda][4]*SymProd[Ud, Ud]\)], 
  "Input"],

Cell[BoxData[
    \({{\[Lambda][1], 0, 0, 0}, {0, \[Lambda][2], 0, 0}, {0, 0, \[Lambda][3], 
        0}, {0, 0, 0, \(-\[Lambda][4]\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A1]\)], "Input"],

Cell[BoxData[
    \("Segre [111,1] or [11,Z\!\(\*OverscriptBox[\"Z\", \"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("I-G(1111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A1 /. \[Lambda][1] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [11(1,1)] or [(11)1,1] or [(11),Z\!\(\*OverscriptBox[\"Z\", \
\"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("II-M3(111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(A1 /. \[Lambda][1] \[Rule] \[Lambda][2]\) /. 
        \[Lambda][3] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(A1 /. \[Lambda][1] \[Rule] \[Lambda][2]\) /. 
        \[Lambda][3] \[Rule] \[Lambda][4]]\)], "Input"],

Cell[BoxData[
    \("Segre [(11)(1,1)]"\)], "Print"],

Cell[BoxData[
    \("IID-M2(11)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(\(A1 /. \[Lambda][1] \[Rule] \[Lambda][2]\) /. 
          \[Lambda][4] \[Rule] \(-\[Lambda][2]\)\) /. 
        \[Lambda][3] \[Rule] \(-\[Lambda][2]\)]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [(11)(1,1)] (Non-Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IID-M2(01)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A1 /. \[Lambda][_] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [(111,1)] (Lamda Term)"\)], "Print"],

Cell[BoxData[
    \("IV-M1(1)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A1 /. \[Lambda][_] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(111,1)] (Vacuum)"\)], "Print"],

Cell[BoxData[
    \("IV-M1(0)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A2 class (5.3b)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(A2 = 
      \[Lambda][1]*SymProd[Xd, Xd] + \[Lambda][2]*SymProd[Yd, Yd] + 
        \[Lambda][3]*SymProd[Kd, Ld] + 
        \[Lambda][4]*\((SymProd[Kd, Kd] - SymProd[Ld, Ld])\)\)], "Input"],

Cell[BoxData[
    \({{\[Lambda][1], 0, 0, 0}, {0, \[Lambda][2], 0, 0}, {0, 0, 
        \(-\(\[Lambda][3]\/2\)\), \(-\[Lambda][4]\)}, {0, 0, 
        \(-\[Lambda][4]\), \[Lambda][3]\/2}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A2]\)], "Input"],

Cell[BoxData[
    \("Segre [111,1] or [11,Z\!\(\*OverscriptBox[\"Z\", \"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("I-G(1111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A2 /. \[Lambda][1] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [11(1,1)] or [(11)1,1] or [(11),Z\!\(\*OverscriptBox[\"Z\", \
\"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("II-M3(111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(A2 /. \[Lambda][1] \[Rule] \[Lambda][2]\) /. 
        \[Lambda][3] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [11(1,1)] or [(11)1,1] or [(11),Z\!\(\*OverscriptBox[\"Z\", \
\"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("II-M3(011)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(\(A2 /. \[Lambda][1] \[Rule] 0\) /. \[Lambda][2] \[Rule] 0\) /. 
        \[Lambda][3] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Double 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [11(1,1)] or [(11)1,1] or [(11),Z\!\(\*OverscriptBox[\"Z\", \
\"_\"]\)]"\)], "Print"],

Cell[BoxData[
    \("II-M3(010)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["A3 class (5.3c)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(A3 = 
      \[Lambda][1]*SymProd[Xd, Xd] + \[Lambda][2]*SymProd[Yd, Yd] - 
        2  \[Lambda][3]*SymProd[Kd, Ld] + \((SymProd[Kd, Kd])\)\)], "Input"],

Cell[BoxData[
    \({{\[Lambda][1], 0, 0, 0}, {0, \[Lambda][2], 0, 0}, {0, 0, 
        1\/2 + \[Lambda][3], \(-\(1\/2\)\)}, {0, 0, \(-\(1\/2\)\), 
        1\/2 - \[Lambda][3]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A3]\)], "Input"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(1111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A3 /. \[Lambda][1] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [(11),2]"\)], "Print"],

Cell[BoxData[
    \("IID-M3(111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A3 /. \[Lambda][3] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [1(1,2)]"\)], "Print"],

Cell[BoxData[
    \("III-M3(111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(A3 /. \[Lambda][3] \[Rule] \[Lambda][1]\) /. 
        \[Lambda][2] \[Rule] \[Lambda][1]]\)], "Input"],

Cell[BoxData[
    \("Segre [(11,2)]"\)], "Print"],

Cell[BoxData[
    \("IV-M2(11)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tr[A3.gUU]\)], "Input"],

Cell[BoxData[
    \(\[Lambda][1] + \[Lambda][2] + 2\ \[Lambda][3]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      A3 /. \[Lambda][3] \[Rule] \(-\((\[Lambda][1] + \[Lambda][2])\)\)/2]\)],
   "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(0111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[A3 /. \[Lambda][_] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(11,2)] (Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IV-M2(00)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["B class (5.3d)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(B = 
      \[Lambda][1]*SymProd[Xd, Xd] + \[Lambda][2]*SymProd[Yd, Yd] + 
        \[Lambda][3]*SymProd[Kd, Ld] + \((SymProd[Kd, Xd])\)\)], "Input"],

Cell[BoxData[
    \({{\[Lambda][1], 0, \(-\(1\/\(2\ \@2\)\)\), 1\/\(2\ \@2\)}, {0, 
        \[Lambda][2], 0, 0}, {\(-\(1\/\(2\ \@2\)\)\), 0, 
        \(-\(\[Lambda][3]\/2\)\), 0}, {1\/\(2\ \@2\), 0, 0, \[Lambda][3]\/2}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B]\)], "Input"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(1111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B /. \[Lambda][3] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Double 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(1100)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B /. \[Lambda][1] \[Rule] \[Lambda][2]]\)], "Input"],

Cell[BoxData[
    \("Segre [(11),2]"\)], "Print"],

Cell[BoxData[
    \("IID-M3(111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B /. \[Lambda][_] \[Rule] \[Lambda][1]]\)], "Input"],

Cell[BoxData[
    \("Segre [(11),2]"\)], "Print"],

Cell[BoxData[
    \("IID-M3(011)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(tr[B.gUU]\)], "Input"],

Cell[BoxData[
    \(\[Lambda][1] + \[Lambda][2] - \[Lambda][3]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B /. \[Lambda][3] \[Rule] \[Lambda][1] + \[Lambda][2]]\)], 
  "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(0111)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(B /. \[Lambda][1] \[Rule] \(-\[Lambda][2]\)\) /. 
        \[Lambda][3] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Double 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [11,2]"\)], "Print"],

Cell[BoxData[
    \("II-G(0100)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(\(B /. \[Lambda][1] \[Rule] 0\) /. \[Lambda][2] \[Rule] 0\) /. 
        \[Lambda][3] \[Rule] 1]\)], "Input"],

Cell[BoxData[
    \("Double 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(11),2]"\)], "Print"],

Cell[BoxData[
    \("IID-M3(110)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[
      \(B /. \[Lambda][1] \[Rule] \[Lambda][2]\) /. \[Lambda][3] \[Rule] 0]
      \)], "Input"],

Cell[BoxData[
    \("Double 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(11),2]"\)], "Print"],

Cell[BoxData[
    \("IID-M3(100)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"checkMatrixIdentity", "=", 
      RowBox[{"Factor", "[", 
        RowBox[{
          RowBox[{
            RowBox[{\(MM.MM.MM - c[2] MM.MM\), "/.", 
              StyleBox[\(MM -> B.gUU\),
                FontColor->RGBColor[0, 0, 1]]}], "/.", 
            \(\[Lambda][1] \[Rule] \[Lambda][2]\)}], "/.", 
          \(\[Lambda][3] \[Rule] 0\)}], "]"}]}]], "Input"],

Cell[BoxData[
    \({{\(-\((c[2] - \[Lambda][2])\)\)\ \[Lambda][2]\^2, 0, 
        \(\((c[2] - \[Lambda][2])\)\ \[Lambda][2]\)\/\(2\ \@2\), 
        \(\((c[2] - \[Lambda][2])\)\ \[Lambda][2]\)\/\(2\ \@2\)}, {0, 
        \(-\((c[2] - \[Lambda][2])\)\)\ \[Lambda][2]\^2, 0, 0}, {
        \(\((c[2] - \[Lambda][2])\)\ \[Lambda][2]\)\/\(2\ \@2\), 0, 
        1\/8\ \((\(-c[2]\) + \[Lambda][2])\), 
        1\/8\ \((\(-c[2]\) + \[Lambda][2])\)}, {
        \(-\(\(\((c[2] - \[Lambda][2])\)\ \[Lambda][2]\)\/\(2\ \@2\)\)\), 0, 
        1\/8\ \((c[2] - \[Lambda][2])\), 1\/8\ \((c[2] - \[Lambda][2])\)}}\)],
   "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. c[2] -> \[Lambda][2]\)], "Input"],

Cell[BoxData[
    \({{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[B /. \[Lambda][_] \[Rule] 0]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(1,3)]"\)], "Print"],

Cell[BoxData[
    \("IV-M3(000)"\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  7.2  Perfect Fluids"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[" Petrov-Type I (Eq. 21.59 -- Corrected)", "Subsubsection",
  FontSize->14],

Cell["\<\
The metric is incorrect as printed in the book. The correct form is \
given here.  \
\>", "Text",
  FontSize->16,
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((d[t] - 2  b\ y\ d[ph]/a)\)^2/x - 
        x \((1 - al)\)^2  Exp[\(-y\)] 
          \((d[x]^2/\((a\ x^2 - b^2)\) + 
              \(d[y]^2/a\)/\((y + al \((Exp[\(-y\)] - 1)\))\))\) - 
        4  x \((y + al \((Exp[\(-y\)] - 1)\))\) d[ph]^2/a\)], "Input"],

Cell[BoxData[
    \(\(-\(\(4\ x\ \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)\)\ 
              d[ph]\^2\)\/a\)\) + 
      \((\(-\(\(2\ b\ y\ d[ph]\)\/a\)\) + d[t])\)\^2\/x - 
      \((1 - al)\)\^2\ \[ExponentialE]\^\(-y\)\ x\ 
        \((d[x]\^2\/\(\(-b\^2\) + a\ x\^2\) + 
            d[y]\^2\/\(a\ 
                \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)\)\))\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {t, x, y, ph}\)], "Input"],

Cell[BoxData[
    \({t, x, y, ph}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{1\/x, 0, 0, \(-\(\(2\ b\ y\)\/\(a\ x\)\)\)}, {0, 
        \(-\(\(\((1 - al)\)\^2\ \[ExponentialE]\^\(-y\)\ x\)\/\(\(-b\^2\) + 
                a\ x\^2\)\)\), 0, 0}, {0, 0, 
        \(-\(\(\((1 - al)\)\^2\ \[ExponentialE]\^\(-y\)\ x\)\/\(a\ 
                \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)\)\)\)\), 
        0}, {\(-\(\(2\ b\ y\)\/\(a\ x\)\)\), 0, 0, 
        1\/2\ \((
            \(8\ b\^2\ y\^2\)\/\(a\^2\ x\) - 
              \(8\ x\ \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)
                    \)\)\/a)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(1\/x\), "0", "0", \(-\(\(2\ b\ y\)\/\(a\ x\)\)\)},
               
                 {"0", \(-
                    \(\(\((1 - al)\)\^2\ \[ExponentialE]\^\(-y\)\ x
                          \)\/\(\(-b\^2\) + a\ x\^2\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(\((1 - al)\)\^2\ \[ExponentialE]\^\(-y\)\ x\)\/\(a\ 
                          \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)
                            \)\)\)\), "0"},
               
                 {\(-\(\(2\ b\ y\)\/\(a\ x\)\)\), "0", "0", 
                  \(1\/2\ \((
                      \(8\ b\^2\ y\^2\)\/\(a\^2\ x\) - 
                        \(8\ x\ 
                            \((al\ \((\(-1\) + \[ExponentialE]\^\(-y\))\) + y)
                              \)\)\/a)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Power[ x, -1], 0, 0, 
          Times[ -2, 
            Power[ a, -1], b, 
            Power[ x, -1], y]}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -1, al]], 2], 
            Power[ E, 
              Times[ -1, y]], x, 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ b, 2]], 
                Times[ a, 
                  Power[ x, 2]]], -1]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ a, -1], 
            Power[ 
              Plus[ 1, 
                Times[ -1, al]], 2], 
            Power[ E, 
              Times[ -1, y]], x, 
            Power[ 
              Plus[ 
                Times[ al, 
                  Plus[ -1, 
                    Power[ E, 
                      Times[ -1, y]]]], y], -1]], 0}, {
          Times[ -2, 
            Power[ a, -1], b, 
            Power[ x, -1], y], 0, 0, 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Times[ 8, 
                Power[ a, -2], 
                Power[ b, 2], 
                Power[ x, -1], 
                Power[ y, 2]], 
              Times[ -8, 
                Power[ a, -1], x, 
                Plus[ 
                  Times[ al, 
                    Plus[ -1, 
                      Power[ E, 
                        Times[ -1, y]]]], y]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(4\ \[ExponentialE]\^\(-y\)\ 
                    \((a\ al\ x\^2 - a\ al\ \[ExponentialE]\^y\ x\^2 + 
                        a\ \[ExponentialE]\^y\ x\^2\ y - 
                        b\^2\ \[ExponentialE]\^y\ y\^2)\)\ 
                    d[ph]\^2\)\/\(a\^2\ x\)\)\) - 
            \(4\ b\ y\ d[ph]\ d[t]\)\/\(a\ x\) + d[t]\^2\/x + 
            \(\((\(-1\) + al)\)\^2\ \[ExponentialE]\^\(-y\)\ x\ 
                d[x]\^2\)\/\(b\^2 - a\ x\^2\) + 
            \(\((\(-1\) + al)\)\^2\ x\ d[y]\^2\)\/\(a\ 
                \((\(-al\) + al\ \[ExponentialE]\^y - \[ExponentialE]\^y\ y)
                  \)\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -4, 
              Power[ a, -2], 
              Power[ E, 
                Times[ -1, y]], 
              Power[ x, -1], 
              Plus[ 
                Times[ a, al, 
                  Power[ x, 2]], 
                Times[ -1, a, al, 
                  Power[ E, y], 
                  Power[ x, 2]], 
                Times[ a, 
                  Power[ E, y], 
                  Power[ x, 2], y], 
                Times[ -1, 
                  Power[ b, 2], 
                  Power[ E, y], 
                  Power[ y, 2]]], 
              Power[ 
                d[ ph], 2]], 
            Times[ -4, 
              Power[ a, -1], b, 
              Power[ x, -1], y, 
              d[ ph], 
              d[ t]], 
            Times[ 
              Power[ x, -1], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, al], 2], 
              Power[ E, 
                Times[ -1, y]], x, 
              Power[ 
                Plus[ 
                  Power[ b, 2], 
                  Times[ -1, a, 
                    Power[ x, 2]]], -1], 
              Power[ 
                d[ x], 2]], 
            Times[ 
              Power[ a, -1], 
              Power[ 
                Plus[ -1, al], 2], x, 
              Power[ 
                Plus[ 
                  Times[ -1, al], 
                  Times[ al, 
                    Power[ E, y]], 
                  Times[ -1, 
                    Power[ E, y], y]], -1], 
              Power[ 
                d[ y], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\(\(-a\)\ al\ x\^2 + a\ al\ \[ExponentialE]\^y\ x\^2 - 
                        a\ \[ExponentialE]\^y\ x\^2\ y + 
                        b\^2\ \[ExponentialE]\^y\ y\^2\)\/\(a\ x\ 
                        \((\(-al\) + al\ \[ExponentialE]\^y - 
                            \[ExponentialE]\^y\ y)\)\)\), "0", "0", 
                  \(\(b\ \[ExponentialE]\^y\ y\)\/\(2\ x\ 
                        \((\(-al\) + al\ \[ExponentialE]\^y - 
                            \[ExponentialE]\^y\ y)\)\)\)},
               
                 {"0", \(-
                    \(\(\[ExponentialE]\^y\ 
                          \((\(-b\^2\) + a\ x\^2)\)\)\/\(\((\(-1\) + al)\)\^2
                            \ x\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\(a\ \((
                          \(-al\) + al\ \[ExponentialE]\^y - 
                            \[ExponentialE]\^y\ y)\)\)\/\(\((\(-1\) + al)\)\^2
                          \ x\)\), "0"},
               
                 {\(\(b\ \[ExponentialE]\^y\ y\)\/\(2\ x\ 
                        \((\(-al\) + al\ \[ExponentialE]\^y - 
                            \[ExponentialE]\^y\ y)\)\)\), "0", "0", 
                  \(\(a\ \[ExponentialE]\^y\)\/\(4\ x\ 
                        \((\(-al\) + al\ \[ExponentialE]\^y - 
                            \[ExponentialE]\^y\ y)\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ a, -1], 
            Power[ x, -1], 
            Power[ 
              Plus[ 
                Times[ -1, al], 
                Times[ al, 
                  Power[ E, y]], 
                Times[ -1, 
                  Power[ E, y], y]], -1], 
            Plus[ 
              Times[ -1, a, al, 
                Power[ x, 2]], 
              Times[ a, al, 
                Power[ E, y], 
                Power[ x, 2]], 
              Times[ -1, a, 
                Power[ E, y], 
                Power[ x, 2], y], 
              Times[ 
                Power[ b, 2], 
                Power[ E, y], 
                Power[ y, 2]]]], 0, 0, 
          Times[ 
            Rational[ 1, 2], b, 
            Power[ E, y], 
            Power[ x, -1], y, 
            Power[ 
              Plus[ 
                Times[ -1, al], 
                Times[ al, 
                  Power[ E, y]], 
                Times[ -1, 
                  Power[ E, y], y]], -1]]}, {0, 
          Times[ -1, 
            Power[ 
              Plus[ -1, al], -2], 
            Power[ E, y], 
            Power[ x, -1], 
            Plus[ 
              Times[ -1, 
                Power[ b, 2]], 
              Times[ a, 
                Power[ x, 2]]]], 0, 0}, {0, 0, 
          Times[ a, 
            Power[ 
              Plus[ -1, al], -2], 
            Power[ x, -1], 
            Plus[ 
              Times[ -1, al], 
              Times[ al, 
                Power[ E, y]], 
              Times[ -1, 
                Power[ E, y], y]]], 0}, {
          Times[ 
            Rational[ 1, 2], b, 
            Power[ E, y], 
            Power[ x, -1], y, 
            Power[ 
              Plus[ 
                Times[ -1, al], 
                Times[ al, 
                  Power[ E, y]], 
                Times[ -1, 
                  Power[ E, y], y]], -1]], 0, 0, 
          Times[ 
            Rational[ 1, 4], a, 
            Power[ E, y], 
            Power[ x, -1], 
            Power[ 
              Plus[ 
                Times[ -1, al], 
                Times[ al, 
                  Power[ E, y]], 
                Times[ -1, 
                  Power[ E, y], y]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.13333333333333464`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.13333333333333464, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.1999999999999993`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.19999999999999929, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.36666666666666714`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.36666666666666714, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.5166666666666675`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 0.5166666666666675, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.049999999999998934`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.049999999999998934, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.2666666666666675`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.2666666666666675, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.01666666666666572`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666665719, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.68333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(EUd\)], "Input"],

Cell[BoxData[
    \({{\(-\(\(3\ a\ al\)\/\(4\ \((\(-1\) + al)\)\^2\ x\)\)\), 0, 0, 
        \(al\ b\ y\)\/\(\((\(-1\) + al)\)\^2\ x\)}, {0, 
        \(-\(\(a\ al\)\/\(4\ \((\(-1\) + al)\)\^2\ x\)\)\), 0, 0}, {0, 0, 
        \(-\(\(a\ al\)\/\(4\ \((\(-1\) + al)\)\^2\ x\)\)\), 0}, {0, 0, 0, 
        \(-\(\(a\ al\)\/\(4\ \((\(-1\) + al)\)\^2\ x\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(Classify[Wdddd]\), 
      RowBox[{"(*", 
        RowBox[{"*", " ", 
          StyleBox["this",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["takes",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[" ",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox[\(long!\),
            FontColor->RGBColor[0, 0, 1]]}], " ", "**)"}]}]], "Input"],

Cell[BoxData[
    \("Type I - G"\)], "Print"],

Cell[BoxData[
    \({1111}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Petrov-Type II (Eq. 33.14)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, w, r, ph}\)], "Input"],

Cell[BoxData[
    \({u, w, r, ph}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((1 - r^2)\)/\((2  ec)\) 
          \((d[w]^2/\((4  w)\) + w\ Exp[w]\ d[ph]^2)\) - 2  d[u] d[r] - 
        ec \((r^2 + 2  w + 3)\) d[u]^2\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ d[r]\ d[u] - ec\ \((3 + r\^2 + 2\ w)\)\ d[u]\^2 + 
      \(\((1 - r\^2)\)\ 
          \((\[ExponentialE]\^w\ w\ d[ph]\^2 + d[w]\^2\/\(4\ w\))\)\)\/\(2\ ec
          \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(-ec\)\ \((3 + r\^2 + 2\ w)\), 0, \(-1\), 0}, {0, 
        \(1 - r\^2\)\/\(8\ ec\ w\), 0, 0}, {\(-1\), 0, 0, 0}, {0, 0, 0, 
        \(\[ExponentialE]\^w\ \((1 - r\^2)\)\ w\)\/\(2\ ec\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(\(-ec\)\ \((3 + r\^2 + 2\ w)\)\), "0", \(-1\), "0"},
                {"0", \(\(1 - r\^2\)\/\(8\ ec\ w\)\), "0", "0"},
                {\(-1\), "0", "0", "0"},
               
                 {"0", "0", "0", 
                  \(\(\[ExponentialE]\^w\ \((1 - r\^2)\)\ w\)\/\(2\ ec\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, ec, 
            Plus[ 3, 
              Power[ r, 2], 
              Times[ 2, w]]], 0, -1, 0}, {0, 
          Times[ 
            Rational[ 1, 8], 
            Power[ ec, -1], 
            Plus[ 1, 
              Times[ -1, 
                Power[ r, 2]]], 
            Power[ w, -1]], 0, 0}, {-1, 0, 0, 0}, {0, 0, 0, 
          Times[ 
            Rational[ 1, 2], 
            Power[ E, w], 
            Power[ ec, -1], 
            Plus[ 1, 
              Times[ -1, 
                Power[ r, 2]]], w]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(\[ExponentialE]\^w\ \((\(-1\) + r\^2)\)\ w\ d[ph]\^2\)\/\(2
                    \ ec\)\)\) - 2\ d[r]\ d[u] - 
            ec\ \((3 + r\^2 + 2\ w)\)\ d[u]\^2 - 
            \(\((\(-1\) + r\^2)\)\ d[w]\^2\)\/\(8\ ec\ w\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Rational[ -1, 2], 
              Power[ E, w], 
              Power[ ec, -1], 
              Plus[ -1, 
                Power[ r, 2]], w, 
              Power[ 
                d[ ph], 2]], 
            Times[ -2, 
              d[ r], 
              d[ u]], 
            Times[ -1, ec, 
              Plus[ 3, 
                Power[ r, 2], 
                Times[ 2, w]], 
              Power[ 
                d[ u], 2]], 
            Times[ 
              Rational[ -1, 8], 
              Power[ ec, -1], 
              Plus[ -1, 
                Power[ r, 2]], 
              Power[ w, -1], 
              Power[ 
                d[ w], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", "0", \(-1\), "0"},
                {"0", \(-\(\(8\ ec\ w\)\/\(\(-1\) + r\^2\)\)\), "0", "0"},
                {\(-1\), "0", \(ec\ \((3 + r\^2 + 2\ w)\)\), "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(2\ \[ExponentialE]\^\(-w\)\ ec
                          \)\/\(\((\(-1\) + r\^2)\)\ w\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 0, -1, 0}, {0, 
          Times[ -8, ec, 
            Power[ 
              Plus[ -1, 
                Power[ r, 2]], -1], w], 0, 0}, {-1, 0, 
          Times[ ec, 
            Plus[ 3, 
              Power[ r, 2], 
              Times[ 2, w]]], 0}, {0, 0, 0, 
          Times[ -2, 
            Power[ E, 
              Times[ -1, w]], ec, 
            Power[ 
              Plus[ -1, 
                Power[ r, 2]], -1], 
            Power[ w, -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.06666666666671972`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.08333333333337123`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.45 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type II"\)], "Print"],

Cell[BoxData[
    \({211}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Plebanski[Rdd]]\)], "Input"],

Cell[BoxData[
    \("Type O"\)], "Print"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Petrov-Type D (Eq. 21.61 -- sign correction)", "Subsubsection",
  FontSize->14],

Cell[BoxData[
    \(Clear[MM, NN, G]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      1/NN^2 \((
          d[z]^2 + d[x]^2/G + G*d[\[Phi]]^2 - 
            x^2 \((d[t] + nn/x^2*d[\[Phi]])\)^2)\)\)], "Input"],

Cell[BoxData[
    \(\(d[x]\^2\/G + d[z]\^2 + G\ d[\[Phi]]\^2 - 
        x\^2\ \((d[t] + \(nn\ d[\[Phi]]\)\/x\^2)\)\^2\)\/NN\^2\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{\(NN = p*Exp[z] + q*Exp[\(-z\)]\), ";", 
      RowBox[{"G", "=", 
        RowBox[{
          RowBox[{
            StyleBox["-",
              FontColor->RGBColor[1, 0, 0]], \(x^2\)}], "+", \(b*Log[x]\), 
          "+", "cc", "+", \(nn^2/x^2\)}]}], ";", 
      RowBox[{"(*", 
        RowBox[{"*", 
          StyleBox[" ",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox["Note",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[" ",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox["minus",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[" ",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[\(sign!\),
            FontColor->RGBColor[1, 0, 0]]}], " ", "**)"}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {t, x, z, \[Phi]}\)], "Input"],

Cell[BoxData[
    \({t, x, z, \[Phi]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = FacSimp[metric[ds2, xIN]]\)], "Input"],

Cell[BoxData[
    \({{\(-
          \(\(\[ExponentialE]\^\(2\ z\)\ 
                x\^2\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\), 0, 0, 
        \(-\(\(\[ExponentialE]\^\(2\ z\)\ nn
                \)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\)}, {0, 
        \(\[ExponentialE]\^\(2\ z\)\ 
            x\^2\)\/\(\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
            \((nn\^2 + cc\ x\^2 - x\^4 + b\ x\^2\ Log[x])\)\), 0, 0}, {0, 0, 
        \[ExponentialE]\^\(2\ z\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2, 
        0}, {\(-\(\(\[ExponentialE]\^\(2\ z\)\ nn
                \)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\), 0, 0, 
        \(-\(\(\[ExponentialE]\^\(2\ z\)\ 
                \((\(-cc\) + x\^2 - b\ Log[x])\)\)\/\((
                  \[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(\[ExponentialE]\^\(2\ z\)\ 
                          x\^2\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2
                          \)\), "0", "0", 
                  \(-\(\(\[ExponentialE]\^\(2\ z\)\ nn
                          \)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\)},
               
                 {"0", \(\(\[ExponentialE]\^\(2\ z\)\ 
                        x\^2\)\/\(\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
                        \((nn\^2 + cc\ x\^2 - x\^4 + b\ x\^2\ Log[x])\)\)\), 
                  "0", "0"},
               
                 {"0", "0", 
                  \(\[ExponentialE]\^\(2\ z\)\/\((
                          \[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\), "0"},
               
                 {\(-\(\(\[ExponentialE]\^\(2\ z\)\ nn
                          \)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\), 
                  "0", "0", 
                  \(-\(\(\[ExponentialE]\^\(2\ z\)\ 
                          \((\(-cc\) + x\^2 - b\ Log[x])\)\)\/\((
                            \[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ E, 
              Times[ 2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2], 
            Power[ x, 2]], 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, z]], nn, 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2]]}, {0, 
          Times[ 
            Power[ E, 
              Times[ 2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2], 
            Power[ x, 2], 
            Power[ 
              Plus[ 
                Power[ nn, 2], 
                Times[ cc, 
                  Power[ x, 2]], 
                Times[ -1, 
                  Power[ x, 4]], 
                Times[ b, 
                  Power[ x, 2], 
                  Log[ x]]], -1]], 0, 0}, {0, 0, 
          Times[ 
            Power[ E, 
              Times[ 2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2]], 0}, {
          Times[ -1, 
            Power[ E, 
              Times[ 2, z]], nn, 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2]], 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ 2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], -2], 
            Plus[ 
              Times[ -1, cc], 
              Power[ x, 2], 
              Times[ -1, b, 
                Log[ x]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(\[ExponentialE]\^\(2\ z\)\ x\^2\ 
                    d[t]\^2\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2
                    \)\) + \(\[ExponentialE]\^\(2\ z\)\ 
                d[z]\^2\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2 - 
            \(2\ \[ExponentialE]\^\(2\ z\)\ nn\ d[t]\ 
                d[\[Phi]]\)\/\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2 + 
            \(\[ExponentialE]\^\(2\ z\)\ d[\[Phi]]\^2\ 
                \((cc - x\^2 + b\ Log[x])\)\)\/\((
                  \[ExponentialE]\^\(2\ z\)\ p + q)\)\^2 + 
            \(\[ExponentialE]\^\(2\ z\)\ x\^2\ 
                d[x]\^2\)\/\(\((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
                \((nn\^2 + cc\ x\^2 - x\^4 + b\ x\^2\ Log[x])\)\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ E, 
                Times[ 2, z]], 
              Power[ 
                Plus[ 
                  Times[ 
                    Power[ E, 
                      Times[ 2, z]], p], q], -2], 
              Power[ x, 2], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ E, 
                Times[ 2, z]], 
              Power[ 
                Plus[ 
                  Times[ 
                    Power[ E, 
                      Times[ 2, z]], p], q], -2], 
              Power[ 
                d[ z], 2]], 
            Times[ -2, 
              Power[ E, 
                Times[ 2, z]], nn, 
              Power[ 
                Plus[ 
                  Times[ 
                    Power[ E, 
                      Times[ 2, z]], p], q], -2], 
              d[ t], 
              d[ \[Phi]]], 
            Times[ 
              Power[ E, 
                Times[ 2, z]], 
              Power[ 
                Plus[ 
                  Times[ 
                    Power[ E, 
                      Times[ 2, z]], p], q], -2], 
              Power[ 
                d[ \[Phi]], 2], 
              Plus[ cc, 
                Times[ -1, 
                  Power[ x, 2]], 
                Times[ b, 
                  Log[ x]]]], 
            Times[ 
              Power[ E, 
                Times[ 2, z]], 
              Power[ 
                Plus[ 
                  Times[ 
                    Power[ E, 
                      Times[ 2, z]], p], q], -2], 
              Power[ x, 2], 
              Power[ 
                d[ x], 2], 
              Power[ 
                Plus[ 
                  Power[ nn, 2], 
                  Times[ cc, 
                    Power[ x, 2]], 
                  Times[ -1, 
                    Power[ x, 4]], 
                  Times[ b, 
                    Power[ x, 2], 
                    Log[ x]]], -1]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(\[ExponentialE]\^\(\(-2\)\ z\)\ 
                          \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
                          \((cc - x\^2 + b\ Log[x])\)\)\/\(nn\^2 + cc\ x\^2 - 
                          x\^4 + b\ x\^2\ Log[x]\)\)\), "0", "0", 
                  \(-\(\(\[ExponentialE]\^\(\(-2\)\ z\)\ nn\ 
                          \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\/\(nn\^2
                             + cc\ x\^2 - x\^4 + b\ x\^2\ Log[x]\)\)\)},
               
                 {"0", \(-
                    \(\(\[ExponentialE]\^\(\(-2\)\ z\)\ 
                          \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
                          \((\(-nn\^2\) - cc\ x\^2 + x\^4 - b\ x\^2\ Log[x])
                            \)\)\/x\^2\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\[ExponentialE]\^\(\(-2\)\ z\)\ 
                    \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\), "0"},
               
                 {\(-\(\(\[ExponentialE]\^\(\(-2\)\ z\)\ nn\ 
                          \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\)\/\(nn\^2
                             + cc\ x\^2 - x\^4 + b\ x\^2\ Log[x]\)\)\), "0", 
                  "0", \(\(\[ExponentialE]\^\(\(-2\)\ z\)\ 
                        \((\[ExponentialE]\^\(2\ z\)\ p + q)\)\^2\ 
                        x\^2\)\/\(nn\^2 + cc\ x\^2 - x\^4 + 
                        b\ x\^2\ Log[x]\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ E, 
              Times[ -2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2], 
            Plus[ cc, 
              Times[ -1, 
                Power[ x, 2]], 
              Times[ b, 
                Log[ x]]], 
            Power[ 
              Plus[ 
                Power[ nn, 2], 
                Times[ cc, 
                  Power[ x, 2]], 
                Times[ -1, 
                  Power[ x, 4]], 
                Times[ b, 
                  Power[ x, 2], 
                  Log[ x]]], -1]], 0, 0, 
          Times[ -1, 
            Power[ E, 
              Times[ -2, z]], nn, 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2], 
            Power[ 
              Plus[ 
                Power[ nn, 2], 
                Times[ cc, 
                  Power[ x, 2]], 
                Times[ -1, 
                  Power[ x, 4]], 
                Times[ b, 
                  Power[ x, 2], 
                  Log[ x]]], -1]]}, {0, 
          Times[ -1, 
            Power[ E, 
              Times[ -2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2], 
            Power[ x, -2], 
            Plus[ 
              Times[ -1, 
                Power[ nn, 2]], 
              Times[ -1, cc, 
                Power[ x, 2]], 
              Power[ x, 4], 
              Times[ -1, b, 
                Power[ x, 2], 
                Log[ x]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ E, 
              Times[ -2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2]], 0}, {
          Times[ -1, 
            Power[ E, 
              Times[ -2, z]], nn, 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2], 
            Power[ 
              Plus[ 
                Power[ nn, 2], 
                Times[ cc, 
                  Power[ x, 2]], 
                Times[ -1, 
                  Power[ x, 4]], 
                Times[ b, 
                  Power[ x, 2], 
                  Log[ x]]], -1]], 0, 0, 
          Times[ 
            Power[ E, 
              Times[ -2, z]], 
            Power[ 
              Plus[ 
                Times[ 
                  Power[ E, 
                    Times[ 2, z]], p], q], 2], 
            Power[ x, 2], 
            Power[ 
              Plus[ 
                Power[ nn, 2], 
                Times[ cc, 
                  Power[ x, 2]], 
                Times[ -1, 
                  Power[ x, 4]], 
                Times[ b, 
                  Power[ x, 2], 
                  Log[ x]]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.10000000000002274`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.10000000000002274, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.1999999999999318`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.19999999999993179, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.3000000000000682`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.30000000000006821, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.2666666666666515`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.26666666666665151, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.08333333333337123`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.083333333333371229, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.2666666666666515`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.26666666666665151, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.06666666666660603`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.33333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Petrov-Type III (Eq. 33.45)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, t, x, y}\)], "Input"],

Cell[BoxData[
    \({u, t, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      2\ Exp[3  t + 4  x] d[x]^2 + 
        \((3  Exp[t + 2  x - 2  y] + Exp[3  t + 6  x]/a)\) d[u]^2 + 
        a*Exp[t]/\((Exp[2  y] - 1)\) d[y]^2 - 
        2  Exp[2  t + 3  x - y] d[u] d[t + 3  x + y]\)], "Input"],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(3\ t + 6\ x\)\/a + 
            3\ \[ExponentialE]\^\(t + 2\ x - 2\ y\))\)\ d[u]\^2 + 
      2\ \[ExponentialE]\^\(3\ t + 4\ x\)\ d[x]\^2 + 
      \(a\ \[ExponentialE]\^t\ d[y]\^2\)\/\(\(-1\) + 
          \[ExponentialE]\^\(2\ y\)\) - 
      2\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\ d[u]\ 
        \((d[t] + 3\ d[x] + d[y])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\[ExponentialE]\^\(3\ t + 6\ x\)\/a + 
          3\ \[ExponentialE]\^\(t + 2\ x - 2\ y\), 
        \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), 
        \(-3\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\), 
        \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\)}, {
        \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), 0, 0, 0}, {
        \(-3\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\), 0, 
        2\ \[ExponentialE]\^\(3\ t + 4\ x\), 0}, {
        \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), 0, 0, 
        \(a\ \[ExponentialE]\^t\)\/\(\(-1\) + \[ExponentialE]\^\(2\ y\)\)}}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\[ExponentialE]\^\(3\ t + 6\ x\)\/a + 
                    3\ \[ExponentialE]\^\(t + 2\ x - 2\ y\)\), 
                  \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), 
                  \(\(-3\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\), 
                  \(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\)},
                {\(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), "0", "0", "0"},
               
                 {\(\(-3\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\), "0", 
                  \(2\ \[ExponentialE]\^\(3\ t + 4\ x\)\), "0"},
               
                 {\(-\[ExponentialE]\^\(2\ t + 3\ x - y\)\), "0", "0", 
                  \(\(a\ \[ExponentialE]\^t\)\/\(\(-1\) + 
                        \[ExponentialE]\^\(2\ y\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 
            Times[ 
              Power[ a, -1], 
              Power[ E, 
                Plus[ 
                  Times[ 3, t], 
                  Times[ 6, x]]]], 
            Times[ 3, 
              Power[ E, 
                Plus[ t, 
                  Times[ 2, x], 
                  Times[ -2, y]]]]], 
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]], 
          Times[ -3, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]], 
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]]}, {
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]], 0, 0, 0}, {
          Times[ -3, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]], 0, 
          Times[ 2, 
            Power[ E, 
              Plus[ 
                Times[ 3, t], 
                Times[ 4, x]]]], 0}, {
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ 2, t], 
                Times[ 3, x], 
                Times[ -1, y]]]], 0, 0, 
          Times[ a, 
            Power[ E, t], 
            Power[ 
              Plus[ -1, 
                Power[ E, 
                  Times[ 2, y]]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-2\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\ d[t]\ d[u] + 
            \(\[ExponentialE]\^\(t + 2\ x - 2\ y\)\ 
                \((3\ a + \[ExponentialE]\^\(2\ t + 4\ x + 2\ y\))\)\ 
                d[u]\^2\)\/a + 2\ \[ExponentialE]\^\(3\ t + 4\ x\)\ d[x]\^2 + 
            \(a\ \[ExponentialE]\^t\ 
                d[y]\^2\)\/\(\((\(-1\) + \[ExponentialE]\^y)\)\ 
                \((1 + \[ExponentialE]\^y)\)\) + 
            d[u]\ \((
                \(-6\)\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\ d[x] - 
                  2\ \[ExponentialE]\^\(2\ t + 3\ x - y\)\ d[y])\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -2, 
              Power[ E, 
                Plus[ 
                  Times[ 2, t], 
                  Times[ 3, x], 
                  Times[ -1, y]]], 
              d[ t], 
              d[ u]], 
            Times[ 
              Power[ a, -1], 
              Power[ E, 
                Plus[ t, 
                  Times[ 2, x], 
                  Times[ -2, y]]], 
              Plus[ 
                Times[ 3, a], 
                Power[ E, 
                  Plus[ 
                    Times[ 2, t], 
                    Times[ 4, x], 
                    Times[ 2, y]]]], 
              Power[ 
                d[ u], 2]], 
            Times[ 2, 
              Power[ E, 
                Plus[ 
                  Times[ 3, t], 
                  Times[ 4, x]]], 
              Power[ 
                d[ x], 2]], 
            Times[ a, 
              Power[ E, t], 
              Power[ 
                Plus[ -1, 
                  Power[ E, y]], -1], 
              Power[ 
                Plus[ 1, 
                  Power[ E, y]], -1], 
              Power[ 
                d[ y], 2]], 
            Times[ 
              d[ u], 
              Plus[ 
                Times[ -6, 
                  Power[ E, 
                    Plus[ 
                      Times[ 2, t], 
                      Times[ 3, x], 
                      Times[ -1, y]]], 
                  d[ x]], 
                Times[ -2, 
                  Power[ E, 
                    Plus[ 
                      Times[ 2, t], 
                      Times[ 3, x], 
                      Times[ -1, y]]], 
                  d[ y]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {"0", \(-\[ExponentialE]\^\(\(-2\)\ t - 3\ x + y\)\), "0", 
                  "0"},
               
                 {\(-\[ExponentialE]\^\(\(-2\)\ t - 3\ x + y\)\), 
                  \(-\(\(\[ExponentialE]\^\(\(-3\)\ t - 4\ x\)\ 
                          \((\(-3\)\ a + 2\ \[ExponentialE]\^\(2\ t + 4\ x\))
                            \)\)\/\(2\ a\)\)\), 
                  \(\(-\(3\/2\)\)\ \[ExponentialE]\^\(\(-3\)\ t - 4\ x\)\), 
                  \(-\(\(\[ExponentialE]\^\(-t\)\ 
                          \((\(-1\) + \[ExponentialE]\^y)\)\ 
                          \((1 + \[ExponentialE]\^y)\)\)\/a\)\)},
               
                 {"0", \(\(-\(3\/2\)\)\ 
                    \[ExponentialE]\^\(\(-3\)\ t - 4\ x\)\), 
                  \(1\/2\ \[ExponentialE]\^\(\(-3\)\ t - 4\ x\)\), "0"},
               
                 {"0", \(-
                    \(\(\[ExponentialE]\^\(-t\)\ 
                          \((\(-1\) + \[ExponentialE]\^y)\)\ 
                          \((1 + \[ExponentialE]\^y)\)\)\/a\)\), "0", 
                  \(\(\[ExponentialE]\^\(-t\)\ 
                        \((\(-1\) + \[ExponentialE]\^y)\)\ 
                        \((1 + \[ExponentialE]\^y)\)\)\/a\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ -2, t], 
                Times[ -3, x], y]]], 0, 0}, {
          Times[ -1, 
            Power[ E, 
              Plus[ 
                Times[ -2, t], 
                Times[ -3, x], y]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ a, -1], 
            Power[ E, 
              Plus[ 
                Times[ -3, t], 
                Times[ -4, x]]], 
            Plus[ 
              Times[ -3, a], 
              Times[ 2, 
                Power[ E, 
                  Plus[ 
                    Times[ 2, t], 
                    Times[ 4, x]]]]]], 
          Times[ 
            Rational[ -3, 2], 
            Power[ E, 
              Plus[ 
                Times[ -3, t], 
                Times[ -4, x]]]], 
          Times[ -1, 
            Power[ a, -1], 
            Power[ E, 
              Times[ -1, t]], 
            Plus[ -1, 
              Power[ E, y]], 
            Plus[ 1, 
              Power[ E, y]]]}, {0, 
          Times[ 
            Rational[ -3, 2], 
            Power[ E, 
              Plus[ 
                Times[ -3, t], 
                Times[ -4, x]]]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ E, 
              Plus[ 
                Times[ -3, t], 
                Times[ -4, x]]]], 0}, {0, 
          Times[ -1, 
            Power[ a, -1], 
            Power[ E, 
              Times[ -1, t]], 
            Plus[ -1, 
              Power[ E, y]], 
            Plus[ 1, 
              Power[ E, y]]], 0, 
          Times[ 
            Power[ a, -1], 
            Power[ E, 
              Times[ -1, t]], 
            Plus[ -1, 
              Power[ E, y]], 
            Plus[ 1, 
              Power[ E, y]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.18333333333339397`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.18333333333339397, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.16666666666662877`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.16666666666662877, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.36666666666667425`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.36666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.16666666666674246`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.16666666666674246, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.06667 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type III"\)], "Print"],

Cell[BoxData[
    \({31}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Note",
    FontSlant->"Italic"],
  ": Inadequate simplification of the exponentials in some versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", may prevent Classify from verifying that Wdddd and gdd.EUd have the \
correct symmetries!"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Petrov-Type N (Eq. 33.48 - Class I)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, t, x, y}\)], "Input"],

Cell[BoxData[
    \({u, t, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rtt = Sqrt[t]\)], "Input"],

Cell[BoxData[
    \(\@t\)], "Output"]
}, Open  ]],

Cell["\<\
Special simplificaion rules, implied by the differential equation \
satisfied by the metric functions, must be defined.\
\>", "Text",
  FontSize->16],

Cell[BoxData[
    \(\(ghRules = 
      Join[FuncRepRules[D[g1[x, u], x, x], \(-a[u]^2\) g1[x, u]], 
        FuncRepRules[D[h1[y, u], y, y], \(-b^2\) h1[y, u]]]; \)\)], "Input"],

Cell[BoxData[
    \(\(G1rules = 
      FacSimp[FuncRepRules[G1[x, y, u], g1[x, u] h1[y, u], 3] /. ghRules]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(simpRules = Join[G1rules, ghRules]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(H1 = \(-2\) \((a[u]^2  rtt + b^2  rtt^3)\)\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ \((b\^2\ t\^\(3/2\) + \@t\ a[u]\^2)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      Collect[2  G1[x, y, u]\ d[t] d[u] + 2  G1[x, y, u]^2  H1\ d[u]^2 - 
          rtt^3 \((d[x] - 2/rtt*D[G1[x, y, u], x] d[u])\)^2 - 
          rtt \((d[y] + 2  rtt*D[G1[x, y, u], y] d[u])\)^2, {d[_]^2, 
          d[i_] d[j_]}, FacSimp]\)], "Input"],

Cell[BoxData[
    RowBox[{
    \(\(-t\^\(3/2\)\)\ d[x]\^2\), "-", \(\@t\ d[y]\^2\), "+", 
      \(2\ d[t]\ d[u]\ g1[x, u]\ h1[y, u]\), "+", 
      RowBox[{
      "4", " ", "t", " ", \(d[u]\), " ", \(d[x]\), " ", \(h1[y, u]\), " ", 
        RowBox[{
          SuperscriptBox["g1", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(x, u\), "]"}]}], "-", 
      RowBox[{
      "4", " ", "t", " ", \(d[u]\), " ", \(d[y]\), " ", \(g1[x, u]\), " ", 
        RowBox[{
          SuperscriptBox["h1", 
            TagBox[\((1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(y, u\), "]"}]}], "-", 
      RowBox[{"4", " ", \(\@t\), " ", \(d[u]\^2\), " ", 
        RowBox[{"(", 
          RowBox[{
          \(b\^2\ t\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
            \(a[u]\^2\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
            RowBox[{\(h1[y, u]\^2\), " ", 
              SuperscriptBox[
                RowBox[{
                  SuperscriptBox["g1", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, u\), "]"}], "2"]}], 
            "+", 
            RowBox[{"t", " ", \(g1[x, u]\^2\), " ", 
              SuperscriptBox[
                RowBox[{
                  SuperscriptBox["h1", 
                    TagBox[\((1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(y, u\), "]"}], "2"]}]}], 
          ")"}]}]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = FacSimp[metric[ds2, xIN]]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(-4\), " ", \(\@t\), " ", 
              RowBox[{"(", 
                RowBox[{
                \(b\^2\ t\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                  \(a[u]\^2\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                  RowBox[{\(h1[y, u]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["g1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}], 
                      "2"]}], "+", 
                  RowBox[{"t", " ", \(g1[x, u]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["h1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(y, u\), "]"}], 
                      "2"]}]}], ")"}]}], ",", \(g1[x, u]\ h1[y, u]\), ",", 
            RowBox[{"2", " ", "t", " ", \(h1[y, u]\), " ", 
              RowBox[{
                SuperscriptBox["g1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, u\), "]"}]}], ",", 
            RowBox[{\(-2\), " ", "t", " ", \(g1[x, u]\), " ", 
              RowBox[{
                SuperscriptBox["h1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(y, u\), "]"}]}]}], "}"}], 
        ",", \({g1[x, u]\ h1[y, u], 0, 0, 0}\), ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{"2", " ", "t", " ", \(h1[y, u]\), " ", 
              RowBox[{
                SuperscriptBox["g1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, u\), "]"}]}], ",", "0", 
            ",", \(-t\^\(3/2\)\), ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(-2\), " ", "t", " ", \(g1[x, u]\), " ", 
              RowBox[{
                SuperscriptBox["h1", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(y, u\), "]"}]}], ",", "0", 
            ",", "0", ",", \(-\@t\)}], "}"}]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {
                  RowBox[{\(-4\), " ", \(\@t\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                      \(b\^2\ t\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                        \(a[u]\^2\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                        RowBox[{\(h1[y, u]\^2\), " ", 
                          SuperscriptBox[
                            RowBox[{
                              SuperscriptBox["g1", 
                                TagBox[\((1, 0)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, u\), 
                              "]"}], "2"]}], "+", 
                        RowBox[{"t", " ", \(g1[x, u]\^2\), " ", 
                          SuperscriptBox[
                            RowBox[{
                              SuperscriptBox["h1", 
                                TagBox[\((1, 0)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(y, u\), 
                              "]"}], "2"]}]}], ")"}]}], 
                  \(g1[x, u]\ h1[y, u]\), 
                  RowBox[{"2", " ", "t", " ", \(h1[y, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["g1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                  RowBox[{\(-2\), " ", "t", " ", \(g1[x, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["h1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(y, u\), "]"}]}]},
                {\(g1[x, u]\ h1[y, u]\), "0", "0", "0"},
                {
                  RowBox[{"2", " ", "t", " ", \(h1[y, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["g1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, u\), "]"}]}], "0",
                   \(-t\^\(3/2\)\), "0"},
                {
                  RowBox[{\(-2\), " ", "t", " ", \(g1[x, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["h1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(y, u\), "]"}]}], "0",
                   "0", \(-\@t\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -4, 
            Power[ t, 
              Rational[ 1, 2]], 
            Plus[ 
              Times[ 
                Power[ b, 2], t, 
                Power[ 
                  g1[ x, u], 2], 
                Power[ 
                  h1[ y, u], 2]], 
              Times[ 
                Power[ 
                  a[ u], 2], 
                Power[ 
                  g1[ x, u], 2], 
                Power[ 
                  h1[ y, u], 2]], 
              Times[ 
                Power[ 
                  h1[ y, u], 2], 
                Power[ 
                  Derivative[ 1, 0][ g1][ x, u], 2]], 
              Times[ t, 
                Power[ 
                  g1[ x, u], 2], 
                Power[ 
                  Derivative[ 1, 0][ h1][ y, u], 2]]]], 
          Times[ 
            g1[ x, u], 
            h1[ y, u]], 
          Times[ 2, t, 
            h1[ y, u], 
            Derivative[ 1, 0][ g1][ x, u]], 
          Times[ -2, t, 
            g1[ x, u], 
            Derivative[ 1, 0][ h1][ y, u]]}, {
          Times[ 
            g1[ x, u], 
            h1[ y, u]], 0, 0, 0}, {
          Times[ 2, t, 
            h1[ y, u], 
            Derivative[ 1, 0][ g1][ x, u]], 0, 
          Times[ -1, 
            Power[ t, 
              Rational[ 3, 2]]], 0}, {
          Times[ -2, t, 
            g1[ x, u], 
            Derivative[ 1, 0][ h1][ y, u]], 0, 0, 
          Times[ -1, 
            Power[ t, 
              Rational[ 1, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{
          \(\(-t\^\(3/2\)\)\ d[x]\^2\), "-", \(\@t\ d[y]\^2\), "+", 
            \(2\ d[t]\ d[u]\ g1[x, u]\ h1[y, u]\), "+", 
            RowBox[{\(d[u]\), " ", 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                  "4", " ", "t", " ", \(d[x]\), " ", \(h1[y, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["g1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(x, u\), "]"}]}], "-",
                   
                  RowBox[{
                  "4", " ", "t", " ", \(d[y]\), " ", \(g1[x, u]\), " ", 
                    RowBox[{
                      SuperscriptBox["h1", 
                        TagBox[\((1, 0)\),
                          Derivative],
                        MultilineFunction->None], "[", \(y, u\), "]"}]}]}], 
                ")"}]}], "-", 
            RowBox[{"4", " ", \(\@t\), " ", \(d[u]\^2\), " ", 
              RowBox[{"(", 
                RowBox[{
                \(b\^2\ t\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                  \(a[u]\^2\ g1[x, u]\^2\ h1[y, u]\^2\), "+", 
                  RowBox[{\(h1[y, u]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["g1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}], 
                      "2"]}], "+", 
                  RowBox[{"t", " ", \(g1[x, u]\^2\), " ", 
                    SuperscriptBox[
                      RowBox[{
                        SuperscriptBox["h1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(y, u\), "]"}], 
                      "2"]}]}], ")"}]}]}],
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ t, 
                Rational[ 3, 2]], 
              Power[ 
                d[ x], 2]], 
            Times[ -1, 
              Power[ t, 
                Rational[ 1, 2]], 
              Power[ 
                d[ y], 2]], 
            Times[ 2, 
              d[ t], 
              d[ u], 
              g1[ x, u], 
              h1[ y, u]], 
            Times[ 
              d[ u], 
              Plus[ 
                Times[ 4, t, 
                  d[ x], 
                  h1[ y, u], 
                  Derivative[ 1, 0][ g1][ x, u]], 
                Times[ -4, t, 
                  d[ y], 
                  g1[ x, u], 
                  Derivative[ 1, 0][ h1][ y, u]]]], 
            Times[ -4, 
              Power[ t, 
                Rational[ 1, 2]], 
              Power[ 
                d[ u], 2], 
              Plus[ 
                Times[ 
                  Power[ b, 2], t, 
                  Power[ 
                    g1[ x, u], 2], 
                  Power[ 
                    h1[ y, u], 2]], 
                Times[ 
                  Power[ 
                    a[ u], 2], 
                  Power[ 
                    g1[ x, u], 2], 
                  Power[ 
                    h1[ y, u], 2]], 
                Times[ 
                  Power[ 
                    h1[ y, u], 2], 
                  Power[ 
                    Derivative[ 1, 0][ g1][ x, u], 2]], 
                Times[ t, 
                  Power[ 
                    g1[ x, u], 2], 
                  Power[ 
                    Derivative[ 1, 0][ h1][ y, u], 2]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", \(1\/\(g1[x, u]\ h1[y, u]\)\), "0", "0"},
               
                 {\(1\/\(g1[x, u]\ h1[y, u]\)\), 
                  \(4\ \@t\ \((b\^2\ t + a[u]\^2)\)\), 
                  FractionBox[
                    RowBox[{"2", " ", 
                      RowBox[{
                        SuperscriptBox["g1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    \(\@t\ g1[x, u]\)], 
                  RowBox[{"-", 
                    FractionBox[
                      RowBox[{"2", " ", \(\@t\), " ", 
                        RowBox[{
                          SuperscriptBox["h1", 
                            TagBox[\((1, 0)\),
                              Derivative],
                            MultilineFunction->None], "[", \(y, u\), "]"}]}], 
                      \(h1[y, u]\)]}]},
                {"0", 
                  FractionBox[
                    RowBox[{"2", " ", 
                      RowBox[{
                        SuperscriptBox["g1", 
                          TagBox[\((1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, u\), "]"}]}], 
                    \(\@t\ g1[x, u]\)], \(-\(1\/t\^\(3/2\)\)\), "0"},
                {"0", 
                  RowBox[{"-", 
                    FractionBox[
                      RowBox[{"2", " ", \(\@t\), " ", 
                        RowBox[{
                          SuperscriptBox["h1", 
                            TagBox[\((1, 0)\),
                              Derivative],
                            MultilineFunction->None], "[", \(y, u\), "]"}]}], 
                      \(h1[y, u]\)]}], "0", \(-\(1\/\@t\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, 
          Times[ 
            Power[ 
              g1[ x, u], -1], 
            Power[ 
              h1[ y, u], -1]], 0, 0}, {
          Times[ 
            Power[ 
              g1[ x, u], -1], 
            Power[ 
              h1[ y, u], -1]], 
          Times[ 4, 
            Power[ t, 
              Rational[ 1, 2]], 
            Plus[ 
              Times[ 
                Power[ b, 2], t], 
              Power[ 
                a[ u], 2]]], 
          Times[ 2, 
            Power[ t, 
              Rational[ -1, 2]], 
            Power[ 
              g1[ x, u], -1], 
            Derivative[ 1, 0][ g1][ x, u]], 
          Times[ -2, 
            Power[ t, 
              Rational[ 1, 2]], 
            Power[ 
              h1[ y, u], -1], 
            Derivative[ 1, 0][ h1][ y, u]]}, {0, 
          Times[ 2, 
            Power[ t, 
              Rational[ -1, 2]], 
            Power[ 
              g1[ x, u], -1], 
            Derivative[ 1, 0][ g1][ x, u]], 
          Times[ -1, 
            Power[ t, 
              Rational[ -3, 2]]], 0}, {0, 
          Times[ -2, 
            Power[ t, 
              Rational[ 1, 2]], 
            Power[ 
              h1[ y, u], -1], 
            Derivative[ 1, 0][ h1][ y, u]], 0, 
          Times[ -1, 
            Power[ t, 
              Rational[ -1, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.11666666666656056`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.11666666666656056, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.20000000000004547`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.20000000000004547, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.18333333333339397`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.18333333333339397, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.2999999999999545`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.29999999999995453, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.11666666666667425`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.016666666666765195`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666765195, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.2 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type N"\)], "Print"],

Cell[BoxData[
    \({4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111),1] or [1(11,1)] (Perfect fluid)"\)], "Print"],

Cell[BoxData[
    \("III-M2(11)"\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  7.3  Electromagnetic Fields"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[" Kerr-Newman (Eq. 21.24)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(xIN = \({t, r, x, \[Phi]}\ \) (*\ x\  = \ Cos[\[Theta]]\ *) \)\)], 
  "Input"],

Cell[BoxData[
    \({t, r, x, \[Phi]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((r^2 + a^2  x^2)\) 
          \((d[r]^2/\((r^2 - 2  M*r + a^2 + e^2)\) + d[x]^2/\((1 - x^2)\))
            \) - \((1 - \((2  M*r - e^2)\)/\((r^2 + a^2  x^2)\))\) d[t]^2 + 
        \((1 - x^2)\) 
          \((r^2 + a^2 + 
              a^2 \((1 - x^2)\) \((2  M*r - e^2)\)/\((r^2 + a^2  x^2)\))\) 
          d[\[Phi]]^2 - 
        2  a \((1 - x^2)\) \((2  M*r - e^2)\)/\((r^2 + a^2  x^2)\) d[\[Phi]] 
          d[t]\)], "Input"],

Cell[BoxData[
    \(\(-\((1 - \(\(-e\^2\) + 2\ M\ r\)\/\(r\^2 + a\^2\ x\^2\))\)\)\ 
        d[t]\^2 + 
      \((r\^2 + a\^2\ x\^2)\)\ 
        \((d[r]\^2\/\(a\^2 + e\^2 - 2\ M\ r + r\^2\) + d[x]\^2\/\(1 - x\^2\))
          \) - \(2\ a\ \((\(-e\^2\) + 2\ M\ r)\)\ \((1 - x\^2)\)\ d[t]\ 
          d[\[Phi]]\)\/\(r\^2 + a\^2\ x\^2\) + 
      \((1 - x\^2)\)\ 
        \((a\^2 + r\^2 + 
            \(a\^2\ \((\(-e\^2\) + 2\ M\ r)\)\ \((1 - x\^2)\)\)\/\(r\^2 + 
                a\^2\ x\^2\))\)\ d[\[Phi]]\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(-1\) + \(\(-e\^2\) + 2\ M\ r\)\/\(r\^2 + a\^2\ x\^2\), 0, 0, 
        \(-\(\(a\ \((\(-e\^2\) + 2\ M\ r)\)\ \((1 - x\^2)\)\)\/\(r\^2 + 
                a\^2\ x\^2\)\)\)}, {0, 
        \(r\^2 + a\^2\ x\^2\)\/\(a\^2 + e\^2 - 2\ M\ r + r\^2\), 0, 0}, {0, 
        0, \(r\^2 + a\^2\ x\^2\)\/\(1 - x\^2\), 0}, {
        \(-\(\(a\ \((\(-e\^2\) + 2\ M\ r)\)\ \((1 - x\^2)\)\)\/\(r\^2 + 
                a\^2\ x\^2\)\)\), 0, 0, 
        \((1 - x\^2)\)\ 
          \((a\^2 + r\^2 + 
              \(a\^2\ \((\(-e\^2\) + 2\ M\ r)\)\ \((1 - x\^2)\)\)\/\(r\^2 + 
                  a\^2\ x\^2\))\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\(-1\) + \(\(-e\^2\) + 2\ M\ r\)\/\(r\^2 + a\^2\ x\^2\)\),
                   "0", "0", 
                  \(-\(\(a\ \((\(-e\^2\) + 2\ M\ r)\)\ 
                          \((1 - x\^2)\)\)\/\(r\^2 + a\^2\ x\^2\)\)\)},
               
                 {"0", \(\(r\^2 + a\^2\ x\^2\)\/\(a\^2 + e\^2 - 2\ M\ r + 
                        r\^2\)\), "0", "0"},
                {"0", "0", \(\(r\^2 + a\^2\ x\^2\)\/\(1 - x\^2\)\), "0"},
               
                 {\(-\(\(a\ \((\(-e\^2\) + 2\ M\ r)\)\ 
                          \((1 - x\^2)\)\)\/\(r\^2 + a\^2\ x\^2\)\)\), "0", 
                  "0", \(\((1 - x\^2)\)\ 
                    \((a\^2 + r\^2 + 
                        \(a\^2\ \((\(-e\^2\) + 2\ M\ r)\)\ 
                            \((1 - x\^2)\)\)\/\(r\^2 + a\^2\ x\^2\))\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ -1, 
            Times[ 
              Plus[ 
                Times[ -1, 
                  Power[ e, 2]], 
                Times[ 2, M, r]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1]]], 0, 0, 
          Times[ -1, a, 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ 2, M, r]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]]}, {0, 
          Times[ 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Plus[ 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]]], 0}, {
          Times[ -1, a, 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ 2, M, r]], 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0, 
          Times[ 
            Plus[ 1, 
              Times[ -1, 
                Power[ x, 2]]], 
            Plus[ 
              Power[ a, 2], 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Plus[ 
                  Times[ -1, 
                    Power[ e, 2]], 
                  Times[ 2, M, r]], 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ x, 2]]], 
                Power[ 
                  Plus[ 
                    Power[ r, 2], 
                    Times[ 
                      Power[ a, 2], 
                      Power[ x, 2]]], -1]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(\((r\^2 + a\^2\ x\^2)\)\ d[r]\^2\)\/\(a\^2 + e\^2 - 2\ M\ r + 
                r\^2\) - 
            \(\((e\^2 - 2\ M\ r + r\^2 + a\^2\ x\^2)\)\ d[t]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\) - 
            \(\((r\^2 + a\^2\ x\^2)\)\ d[x]\^2\)\/\(\(-1\) + x\^2\) - 
            \(2\ a\ \((e\^2 - 2\ M\ r)\)\ \((\(-1\) + x\^2)\)\ d[t]\ 
                d[\[Phi]]\)\/\(r\^2 + a\^2\ x\^2\) - 
            \(\((\(-1\) + x\^2)\)\ 
                \((\(-a\^2\)\ e\^2 + 2\ a\^2\ M\ r + a\^2\ r\^2 + r\^4 + 
                    a\^4\ x\^2 + a\^2\ e\^2\ x\^2 - 2\ a\^2\ M\ r\ x\^2 + 
                    a\^2\ r\^2\ x\^2)\)\ d[\[Phi]]\^2\)\/\(r\^2 + 
                a\^2\ x\^2\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ 
                Plus[ 
                  Power[ a, 2], 
                  Power[ e, 2], 
                  Times[ -2, M, r], 
                  Power[ r, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ r], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ t], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ -1, 
                  Power[ x, 2]], -1], 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ x], 2]], 
            Times[ -2, a, 
              Plus[ 
                Power[ e, 2], 
                Times[ -2, M, r]], 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              d[ t], 
              d[ \[Phi]]], 
            Times[ -1, 
              Plus[ -1, 
                Power[ x, 2]], 
              Power[ 
                Plus[ 
                  Power[ r, 2], 
                  Times[ 
                    Power[ a, 2], 
                    Power[ x, 2]]], -1], 
              Plus[ 
                Times[ -1, 
                  Power[ a, 2], 
                  Power[ e, 2]], 
                Times[ 2, 
                  Power[ a, 2], M, r], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2]], 
                Power[ r, 4], 
                Times[ 
                  Power[ a, 4], 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ e, 2], 
                  Power[ x, 2]], 
                Times[ -2, 
                  Power[ a, 2], M, r, 
                  Power[ x, 2]], 
                Times[ 
                  Power[ a, 2], 
                  Power[ r, 2], 
                  Power[ x, 2]]], 
              Power[ 
                d[ \[Phi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(\(-a\^2\)\ e\^2 + 2\ a\^2\ M\ r + a\^2\ r\^2 + 
                          r\^4 + a\^4\ x\^2 + a\^2\ e\^2\ x\^2 - 
                          2\ a\^2\ M\ r\ x\^2 + 
                          a\^2\ r\^2\ x\^2\)\/\(\((
                            a\^2 + e\^2 - 2\ M\ r + r\^2)\)\ 
                          \((r\^2 + a\^2\ x\^2)\)\)\)\), "0", "0", 
                  \(\(a\ \((e\^2 - 2\ M\ r)\)\)\/\(\((
                          a\^2 + e\^2 - 2\ M\ r + r\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\)},
               
                 {"0", \(\(a\^2 + e\^2 - 2\ M\ r + r\^2\)\/\(r\^2 + 
                        a\^2\ x\^2\)\), "0", "0"},
               
                 {"0", "0", \(-\(\(\(-1\) + x\^2\)\/\(r\^2 + a\^2\ x\^2\)\)\),
                   "0"},
               
                 {\(\(a\ \((e\^2 - 2\ M\ r)\)\)\/\(\((
                          a\^2 + e\^2 - 2\ M\ r + r\^2)\)\ 
                        \((r\^2 + a\^2\ x\^2)\)\)\), "0", "0", 
                  \(-\(\(e\^2 - 2\ M\ r + r\^2 + 
                          a\^2\ x\^2\)\/\(\((a\^2 + e\^2 - 2\ M\ r + r\^2)\)\ 
                          \((\(-1\) + x\^2)\)\ \((r\^2 + a\^2\ x\^2)\)\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Times[ -1, 
                Power[ a, 2], 
                Power[ e, 2]], 
              Times[ 2, 
                Power[ a, 2], M, r], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2]], 
              Power[ r, 4], 
              Times[ 
                Power[ a, 4], 
                Power[ x, 2]], 
              Times[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Power[ x, 2]], 
              Times[ -2, 
                Power[ a, 2], M, r, 
                Power[ x, 2]], 
              Times[ 
                Power[ a, 2], 
                Power[ r, 2], 
                Power[ x, 2]]]], 0, 0, 
          Times[ a, 
            Plus[ 
              Power[ e, 2], 
              Times[ -2, M, r]], 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]]}, {0, 
          Times[ 
            Plus[ 
              Power[ a, 2], 
              Power[ e, 2], 
              Times[ -2, M, r], 
              Power[ r, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0}, {0, 0, 
          Times[ -1, 
            Plus[ -1, 
              Power[ x, 2]], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0}, {
          Times[ a, 
            Plus[ 
              Power[ e, 2], 
              Times[ -2, M, r]], 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1]], 0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ a, 2], 
                Power[ e, 2], 
                Times[ -2, M, r], 
                Power[ r, 2]], -1], 
            Power[ 
              Plus[ -1, 
                Power[ x, 2]], -1], 
            Power[ 
              Plus[ 
                Power[ r, 2], 
                Times[ 
                  Power[ a, 2], 
                  Power[ x, 2]]], -1], 
            Plus[ 
              Power[ e, 2], 
              Times[ -2, M, r], 
              Power[ r, 2], 
              Times[ 
                Power[ a, 2], 
                Power[ x, 2]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.16666666666662877`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.16666666666662877, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.39999999999997726`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.39999999999997726, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.5500000000000682`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.55000000000006821, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]1.0499999999999545`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(Uddd) computed in ", 1.0499999999999545, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.11666666666667425`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.11666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.683333333333394`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.68333333333339397, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.06666666666660603`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.066666666666606034, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 3.11667 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [(11)(1,1)] (Non-Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IID-M2(01)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Plebanski[Rdd]]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Type D with G2 on Null Orbits (Eq. 24.21)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, v, x, y}\)], "Input"],

Cell[BoxData[
    \({u, v, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((x^2 + y^2)\)/FF*d[x]^2 + 
        FF/\((x^2 + y^2)\) \((d[u] - y^2  d[v])\)^2 + 
        2  d[y] \((d[u] + x^2  d[v])\)\)], "Input"],

Cell[BoxData[
    \(\(FF\ \((d[u] - y\^2\ d[v])\)\^2\)\/\(x\^2 + y\^2\) + 
      \(\((x\^2 + y\^2)\)\ d[x]\^2\)\/FF + 
      2\ \((d[u] + x\^2\ d[v])\)\ d[y]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(FF = 2  n*x - \((e^2 + g^2)\); \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(\(-e\^2\) - g\^2 + 2\ n\ x\)\/\(x\^2 + y\^2\), 
        \(-\(\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^2\)\/\(x\^2 + y\^2\)\)\), 
        0, 1}, {\(-
          \(\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^2\)\/\(x\^2 + y\^2\)\)\), 
        \(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^4\)\/\(x\^2 + y\^2\), 0, 
        x\^2}, {0, 0, \(x\^2 + y\^2\)\/\(\(-e\^2\) - g\^2 + 2\ n\ x\), 0}, {
        1, x\^2, 0, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\(\(-e\^2\) - g\^2 + 2\ n\ x\)\/\(x\^2 + y\^2\)\), 
                  \(-\(\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^2\)\/\(x\^2 + 
                          y\^2\)\)\), "0", "1"},
               
                 {\(-\(\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^2\)\/\(x\^2 + 
                          y\^2\)\)\), 
                  \(\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ y\^4\)\/\(x\^2 + 
                        y\^2\)\), "0", \(x\^2\)},
               
                 {"0", "0", 
                  \(\(x\^2 + y\^2\)\/\(\(-e\^2\) - g\^2 + 2\ n\ x\)\), "0"},
                {"1", \(x\^2\), "0", "0"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ -1, 
                Power[ g, 2]], 
              Times[ 2, n, x]], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 
          Times[ -1, 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ -1, 
                Power[ g, 2]], 
              Times[ 2, n, x]], 
            Power[ y, 2], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 0, 1}, {
          Times[ -1, 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ -1, 
                Power[ g, 2]], 
              Times[ 2, n, x]], 
            Power[ y, 2], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 
          Times[ 
            Plus[ 
              Times[ -1, 
                Power[ e, 2]], 
              Times[ -1, 
                Power[ g, 2]], 
              Times[ 2, n, x]], 
            Power[ y, 4], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 0, 
          Power[ x, 2]}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ e, 2]], 
                Times[ -1, 
                  Power[ g, 2]], 
                Times[ 2, n, x]], -1], 
            Plus[ 
              Power[ x, 2], 
              Power[ y, 2]]], 0}, {1, 
          Power[ x, 2], 0, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(\((e\^2 + g\^2 - 2\ n\ x)\)\ d[u]\^2\)\/\(x\^2 + 
                    y\^2\)\)\) - 
            \(\((e\^2 + g\^2 - 2\ n\ x)\)\ y\^4\ d[v]\^2\)\/\(x\^2 + y\^2\) - 
            \(\((x\^2 + y\^2)\)\ d[x]\^2\)\/\(e\^2 + g\^2 - 2\ n\ x\) + 
            2\ x\^2\ d[v]\ d[y] + 
            d[u]\ \((
                \(2\ \((e\^2 + g\^2 - 2\ n\ x)\)\ y\^2\ d[v]\)\/\(x\^2 + 
                      y\^2\) + 2\ d[y])\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Plus[ 
                Power[ e, 2], 
                Power[ g, 2], 
                Times[ -2, n, x]], 
              Power[ 
                Plus[ 
                  Power[ x, 2], 
                  Power[ y, 2]], -1], 
              Power[ 
                d[ u], 2]], 
            Times[ -1, 
              Plus[ 
                Power[ e, 2], 
                Power[ g, 2], 
                Times[ -2, n, x]], 
              Power[ y, 4], 
              Power[ 
                Plus[ 
                  Power[ x, 2], 
                  Power[ y, 2]], -1], 
              Power[ 
                d[ v], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ 
                  Power[ e, 2], 
                  Power[ g, 2], 
                  Times[ -2, n, x]], -1], 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], 
              Power[ 
                d[ x], 2]], 
            Times[ 2, 
              Power[ x, 2], 
              d[ v], 
              d[ y]], 
            Times[ 
              d[ u], 
              Plus[ 
                Times[ 2, 
                  Plus[ 
                    Power[ e, 2], 
                    Power[ g, 2], 
                    Times[ -2, n, x]], 
                  Power[ y, 2], 
                  Power[ 
                    Plus[ 
                      Power[ x, 2], 
                      Power[ y, 2]], -1], 
                  d[ v]], 
                Times[ 2, 
                  d[ y]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(x\^4\/\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ 
                        \((x\^2 + y\^2)\)\)\), 
                  \(-\(x\^2\/\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ 
                          \((x\^2 + y\^2)\)\)\)\), "0", 
                  \(y\^2\/\(x\^2 + y\^2\)\)},
               
                 {\(-\(x\^2\/\(\((\(-e\^2\) - g\^2 + 2\ n\ x)\)\ 
                          \((x\^2 + y\^2)\)\)\)\), 
                  \(-\(1\/\(\((e\^2 + g\^2 - 2\ n\ x)\)\ 
                          \((x\^2 + y\^2)\)\)\)\), "0", 
                  \(1\/\(x\^2 + y\^2\)\)},
               
                 {"0", "0", 
                  \(-\(\(e\^2 + g\^2 - 2\ n\ x\)\/\(x\^2 + y\^2\)\)\), "0"},
                {\(y\^2\/\(x\^2 + y\^2\)\), \(1\/\(x\^2 + y\^2\)\), "0", "0"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Power[ x, 4], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ e, 2]], 
                Times[ -1, 
                  Power[ g, 2]], 
                Times[ 2, n, x]], -1], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 
          Times[ -1, 
            Power[ x, 2], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ e, 2]], 
                Times[ -1, 
                  Power[ g, 2]], 
                Times[ 2, n, x]], -1], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 0, 
          Times[ 
            Power[ y, 2], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]]}, {
          Times[ -1, 
            Power[ x, 2], 
            Power[ 
              Plus[ 
                Times[ -1, 
                  Power[ e, 2]], 
                Times[ -1, 
                  Power[ g, 2]], 
                Times[ 2, n, x]], -1], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 
          Times[ -1, 
            Power[ 
              Plus[ 
                Power[ e, 2], 
                Power[ g, 2], 
                Times[ -2, n, x]], -1], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 0, 
          Power[ 
            Plus[ 
              Power[ x, 2], 
              Power[ y, 2]], -1]}, {0, 0, 
          Times[ -1, 
            Plus[ 
              Power[ e, 2], 
              Power[ g, 2], 
              Times[ -2, n, x]], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 0}, {
          Times[ 
            Power[ y, 2], 
            Power[ 
              Plus[ 
                Power[ x, 2], 
                Power[ y, 2]], -1]], 
          Power[ 
            Plus[ 
              Power[ x, 2], 
              Power[ y, 2]], -1], 0, 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.10000000000002274`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.10000000000002274, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.25`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.25, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.3000000000000682`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.30000000000006821, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.6166666666666742`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.61666666666667425, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.08333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.083333333333257542, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.18333333333339397`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.18333333333339397, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.63333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [(11)(1,1)] (Non-Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IID-M2(01)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Plebanski[Rdd]]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" McLenaghan-Tariq-Tupper (Eq. 12.21)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {t, x, y, \[Phi]}\)], "Input"],

Cell[BoxData[
    \({t, x, y, \[Phi]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      a^2/x^2 \((d[x]^2 + d[y]^2)\) + x^2  d[\[Phi]]^2 - 
        \((d[t] - 2  y*d[\[Phi]])\)^2\)], "Input"],

Cell[BoxData[
    \(\(a\^2\ \((d[x]\^2 + d[y]\^2)\)\)\/x\^2 + x\^2\ d[\[Phi]]\^2 - 
      \((d[t] - 2\ y\ d[\[Phi]])\)\^2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(-1\), 0, 0, 2\ y}, {0, a\^2\/x\^2, 0, 0}, {0, 0, a\^2\/x\^2, 0}, {
        2\ y, 0, 0, 1\/2\ \((2\ x\^2 - 8\ y\^2)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-1\), "0", "0", \(2\ y\)},
                {"0", \(a\^2\/x\^2\), "0", "0"},
                {"0", "0", \(a\^2\/x\^2\), "0"},
                {\(2\ y\), "0", "0", \(1\/2\ \((2\ x\^2 - 8\ y\^2)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{-1, 0, 0, 
          Times[ 2, y]}, {0, 
          Times[ 
            Power[ a, 2], 
            Power[ x, -2]], 0, 0}, {0, 0, 
          Times[ 
            Power[ a, 2], 
            Power[ x, -2]], 0}, {
          Times[ 2, y], 0, 0, 
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Times[ 2, 
                Power[ x, 2]], 
              Times[ -8, 
                Power[ y, 2]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-d[t]\^2\) + \(a\^2\ d[x]\^2\)\/x\^2 + 
            \(a\^2\ d[y]\^2\)\/x\^2 + 4\ y\ d[t]\ d[\[Phi]] + 
            \((x - 2\ y)\)\ \((x + 2\ y)\)\ d[\[Phi]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ a, 2], 
              Power[ x, -2], 
              Power[ 
                d[ x], 2]], 
            Times[ 
              Power[ a, 2], 
              Power[ x, -2], 
              Power[ 
                d[ y], 2]], 
            Times[ 4, y, 
              d[ t], 
              d[ \[Phi]]], 
            Times[ 
              Plus[ x, 
                Times[ -2, y]], 
              Plus[ x, 
                Times[ 2, y]], 
              Power[ 
                d[ \[Phi]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(\((x - 2\ y)\)\ \((x + 2\ y)\)\)\/x\^2\)\), "0", "0",
                   \(\(2\ y\)\/x\^2\)},
                {"0", \(x\^2\/a\^2\), "0", "0"},
                {"0", "0", \(x\^2\/a\^2\), "0"},
                {\(\(2\ y\)\/x\^2\), "0", "0", \(1\/x\^2\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ x, -2], 
            Plus[ x, 
              Times[ -2, y]], 
            Plus[ x, 
              Times[ 2, y]]], 0, 0, 
          Times[ 2, 
            Power[ x, -2], y]}, {0, 
          Times[ 
            Power[ a, -2], 
            Power[ x, 2]], 0, 0}, {0, 0, 
          Times[ 
            Power[ a, -2], 
            Power[ x, 2]], 0}, {
          Times[ 2, 
            Power[ x, -2], y], 0, 0, 
          Power[ x, -2]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.016666666666765195`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.016666666666765195, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.033333333333416704`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.033333333333416704, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.333333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type I - G"\)], "Print"],

Cell[BoxData[
    \({1111}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Segre [(11)(1,1)] (Non-Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IID-M2(01)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Plebanski[Rdd]]\)], "Input"],

Cell[BoxData[
    \("Type D"\)], "Print"],

Cell[BoxData[
    \({22}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" PP wave (Eq. 24.40 -- real coordinates)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, v, x, y}\)], "Input"],

Cell[BoxData[
    \({u, v, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = d[x]^2 + d[y]^2 - 2  d[u] d[v] - 2  HH[u, x, y] d[u]^2\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ d[u]\ d[v] + d[x]\^2 + d[y]\^2 - 2\ d[u]\^2\ HH[u, x, y]\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(-2\)\ HH[u, x, y], \(-1\), 0, 0}, {\(-1\), 0, 0, 0}, {0, 0, 1, 0}, {
        0, 0, 0, 1}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(\(-2\)\ HH[u, x, y]\), \(-1\), "0", "0"},
                {\(-1\), "0", "0", "0"},
                {"0", "0", "1", "0"},
                {"0", "0", "0", "1"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -2, 
            HH[ u, x, y]], -1, 0, 0}, {-1, 0, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 
          1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-2\)\ d[u]\ d[v] + d[x]\^2 + d[y]\^2 - 
            2\ d[u]\^2\ HH[u, x, y]\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -2, 
              d[ u], 
              d[ v]], 
            Power[ 
              d[ x], 2], 
            Power[ 
              d[ y], 2], 
            Times[ -2, 
              Power[ 
                d[ u], 2], 
              HH[ u, x, y]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", \(-1\), "0", "0"},
                {\(-1\), \(2\ HH[u, x, y]\), "0", "0"},
                {"0", "0", "1", "0"},
                {"0", "0", "0", "1"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, -1, 0, 0}, {-1, 
          Times[ 2, 
            HH[ u, x, y]], 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.033333333333416704`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.033333333333416704, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 0.1 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type N"\)], "Print"],

Cell[BoxData[
    \({4}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(11,2)] (Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IV-M2(00)"\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Conformally Flat wave (Eq. 24.51)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, v, x, y}\)], "Input"],

Cell[BoxData[
    \({u, v, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((1 - Sin[\[Omega]*u])\) d[x]^2 + \((1 + Sin[\[Omega]*u])\) d[y]^2 - 
        2  d[u] d[v]\)], "Input"],

Cell[BoxData[
    \(\(-2\)\ d[u]\ d[v] + d[x]\^2\ \((1 - Sin[u\ \[Omega]])\) + 
      d[y]\^2\ \((1 + Sin[u\ \[Omega]])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{0, \(-1\), 0, 0}, {\(-1\), 0, 0, 0}, {0, 0, 1 - Sin[u\ \[Omega]], 
        0}, {0, 0, 0, 1 + Sin[u\ \[Omega]]}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", \(-1\), "0", "0"},
                {\(-1\), "0", "0", "0"},
                {"0", "0", \(1 - Sin[u\ \[Omega]]\), "0"},
                {"0", "0", "0", \(1 + Sin[u\ \[Omega]]\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{0, -1, 0, 0}, {-1, 0, 0, 0}, {0, 0, 
          Plus[ 1, 
            Times[ -1, 
              Sin[ 
                Times[ u, \[Omega]]]]], 0}, {0, 0, 0, 
          Plus[ 1, 
            Sin[ 
              Times[ u, \[Omega]]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-2\)\ d[u]\ d[v] + d[x]\^2\ \((1 - Sin[u\ \[Omega]])\) + 
            d[y]\^2\ \((1 + Sin[u\ \[Omega]])\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -2, 
              d[ u], 
              d[ v]], 
            Times[ 
              Power[ 
                d[ x], 2], 
              Plus[ 1, 
                Times[ -1, 
                  Sin[ 
                    Times[ u, \[Omega]]]]]], 
            Times[ 
              Power[ 
                d[ y], 2], 
              Plus[ 1, 
                Sin[ 
                  Times[ u, \[Omega]]]]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", \(-1\), "0", "0"},
                {\(-1\), "0", "0", "0"},
                {"0", "0", \(-\(1\/\(\(-1\) + Sin[u\ \[Omega]]\)\)\), "0"},
                {"0", "0", "0", \(1\/\(1 + Sin[u\ \[Omega]]\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, -1, 0, 0}, {-1, 0, 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ -1, 
                Sin[ 
                  Times[ u, \[Omega]]]], -1]], 0}, {0, 0, 0, 
          Power[ 
            Plus[ 1, 
              Sin[ 
                Times[ u, \[Omega]]]], -1]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.05000000000006821`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Conformally Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("All tasks completed in 1.1 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type O"\)], "Print"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(11,2)] (Null EM field)"\)], "Print"],

Cell[BoxData[
    \("IV-M2(00)"\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  Cell[BoxData[
      TagBox["",
        DisplayForm]]],
  "  7.4  Miscellaneous test metrics"
}], "Subsection",
  ShowGroupOpenCloseIcon->True,
  FontSize->16],

Cell[CellGroupData[{

Cell[" Curzon (Eq. 20.5 @ 20.3)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {t, r, \[Theta], \[Phi]}\)], "Input"],

Cell[BoxData[
    \({t, r, \[Theta], \[Phi]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      Exp[2  M/r] 
          \((Exp[\(-M^2\)/r^2  Sin[\[Theta]]^2] 
                \((d[r]^2 + r^2  d[\[Theta]]^2)\) + 
              r^2  Sin[\[Theta]]^2  d[\[Phi]]^2)\) - 
        Exp[\(-2\) M/r] d[t]^2\)], "Input"],

Cell[BoxData[
    \(\(-\[ExponentialE]\^\(-\(\(2\ M\)\/r\)\)\)\ d[t]\^2 + 
      \[ExponentialE]\^\(\(2\ M\)\/r\)\ 
        \((\[ExponentialE]\^\(-\(\(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\)\ 
              \((d[r]\^2 + r\^2\ d[\[Theta]]\^2)\) + 
            r\^2\ d[\[Phi]]\^2\ Sin[\[Theta]]\^2)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(-\[ExponentialE]\^\(-\(\(2\ M\)\/r\)\)\), 0, 0, 0}, {0, 
        \[ExponentialE]\^\(\(2\ M\)\/r - \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\), 
        0, 0}, {0, 0, 
        \[ExponentialE]\^\(\(2\ M\)\/r - \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\ 
          r\^2, 0}, {0, 0, 0, 
        \[ExponentialE]\^\(\(2\ M\)\/r\)\ r\^2\ Sin[\[Theta]]\^2}}\)], 
  "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(simpRules = TrigRules; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-\[ExponentialE]\^\(-\(\(2\ M\)\/r\)\)\), "0", "0", "0"},
               
                 {"0", \(\[ExponentialE]\^\(\(2\ M\)\/r - 
                        \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\[ExponentialE]\^\(\(2\ M\)\/r - 
                        \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\ r\^2\), "0"},
               
                 {"0", "0", "0", 
                  \(\[ExponentialE]\^\(\(2\ M\)\/r\)\ r\^2\ 
                    Sin[\[Theta]]\^2\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ E, 
              Times[ -2, M, 
                Power[ r, -1]]]], 0, 0, 0}, {0, 
          Power[ E, 
            Plus[ 
              Times[ 2, M, 
                Power[ r, -1]], 
              Times[ -1, 
                Power[ M, 2], 
                Power[ r, -2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ E, 
              Plus[ 
                Times[ 2, M, 
                  Power[ r, -1]], 
                Times[ -1, 
                  Power[ M, 2], 
                  Power[ r, -2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]], 
            Power[ r, 2]], 0}, {0, 0, 0, 
          Times[ 
            Power[ E, 
              Times[ 2, M, 
                Power[ r, -1]]], 
            Power[ r, 2], 
            Power[ 
              Sin[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\[ExponentialE]\^\(\(2\ M\)\/r - 
                  \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\ d[r]\^2 - 
            \[ExponentialE]\^\(-\(\(2\ M\)\/r\)\)\ d[t]\^2 + 
            \[ExponentialE]\^\(\(2\ M\)\/r - 
                  \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\ r\^2\ d[\[Theta]]\^2 + 
            \[ExponentialE]\^\(\(2\ M\)\/r\)\ r\^2\ d[\[Phi]]\^2\ 
              Sin[\[Theta]]\^2\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ 
              Power[ E, 
                Plus[ 
                  Times[ 2, M, 
                    Power[ r, -1]], 
                  Times[ -1, 
                    Power[ M, 2], 
                    Power[ r, -2], 
                    Power[ 
                      Sin[ \[Theta]], 2]]]], 
              Power[ 
                d[ r], 2]], 
            Times[ -1, 
              Power[ E, 
                Times[ -2, M, 
                  Power[ r, -1]]], 
              Power[ 
                d[ t], 2]], 
            Times[ 
              Power[ E, 
                Plus[ 
                  Times[ 2, M, 
                    Power[ r, -1]], 
                  Times[ -1, 
                    Power[ M, 2], 
                    Power[ r, -2], 
                    Power[ 
                      Sin[ \[Theta]], 2]]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[Theta]], 2]], 
            Times[ 
              Power[ E, 
                Times[ 2, M, 
                  Power[ r, -1]]], 
              Power[ r, 2], 
              Power[ 
                d[ \[Phi]], 2], 
              Power[ 
                Sin[ \[Theta]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {\(-\[ExponentialE]\^\(\(2\ M\)\/r\)\), "0", "0", "0"},
               
                 {"0", \(\[ExponentialE]\^\(\(-\(\(2\ M\)\/r\)\) + 
                        \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\[ExponentialE]\^\(\(-\(\(2\ M\)\/r\)\) + 
                          \(M\^2\ Sin[\[Theta]]\^2\)\/r\^2\)\/r\^2\), "0"},
               
                 {"0", "0", "0", 
                  \(\(\[ExponentialE]\^\(-\(\(2\ M\)\/r\)\)\ 
                        Csc[\[Theta]]\^2\)\/r\^2\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ E, 
              Times[ 2, M, 
                Power[ r, -1]]]], 0, 0, 0}, {0, 
          Power[ E, 
            Plus[ 
              Times[ -2, M, 
                Power[ r, -1]], 
              Times[ 
                Power[ M, 2], 
                Power[ r, -2], 
                Power[ 
                  Sin[ \[Theta]], 2]]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ E, 
              Plus[ 
                Times[ -2, M, 
                  Power[ r, -1]], 
                Times[ 
                  Power[ M, 2], 
                  Power[ r, -2], 
                  Power[ 
                    Sin[ \[Theta]], 2]]]], 
            Power[ r, -2]], 0}, {0, 0, 0, 
          Times[ 
            Power[ E, 
              Times[ -2, M, 
                Power[ r, -1]]], 
            Power[ r, -2], 
            Power[ 
              Csc[ \[Theta]], 2]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.06666666666671972`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.08333333333325754`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.083333333333257542, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.06666666666671972`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.433333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type I - G"\)], "Print"],

Cell[BoxData[
    \({1111}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Rdd]\)], "Input"],

Cell[BoxData[
    \("Traceless"\)], "Print"],

Cell[BoxData[
    \("Quadruple 0 eigenvalue"\)], "Print"],

Cell[BoxData[
    \("Segre [(111,1)] (Vacuum)"\)], "Print"],

Cell[BoxData[
    \("IV-M1(0)"\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(simpRules = {}; \)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[" Robinson-Trautman Type II (Eq. 28.78 @ 28.26)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {u, r, z, zB}\)], "Input"],

Cell[BoxData[
    \({u, r, z, zB}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Bar[z] = zB; Bar[zB] = z; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      2  r^2/\((z + zB)\)^3  d[z] d[zB] - 2  d[u] d[r] + 
        \((3 \((z + zB)\) + 2  M/r + \[CapitalLambda]/3  r^2)\) d[u]^2\)], 
  "Input"],

Cell[BoxData[
    \(\(-2\)\ d[r]\ d[u] + 
      \((\(2\ M\)\/r + 3\ \((z + zB)\) + \(r\^2\ \[CapitalLambda]\)\/3)\)\ 
        d[u]\^2 + \(2\ r\^2\ d[z]\ d[zB]\)\/\((z + zB)\)\^3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = metric[ds2, xIN]\)], "Input"],

Cell[BoxData[
    \({{\(2\ M\)\/r + 3\ \((z + zB)\) + \(r\^2\ \[CapitalLambda]\)\/3, 
        \(-1\), 0, 0}, {\(-1\), 0, 0, 0}, {0, 0, 0, r\^2\/\((z + zB)\)\^3}, {
        0, 0, r\^2\/\((z + zB)\)\^3, 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\(2\ M\)\/r + 3\ \((z + zB)\) + 
                    \(r\^2\ \[CapitalLambda]\)\/3\), \(-1\), "0", "0"},
                {\(-1\), "0", "0", "0"},
                {"0", "0", "0", \(r\^2\/\((z + zB)\)\^3\)},
                {"0", "0", \(r\^2\/\((z + zB)\)\^3\), "0"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Plus[ 
            Times[ 2, M, 
              Power[ r, -1]], 
            Times[ 3, 
              Plus[ z, zB]], 
            Times[ 
              Rational[ 1, 3], 
              Power[ r, 2], \[CapitalLambda]]], -1, 0, 0}, {-1, 0, 0, 0}, {0, 
          0, 0, 
          Times[ 
            Power[ r, 2], 
            Power[ 
              Plus[ z, zB], -3]]}, {0, 0, 
          Times[ 
            Power[ r, 2], 
            Power[ 
              Plus[ z, zB], -3]], 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-2\)\ d[r]\ d[u] + 
            \(\((6\ M + 9\ r\ z + 9\ r\ zB + r\^3\ \[CapitalLambda])\)\ 
                d[u]\^2\)\/\(3\ r\) + 
            \(2\ r\^2\ d[z]\ d[zB]\)\/\((z + zB)\)\^3\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -2, 
              d[ r], 
              d[ u]], 
            Times[ 
              Rational[ 1, 3], 
              Power[ r, -1], 
              Plus[ 
                Times[ 6, M], 
                Times[ 9, r, z], 
                Times[ 9, r, zB], 
                Times[ 
                  Power[ r, 3], \[CapitalLambda]]], 
              Power[ 
                d[ u], 2]], 
            Times[ 2, 
              Power[ r, 2], 
              Power[ 
                Plus[ z, zB], -3], 
              d[ z], 
              d[ zB]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {"0", \(-1\), "0", "0"},
               
                 {\(-1\), 
                  \(-\(\(6\ M + 9\ r\ z + 9\ r\ zB + 
                          r\^3\ \[CapitalLambda]\)\/\(3\ r\)\)\), "0", "0"},
                {"0", "0", "0", \(\((z + zB)\)\^3\/r\^2\)},
                {"0", "0", \(\((z + zB)\)\^3\/r\^2\), "0"}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{0, -1, 0, 0}, {-1, 
          Times[ 
            Rational[ -1, 3], 
            Power[ r, -1], 
            Plus[ 
              Times[ 6, M], 
              Times[ 9, r, z], 
              Times[ 9, r, zB], 
              Times[ 
                Power[ r, 3], \[CapitalLambda]]]], 0, 0}, {0, 0, 0, 
          Times[ 
            Power[ r, -2], 
            Power[ 
              Plus[ z, zB], 3]]}, {0, 0, 
          Times[ 
            Power[ r, -2], 
            Power[ 
              Plus[ z, zB], 3]], 0}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.03333333333330302`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.033333333333303017, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.05000000000006821`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.050000000000068212, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.049999999999954525`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.049999999999954525, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.01666666666665151`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666651508, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.06666666666671972`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.066666666666719721, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Einstein computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Einstein computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Einstein Space"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.416667 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type II"\)], "Print"],

Cell[BoxData[
    \({211}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[gdd.EUd]\)], "Input"],

Cell[BoxData[
    \("Segre [(111,1)] (Lamda Term)"\)], "Print"],

Cell[BoxData[
    \("IV-M1(1)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Plebanski[Rdd]]\)], "Input"],

Cell[BoxData[
    \("Type O"\)], "Print"],

Cell[BoxData[
    \({0}\)], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" Khan-Penrose colliding waves (Eq. 25.24)", "Subsubsection",
  FontSize->14],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {\[Eta], \[Mu], x, y}\)], "Input"],

Cell[BoxData[
    \({\[Eta], \[Mu], x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(W = Sqrt[1 - \[Eta]^2] Sqrt[1 - \[Mu]^2]\)], "Input"],

Cell[BoxData[
    \(\@\(1 - \[Eta]\^2\)\ \@\(1 - \[Mu]\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ds2 = 
      \((1 - \[Eta]\^2)\)^\((3/4)\)\ /\((1 - \[Mu]\^2)\)^\((1/4)\) 
          \((d[\[Mu]]^2/\((1 - \[Mu]^2)\) - d[\[Eta]]^2/\((1 - \[Eta]^2)\))
            \) + W \((
            \((1 - \[Eta])\)/\((1 + \[Eta])\) d[x]^2 + 
              \((1 + \[Eta])\)/\((1 - \[Eta])\) d[y]^2)\)\)], "Input"],

Cell[BoxData[
    \(\@\(1 - \[Eta]\^2\)\ \@\(1 - \[Mu]\^2\)\ 
        \((\(\((1 - \[Eta])\)\ d[x]\^2\)\/\(1 + \[Eta]\) + 
            \(\((1 + \[Eta])\)\ d[y]\^2\)\/\(1 - \[Eta]\))\) + 
      \(\((1 - \[Eta]\^2)\)\^\(3/4\)\ 
          \((\(-\(d[\[Eta]]\^2\/\(1 - \[Eta]\^2\)\)\) + 
              d[\[Mu]]\^2\/\(1 - \[Mu]\^2\))\)\)\/\((1 - \[Mu]\^2)\)\^\(1/4
            \)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = Factor[metric[ds2, xIN]]\)], "Input"],

Cell[BoxData[
    \({{\(-
          \(1\/\(\((1 - \[Eta]\^2)\)\^\(1/4\)\ 
                \((1 - \[Mu]\^2)\)\^\(1/4\)\)\)\), 0, 0, 0}, {0, 
        \((1 - \[Eta]\^2)\)\^\(3/4\)\/\((1 - \[Mu]\^2)\)\^\(5/4\), 0, 0}, {0, 
        0, \(-\(\(\((\(-1\) + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ 
                \@\(1 - \[Mu]\^2\)\)\/\(1 + \[Eta]\)\)\), 0}, {0, 0, 0, 
        \(-\(\(\((1 + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ 
                \@\(1 - \[Mu]\^2\)\)\/\(\(-1\) + \[Eta]\)\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(1\/\(\((1 - \[Eta]\^2)\)\^\(1/4\)\ 
                          \((1 - \[Mu]\^2)\)\^\(1/4\)\)\)\), "0", "0", "0"},
               
                 {"0", \(\((1 - \[Eta]\^2)\)\^\(3/4\)\/\((1 - \[Mu]\^2)
                          \)\^\(5/4\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(\((\(-1\) + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ 
                          \@\(1 - \[Mu]\^2\)\)\/\(1 + \[Eta]\)\)\), "0"},
               
                 {"0", "0", "0", 
                  \(-\(\(\((1 + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ 
                          \@\(1 - \[Mu]\^2\)\)\/\(\(-1\) + \[Eta]\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ -1, 4]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ -1, 4]]], 0, 0, 0}, {0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ 3, 4]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ -5, 4]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Plus[ -1, \[Eta]], 
            Power[ 
              Plus[ 1, \[Eta]], -1], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ 1, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ 1, 2]]], 0}, {0, 0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ -1, \[Eta]], -1], 
            Plus[ 1, \[Eta]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ 1, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ 1, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(\((\(-1\) + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ 
                    \@\(1 - \[Mu]\^2\)\ d[x]\^2\)\/\(1 + \[Eta]\)\)\) - 
            \(\((1 + \[Eta])\)\ \@\(1 - \[Eta]\^2\)\ \@\(1 - \[Mu]\^2\)\ 
                d[y]\^2\)\/\(\(-1\) + \[Eta]\) - 
            d[\[Eta]]\^2\/\(\((1 - \[Eta]\^2)\)\^\(1/4\)\ 
                \((1 - \[Mu]\^2)\)\^\(1/4\)\) + 
            \(\((1 - \[Eta]\^2)\)\^\(3/4\)\ 
                d[\[Mu]]\^2\)\/\((1 - \[Mu]\^2)\)\^\(5/4\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -1, 
              Plus[ -1, \[Eta]], 
              Power[ 
                Plus[ 1, \[Eta]], -1], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Eta], 2]]], 
                Rational[ 1, 2]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Mu], 2]]], 
                Rational[ 1, 2]], 
              Power[ 
                d[ x], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ -1, \[Eta]], -1], 
              Plus[ 1, \[Eta]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Eta], 2]]], 
                Rational[ 1, 2]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Mu], 2]]], 
                Rational[ 1, 2]], 
              Power[ 
                d[ y], 2]], 
            Times[ -1, 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Eta], 2]]], 
                Rational[ -1, 4]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Mu], 2]]], 
                Rational[ -1, 4]], 
              Power[ 
                d[ \[Eta]], 2]], 
            Times[ 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Eta], 2]]], 
                Rational[ 3, 4]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ \[Mu], 2]]], 
                Rational[ -5, 4]], 
              Power[ 
                d[ \[Mu]], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(\(-\((1 - \[Eta]\^2)\)\^\(1/4\)\)\ 
                    \((1 - \[Mu]\^2)\)\^\(1/4\)\), "0", "0", "0"},
               
                 {"0", \(\((1 - \[Mu]\^2)\)\^\(5/4\)\/\((1 - \[Eta]\^2)
                          \)\^\(3/4\)\), "0", "0"},
               
                 {"0", "0", 
                  \(-\(\(1 + \[Eta]\)\/\(\((\(-1\) + \[Eta])\)\ 
                          \@\(1 - \[Eta]\^2\)\ \@\(1 - \[Mu]\^2\)\)\)\), "0"},
                
               
                 {"0", "0", "0", 
                  \(-\(\(\(-1\) + \[Eta]\)\/\(\((1 + \[Eta])\)\ 
                          \@\(1 - \[Eta]\^2\)\ \@\(1 - \[Mu]\^2\)\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ -1, 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ 1, 4]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ 1, 4]]], 0, 0, 0}, {0, 
          Times[ 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ -3, 4]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ 5, 4]]], 0, 0}, {0, 0, 
          Times[ -1, 
            Power[ 
              Plus[ -1, \[Eta]], -1], 
            Plus[ 1, \[Eta]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ -1, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ -1, 2]]], 0}, {0, 0, 0, 
          Times[ -1, 
            Plus[ -1, \[Eta]], 
            Power[ 
              Plus[ 1, \[Eta]], -1], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Eta], 2]]], 
              Rational[ -1, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ \[Mu], 2]]], 
              Rational[ -1, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.05000000000000426`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.050000000000004263, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.10000000000000142`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.10000000000000142, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]0.18333333333333002`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(dddd) computed in ", 0.18333333333333002, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.10000000000000142`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.10000000000000142, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.01666666666666572`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.016666666666665719, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 0.583333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Cannot perform classification; try different coordinates or frame!"\)],
   "Output",
  FontSize->16,
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 1]]
}, Open  ]],

Cell[TextData[{
  "This message sometimes appears due to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s failure to recognize that an expression vanishes. This happens when the \
determinant of the metric tensor is not a perfect square, as in this case, \
and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " writes (1-\[Eta]) as -(-1+\[Eta]):"
}], "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(detg\)], "Input"],

Cell[BoxData[
    \(\(-\(\((1 - \[Eta]\^2)\)\^\(3/2\)\/\@\(1 - \[Mu]\^2\)\)\)\)], "Output"]
}, Open  ]],

Cell["The expression that fails to vanish is: ", "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[
      1 - \(\@\(\(-1\) + \[Eta]\)\ \@\(1 + \[Eta]\)\ 
            \@\(1 - \[Mu]\^2\)\)\/\(\@\(1 - \[Eta]\^2\)\ 
            \@\(\(-1\) + \[Mu]\)\ \@\(1 + \[Mu]\)\)]\)], "Input"],

Cell[BoxData[
    \(1 - 
      \(\@\(\(-1\) + \[Eta]\)\ \@\(1 + \[Eta]\)\ 
          \@\(1 - \[Mu]\^2\)\)\/\(\@\(1 - \[Eta]\^2\)\ \@\(\(-1\) + \[Mu]\)\ 
          \@\(1 + \[Mu]\)\)\)], "Output"]
}, Open  ]],

Cell["\<\
In this case, a coordinate transformation solves the problem:\
\>", 
  "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Factor", "[", 
      RowBox[{"W", "/.", 
        StyleBox[
          \({\[Eta] \[Rule] 2 h/\((1 + h^2)\), 
            \[Mu] \[Rule] 2 k/\((1 + k^2)\)}\),
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox["]",
        FontColor->RGBColor[0, 0, 1]]}]], "Input"],

Cell[BoxData[
    \(\@\(1 - \(4\ h\^2\)\/\((1 + h\^2)\)\^2\)\ 
      \@\(1 - \(4\ k\^2\)\/\((1 + k\^2)\)\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[% /. 
        Power[1 - \(4\ x_\^2\)\/\((1 + x_\^2)\)\^2, Rational[m_, n_]] :> 
          Power[\(1 - \ x\^2\)\/\((1 + x\^2)\), Rational[2  m, n]]]\)], 
  "Input"],

Cell[BoxData[
    \(\(\((\(-1\) + h\^2)\)\ \((\(-1\) + k\^2)\)\)\/\(\((1 + h\^2)\)\ 
        \((1 + k\^2)\)\)\)], "Output"]
}, Open  ]],

Cell["The line element now becomes:", "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ds2", "=", 
      RowBox[{"Collect", "[", 
        RowBox[{
          RowBox[{"PowerExpand", "[", 
            RowBox[{
              RowBox[{"ds2", "/.", 
                
                StyleBox[
                  \({\[Eta] \[Rule] 2 h/\((1 + h^2)\), 
                    \[Mu] \[Rule] 2 k/\((1 + k^2)\)}\),
                  FontColor->RGBColor[0, 0, 1]]}], "/.", 
              \(Power[1 - \(4\ x_\^2\)\/\((1 + x_\^2)\)\^2, Rational[m_, n_]]
                   :> Power[\(1 - \ x\^2\)\/\((1 + x\^2)\), Rational[2  m, n]]
                  \)}], "]"}], ",", "_d", ",", "Factor"}], "]"}]}]], "Input"],

Cell[BoxData[
    \(\(-\(\(4\ \((1 - h\^2)\)\^\(3/2\)\ \@\(1 + k\^2\)\ 
              d[h]\^2\)\/\(\((1 + h\^2)\)\^\(7/2\)\ \@\(1 - k\^2\)\)\)\) + 
      \(4\ \((1 - h\^2)\)\^\(3/2\)\ d[k]\^2\)\/\(\((1 + h\^2)\)\^\(3/2\)\ 
          \@\(1 - k\^2\)\ \((1 + k\^2)\)\^\(3/2\)\) + 
      \(\((\(-1\) + h)\)\^3\ \((\(-1\) + k)\)\ \((1 + k)\)\ 
          d[x]\^2\)\/\(\((1 + h)\)\ \((1 + h\^2)\)\ \((1 + k\^2)\)\) + 
      \(\((1 + h)\)\^3\ \((\(-1\) + k)\)\ \((1 + k)\)\ 
          d[y]\^2\)\/\(\((\(-1\) + h)\)\ \((1 + h\^2)\)\ \((1 + k\^2)\)\)\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xIN = {h, k, x, y}\)], "Input"],

Cell[BoxData[
    \({h, k, x, y}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(gIN = Factor[metric[ds2, xIN]]\)], "Input"],

Cell[BoxData[
    \({{\(-
          \(\(4\ \((1 - h\^2)\)\^\(3/2\)\ 
                \@\(1 + k\^2\)\)\/\(\((1 + h\^2)\)\^\(7/2\)\ 
                \@\(1 - k\^2\)\)\)\), 0, 0, 0}, {0, 
        \(4\ \((1 - h\^2)\)\^\(3/2\)\)\/\(\((1 + h\^2)\)\^\(3/2\)\ 
            \@\(1 - k\^2\)\ \((1 + k\^2)\)\^\(3/2\)\), 0, 0}, {0, 0, 
        \(\((\(-1\) + h)\)\^3\ \((\(-1\) + k)\)\ 
            \((1 + k)\)\)\/\(\((1 + h)\)\ \((1 + h\^2)\)\ \((1 + k\^2)\)\), 
        0}, {0, 0, 0, 
        \(\((1 + h)\)\^3\ \((\(-1\) + k)\)\ 
            \((1 + k)\)\)\/\(\((\(-1\) + h)\)\ \((1 + h\^2)\)\ 
            \((1 + k\^2)\)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RGtensors[gIN, xIN]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gdd = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(4\ \((1 - h\^2)\)\^\(3/2\)\ 
                          \@\(1 + k\^2\)\)\/\(\((1 + h\^2)\)\^\(7/2\)\ 
                          \@\(1 - k\^2\)\)\)\), "0", "0", "0"},
               
                 {"0", \(\(4\ 
                        \((1 - h\^2)\)\^\(3/2\)\)\/\(\((1 + h\^2)\)\^\(3/2\)\ 
                        \@\(1 - k\^2\)\ \((1 + k\^2)\)\^\(3/2\)\)\), "0", 
                  "0"},
               
                 {"0", "0", 
                  \(\(\((\(-1\) + h)\)\^3\ \((\(-1\) + k)\)\ 
                        \((1 + k)\)\)\/\(\((1 + h)\)\ \((1 + h\^2)\)\ 
                        \((1 + k\^2)\)\)\), "0"},
               
                 {"0", "0", "0", 
                  \(\(\((1 + h)\)\^3\ \((\(-1\) + k)\)\ 
                        \((1 + k)\)\)\/\(\((\(-1\) + h)\)\ \((1 + h\^2)\)\ 
                        \((1 + k\^2)\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gdd = ", 
        MatrixForm[ {{
          Times[ -4, 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ h, 2]]], 
              Rational[ 3, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], 
              Rational[ -7, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ k, 2]]], 
              Rational[ -1, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], 
              Rational[ 1, 2]]], 0, 0, 0}, {0, 
          Times[ 4, 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ h, 2]]], 
              Rational[ 3, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], 
              Rational[ -3, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ k, 2]]], 
              Rational[ -1, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], 
              Rational[ -3, 2]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ -1, h], 3], 
            Power[ 
              Plus[ 1, h], -1], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], -1], 
            Plus[ -1, k], 
            Plus[ 1, k], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], -1]], 0}, {0, 0, 0, 
          Times[ 
            Power[ 
              Plus[ -1, h], -1], 
            Power[ 
              Plus[ 1, h], 3], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], -1], 
            Plus[ -1, k], 
            Plus[ 1, k], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], -1]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("LineElement = "\), "\[InvisibleSpace]", 
        TagBox[
          \(\(-\(\(4\ \((1 - h\^2)\)\^\(3/2\)\ \@\(1 + k\^2\)\ 
                    d[h]\^2\)\/\(\((1 + h\^2)\)\^\(7/2\)\ 
                    \@\(1 - k\^2\)\)\)\) + 
            \(4\ \((1 - h\^2)\)\^\(3/2\)\ 
                d[k]\^2\)\/\(\((1 + h\^2)\)\^\(3/2\)\ \@\(1 - k\^2\)\ 
                \((1 + k\^2)\)\^\(3/2\)\) + 
            \(\((\(-1\) + h)\)\^3\ \((\(-1\) + k\^2)\)\ 
                d[x]\^2\)\/\(\((1 + h)\)\ \((1 + h\^2)\)\ \((1 + k\^2)\)\) + 
            \(\((1 + h)\)\^3\ \((\(-1\) + k\^2)\)\ 
                d[y]\^2\)\/\(\((\(-1\) + h)\)\ \((1 + h\^2)\)\ 
                \((1 + k\^2)\)\)\),
          (Short[ #, 32]&)]}],
      SequenceForm[ "LineElement = ", 
        Short[ 
          Plus[ 
            Times[ -4, 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ h, 2]]], 
                Rational[ 3, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ h, 2]], 
                Rational[ -7, 2]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ k, 2]]], 
                Rational[ -1, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ k, 2]], 
                Rational[ 1, 2]], 
              Power[ 
                d[ h], 2]], 
            Times[ 4, 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ h, 2]]], 
                Rational[ 3, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ h, 2]], 
                Rational[ -3, 2]], 
              Power[ 
                Plus[ 1, 
                  Times[ -1, 
                    Power[ k, 2]]], 
                Rational[ -1, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ k, 2]], 
                Rational[ -3, 2]], 
              Power[ 
                d[ k], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, h], 3], 
              Power[ 
                Plus[ 1, h], -1], 
              Power[ 
                Plus[ 1, 
                  Power[ h, 2]], -1], 
              Plus[ -1, 
                Power[ k, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ k, 2]], -1], 
              Power[ 
                d[ x], 2]], 
            Times[ 
              Power[ 
                Plus[ -1, h], -1], 
              Power[ 
                Plus[ 1, h], 3], 
              Power[ 
                Plus[ 1, 
                  Power[ h, 2]], -1], 
              Plus[ -1, 
                Power[ k, 2]], 
              Power[ 
                Plus[ 1, 
                  Power[ k, 2]], -1], 
              Power[ 
                d[ y], 2]]], 32]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\("gUU = "\), "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
               
                 {\(-\(\(\((1 + h\^2)\)\^\(7/2\)\ \@\(1 - k\^2\)\)\/\(4\ 
                          \((1 - h\^2)\)\^\(3/2\)\ \@\(1 + k\^2\)\)\)\), "0", 
                  "0", "0"},
               
                 {"0", \(\(\((1 + h\^2)\)\^\(3/2\)\ \@\(1 - k\^2\)\ 
                        \((1 + k\^2)\)\^\(3/2\)\)\/\(4\ 
                        \((1 - h\^2)\)\^\(3/2\)\)\), "0", "0"},
               
                 {"0", "0", 
                  \(\(\((1 + h)\)\ \((1 + h\^2)\)\ 
                        \((1 + k\^2)\)\)\/\(\((\(-1\) + h)\)\^3\ 
                        \((\(-1\) + k\^2)\)\)\), "0"},
               
                 {"0", "0", "0", 
                  \(\(\((\(-1\) + h)\)\ \((1 + h\^2)\)\ 
                        \((1 + k\^2)\)\)\/\(\((1 + h)\)\^3\ 
                        \((\(-1\) + k\^2)\)\)\)}
                }], "\[NoBreak]", ")"}],
          (MatrixForm[ #]&)]}],
      SequenceForm[ "gUU = ", 
        MatrixForm[ {{
          Times[ 
            Rational[ -1, 4], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ h, 2]]], 
              Rational[ -3, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], 
              Rational[ 7, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ k, 2]]], 
              Rational[ 1, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], 
              Rational[ -1, 2]]], 0, 0, 0}, {0, 
          Times[ 
            Rational[ 1, 4], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ h, 2]]], 
              Rational[ -3, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ h, 2]], 
              Rational[ 3, 2]], 
            Power[ 
              Plus[ 1, 
                Times[ -1, 
                  Power[ k, 2]]], 
              Rational[ 1, 2]], 
            Power[ 
              Plus[ 1, 
                Power[ k, 2]], 
              Rational[ 3, 2]]], 0, 0}, {0, 0, 
          Times[ 
            Power[ 
              Plus[ -1, h], -3], 
            Plus[ 1, h], 
            Plus[ 1, 
              Power[ h, 2]], 
            Power[ 
              Plus[ -1, 
                Power[ k, 2]], -1], 
            Plus[ 1, 
              Power[ k, 2]]], 0}, {0, 0, 0, 
          Times[ 
            Plus[ -1, h], 
            Power[ 
              Plus[ 1, h], -3], 
            Plus[ 1, 
              Power[ h, 2]], 
            Power[ 
              Plus[ -1, 
                Power[ k, 2]], -1], 
            Plus[ 1, 
              Power[ k, 2]]]}}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("gUU computed in "\[InvisibleSpace]0.11666666666666714`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "gUU computed in ", 0.11666666666666714, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Gamma computed in "\[InvisibleSpace]0.1666666666666643`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Gamma computed in ", 0.1666666666666643, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(dddd) computed in "\[InvisibleSpace]9.383333333333333`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Riemann(dddd) computed in ", 9.3833333333333329, " sec"],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Riemann(Uddd) computed in "\[InvisibleSpace]0.18333333333333712`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ 
      "Riemann(Uddd) computed in ", 0.18333333333333712, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Ricci computed in "\[InvisibleSpace]0.04999999999999716`
        \[InvisibleSpace]" sec"\),
      SequenceForm[ "Ricci computed in ", 0.049999999999997158, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Weyl computed in "\[InvisibleSpace]0.`\[InvisibleSpace]" sec"\),
      SequenceForm[ "Weyl computed in ", 0.0, " sec"],
      Editable->False]], "Print"],

Cell[BoxData[
    \("Ricci Flat"\)], "Output",
  FontSize->20,
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]],

Cell[BoxData[
    \("All tasks completed in 9.93333 seconds"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(detg\)], "Input"],

Cell[BoxData[
    \(\(-\(\(16\ \((\(-1\) + h\^2)\)\^5\ 
            \((\(-1\) + k\^2)\)\)\/\(\((1 + h\^2)\)\^7\ 
            \((1 + k\^2)\)\^3\)\)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Classify[Wdddd]\)], "Input"],

Cell[BoxData[
    \("Type I - G"\)], "Print"],

Cell[BoxData[
    \({1111}\)], "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[TextData[{
  StyleBox["\nWarning",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": Even though Classify takes very little time in these examples, it can \
take a ",
  StyleBox["very long",
    FontSlant->"Italic"],
  " time on algebraically complicated metrics, as it evaluates expressions \
that are up to order 12 in the components of the input tensors. \
Classify[Wdddd] usually takes a few times as long as RGtensors takes to \
compute all tensors; but for complicated metrics it can take hundreds of \
times as long! "
}], "Text",
  FontSize->16],

Cell[TextData[{
  "In approximate calculations, the result returned by Classify can be \
misleading, as it depends on high order combinations of the relevant tensor \
components. For example, for a perturbed type D metric which is type I, when \
evaluated exactly, ",
  StyleBox["Classify[Wdddd]",
    FontWeight->"Bold"],
  " at low approximations will give more special results (type D or II). See \
the example ",
  StyleBox["ClassifyApproximateMetrics.nb",
    FontWeight->"Bold"],
  " in ",
  ButtonBox["AdditionalExamples.html",
    ButtonData:>{
      URL[ 
      "http://www.inp.demokritos.gr/~sbonano/RGTC/AdditionalExamples.html"], 
      None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "Classify[Rdd] finds the root multiplicity first and then tests the \
possible minimal polynomials for that multiplicity, starting with the one of \
lowest degree. Lastly, for the particular minimal polynomial found, it tests \
whether a matrix identity with some terms missing is satisfied. In some cases \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3 gives erroneous results for this last step, because it cannot solve the \
system of nonlinear equations obtained."
}], "Text",
  FontSize->16],

Cell[TextData[{
  "It is possible, especially with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " versions <5.0, that due to inadequate simplification, Classify[Wdddd] \
will print the message: \"",
  StyleBox[
  "Cannot perform classification; try different coordinates or frame!",
    FontSlant->"Italic"],
  "\". This happens in the last example in section 7.4, where a change of \
coordinate solves the problem. For the same reason, it can happen that \
Classify will be unable to verify that Wdddd (or gdd.EUd) has the correct \
symmetries and will not proceed with the classification! "
}], "Text",
  FontSize->16]
}, Closed]],

Cell["", "Text",
  FontSize->10,
  FontColor->RGBColor[0, 0, 1]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 1024}, {0, 748}},
CellGrouping->Manual,
WindowSize->{956, 721},
WindowMargins->{{6, Automatic}, {Automatic, 1}},
Magnification->1.25,
MacintoshSystemPageSetup->"\<\
0040001804P000000aP2I0000003609To`83609T0@00001804P000000aP2I001
0@00I00100000@0200000BL?00400000000000000000051`I6H0I00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "blank 4"->{
    Cell[327444, 10871, 87, 3, 29, "Text",
      CellTags->"blank 4"]},
  "sec 5"->{
    Cell[346810, 11557, 284, 10, 54, "Subsubsection",
      CellTags->"sec 5"],
    Cell[347097, 11569, 345, 12, 65, "Text",
      CellTags->"sec 5"],
    Cell[347467, 11585, 78, 2, 33, "Input",
      CellTags->"sec 5"],
    Cell[347871, 11599, 506, 13, 89, "Text",
      CellTags->"sec 5"],
    Cell[348572, 11624, 379, 8, 89, "Text",
      CellTags->"sec 5"],
    Cell[349072, 11643, 187, 7, 41, "Text",
      CellTags->"sec 5"],
    Cell[349393, 11661, 321, 9, 65, "Text",
      CellTags->"sec 5"]},
  "ExactSolBook"->{
    Cell[684822, 22091, 357, 8, 89, "Text",
      CellTags->"ExactSolBook"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"blank 4", 858283, 27954},
  {"sec 5", 858368, 27957},
  {"ExactSolBook", 858891, 27972}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 413, 15, 137, "Text"],
Cell[2147, 68, 151, 5, 39, "Text"],
Cell[2301, 75, 1358, 47, 185, "Text"]
}, Closed]],
Cell[3674, 125, 612, 21, 46, "Text"],

Cell[CellGroupData[{
Cell[4311, 150, 157, 4, 72, "Section"],

Cell[CellGroupData[{
Cell[4493, 158, 89, 2, 57, "Subsection"],
Cell[4585, 162, 891, 23, 161, "Text"],
Cell[5479, 187, 833, 23, 137, "Text"],
Cell[6315, 212, 845, 38, 65, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7197, 255, 107, 2, 57, "Subsection"],
Cell[7307, 259, 1592, 50, 290, "Text"],

Cell[CellGroupData[{
Cell[8924, 313, 966, 32, 137, "Text"],
Cell[9893, 347, 206, 8, 41, "Text"],
Cell[10102, 357, 213, 9, 41, "Text"],
Cell[10318, 368, 256, 9, 41, "Text"],
Cell[10577, 379, 248, 10, 41, "Text"],
Cell[10828, 391, 248, 9, 41, "Text"],
Cell[11079, 402, 354, 15, 41, "Text"],
Cell[11436, 419, 438, 19, 41, "Text"],
Cell[11877, 440, 375, 16, 41, "Text"],
Cell[12255, 458, 217, 9, 41, "Text"]
}, Closed]],
Cell[12487, 470, 1145, 35, 156, "Text"],
Cell[13635, 507, 1457, 42, 233, "Text"],

Cell[CellGroupData[{
Cell[15117, 553, 119, 2, 54, "Subsubsection"],
Cell[15239, 557, 595, 18, 89, "Text"],
Cell[15837, 577, 503, 20, 65, "Text"],
Cell[16343, 599, 485, 21, 65, "Text"],
Cell[16831, 622, 608, 23, 89, "Text"],
Cell[17442, 647, 391, 16, 41, "Text"],
Cell[17836, 665, 167, 9, 41, "Text"],
Cell[18006, 676, 465, 19, 41, "Text"],
Cell[18474, 697, 1505, 58, 161, "Text"]
}, Closed]],
Cell[19994, 758, 309, 11, 84, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[20340, 774, 125, 2, 36, "Subsection"],
Cell[20468, 778, 295, 12, 41, "Text"],
Cell[20766, 792, 179, 8, 41, "Text"],
Cell[20948, 802, 286, 13, 41, "Text"],
Cell[21237, 817, 234, 9, 41, "Text"],
Cell[21474, 828, 505, 21, 65, "Text"],
Cell[21982, 851, 505, 21, 65, "Text"],
Cell[22490, 874, 618, 28, 65, "Text"],
Cell[23111, 904, 613, 27, 65, "Text"],
Cell[23727, 933, 339, 15, 41, "Text"],
Cell[24069, 950, 525, 23, 65, "Text"],
Cell[24597, 975, 1136, 52, 89, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[25770, 1032, 106, 2, 36, "Subsection"],
Cell[25879, 1036, 759, 22, 113, "Text"],
Cell[26641, 1060, 389, 17, 41, "Text"],
Cell[27033, 1079, 274, 13, 41, "Text"],
Cell[27310, 1094, 421, 18, 65, "Text"],
Cell[27734, 1114, 455, 16, 65, "Text"],
Cell[28192, 1132, 652, 24, 89, "Text"],
Cell[28847, 1158, 2065, 82, 185, "Text"],
Cell[30915, 1242, 557, 15, 89, "Text"],
Cell[31475, 1259, 807, 23, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[32319, 1287, 113, 2, 36, "Subsection"],
Cell[32435, 1291, 129, 4, 41, "Text"],

Cell[CellGroupData[{
Cell[32589, 1299, 973, 34, 113, "Text"],
Cell[33565, 1335, 418, 19, 41, "Text"],
Cell[33986, 1356, 434, 19, 41, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[34457, 1380, 980, 34, 108, "Text"],
Cell[35440, 1416, 434, 19, 41, "Text"],
Cell[35877, 1437, 446, 19, 41, "Text"],
Cell[36326, 1458, 492, 24, 41, "Text"],
Cell[36821, 1484, 508, 20, 65, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[37366, 1509, 1308, 51, 132, "Text"],
Cell[38677, 1562, 749, 29, 65, "Text"],
Cell[39429, 1593, 1133, 49, 69, "Text"],
Cell[40565, 1644, 1058, 36, 89, "Text"]
}, Closed]],
Cell[41638, 1683, 754, 27, 84, "Text"],
Cell[42395, 1712, 762, 30, 89, "Text"],

Cell[CellGroupData[{
Cell[43182, 1746, 726, 24, 113, "Text"],
Cell[43911, 1772, 497, 14, 89, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[44457, 1792, 110, 2, 36, "Subsection"],
Cell[44570, 1796, 451, 10, 89, "Text"],

Cell[CellGroupData[{
Cell[45046, 1810, 294, 13, 54, "Subsubsection"],
Cell[45343, 1825, 767, 26, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[46147, 1856, 280, 12, 36, "Subsubsection"],
Cell[46430, 1870, 649, 21, 161, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[47116, 1896, 274, 12, 36, "Subsubsection"],
Cell[47393, 1910, 442, 15, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[47872, 1930, 270, 12, 36, "Subsubsection"],
Cell[48145, 1944, 459, 15, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[48641, 1964, 351, 15, 36, "Subsubsection"],
Cell[48995, 1981, 440, 19, 41, "Text"]
}, Closed]],
Cell[49450, 2003, 568, 22, 60, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[50055, 2030, 91, 2, 36, "Subsection"],
Cell[50149, 2034, 450, 12, 89, "Text"]
}, Closed]],
Cell[50614, 2049, 540, 12, 108, "Text"],
Cell[51157, 2063, 790, 30, 89, "Text"]
}, Open  ]],
Cell[51962, 2096, 64, 2, 34, "Text"],

Cell[CellGroupData[{
Cell[52051, 2102, 155, 4, 72, "Section"],
Cell[52209, 2108, 49, 1, 33, "Input"],
Cell[52261, 2111, 503, 17, 89, "Text"],
Cell[52767, 2130, 38, 1, 33, "Input"],
Cell[52808, 2133, 453, 16, 65, "Text"],
Cell[53264, 2151, 250, 8, 65, "Text"]
}, Closed]],
Cell[53529, 2162, 64, 2, 29, "Text"],

Cell[CellGroupData[{
Cell[53618, 2168, 440, 15, 92, "Section"],
Cell[54061, 2185, 307, 11, 84, "Text"],
Cell[54371, 2198, 61, 1, 33, "Input"],

Cell[CellGroupData[{
Cell[54457, 2203, 149, 5, 57, "Subsection"],
Cell[54609, 2210, 398, 11, 65, "Text"],
Cell[55010, 2223, 77, 1, 33, "Input"],
Cell[55090, 2226, 494, 8, 71, "Input"],

Cell[CellGroupData[{
Cell[55609, 2238, 57, 1, 33, "Input"],
Cell[55669, 2241, 2385, 70, 70, "Print"],
Cell[58057, 2313, 2428, 68, 70, "Print"],
Cell[60488, 2383, 2243, 62, 70, "Print"],
Cell[62734, 2447, 242, 5, 70, "Print"],
Cell[62979, 2454, 246, 5, 70, "Print"],
Cell[63228, 2461, 269, 6, 70, "Print"],
Cell[63500, 2469, 117, 4, 70, "Output"],
Cell[63620, 2475, 61, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63718, 2481, 52, 1, 33, "Input"],
Cell[63773, 2484, 231, 4, 70, "Output"]
}, Open  ]],
Cell[64019, 2491, 145, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[64189, 2500, 42, 1, 33, "Input"],
Cell[64234, 2503, 299, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64570, 2512, 50, 1, 33, "Input"],
Cell[64623, 2515, 299, 4, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[64971, 2525, 95, 2, 36, "Subsection"],
Cell[65069, 2529, 77, 1, 70, "Input"],
Cell[65149, 2532, 150, 3, 70, "Input"],
Cell[65302, 2537, 60, 1, 70, "Input"],
Cell[65365, 2540, 665, 28, 70, "Text"],

Cell[CellGroupData[{
Cell[66055, 2572, 53, 1, 70, "Input"],
Cell[66111, 2575, 929, 27, 70, "Print"],
Cell[67043, 2604, 1089, 35, 70, "Print"],
Cell[68135, 2641, 963, 28, 70, "Print"],
Cell[69101, 2671, 242, 5, 70, "Print"],
Cell[69346, 2678, 246, 5, 70, "Print"],
Cell[69595, 2685, 268, 6, 70, "Print"],
Cell[69866, 2693, 269, 6, 70, "Print"],
Cell[70138, 2701, 201, 4, 70, "Print"],
Cell[70342, 2707, 199, 4, 70, "Print"],
Cell[70544, 2713, 116, 4, 70, "Output"],
Cell[70663, 2719, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70774, 2725, 56, 1, 70, "Input"],
Cell[70833, 2728, 77, 1, 70, "Output"]
}, Open  ]],
Cell[70925, 2732, 150, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[71100, 2742, 60, 1, 70, "Input"],
Cell[71163, 2745, 70, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[71282, 2752, 123, 2, 36, "Subsection"],
Cell[71408, 2756, 77, 1, 70, "Input"],
Cell[71488, 2759, 213, 4, 70, "Input"],
Cell[71704, 2765, 60, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[71789, 2770, 53, 1, 70, "Input"],
Cell[71845, 2773, 1308, 38, 70, "Print"],
Cell[73156, 2813, 1360, 41, 70, "Print"],
Cell[74519, 2856, 1295, 38, 70, "Print"],
Cell[75817, 2896, 241, 5, 70, "Print"],
Cell[76061, 2903, 246, 5, 70, "Print"],
Cell[76310, 2910, 268, 6, 70, "Print"],
Cell[76581, 2918, 269, 6, 70, "Print"],
Cell[76853, 2926, 201, 4, 70, "Print"],
Cell[77057, 2932, 244, 5, 70, "Print"],
Cell[77304, 2939, 207, 4, 70, "Print"],
Cell[77514, 2945, 120, 4, 70, "Output"],
Cell[77637, 2951, 70, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77744, 2957, 48, 1, 70, "Input"],
Cell[77795, 2960, 56, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77888, 2966, 34, 1, 70, "Input"],
Cell[77925, 2969, 58, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78020, 2975, 57, 1, 70, "Input"],
Cell[78080, 2978, 90, 1, 70, "Output"]
}, Open  ]],
Cell[78185, 2982, 145, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[78355, 2991, 50, 1, 70, "Input"],
Cell[78408, 2994, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78483, 3000, 436, 18, 70, "Subsubsection"],
Cell[78922, 3020, 121, 2, 70, "Input"],
Cell[79046, 3024, 99, 2, 70, "Input"],
Cell[79148, 3028, 1249, 35, 70, "Input"],
Cell[80400, 3065, 675, 20, 70, "Input"],

Cell[CellGroupData[{
Cell[81100, 3089, 118, 2, 70, "Input"],
Cell[81221, 3093, 87, 1, 70, "Output"]
}, Open  ]],
Cell[81323, 3097, 247, 10, 70, "Text"],

Cell[CellGroupData[{
Cell[81595, 3111, 367, 9, 70, "Input"],
Cell[81965, 3122, 83, 1, 70, "Output"]
}, Open  ]],
Cell[82063, 3126, 120, 2, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[82232, 3134, 98, 2, 36, "Subsection"],
Cell[82333, 3138, 77, 1, 70, "Input"],
Cell[82413, 3141, 187, 3, 70, "Input"],
Cell[82603, 3146, 60, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[82688, 3151, 53, 1, 70, "Input"],
Cell[82744, 3154, 998, 30, 70, "Print"],
Cell[83745, 3186, 1103, 36, 70, "Print"],
Cell[84851, 3224, 976, 29, 70, "Print"],
Cell[85830, 3255, 242, 5, 70, "Print"],
Cell[86075, 3262, 246, 5, 70, "Print"],
Cell[86324, 3269, 269, 6, 70, "Print"],
Cell[86596, 3277, 268, 6, 70, "Print"],
Cell[86867, 3285, 246, 5, 70, "Print"],
Cell[87116, 3292, 244, 5, 70, "Print"],
Cell[87363, 3299, 122, 4, 70, "Output"],
Cell[87488, 3305, 252, 5, 70, "Print"],
Cell[87743, 3312, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87854, 3318, 48, 1, 70, "Input"],
Cell[87905, 3321, 232, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88174, 3333, 48, 1, 70, "Input"],
Cell[88225, 3336, 315, 9, 70, "Output"]
}, Open  ]],
Cell[88555, 3348, 146, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[88726, 3357, 50, 1, 70, "Input"],
Cell[88779, 3360, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[88866, 3367, 112, 2, 36, "Subsection"],
Cell[88981, 3371, 68, 1, 70, "Input"],
Cell[89052, 3374, 102, 2, 70, "Input"],
Cell[89157, 3378, 53, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[89235, 3383, 174, 7, 70, "Subsubsection"],

Cell[CellGroupData[{
Cell[89434, 3394, 53, 1, 70, "Input"],
Cell[89490, 3397, 1307, 34, 70, "Print"],
Cell[90800, 3433, 1338, 38, 70, "Print"],
Cell[92141, 3473, 1327, 34, 70, "Print"],
Cell[93471, 3509, 241, 5, 70, "Print"],
Cell[93715, 3516, 246, 5, 70, "Print"],
Cell[93964, 3523, 267, 6, 70, "Print"],
Cell[94234, 3531, 267, 6, 70, "Print"],
Cell[94504, 3539, 246, 5, 70, "Print"],
Cell[94753, 3546, 242, 5, 70, "Print"],
Cell[94998, 3553, 122, 4, 70, "Output"],
Cell[95123, 3559, 252, 5, 70, "Print"],
Cell[95378, 3566, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95489, 3572, 52, 1, 70, "Input"],
Cell[95544, 3575, 283, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[95864, 3587, 48, 1, 70, "Input"],
Cell[95915, 3590, 1899, 41, 70, "Output"]
}, Open  ]],
Cell[97829, 3634, 130, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[97984, 3643, 48, 1, 70, "Input"],
Cell[98035, 3646, 37, 1, 70, "Output"]
}, Open  ]],
Cell[98087, 3650, 123, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[98235, 3659, 56, 1, 70, "Input"],
Cell[98294, 3662, 36, 1, 70, "Output"]
}, Open  ]],
Cell[98345, 3666, 124, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[98494, 3675, 58, 1, 70, "Input"],
Cell[98555, 3678, 36, 1, 70, "Output"]
}, Open  ]],
Cell[98606, 3682, 143, 5, 70, "Text"],
Cell[98752, 3689, 630, 26, 70, "Text"],

Cell[CellGroupData[{
Cell[99407, 3719, 78, 1, 70, "Input"],
Cell[99488, 3722, 220, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99745, 3730, 89, 1, 70, "Input"],
Cell[99837, 3733, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99912, 3739, 89, 1, 70, "Input"],
Cell[100004, 3742, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[100091, 3749, 185, 7, 70, "Subsubsection"],

Cell[CellGroupData[{
Cell[100301, 3760, 179, 4, 70, "Input"],
Cell[100483, 3766, 2877, 83, 70, "Print"],
Cell[103363, 3851, 3238, 98, 70, "Print"],
Cell[106604, 3951, 3359, 102, 70, "Print"],
Cell[109966, 4055, 242, 5, 70, "Print"],
Cell[110211, 4062, 244, 5, 70, "Print"],
Cell[110458, 4069, 267, 6, 70, "Print"],
Cell[110728, 4077, 269, 6, 70, "Print"],
Cell[111000, 4085, 245, 5, 70, "Print"],
Cell[111248, 4092, 244, 5, 70, "Print"],
Cell[111495, 4099, 122, 4, 70, "Output"],
Cell[111620, 4105, 207, 4, 70, "Print"],
Cell[111830, 4111, 120, 4, 70, "Output"],
Cell[111953, 4117, 134, 4, 70, "Output"],
Cell[112090, 4123, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112201, 4129, 56, 1, 70, "Input"],
Cell[112260, 4132, 128, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112425, 4140, 34, 1, 70, "Input"],
Cell[112462, 4143, 39, 1, 70, "Output"]
}, Open  ]],
Cell[112516, 4147, 130, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[112671, 4156, 48, 1, 70, "Input"],
Cell[112722, 4159, 36, 1, 70, "Output"]
}, Open  ]],
Cell[112773, 4163, 185, 7, 70, "Text"],

Cell[CellGroupData[{
Cell[112983, 4174, 50, 1, 70, "Input"],
Cell[113036, 4177, 111, 2, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[113208, 4186, 176, 4, 36, "Subsection"],
Cell[113387, 4192, 160, 6, 70, "Text"],
Cell[113550, 4200, 76, 1, 70, "Input"],
Cell[113629, 4203, 86, 1, 70, "Input"],
Cell[113718, 4206, 328, 6, 70, "Input"],
Cell[114049, 4214, 53, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[114127, 4219, 53, 1, 70, "Input"],
Cell[114183, 4222, 2959, 92, 70, "Print"],
Cell[117145, 4316, 3192, 98, 70, "Print"],
Cell[120340, 4416, 3938, 122, 70, "Print"],
Cell[124281, 4540, 240, 5, 70, "Print"],
Cell[124524, 4547, 204, 4, 70, "Print"],
Cell[124731, 4553, 266, 6, 70, "Print"],
Cell[125000, 4561, 267, 6, 70, "Print"],
Cell[125270, 4569, 245, 5, 70, "Print"],
Cell[125518, 4576, 199, 4, 70, "Print"],
Cell[125720, 4582, 116, 4, 70, "Output"],
Cell[125839, 4588, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125949, 4594, 52, 1, 70, "Input"],
Cell[126004, 4597, 68, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126109, 4603, 56, 1, 70, "Input"],
Cell[126168, 4606, 212, 3, 70, "Output"]
}, Open  ]],
Cell[126395, 4612, 145, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[126565, 4621, 60, 1, 70, "Input"],
Cell[126628, 4624, 70, 1, 70, "Output"]
}, Open  ]],
Cell[126713, 4628, 458, 19, 70, "Text"],

Cell[CellGroupData[{
Cell[127196, 4651, 60, 1, 70, "Input"],
Cell[127259, 4654, 72, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[127368, 4660, 144, 4, 70, "Subsection"],
Cell[127515, 4666, 375, 16, 70, "Text"],
Cell[127893, 4684, 178, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[128096, 4692, 113, 2, 70, "Input"],
Cell[128212, 4696, 71, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128320, 4702, 572, 15, 70, "Input"],
Cell[128895, 4719, 6539, 149, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[135471, 4873, 76, 2, 70, "Input"],
Cell[135550, 4877, 36, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[135623, 4883, 162, 4, 70, "Input"],
Cell[135788, 4889, 99, 2, 70, "Output"]
}, Open  ]],
Cell[135902, 4894, 332, 12, 70, "Text"],

Cell[CellGroupData[{
Cell[136259, 4910, 592, 16, 70, "Input"],
Cell[136854, 4928, 3472, 86, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[140363, 5019, 980, 26, 70, "Input"],
Cell[141346, 5047, 1093, 31, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[142476, 5083, 302, 6, 70, "Input"],
Cell[142781, 5091, 64, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[142894, 5098, 136, 4, 70, "Subsection"],
Cell[143033, 5104, 358, 14, 70, "Text"],

Cell[CellGroupData[{
Cell[143416, 5122, 92, 2, 70, "Input"],
Cell[143511, 5126, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[143594, 5132, 89, 2, 70, "Input"],
Cell[143686, 5136, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[143769, 5142, 107, 2, 70, "Input"],
Cell[143879, 5146, 48, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[143964, 5152, 88, 2, 70, "Input"],
Cell[144055, 5156, 90, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[144182, 5162, 92, 2, 70, "Input"],
Cell[144277, 5166, 1152, 15, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[145466, 5186, 95, 2, 70, "Input"],
Cell[145564, 5190, 90, 1, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[145715, 5198, 285, 9, 36, "Subsection"],
Cell[146003, 5209, 62, 1, 70, "Input"],
Cell[146068, 5212, 80, 1, 70, "Input"],
Cell[146151, 5215, 442, 7, 70, "Input"],
Cell[146596, 5224, 121, 2, 70, "Text"],
Cell[146720, 5228, 128, 2, 70, "Input"],
Cell[146851, 5232, 273, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[147149, 5242, 1673, 38, 70, "Input"],
Cell[148825, 5282, 4057, 108, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[152919, 5395, 59, 1, 70, "Input"],
Cell[152981, 5398, 3395, 103, 70, "Print"],
Cell[156379, 5503, 3161, 104, 70, "Print"],
Cell[159543, 5609, 3551, 107, 70, "Print"],
Cell[163097, 5718, 242, 5, 70, "Print"],
Cell[163342, 5725, 244, 5, 70, "Print"],
Cell[163589, 5732, 265, 6, 70, "Print"],
Cell[163857, 5740, 265, 6, 70, "Print"],
Cell[164125, 5748, 244, 5, 70, "Print"],
Cell[164372, 5755, 199, 4, 70, "Print"],
Cell[164574, 5761, 116, 4, 70, "Output"],
Cell[164693, 5767, 73, 1, 70, "Print"]
}, Open  ]],
Cell[164781, 5771, 562, 22, 70, "Text"],

Cell[CellGroupData[{
Cell[165368, 5797, 229, 8, 70, "Text"],
Cell[165600, 5807, 334, 13, 70, "Text"]
}, Closed]],
Cell[165949, 5823, 65, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[166051, 5829, 127, 2, 36, "Subsection"],
Cell[166181, 5833, 169, 5, 70, "Text"],
Cell[166353, 5840, 66, 1, 70, "Input"],
Cell[166422, 5843, 493, 12, 70, "Input"],
Cell[166918, 5857, 107, 2, 70, "Input"],
Cell[167028, 5861, 111, 2, 70, "Input"],
Cell[167142, 5865, 123, 2, 70, "Input"],
Cell[167268, 5869, 328, 6, 70, "Input"],
Cell[167599, 5877, 53, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[167677, 5882, 53, 1, 70, "Input"],
Cell[167733, 5885, 3975, 124, 70, "Print"],
Cell[171711, 6011, 4711, 142, 70, "Print"],
Cell[176425, 6155, 9149, 268, 70, "Print"],
Cell[185577, 6425, 240, 5, 70, "Print"],
Cell[185820, 6432, 244, 5, 70, "Print"],
Cell[186067, 6439, 226, 5, 70, "Print"],
Cell[186296, 6446, 265, 6, 70, "Print"],
Cell[186564, 6454, 242, 5, 70, "Print"],
Cell[186809, 6461, 199, 4, 70, "Print"],
Cell[187011, 6467, 116, 4, 70, "Output"],
Cell[187130, 6473, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[187240, 6479, 37, 1, 70, "Input"],
Cell[187280, 6482, 414, 7, 70, "Output"]
}, Open  ]],
Cell[187709, 6492, 747, 24, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[188493, 6521, 122, 2, 36, "Subsection"],
Cell[188618, 6525, 77, 1, 33, "Input"],
Cell[188698, 6528, 572, 10, 90, "Input"],
Cell[189273, 6540, 60, 1, 33, "Input"],

Cell[CellGroupData[{
Cell[189358, 6545, 53, 1, 33, "Input"],
Cell[189414, 6548, 2445, 70, 70, "Print"],
Cell[191862, 6620, 2287, 66, 70, "Print"],
Cell[194152, 6688, 2086, 59, 70, "Print"],
Cell[196241, 6749, 241, 5, 70, "Print"],
Cell[196485, 6756, 244, 5, 70, "Print"],
Cell[196732, 6763, 265, 6, 70, "Print"],
Cell[197000, 6771, 265, 6, 70, "Print"],
Cell[197268, 6779, 241, 5, 70, "Print"],
Cell[197512, 6786, 240, 5, 70, "Print"],
Cell[197755, 6793, 248, 5, 70, "Print"],
Cell[198006, 6800, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[198116, 6806, 52, 1, 33, "Input"],
Cell[198171, 6809, 746, 18, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[198954, 6832, 48, 1, 33, "Input"],
Cell[199005, 6835, 770, 20, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199812, 6860, 48, 1, 33, "Input"],
Cell[199863, 6863, 12620, 291, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212520, 7159, 42, 1, 33, "Input"],
Cell[212565, 7162, 299, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212901, 7171, 56, 1, 33, "Input"],
Cell[212960, 7174, 90, 1, 70, "Output"]
}, Open  ]],
Cell[213065, 7178, 202, 7, 41, "Text"],
Cell[213270, 7187, 344, 12, 84, "Text"],

Cell[CellGroupData[{
Cell[213639, 7203, 61, 1, 33, "Input"],
Cell[213703, 7206, 2445, 70, 70, "Print"],
Cell[216151, 7278, 2287, 66, 70, "Print"],
Cell[218441, 7346, 2086, 59, 70, "Print"],
Cell[220530, 7407, 242, 5, 70, "Print"],
Cell[220775, 7414, 244, 5, 70, "Print"],
Cell[221022, 7421, 265, 6, 70, "Print"],
Cell[221290, 7429, 125, 4, 70, "Output"],
Cell[221418, 7435, 242, 5, 70, "Print"],
Cell[221663, 7442, 131, 4, 70, "Output"],
Cell[221797, 7448, 248, 5, 70, "Print"],
Cell[222048, 7455, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[222158, 7461, 64, 1, 33, "Input"],
Cell[222225, 7464, 2445, 70, 70, "Print"],
Cell[224673, 7536, 2287, 66, 70, "Print"],
Cell[226963, 7604, 2086, 59, 70, "Print"],
Cell[229052, 7665, 242, 5, 70, "Print"],
Cell[229297, 7672, 244, 5, 70, "Print"],
Cell[229544, 7679, 264, 6, 70, "Print"],
Cell[229811, 7687, 265, 6, 70, "Print"],
Cell[230079, 7695, 242, 5, 70, "Print"],
Cell[230324, 7702, 131, 4, 70, "Output"],
Cell[230458, 7708, 135, 4, 70, "Output"],
Cell[230596, 7714, 73, 1, 70, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[230718, 7721, 132, 3, 36, "Subsection"],
Cell[230853, 7726, 336, 11, 63, "Text"],
Cell[231192, 7739, 77, 1, 33, "Input"],
Cell[231272, 7742, 647, 11, 138, "Input"],
Cell[231922, 7755, 173, 6, 79, "Text"],
Cell[232098, 7763, 60, 1, 33, "Input"],

Cell[CellGroupData[{
Cell[232183, 7768, 64, 1, 33, "Input"],
Cell[232250, 7771, 3072, 91, 125, "Print"],
Cell[235325, 7864, 3375, 99, 120, "Print"],
Cell[238703, 7965, 4878, 151, 142, "Print"],
Cell[243584, 8118, 240, 5, 28, "Print"],
Cell[243827, 8125, 202, 4, 28, "Print"],
Cell[244032, 8131, 265, 6, 28, "Print"],
Cell[244300, 8139, 265, 6, 28, "Print"],
Cell[244568, 8147, 242, 5, 28, "Print"],
Cell[244813, 8154, 131, 4, 38, "Output"],
Cell[244947, 8160, 135, 4, 38, "Output"],
Cell[245085, 8166, 73, 1, 28, "Print"]
}, Open  ]],
Cell[245173, 8170, 422, 15, 65, "Text"],

Cell[CellGroupData[{
Cell[245620, 8189, 48, 1, 33, "Input"],
Cell[245671, 8192, 10923, 173, 1103, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[256631, 8370, 44, 1, 28, "Input"],
Cell[256678, 8373, 40, 1, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[256755, 8379, 56, 1, 33, "Input"],
Cell[256814, 8382, 443, 7, 84, "Output"]
}, Open  ]],
Cell[257272, 8392, 16, 0, 36, "Text"],

Cell[CellGroupData[{
Cell[257313, 8396, 236, 9, 62, "Text"],

Cell[CellGroupData[{
Cell[257574, 8409, 223, 6, 35, "Input"],
Cell[257800, 8417, 347, 6, 57, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[258184, 8428, 87, 2, 33, "Input"],
Cell[258274, 8432, 3072, 91, 125, "Print"],
Cell[261349, 8525, 3776, 111, 161, "Print"],
Cell[265128, 8638, 4171, 130, 138, "Print"],
Cell[269302, 8770, 240, 5, 28, "Print"],
Cell[269545, 8777, 244, 5, 28, "Print"],
Cell[269792, 8784, 267, 6, 28, "Print"],
Cell[270062, 8792, 267, 6, 28, "Print"],
Cell[270332, 8800, 246, 5, 28, "Print"],
Cell[270581, 8807, 199, 4, 28, "Print"],
Cell[270783, 8813, 116, 4, 43, "Output"],
Cell[270902, 8819, 73, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[271012, 8825, 86, 2, 33, "Input"],
Cell[271101, 8829, 129, 2, 55, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[271267, 8836, 90, 2, 33, "Input"],
Cell[271360, 8840, 169, 2, 56, "Output"]
}, Open  ]],
Cell[271544, 8845, 162, 5, 41, "Text"],
Cell[271709, 8852, 53, 1, 33, "Input"]
}, Closed]]
}, Closed]],
Cell[271789, 8857, 26, 0, 28, "Input"],

Cell[CellGroupData[{
Cell[271840, 8861, 109, 2, 33, "Input"],
Cell[271952, 8865, 189, 4, 28, "Print"]
}, Open  ]],
Cell[272156, 8872, 588, 17, 132, "Text"]
}, Closed]],
Cell[272759, 8892, 64, 2, 29, "Text"],

Cell[CellGroupData[{
Cell[272848, 8898, 177, 4, 72, "Section"],

Cell[CellGroupData[{
Cell[273050, 8906, 247, 10, 57, "Subsection"],
Cell[273300, 8918, 1450, 43, 209, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[274787, 8966, 268, 10, 36, "Subsection"],
Cell[275058, 8978, 969, 24, 161, "Text"],
Cell[276030, 9004, 424, 8, 113, "Text"],
Cell[276457, 9014, 841, 23, 137, "Text"],
Cell[277301, 9039, 387, 10, 89, "Text"],
Cell[277691, 9051, 93, 1, 33, "Input"],
Cell[277787, 9054, 533, 19, 89, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[278357, 9078, 262, 10, 36, "Subsection"],
Cell[278622, 9090, 264, 10, 41, "Text"],
Cell[278889, 9102, 488, 23, 41, "Text"],
Cell[279380, 9127, 432, 20, 41, "Text"],
Cell[279815, 9149, 1599, 65, 137, "Text"],

Cell[CellGroupData[{
Cell[281439, 9218, 598, 21, 89, "Text"],

Cell[CellGroupData[{
Cell[282062, 9243, 65, 1, 33, "Input"],
Cell[282130, 9246, 54, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[282221, 9252, 67, 1, 33, "Input"],
Cell[282291, 9255, 41, 1, 70, "Output"]
}, Open  ]],
Cell[282347, 9259, 127, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[282499, 9266, 66, 1, 33, "Input"],
Cell[282568, 9269, 60, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[282665, 9275, 40, 1, 33, "Input"],
Cell[282708, 9278, 35, 1, 70, "Output"]
}, Open  ]],
Cell[282758, 9282, 525, 18, 89, "Text"],

Cell[CellGroupData[{
Cell[283308, 9304, 951, 31, 35, "Input"],
Cell[284262, 9337, 105, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[284404, 9344, 85, 2, 33, "Input"],
Cell[284492, 9348, 91, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[284620, 9354, 99, 2, 33, "Input"],
Cell[284722, 9358, 55, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[284814, 9364, 111, 2, 33, "Input"],
Cell[284928, 9368, 37, 1, 70, "Output"]
}, Open  ]],
Cell[284980, 9372, 129, 4, 41, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[285146, 9381, 735, 25, 84, "Text"],
Cell[285884, 9408, 161, 6, 41, "Text"],

Cell[CellGroupData[{
Cell[286070, 9418, 81, 1, 33, "Input"],
Cell[286154, 9421, 52, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[286243, 9427, 181, 4, 33, "Input"],
Cell[286427, 9433, 78, 1, 70, "Output"]
}, Open  ]],
Cell[286520, 9437, 266, 11, 41, "Text"],

Cell[CellGroupData[{
Cell[286811, 9452, 40, 1, 33, "Input"],
Cell[286854, 9455, 35, 1, 70, "Output"]
}, Open  ]],
Cell[286904, 9459, 219, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[287148, 9470, 81, 1, 33, "Input"],
Cell[287232, 9473, 72, 1, 70, "Output"]
}, Open  ]],
Cell[287319, 9477, 182, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[287526, 9488, 129, 3, 33, "Input"],
Cell[287658, 9493, 364, 6, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[288059, 9504, 46, 1, 33, "Input"],
Cell[288108, 9507, 73, 1, 70, "Output"]
}, Open  ]],
Cell[288196, 9511, 319, 11, 65, "Text"],

Cell[CellGroupData[{
Cell[288540, 9526, 53, 1, 33, "Input"],
Cell[288596, 9529, 306, 6, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[288939, 9540, 62, 1, 33, "Input"],
Cell[289004, 9543, 159, 3, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[289190, 9550, 1766, 71, 156, "Text"],
Cell[290959, 9623, 536, 21, 65, "Text"],

Cell[CellGroupData[{
Cell[291520, 9648, 876, 36, 89, "Text"],

Cell[CellGroupData[{
Cell[292421, 9688, 101, 2, 33, "Input"],
Cell[292525, 9692, 409, 12, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[292971, 9709, 59, 1, 33, "Input"],
Cell[293033, 9712, 64, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[293134, 9718, 62, 1, 33, "Input"],
Cell[293199, 9721, 51, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[293287, 9727, 55, 1, 33, "Input"],
Cell[293345, 9730, 309, 8, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[293691, 9743, 58, 1, 33, "Input"],
Cell[293752, 9746, 245, 6, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[294034, 9757, 88, 1, 33, "Input"],
Cell[294125, 9760, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[294208, 9766, 84, 1, 33, "Input"],
Cell[294295, 9769, 62, 1, 70, "Output"]
}, Open  ]],
Cell[294372, 9773, 346, 13, 65, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[294755, 9791, 399, 15, 60, "Text"],

Cell[CellGroupData[{
Cell[295179, 9810, 901, 23, 33, "Input"],
Cell[296083, 9835, 156, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[296276, 9842, 190, 4, 33, "Input"],
Cell[296469, 9848, 103, 2, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[296633, 9857, 243, 10, 36, "Subsection"],
Cell[296879, 9869, 617, 22, 89, "Text"],
Cell[297499, 9893, 530, 17, 89, "Text"],
Cell[298032, 9912, 920, 26, 161, "Text"],

Cell[CellGroupData[{
Cell[298977, 9942, 443, 17, 86, "Text"],
Cell[299423, 9961, 348, 8, 70, "Input"],
Cell[299774, 9971, 146, 3, 70, "Input"],
Cell[299923, 9976, 297, 12, 70, "Text"],
Cell[300223, 9990, 302, 12, 70, "Text"]
}, Closed]],
Cell[300540, 10005, 529, 15, 84, "Text"],

Cell[CellGroupData[{
Cell[301094, 10024, 391, 12, 86, "Text"],

Cell[CellGroupData[{
Cell[301510, 10040, 74, 2, 70, "Input"],
Cell[301587, 10044, 36, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[301660, 10050, 170, 4, 70, "Input"],
Cell[301833, 10056, 327, 5, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[302197, 10066, 91, 2, 70, "Input"],
Cell[302291, 10070, 398, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[302726, 10082, 95, 2, 70, "Input"],
Cell[302824, 10086, 314, 6, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[303175, 10097, 213, 5, 70, "Input"],
Cell[303391, 10104, 152, 3, 70, "Output"]
}, Open  ]],
Cell[303558, 10110, 85, 2, 70, "Input"],

Cell[CellGroupData[{
Cell[303668, 10116, 80, 2, 70, "Input"],
Cell[303751, 10120, 327, 5, 70, "Output"]
}, Open  ]],
Cell[304093, 10128, 747, 27, 70, "Text"]
}, Closed]],
Cell[304855, 10158, 501, 19, 60, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[305393, 10182, 233, 10, 36, "Subsection"],
Cell[305629, 10194, 896, 33, 113, "Text"],

Cell[CellGroupData[{
Cell[306550, 10231, 124, 3, 33, "Input"],
Cell[306677, 10236, 1074, 27, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[307788, 10268, 127, 3, 33, "Input"],
Cell[307918, 10273, 2014, 52, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[309969, 10330, 150, 3, 33, "Input"],
Cell[310122, 10335, 4191, 111, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[314350, 10451, 165, 4, 33, "Input"],
Cell[314518, 10457, 4158, 107, 70, "Output"]
}, Open  ]],
Cell[318691, 10567, 426, 14, 65, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[319154, 10586, 237, 10, 36, "Subsection"],
Cell[319394, 10598, 754, 22, 137, "Text"],
Cell[320151, 10622, 507, 14, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[320695, 10641, 270, 10, 36, "Subsection"],
Cell[320968, 10653, 788, 20, 137, "Text"],
Cell[321759, 10675, 394, 13, 65, "Text"],
Cell[322156, 10690, 785, 29, 113, "Text"],
Cell[322944, 10721, 3166, 106, 377, "Text"],
Cell[326113, 10829, 1304, 38, 185, "Text"]
}, Closed]]
}, Closed]],
Cell[327444, 10871, 87, 3, 29, "Text",
  CellTags->"blank 4"],

Cell[CellGroupData[{
Cell[327556, 10878, 184, 4, 72, "Section"],
Cell[327743, 10884, 418, 13, 65, "Text"],
Cell[328164, 10899, 745, 21, 113, "Text"],
Cell[328912, 10922, 299, 8, 65, "Text"],

Cell[CellGroupData[{
Cell[329236, 10934, 169, 4, 60, "Subsection"],
Cell[329408, 10940, 186, 9, 41, "Text"],
Cell[329597, 10951, 583, 22, 89, "Text"],
Cell[330183, 10975, 257, 10, 41, "Text"],
Cell[330443, 10987, 1527, 54, 185, "Text"],
Cell[331973, 11043, 636, 23, 89, "Text"],

Cell[CellGroupData[{
Cell[332634, 11070, 246, 7, 62, "Text"],
Cell[332883, 11079, 104, 2, 33, "Input"],
Cell[332990, 11083, 208, 5, 33, "Input"],
Cell[333201, 11090, 120, 2, 33, "Input"],
Cell[333324, 11094, 243, 6, 52, "Input"],
Cell[333570, 11102, 87, 2, 33, "Input"],
Cell[333660, 11106, 87, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[333772, 11112, 96, 2, 33, "Input"],
Cell[333871, 11116, 2340, 73, 137, "Print"],
Cell[336214, 11191, 3192, 98, 90, "Print"],
Cell[339409, 11291, 2433, 77, 140, "Print"],
Cell[341845, 11370, 240, 5, 28, "Print"],
Cell[342088, 11377, 254, 5, 28, "Print"],
Cell[342345, 11384, 244, 5, 28, "Print"],
Cell[342592, 11391, 267, 6, 28, "Print"],
Cell[342862, 11399, 267, 6, 28, "Print"],
Cell[343132, 11407, 246, 5, 28, "Print"],
Cell[343381, 11414, 199, 4, 28, "Print"],
Cell[343583, 11420, 116, 4, 43, "Output"],
Cell[343702, 11426, 73, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[343812, 11432, 71, 2, 33, "Input"],
Cell[343886, 11436, 65, 1, 36, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[343988, 11442, 90, 2, 33, "Input"],
Cell[344081, 11446, 287, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[344405, 11456, 89, 2, 33, "Input"],
Cell[344497, 11460, 337, 6, 53, "Output"]
}, Open  ]]
}, Closed]],
Cell[344861, 11470, 624, 22, 84, "Text"],
Cell[345488, 11494, 303, 13, 41, "Text"],
Cell[345794, 11509, 322, 13, 41, "Text"],
Cell[346119, 11524, 316, 13, 41, "Text"],
Cell[346438, 11539, 347, 14, 65, "Text"],

Cell[CellGroupData[{
Cell[346810, 11557, 284, 10, 54, "Subsubsection",
  CellTags->"sec 5"],
Cell[347097, 11569, 345, 12, 65, "Text",
  CellTags->"sec 5"],

Cell[CellGroupData[{
Cell[347467, 11585, 78, 2, 33, "Input",
  CellTags->"sec 5"],
Cell[347548, 11589, 308, 7, 48, "Output"]
}, Open  ]],
Cell[347871, 11599, 506, 13, 89, "Text",
  CellTags->"sec 5"],

Cell[CellGroupData[{
Cell[348402, 11616, 53, 1, 33, "Input"],
Cell[348458, 11619, 99, 2, 33, "Output"]
}, Open  ]],
Cell[348572, 11624, 379, 8, 89, "Text",
  CellTags->"sec 5"],

Cell[CellGroupData[{
Cell[348976, 11636, 41, 1, 33, "Input"],
Cell[349020, 11639, 37, 1, 28, "Print"]
}, Open  ]],
Cell[349072, 11643, 187, 7, 41, "Text",
  CellTags->"sec 5"],

Cell[CellGroupData[{
Cell[349284, 11654, 45, 1, 33, "Input"],
Cell[349332, 11657, 46, 1, 33, "Output"]
}, Open  ]],
Cell[349393, 11661, 321, 9, 65, "Text",
  CellTags->"sec 5"]
}, Closed]],

Cell[CellGroupData[{
Cell[349751, 11675, 97, 2, 36, "Subsubsection"],
Cell[349851, 11679, 637, 22, 89, "Text"],
Cell[350491, 11703, 632, 16, 64, "Text"],
Cell[351126, 11721, 1812, 64, 161, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[352975, 11790, 236, 7, 57, "Text"],

Cell[CellGroupData[{
Cell[353236, 11801, 75, 2, 33, "Input"],
Cell[353314, 11805, 37, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[353388, 11811, 963, 22, 71, "Input"],
Cell[354354, 11835, 572, 10, 115, "Output"]
}, Open  ]],
Cell[354941, 11848, 393, 15, 65, "Text"],
Cell[355337, 11865, 122, 2, 33, "Input"],
Cell[355462, 11869, 358, 7, 95, "Input"],
Cell[355823, 11878, 268, 6, 65, "Text"],

Cell[CellGroupData[{
Cell[356116, 11888, 106, 2, 33, "Input"],
Cell[356225, 11892, 511, 14, 86, "Print"],
Cell[356739, 11908, 3159, 97, 90, "Print"],
Cell[359901, 12007, 511, 14, 86, "Print"],
Cell[360415, 12023, 197, 4, 28, "Print"],
Cell[360615, 12029, 254, 5, 28, "Print"],
Cell[360872, 12036, 244, 5, 28, "Print"],
Cell[361119, 12043, 265, 6, 28, "Print"],
Cell[361387, 12051, 125, 4, 38, "Output"],
Cell[361515, 12057, 246, 5, 28, "Print"],
Cell[361764, 12064, 131, 4, 38, "Output"],
Cell[361898, 12070, 116, 4, 43, "Output"],
Cell[362017, 12076, 73, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[362127, 12082, 71, 2, 33, "Input"],
Cell[362201, 12086, 40, 1, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[362278, 12092, 90, 2, 33, "Input"],
Cell[362371, 12096, 213, 4, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[362621, 12105, 89, 2, 33, "Input"],
Cell[362713, 12109, 378, 6, 59, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[363128, 12120, 307, 11, 62, "Text"],
Cell[363438, 12133, 457, 12, 65, "Text"],
Cell[363898, 12147, 176, 3, 33, "Input"],

Cell[CellGroupData[{
Cell[364099, 12154, 152, 3, 33, "Input"],
Cell[364254, 12159, 54, 1, 33, "Output"]
}, Open  ]],
Cell[364323, 12163, 534, 20, 65, "Text"],

Cell[CellGroupData[{
Cell[364882, 12187, 179, 4, 33, "Input"],
Cell[365064, 12193, 70, 1, 33, "Output"]
}, Open  ]],
Cell[365149, 12197, 151, 4, 41, "Text"],

Cell[CellGroupData[{
Cell[365325, 12205, 211, 4, 33, "Input"],
Cell[365539, 12211, 70, 1, 33, "Output"]
}, Open  ]],
Cell[365624, 12215, 287, 8, 65, "Text"],

Cell[CellGroupData[{
Cell[365936, 12227, 146, 3, 33, "Input"],
Cell[366085, 12232, 266, 5, 56, "Output"]
}, Open  ]],
Cell[366366, 12240, 179, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[366570, 12251, 99, 2, 33, "Input"],
Cell[366672, 12255, 156, 3, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[366865, 12263, 409, 14, 86, "Text"],

Cell[CellGroupData[{
Cell[367299, 12281, 109, 2, 70, "Input"],
Cell[367411, 12285, 71, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[367519, 12291, 146, 3, 70, "Input"],
Cell[367668, 12296, 71, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[367776, 12302, 135, 3, 70, "Input"],
Cell[367914, 12307, 184, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[368135, 12315, 91, 2, 70, "Input"],
Cell[368229, 12319, 35, 1, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[368291, 12324, 247, 9, 36, "Text"],

Cell[CellGroupData[{
Cell[368563, 12337, 123, 2, 33, "Input"],
Cell[368689, 12341, 203, 4, 56, "Output"]
}, Open  ]],
Cell[368907, 12348, 171, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[369103, 12359, 171, 4, 33, "Input"],
Cell[369277, 12365, 282, 5, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[369596, 12375, 90, 2, 33, "Input"],
Cell[369689, 12379, 35, 1, 33, "Output"]
}, Open  ]],
Cell[369739, 12383, 120, 2, 33, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[369908, 12391, 109, 2, 36, "Subsubsection"],
Cell[370020, 12395, 2755, 92, 329, "Text"],
Cell[372778, 12489, 849, 29, 113, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[373664, 12523, 239, 7, 57, "Text"],

Cell[CellGroupData[{
Cell[373928, 12534, 75, 2, 33, "Input"],
Cell[374006, 12538, 37, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[374080, 12544, 320, 6, 85, "Input"],
Cell[374403, 12552, 1289, 23, 227, "Output"]
}, Open  ]],
Cell[375707, 12578, 301, 9, 33, "Input"],

Cell[CellGroupData[{
Cell[376033, 12591, 106, 2, 46, "Input"],
Cell[376142, 12595, 63, 1, 44, "Output"]
}, Open  ]],
Cell[376220, 12599, 523, 16, 89, "Text"],

Cell[CellGroupData[{
Cell[376768, 12619, 106, 2, 33, "Input"],
Cell[376877, 12623, 507, 14, 86, "Print"],
Cell[377387, 12639, 3159, 97, 90, "Print"],
Cell[380549, 12738, 507, 14, 86, "Print"],
Cell[381059, 12754, 197, 4, 28, "Print"],
Cell[381259, 12760, 130, 4, 38, "Output"],
Cell[381392, 12766, 251, 5, 28, "Print"],
Cell[381646, 12773, 242, 5, 28, "Print"],
Cell[381891, 12780, 174, 3, 28, "Print"],
Cell[382068, 12785, 139, 2, 28, "Print"],
Cell[382210, 12789, 231, 5, 28, "Print"],
Cell[382444, 12796, 125, 4, 38, "Output"],
Cell[382572, 12802, 246, 5, 28, "Print"],
Cell[382821, 12809, 131, 4, 38, "Output"],
Cell[382955, 12815, 92, 1, 28, "Print"],
Cell[383050, 12818, 116, 4, 43, "Output"],
Cell[383169, 12824, 73, 1, 28, "Print"]
}, Open  ]],
Cell[383257, 12828, 144, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[383426, 12837, 75, 2, 33, "Input"],
Cell[383504, 12841, 294, 4, 61, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[383835, 12850, 80, 2, 33, "Input"],
Cell[383918, 12854, 289, 4, 61, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[384244, 12863, 373, 8, 33, "Input"],
Cell[384620, 12873, 70, 1, 33, "Output"]
}, Open  ]],
Cell[384705, 12877, 169, 4, 41, "Text"],

Cell[CellGroupData[{
Cell[384899, 12885, 83, 2, 33, "Input"],
Cell[384985, 12889, 39, 1, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[385061, 12895, 91, 2, 33, "Input"],
Cell[385155, 12899, 67, 1, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[385259, 12905, 246, 9, 62, "Text"],
Cell[385508, 12916, 136, 3, 33, "Input"],

Cell[CellGroupData[{
Cell[385669, 12923, 103, 2, 33, "Input"],
Cell[385775, 12927, 35, 1, 70, "Output"]
}, Open  ]],
Cell[385825, 12931, 211, 4, 65, "Text"],
Cell[386039, 12937, 92, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[386156, 12943, 106, 2, 33, "Input"],
Cell[386265, 12947, 35, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[386349, 12954, 90, 2, 28, "Input"],
Cell[386442, 12958, 218, 3, 56, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[386697, 12966, 89, 2, 33, "Input"],
Cell[386789, 12970, 1122, 19, 273, "Output"]
}, Open  ]],
Cell[387926, 12992, 148, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[388099, 13001, 174, 4, 33, "Input"],
Cell[388276, 13007, 1218, 20, 193, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[389555, 13034, 169, 4, 39, "Subsection"],
Cell[389727, 13040, 652, 22, 113, "Text"],
Cell[390382, 13064, 1672, 56, 209, "Text"],

Cell[CellGroupData[{
Cell[392079, 13124, 443, 19, 41, "Text"],

Cell[CellGroupData[{
Cell[392547, 13147, 41, 1, 33, "Input"],
Cell[392591, 13150, 122, 4, 38, "Output"]
}, Open  ]],
Cell[392728, 13157, 78, 1, 46, "Input"],

Cell[CellGroupData[{
Cell[392831, 13162, 40, 1, 33, "Input"],
Cell[392874, 13165, 1289, 23, 227, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[394200, 13193, 42, 1, 33, "Input"],
Cell[394245, 13196, 68, 1, 33, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[394350, 13202, 134, 3, 33, "Input"],
Cell[394487, 13207, 1427, 26, 281, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[395951, 13238, 75, 1, 33, "Input"],
Cell[396029, 13241, 6281, 99, 1179, "Output"]
}, Closed]],
Cell[402325, 13343, 369, 13, 60, "Text"],

Cell[CellGroupData[{
Cell[402719, 13360, 109, 2, 33, "Input"],
Cell[402831, 13364, 507, 14, 86, "Print"],
Cell[403341, 13380, 424, 14, 28, "Print"],
Cell[403768, 13396, 507, 14, 86, "Print"],
Cell[404278, 13412, 242, 5, 28, "Print"],
Cell[404523, 13419, 141, 4, 38, "Output"],
Cell[404667, 13425, 242, 5, 28, "Print"],
Cell[404912, 13432, 174, 3, 28, "Print"],
Cell[405089, 13437, 139, 2, 28, "Print"],
Cell[405231, 13441, 265, 6, 28, "Print"],
Cell[405499, 13449, 125, 4, 38, "Output"],
Cell[405627, 13455, 246, 5, 28, "Print"],
Cell[405876, 13462, 131, 4, 38, "Output"],
Cell[406010, 13468, 92, 1, 28, "Print"],
Cell[406105, 13471, 116, 4, 43, "Output"],
Cell[406224, 13477, 70, 1, 28, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[406331, 13483, 41, 1, 33, "Input"],
Cell[406375, 13486, 294, 4, 61, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[406706, 13495, 41, 1, 33, "Input"],
Cell[406750, 13498, 122, 4, 38, "Output"],
Cell[406875, 13504, 141, 4, 38, "Output"]
}, Open  ]],
Cell[407031, 13511, 53, 1, 33, "Input"]
}, Closed]],
Cell[407099, 13515, 646, 27, 60, "Text"],

Cell[CellGroupData[{
Cell[407770, 13546, 233, 7, 62, "Text"],

Cell[CellGroupData[{
Cell[408028, 13557, 75, 2, 33, "Input"],
Cell[408106, 13561, 37, 1, 70, "Print"]
}, Open  ]],
Cell[408158, 13565, 97, 2, 33, "Input"],
Cell[408258, 13569, 171, 3, 33, "Input"],
Cell[408432, 13574, 254, 10, 41, "Text"],
Cell[408689, 13586, 100, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[408814, 13592, 164, 4, 33, "Input"],
Cell[408981, 13598, 121, 2, 70, "Output"]
}, Open  ]],
Cell[409117, 13603, 256, 10, 41, "Text"],
Cell[409376, 13615, 96, 2, 33, "Input"],
Cell[409475, 13619, 201, 7, 41, "Text"],
Cell[409679, 13628, 87, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[409791, 13634, 94, 2, 33, "Input"],
Cell[409888, 13638, 648, 20, 70, "Print"],
Cell[410539, 13660, 734, 26, 70, "Print"],
Cell[411276, 13688, 778, 24, 70, "Print"],
Cell[412057, 13714, 242, 5, 70, "Print"],
Cell[412302, 13721, 145, 4, 70, "Output"],
Cell[412450, 13727, 160, 3, 70, "Print"],
Cell[412613, 13732, 246, 5, 70, "Print"],
Cell[412862, 13739, 269, 6, 70, "Print"],
Cell[413134, 13747, 267, 6, 70, "Print"],
Cell[413404, 13755, 246, 5, 70, "Print"],
Cell[413653, 13762, 242, 5, 70, "Print"],
Cell[413898, 13769, 252, 5, 70, "Print"],
Cell[414153, 13776, 70, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[414260, 13782, 75, 2, 33, "Input"],
Cell[414338, 13786, 141, 4, 70, "Output"]
}, Open  ]],
Cell[414494, 13793, 299, 13, 41, "Text"],
Cell[414796, 13808, 171, 7, 89, "Text"],

Cell[CellGroupData[{
Cell[414992, 13819, 127, 3, 75, "Subsection"],
Cell[415122, 13824, 417, 10, 52, "Input"],

Cell[CellGroupData[{
Cell[415564, 13838, 260, 6, 71, "Input"],
Cell[415827, 13846, 1235, 38, 70, "Print"],
Cell[417065, 13886, 1349, 43, 70, "Print"],
Cell[418417, 13931, 1355, 42, 70, "Print"],
Cell[419775, 13975, 242, 5, 70, "Print"],
Cell[420020, 13982, 148, 4, 70, "Output"],
Cell[420171, 13988, 133, 3, 70, "Print"],
Cell[420307, 13993, 58, 1, 70, "Print"],
Cell[420368, 13996, 246, 5, 70, "Print"],
Cell[420617, 14003, 269, 6, 70, "Print"],
Cell[420889, 14011, 269, 6, 70, "Print"],
Cell[421161, 14019, 201, 4, 70, "Print"],
Cell[421365, 14025, 199, 4, 70, "Print"],
Cell[421567, 14031, 116, 4, 70, "Output"],
Cell[421686, 14037, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[421797, 14043, 94, 2, 33, "Input"],
Cell[421894, 14047, 70, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[422013, 14054, 75, 2, 28, "Input"],
Cell[422091, 14058, 141, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[422269, 14067, 128, 3, 75, "Subsection"],
Cell[422400, 14072, 1136, 31, 52, "Input"],

Cell[CellGroupData[{
Cell[423561, 14107, 290, 6, 71, "Input"],
Cell[423854, 14115, 1260, 37, 70, "Print"],
Cell[425117, 14154, 1463, 45, 70, "Print"],
Cell[426583, 14201, 1462, 43, 70, "Print"],
Cell[428048, 14246, 242, 5, 70, "Print"],
Cell[428293, 14253, 58, 1, 70, "Print"],
Cell[428354, 14256, 246, 5, 70, "Print"],
Cell[428603, 14263, 269, 6, 70, "Print"],
Cell[428875, 14271, 269, 6, 70, "Print"],
Cell[429147, 14279, 201, 4, 70, "Print"],
Cell[429351, 14285, 199, 4, 70, "Print"],
Cell[429553, 14291, 116, 4, 70, "Output"],
Cell[429672, 14297, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[429783, 14303, 84, 2, 28, "Input"],
Cell[429870, 14307, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[429957, 14314, 100, 2, 28, "Input"],
Cell[430060, 14318, 141, 4, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[430228, 14326, 67, 1, 36, "Text"]
}, Closed]]
}, Closed]],
Cell[430322, 14331, 64, 2, 29, "Text"],

Cell[CellGroupData[{
Cell[430411, 14337, 179, 4, 72, "Section"],
Cell[430593, 14343, 1280, 46, 185, "Text"],

Cell[CellGroupData[{
Cell[431898, 14393, 198, 7, 57, "Subsection"],
Cell[432099, 14402, 528, 17, 89, "Text"],

Cell[CellGroupData[{
Cell[432652, 14423, 92, 1, 33, "Input"],
Cell[432747, 14426, 745, 19, 52, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[433529, 14450, 99, 2, 33, "Input"],
Cell[433631, 14454, 677, 17, 52, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[434345, 14476, 104, 2, 33, "Input"],
Cell[434452, 14480, 627, 16, 52, "Output"]
}, Open  ]],
Cell[435094, 14499, 346, 13, 65, "Text"],
Cell[435443, 14514, 448, 15, 65, "Text"],

Cell[CellGroupData[{
Cell[435916, 14533, 71, 1, 33, "Input"],
Cell[435990, 14536, 98, 2, 35, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[436125, 14543, 485, 16, 89, "Text"],

Cell[CellGroupData[{
Cell[436635, 14563, 80, 1, 33, "Input"],
Cell[436718, 14566, 344, 11, 35, "Output"]
}, Open  ]],
Cell[437077, 14580, 316, 13, 41, "Text"],

Cell[CellGroupData[{
Cell[437418, 14597, 136, 3, 33, "Input"],
Cell[437557, 14602, 127, 3, 64, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[437721, 14610, 49, 1, 33, "Input"],
Cell[437773, 14613, 416, 12, 49, "Output"]
}, Open  ]],
Cell[438204, 14628, 169, 6, 41, "Text"],

Cell[CellGroupData[{
Cell[438398, 14638, 59, 1, 33, "Input"],
Cell[438460, 14641, 3002, 85, 166, "Output"]
}, Open  ]],
Cell[441477, 14729, 220, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[441722, 14740, 59, 1, 33, "Input"],
Cell[441784, 14743, 961, 32, 95, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[442794, 14781, 891, 26, 132, "Text"],
Cell[443688, 14809, 731, 21, 55, "Text"]
}, Closed]],
Cell[444434, 14833, 921, 26, 156, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[445392, 14864, 123, 2, 36, "Subsection"],
Cell[445518, 14868, 291, 11, 41, "Text"],
Cell[445812, 14881, 133, 3, 33, "Input"],
Cell[445948, 14886, 125, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[446098, 14892, 174, 4, 33, "Input"],
Cell[446275, 14898, 284, 4, 70, "Output"]
}, Open  ]],
Cell[446574, 14905, 383, 16, 41, "Text"],
Cell[446960, 14923, 114, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[447099, 14929, 76, 2, 33, "Input"],
Cell[447178, 14933, 3030, 81, 70, "Output"]
}, Open  ]],
Cell[450223, 15017, 392, 14, 65, "Text"],

Cell[CellGroupData[{
Cell[450640, 15035, 248, 7, 62, "Text"],

Cell[CellGroupData[{
Cell[450913, 15046, 95, 2, 33, "Input"],
Cell[451011, 15050, 6111, 160, 70, "Print"],
Cell[457125, 15212, 7068, 213, 70, "Print"],
Cell[464196, 15427, 6495, 171, 70, "Print"],
Cell[470694, 15600, 240, 5, 70, "Print"],
Cell[470937, 15607, 246, 5, 70, "Print"],
Cell[471186, 15614, 267, 6, 70, "Print"],
Cell[471456, 15622, 267, 6, 70, "Print"],
Cell[471726, 15630, 246, 5, 70, "Print"],
Cell[471975, 15637, 242, 5, 70, "Print"],
Cell[472220, 15644, 252, 5, 70, "Print"],
Cell[472475, 15651, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[472585, 15657, 70, 2, 33, "Input"],
Cell[472658, 15661, 5944, 152, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[478639, 15818, 83, 2, 33, "Input"],
Cell[478725, 15822, 90, 1, 70, "Output"]
}, Open  ]],
Cell[478830, 15826, 302, 12, 41, "Text"],

Cell[CellGroupData[{
Cell[479157, 15842, 71, 2, 33, "Input"],
Cell[479231, 15846, 35, 1, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[479293, 15851, 64, 2, 34, "Text"],
Cell[479360, 15855, 732, 26, 89, "Text"],

Cell[CellGroupData[{
Cell[480117, 15885, 68, 1, 33, "Input"],
Cell[480188, 15888, 928, 26, 70, "Output"]
}, Open  ]],
Cell[481131, 15917, 556, 20, 89, "Text"],

Cell[CellGroupData[{
Cell[481712, 15941, 266, 7, 62, "Text"],
Cell[481981, 15950, 123, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[482129, 15956, 78, 2, 33, "Input"],
Cell[482210, 15960, 3275, 84, 70, "Output"]
}, Open  ]],
Cell[485500, 16047, 364, 15, 41, "Text"],

Cell[CellGroupData[{
Cell[485889, 16066, 97, 2, 33, "Input"],
Cell[485989, 16070, 6138, 157, 70, "Print"],
Cell[492130, 16229, 5423, 163, 70, "Print"],
Cell[497556, 16394, 6121, 157, 70, "Print"],
Cell[503680, 16553, 240, 5, 70, "Print"],
Cell[503923, 16560, 246, 5, 70, "Print"],
Cell[504172, 16567, 267, 6, 70, "Print"],
Cell[504442, 16575, 267, 6, 70, "Print"],
Cell[504712, 16583, 246, 5, 70, "Print"],
Cell[504961, 16590, 242, 5, 70, "Print"],
Cell[505206, 16597, 207, 4, 70, "Print"],
Cell[505416, 16603, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[505527, 16609, 70, 2, 33, "Input"],
Cell[505600, 16613, 4101, 101, 70, "Output"]
}, Open  ]],
Cell[509716, 16717, 134, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[509875, 16726, 313, 9, 33, "Input"],
Cell[510191, 16737, 3114, 75, 70, "Print"],
Cell[513308, 16814, 2206, 67, 70, "Print"],
Cell[515517, 16883, 3091, 75, 70, "Print"],
Cell[518611, 16960, 242, 5, 70, "Print"],
Cell[518856, 16967, 246, 5, 70, "Print"],
Cell[519105, 16974, 269, 6, 70, "Print"],
Cell[519377, 16982, 269, 6, 70, "Print"],
Cell[519649, 16990, 246, 5, 70, "Print"],
Cell[519898, 16997, 199, 4, 70, "Print"],
Cell[520100, 17003, 137, 4, 70, "Output"],
Cell[520240, 17009, 69, 1, 70, "Print"]
}, Open  ]],
Cell[520324, 17013, 168, 6, 41, "Text"],

Cell[CellGroupData[{
Cell[520517, 17023, 36, 1, 33, "Input"],
Cell[520556, 17026, 2423, 59, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[523016, 17090, 40, 1, 33, "Input"],
Cell[523059, 17093, 2423, 59, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[525509, 17156, 64, 2, 29, "Text"],
Cell[525576, 17160, 937, 31, 113, "Text"],

Cell[CellGroupData[{
Cell[526538, 17195, 76, 1, 33, "Input"],
Cell[526617, 17198, 37, 1, 70, "Print"]
}, Open  ]],
Cell[526669, 17202, 236, 12, 41, "Text"],

Cell[CellGroupData[{
Cell[526930, 17218, 68, 1, 33, "Input"],
Cell[527001, 17221, 241, 5, 70, "Output"]
}, Open  ]],
Cell[527257, 17229, 147, 6, 41, "Text"],

Cell[CellGroupData[{
Cell[527429, 17239, 37, 1, 33, "Input"],
Cell[527469, 17242, 98, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[527604, 17249, 45, 1, 33, "Input"],
Cell[527652, 17252, 98, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[527787, 17259, 224, 7, 62, "Text"],

Cell[CellGroupData[{
Cell[528036, 17270, 75, 2, 33, "Input"],
Cell[528114, 17274, 37, 1, 70, "Print"]
}, Open  ]],
Cell[528166, 17278, 97, 2, 33, "Input"],
Cell[528266, 17282, 230, 5, 52, "Input"],
Cell[528499, 17289, 122, 2, 33, "Input"],
Cell[528624, 17293, 468, 20, 41, "Text"],

Cell[CellGroupData[{
Cell[529117, 17317, 110, 2, 33, "Input"],
Cell[529230, 17321, 37, 1, 70, "Print"]
}, Open  ]],
Cell[529282, 17325, 129, 3, 33, "Input"],

Cell[CellGroupData[{
Cell[529436, 17332, 80, 2, 33, "Input"],
Cell[529519, 17336, 4453, 127, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[534009, 17468, 104, 2, 33, "Input"],
Cell[534116, 17472, 511, 14, 70, "Print"],
Cell[534630, 17488, 5423, 163, 70, "Print"],
Cell[540056, 17653, 511, 14, 70, "Print"],
Cell[540570, 17669, 197, 4, 70, "Print"],
Cell[540770, 17675, 254, 5, 70, "Print"],
Cell[541027, 17682, 246, 5, 70, "Print"],
Cell[541276, 17689, 267, 6, 70, "Print"],
Cell[541546, 17697, 269, 6, 70, "Print"],
Cell[541818, 17705, 246, 5, 70, "Print"],
Cell[542067, 17712, 244, 5, 70, "Print"],
Cell[542314, 17719, 207, 4, 70, "Print"],
Cell[542524, 17725, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[542635, 17731, 70, 2, 33, "Input"],
Cell[542708, 17735, 3609, 86, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[546354, 17826, 83, 2, 33, "Input"],
Cell[546440, 17830, 2423, 59, 70, "Output"]
}, Open  ]],
Cell[548878, 17892, 199, 7, 41, "Text"],

Cell[CellGroupData[{
Cell[549102, 17903, 71, 2, 33, "Input"],
Cell[549176, 17907, 1042, 35, 70, "Output"]
}, Open  ]],
Cell[550233, 17945, 584, 19, 89, "Text"],

Cell[CellGroupData[{
Cell[550842, 17968, 81, 2, 33, "Input"],
Cell[550926, 17972, 37, 1, 70, "Print"],
Cell[550966, 17975, 36, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[551039, 17981, 456, 13, 33, "Input"],
Cell[551498, 17996, 511, 14, 70, "Print"],
Cell[552012, 18012, 7088, 213, 70, "Print"],
Cell[559103, 18227, 511, 14, 70, "Print"],
Cell[559617, 18243, 197, 4, 70, "Print"],
Cell[559817, 18249, 253, 5, 70, "Print"],
Cell[560073, 18256, 246, 5, 70, "Print"],
Cell[560322, 18263, 267, 6, 70, "Print"],
Cell[560592, 18271, 269, 6, 70, "Print"],
Cell[560864, 18279, 246, 5, 70, "Print"],
Cell[561113, 18286, 242, 5, 70, "Print"],
Cell[561358, 18293, 252, 5, 70, "Print"],
Cell[561613, 18300, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[561723, 18306, 70, 2, 33, "Input"],
Cell[561796, 18310, 4494, 111, 70, "Output"]
}, Open  ]],
Cell[566305, 18424, 479, 17, 65, "Text"],

Cell[CellGroupData[{
Cell[566809, 18445, 78, 2, 33, "Input"],
Cell[566890, 18449, 1693, 59, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[568620, 18513, 87, 2, 33, "Input"],
Cell[568710, 18517, 561, 19, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[569308, 18541, 97, 2, 33, "Input"],
Cell[569408, 18545, 4128, 123, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[573573, 18673, 98, 2, 33, "Input"],
Cell[573674, 18677, 124, 2, 70, "Output"]
}, Open  ]],
Cell[573813, 18682, 323, 12, 65, "Text"],

Cell[CellGroupData[{
Cell[574161, 18698, 95, 2, 33, "Input"],
Cell[574259, 18702, 584, 17, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[574870, 18723, 64, 2, 29, "Text"],
Cell[574937, 18727, 296, 11, 41, "Text"],

Cell[CellGroupData[{
Cell[575258, 18742, 226, 7, 62, "Text"],

Cell[CellGroupData[{
Cell[575509, 18753, 75, 2, 33, "Input"],
Cell[575587, 18757, 37, 1, 70, "Print"]
}, Open  ]],
Cell[575639, 18761, 199, 4, 33, "Input"],
Cell[575841, 18767, 135, 3, 33, "Input"],
Cell[575979, 18772, 272, 11, 41, "Text"],
Cell[576254, 18785, 123, 2, 33, "Input"],
Cell[576380, 18789, 115, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[576520, 18795, 81, 2, 33, "Input"],
Cell[576604, 18799, 2080, 58, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[578721, 18862, 77, 2, 33, "Input"],
Cell[578801, 18866, 1879, 50, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[580717, 18921, 112, 2, 33, "Input"],
Cell[580832, 18925, 3152, 83, 70, "Print"],
Cell[583987, 19010, 6924, 207, 70, "Print"],
Cell[590914, 19219, 3697, 94, 70, "Print"],
Cell[594614, 19315, 242, 5, 70, "Print"],
Cell[594859, 19322, 254, 5, 70, "Print"],
Cell[595116, 19329, 244, 5, 70, "Print"],
Cell[595363, 19336, 267, 6, 70, "Print"],
Cell[595633, 19344, 267, 6, 70, "Print"],
Cell[595903, 19352, 246, 5, 70, "Print"],
Cell[596152, 19359, 242, 5, 70, "Print"],
Cell[596397, 19366, 252, 5, 70, "Print"],
Cell[596652, 19373, 73, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[596762, 19379, 70, 2, 33, "Input"],
Cell[596835, 19383, 6840, 176, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[603712, 19564, 83, 2, 33, "Input"],
Cell[603798, 19568, 90, 1, 70, "Output"]
}, Open  ]],
Cell[603903, 19572, 26, 0, 33, "Input"],
Cell[603932, 19574, 292, 11, 41, "Text"],
Cell[604227, 19587, 442, 19, 41, "Text"],

Cell[CellGroupData[{
Cell[604694, 19610, 75, 2, 33, "Input"],
Cell[604772, 19614, 37, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[604846, 19620, 110, 2, 33, "Input"],
Cell[604959, 19624, 37, 1, 70, "Print"]
}, Open  ]],
Cell[605011, 19628, 134, 3, 33, "Input"],
Cell[605148, 19633, 123, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[605296, 19639, 82, 2, 33, "Input"],
Cell[605381, 19643, 2250, 62, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[607668, 19710, 78, 2, 33, "Input"],
Cell[607749, 19714, 1789, 46, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[609575, 19765, 114, 2, 33, "Input"],
Cell[609692, 19769, 2845, 73, 70, "Print"],
Cell[612540, 19844, 5423, 163, 70, "Print"],
Cell[617966, 20009, 3585, 89, 70, "Print"],
Cell[621554, 20100, 242, 5, 70, "Print"],
Cell[621799, 20107, 254, 5, 70, "Print"],
Cell[622056, 20114, 246, 5, 70, "Print"],
Cell[622305, 20121, 269, 6, 70, "Print"],
Cell[622577, 20129, 269, 6, 70, "Print"],
Cell[622849, 20137, 246, 5, 70, "Print"],
Cell[623098, 20144, 244, 5, 70, "Print"],
Cell[623345, 20151, 207, 4, 70, "Print"],
Cell[623555, 20157, 74, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[623666, 20163, 70, 2, 33, "Input"],
Cell[623739, 20167, 3609, 86, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[627385, 20258, 83, 2, 33, "Input"],
Cell[627471, 20262, 2423, 59, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[629955, 20328, 149, 5, 36, "Subsection"],
Cell[630107, 20335, 972, 29, 161, "Text"],

Cell[CellGroupData[{
Cell[631104, 20368, 227, 7, 62, "Text"],

Cell[CellGroupData[{
Cell[631356, 20379, 75, 2, 33, "Input"],
Cell[631434, 20383, 37, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[631508, 20389, 320, 6, 85, "Input"],
Cell[631831, 20397, 542, 8, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[632410, 20410, 262, 6, 55, "Input"],
Cell[632675, 20418, 689, 13, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[633401, 20436, 217, 5, 33, "Input"],
Cell[633621, 20443, 777, 15, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[634435, 20463, 110, 2, 33, "Input"],
Cell[634548, 20467, 1522, 27, 70, "Output"]
}, Open  ]],
Cell[636085, 20497, 629, 26, 65, "Text"],
Cell[636717, 20525, 94, 2, 33, "Input"],
Cell[636814, 20529, 101, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[636940, 20535, 86, 2, 33, "Input"],
Cell[637029, 20539, 372, 7, 70, "Output"]
}, Open  ]],
Cell[637416, 20549, 370, 16, 41, "Text"],

Cell[CellGroupData[{
Cell[637811, 20569, 175, 4, 33, "Input"],
Cell[637989, 20575, 78, 1, 70, "Output"]
}, Open  ]],
Cell[638082, 20579, 164, 9, 41, "Text"],

Cell[CellGroupData[{
Cell[638271, 20592, 139, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[638435, 20600, 293, 8, 33, "Input"],
Cell[638731, 20610, 507, 14, 70, "Print"],
Cell[639241, 20626, 424, 14, 70, "Print"],
Cell[639668, 20642, 507, 14, 70, "Print"],
Cell[640178, 20658, 242, 5, 70, "Print"],
Cell[640423, 20665, 141, 4, 70, "Output"],
Cell[640567, 20671, 246, 5, 70, "Print"],
Cell[640816, 20678, 174, 3, 70, "Print"],
Cell[640993, 20683, 139, 2, 70, "Print"],
Cell[641135, 20687, 267, 6, 70, "Print"],
Cell[641405, 20695, 267, 6, 70, "Print"],
Cell[641675, 20703, 246, 5, 70, "Print"],
Cell[641924, 20710, 242, 5, 70, "Print"],
Cell[642169, 20717, 115, 2, 70, "Print"],
Cell[642287, 20721, 250, 5, 70, "Print"],
Cell[642540, 20728, 73, 1, 70, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[642662, 20735, 81, 2, 28, "Input"],
Cell[642746, 20739, 2428, 41, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[645211, 20785, 133, 3, 33, "Input"],
Cell[645347, 20790, 374, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[645758, 20802, 108, 2, 33, "Input"],
Cell[645869, 20806, 721, 13, 70, "Output"]
}, Open  ]],
Cell[646605, 20822, 35, 1, 52, "Input"],

Cell[CellGroupData[{
Cell[646665, 20827, 145, 4, 62, "Text"],

Cell[CellGroupData[{
Cell[646835, 20835, 75, 2, 33, "Input"],
Cell[646913, 20839, 141, 4, 70, "Output"]
}, Open  ]],
Cell[647069, 20846, 423, 19, 41, "Text"],

Cell[CellGroupData[{
Cell[647517, 20869, 123, 2, 33, "Input"],
Cell[647643, 20873, 8254, 252, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[655934, 21130, 173, 4, 33, "Input"],
Cell[656110, 21136, 3848, 111, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[659995, 21252, 175, 4, 33, "Input"],
Cell[660173, 21258, 677, 17, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[660887, 21280, 351, 11, 86, "Text"],

Cell[CellGroupData[{
Cell[661263, 21295, 104, 2, 33, "Input"],
Cell[661370, 21299, 150, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[661557, 21306, 100, 2, 33, "Input"],
Cell[661660, 21310, 1548, 43, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[663245, 21358, 44, 1, 33, "Input"],
Cell[663292, 21361, 130, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[663459, 21368, 108, 2, 33, "Input"],
Cell[663570, 21372, 130, 2, 70, "Output"]
}, Open  ]]
}, Closed]],
Cell[663727, 21378, 26, 0, 28, "Input"],

Cell[CellGroupData[{
Cell[663778, 21382, 293, 8, 33, "Input"],
Cell[664074, 21392, 507, 14, 70, "Print"],
Cell[664584, 21408, 424, 14, 70, "Print"],
Cell[665011, 21424, 507, 14, 70, "Print"],
Cell[665521, 21440, 242, 5, 70, "Print"],
Cell[665766, 21447, 141, 4, 70, "Output"],
Cell[665910, 21453, 244, 5, 70, "Print"],
Cell[666157, 21460, 174, 3, 70, "Print"],
Cell[666334, 21465, 139, 2, 70, "Print"],
Cell[666476, 21469, 267, 6, 70, "Print"],
Cell[666746, 21477, 269, 6, 70, "Print"],
Cell[667018, 21485, 201, 4, 70, "Print"],
Cell[667222, 21491, 242, 5, 70, "Print"],
Cell[667467, 21498, 115, 2, 70, "Print"],
Cell[667585, 21502, 207, 4, 70, "Print"],
Cell[667795, 21508, 70, 1, 70, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[667902, 21514, 75, 2, 33, "Input"],
Cell[667980, 21518, 141, 4, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[668170, 21528, 81, 2, 28, "Input"],
Cell[668254, 21532, 2423, 59, 70, "Output"]
}, Open  ]],
Cell[670692, 21594, 327, 16, 41, "Text"],

Cell[CellGroupData[{
Cell[671044, 21614, 75, 2, 33, "Input"],
Cell[671122, 21618, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[671197, 21624, 108, 2, 33, "Input"],
Cell[671308, 21628, 675, 17, 70, "Output"]
}, Open  ]],
Cell[671998, 21648, 506, 18, 68, "Text"]
}, Closed]],
Cell[672519, 21669, 428, 18, 60, "Text"]
}, Closed]]
}, Closed]],
Cell[672974, 21691, 64, 2, 29, "Text"],

Cell[CellGroupData[{
Cell[673063, 21697, 185, 4, 72, "Section"],
Cell[673251, 21703, 961, 29, 137, "Text"],
Cell[674215, 21734, 346, 9, 65, "Text"],
Cell[674564, 21745, 694, 14, 137, "Text"],

Cell[CellGroupData[{
Cell[675283, 21763, 1449, 33, 209, "Text"],
Cell[676735, 21798, 393, 16, 70, "Text"],
Cell[677131, 21816, 360, 13, 70, "Text"],
Cell[677494, 21831, 449, 18, 70, "Text"],
Cell[677946, 21851, 346, 13, 70, "Text"],
Cell[678295, 21866, 788, 14, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[679120, 21885, 1242, 39, 156, "Text"],
Cell[680365, 21926, 1388, 50, 146, "Text"],

Cell[CellGroupData[{
Cell[681778, 21980, 685, 25, 65, "Text"],
Cell[682466, 22007, 97, 2, 33, "Input"],

Cell[CellGroupData[{
Cell[682588, 22013, 85, 1, 33, "Input"],
Cell[682676, 22016, 204, 3, 52, "Output"]
}, Open  ]],
Cell[682895, 22022, 67, 1, 33, "Input"],

Cell[CellGroupData[{
Cell[682987, 22027, 66, 1, 33, "Input"],
Cell[683056, 22030, 38, 1, 33, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[683133, 22036, 831, 29, 108, "Text"],
Cell[683967, 22067, 634, 13, 137, "Text"],

Cell[CellGroupData[{
Cell[684626, 22084, 193, 5, 60, "Subsection"],
Cell[684822, 22091, 357, 8, 89, "Text",
  CellTags->"ExactSolBook"],

Cell[CellGroupData[{
Cell[685204, 22103, 260, 10, 57, "Subsection"],

Cell[CellGroupData[{
Cell[685489, 22117, 64, 1, 52, "Subsubsection"],
Cell[685556, 22120, 254, 6, 70, "Text"],

Cell[CellGroupData[{
Cell[685835, 22130, 81, 1, 70, "Input"],
Cell[685919, 22133, 98, 2, 70, "Output"]
}, Open  ]],
Cell[686032, 22138, 48, 1, 70, "Input"],
Cell[686083, 22141, 121, 4, 70, "Text"],
Cell[686207, 22147, 141, 2, 70, "Input"],
Cell[686351, 22151, 225, 5, 70, "Text"],
Cell[686579, 22158, 114, 2, 70, "Input"],
Cell[686696, 22162, 89, 1, 70, "Input"],
Cell[686788, 22165, 102, 2, 70, "Input"],
Cell[686893, 22169, 70, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[687000, 22175, 56, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[687081, 22180, 178, 4, 70, "Input"],
Cell[687262, 22186, 148, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[687447, 22193, 45, 1, 70, "Input"],
Cell[687495, 22196, 93, 1, 70, "Print"],
Cell[687591, 22199, 45, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[687673, 22205, 82, 1, 70, "Input"],
Cell[687758, 22208, 112, 2, 70, "Print"],
Cell[687873, 22212, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[687956, 22218, 139, 3, 70, "Input"],
Cell[688098, 22223, 79, 1, 70, "Print"],
Cell[688180, 22226, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[688263, 22232, 139, 3, 70, "Input"],
Cell[688405, 22237, 52, 1, 70, "Print"],
Cell[688460, 22240, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[688543, 22246, 201, 4, 70, "Input"],
Cell[688747, 22252, 44, 1, 70, "Print"],
Cell[688794, 22255, 72, 1, 70, "Print"],
Cell[688869, 22258, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[688952, 22264, 82, 1, 70, "Input"],
Cell[689037, 22267, 63, 1, 70, "Print"],
Cell[689103, 22270, 44, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[689184, 22276, 71, 1, 70, "Input"],
Cell[689258, 22279, 44, 1, 70, "Print"],
Cell[689305, 22282, 57, 1, 70, "Print"],
Cell[689365, 22285, 59, 1, 70, "Print"],
Cell[689427, 22288, 44, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[689520, 22295, 56, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[689601, 22300, 208, 4, 70, "Input"],
Cell[689812, 22306, 199, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[690048, 22314, 45, 1, 70, "Input"],
Cell[690096, 22317, 93, 1, 70, "Print"],
Cell[690192, 22320, 45, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[690274, 22326, 82, 1, 70, "Input"],
Cell[690359, 22329, 112, 2, 70, "Print"],
Cell[690474, 22333, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[690557, 22339, 139, 3, 70, "Input"],
Cell[690699, 22344, 112, 2, 70, "Print"],
Cell[690814, 22348, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[690897, 22354, 147, 3, 70, "Input"],
Cell[691047, 22359, 44, 1, 70, "Print"],
Cell[691094, 22362, 54, 1, 70, "Print"],
Cell[691151, 22365, 112, 2, 70, "Print"],
Cell[691266, 22369, 46, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[691361, 22376, 56, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[691442, 22381, 171, 3, 70, "Input"],
Cell[691616, 22386, 190, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[691843, 22394, 45, 1, 70, "Input"],
Cell[691891, 22397, 47, 1, 70, "Print"],
Cell[691941, 22400, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[692024, 22406, 82, 1, 70, "Input"],
Cell[692109, 22409, 49, 1, 70, "Print"],
Cell[692161, 22412, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[692245, 22418, 82, 1, 70, "Input"],
Cell[692330, 22421, 49, 1, 70, "Print"],
Cell[692382, 22424, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[692466, 22430, 139, 3, 70, "Input"],
Cell[692608, 22435, 49, 1, 70, "Print"],
Cell[692660, 22438, 45, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[692742, 22444, 43, 1, 70, "Input"],
Cell[692788, 22447, 79, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[692904, 22453, 120, 3, 70, "Input"],
Cell[693027, 22458, 44, 1, 70, "Print"],
Cell[693074, 22461, 47, 1, 70, "Print"],
Cell[693124, 22464, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[693207, 22470, 71, 1, 70, "Input"],
Cell[693281, 22473, 44, 1, 70, "Print"],
Cell[693328, 22476, 57, 1, 70, "Print"],
Cell[693388, 22479, 65, 1, 70, "Print"],
Cell[693456, 22482, 45, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[693550, 22489, 55, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[693630, 22494, 167, 3, 70, "Input"],
Cell[693800, 22499, 240, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[694077, 22508, 44, 1, 70, "Input"],
Cell[694124, 22511, 47, 1, 70, "Print"],
Cell[694174, 22514, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[694257, 22520, 70, 1, 70, "Input"],
Cell[694330, 22523, 54, 1, 70, "Print"],
Cell[694387, 22526, 47, 1, 70, "Print"],
Cell[694437, 22529, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[694520, 22535, 81, 1, 70, "Input"],
Cell[694604, 22538, 49, 1, 70, "Print"],
Cell[694656, 22541, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[694740, 22547, 81, 1, 70, "Input"],
Cell[694824, 22550, 49, 1, 70, "Print"],
Cell[694876, 22553, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[694960, 22559, 42, 1, 70, "Input"],
Cell[695005, 22562, 76, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[695118, 22568, 99, 2, 70, "Input"],
Cell[695220, 22572, 44, 1, 70, "Print"],
Cell[695267, 22575, 47, 1, 70, "Print"],
Cell[695317, 22578, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[695400, 22584, 132, 3, 70, "Input"],
Cell[695535, 22589, 44, 1, 70, "Print"],
Cell[695582, 22592, 54, 1, 70, "Print"],
Cell[695639, 22595, 47, 1, 70, "Print"],
Cell[695689, 22598, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[695772, 22604, 146, 3, 70, "Input"],
Cell[695921, 22609, 54, 1, 70, "Print"],
Cell[695978, 22612, 49, 1, 70, "Print"],
Cell[696030, 22615, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[696114, 22621, 125, 3, 70, "Input"],
Cell[696242, 22626, 54, 1, 70, "Print"],
Cell[696299, 22629, 49, 1, 70, "Print"],
Cell[696351, 22632, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[696435, 22638, 389, 9, 70, "Input"],
Cell[696827, 22649, 612, 10, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[697476, 22664, 58, 1, 70, "Input"],
Cell[697537, 22667, 90, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[697664, 22673, 70, 1, 70, "Input"],
Cell[697737, 22676, 44, 1, 70, "Print"],
Cell[697784, 22679, 57, 1, 70, "Print"],
Cell[697844, 22682, 48, 1, 70, "Print"],
Cell[697895, 22685, 46, 1, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[698002, 22693, 221, 10, 36, "Subsection"],

Cell[CellGroupData[{
Cell[698248, 22707, 80, 1, 52, "Subsubsection"],
Cell[698331, 22710, 146, 5, 70, "Text"],

Cell[CellGroupData[{
Cell[698502, 22719, 289, 6, 70, "Input"],
Cell[698794, 22727, 398, 8, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[699229, 22740, 52, 1, 70, "Input"],
Cell[699284, 22743, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[699368, 22749, 55, 1, 70, "Input"],
Cell[699426, 22752, 575, 10, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[700038, 22767, 52, 1, 70, "Input"],
Cell[700093, 22770, 2507, 73, 70, "Print"],
Cell[702603, 22845, 2449, 73, 70, "Print"],
Cell[705055, 22920, 3896, 112, 70, "Print"],
Cell[708954, 23034, 239, 5, 70, "Print"],
Cell[709196, 23041, 242, 5, 70, "Print"],
Cell[709441, 23048, 266, 6, 70, "Print"],
Cell[709710, 23056, 264, 6, 70, "Print"],
Cell[709977, 23064, 245, 5, 70, "Print"],
Cell[710225, 23071, 239, 5, 70, "Print"],
Cell[710467, 23078, 250, 5, 70, "Print"],
Cell[710720, 23085, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[710831, 23091, 36, 1, 70, "Input"],
Cell[710870, 23094, 365, 5, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[711272, 23104, 50, 1, 70, "Input"],
Cell[711325, 23107, 79, 1, 70, "Print"],
Cell[711407, 23110, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[711490, 23116, 475, 13, 70, "Input"],
Cell[711968, 23131, 45, 1, 70, "Print"],
Cell[712016, 23134, 40, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[712105, 23141, 68, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[712198, 23146, 52, 1, 70, "Input"],
Cell[712253, 23149, 47, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[712337, 23155, 184, 4, 70, "Input"],
Cell[712524, 23161, 209, 4, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[712770, 23170, 55, 1, 70, "Input"],
Cell[712828, 23173, 223, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[713088, 23181, 52, 1, 70, "Input"],
Cell[713143, 23184, 1148, 33, 70, "Print"],
Cell[714294, 23219, 1176, 37, 70, "Print"],
Cell[715473, 23258, 1118, 31, 70, "Print"],
Cell[716594, 23291, 241, 5, 70, "Print"],
Cell[716838, 23298, 245, 5, 70, "Print"],
Cell[717086, 23305, 268, 6, 70, "Print"],
Cell[717357, 23313, 267, 6, 70, "Print"],
Cell[717627, 23321, 244, 5, 70, "Print"],
Cell[717874, 23328, 242, 5, 70, "Print"],
Cell[718119, 23335, 250, 5, 70, "Print"],
Cell[718372, 23342, 71, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[718480, 23348, 48, 1, 70, "Input"],
Cell[718531, 23351, 42, 1, 70, "Print"],
Cell[718576, 23354, 39, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[718652, 23360, 50, 1, 70, "Input"],
Cell[718705, 23363, 79, 1, 70, "Print"],
Cell[718787, 23366, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[718870, 23372, 57, 1, 70, "Input"],
Cell[718930, 23375, 41, 1, 70, "Print"],
Cell[718974, 23378, 37, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[719060, 23385, 86, 1, 34, "Subsubsection"],
Cell[719149, 23388, 49, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[719223, 23393, 154, 4, 70, "Input"],
Cell[719380, 23399, 140, 2, 70, "Output"]
}, Open  ]],
Cell[719535, 23404, 770, 21, 70, "Input"],

Cell[CellGroupData[{
Cell[720330, 23429, 56, 1, 70, "Input"],
Cell[720389, 23432, 51, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[720477, 23438, 64, 1, 70, "Input"],
Cell[720544, 23441, 824, 14, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[721405, 23460, 52, 1, 70, "Input"],
Cell[721460, 23463, 3261, 96, 70, "Print"],
Cell[724724, 23561, 2929, 87, 70, "Print"],
Cell[727656, 23650, 4721, 139, 70, "Print"],
Cell[732380, 23791, 239, 5, 70, "Print"],
Cell[732622, 23798, 242, 5, 70, "Print"],
Cell[732867, 23805, 265, 6, 70, "Print"],
Cell[733135, 23813, 265, 6, 70, "Print"],
Cell[733403, 23821, 244, 5, 70, "Print"],
Cell[733650, 23828, 240, 5, 70, "Print"],
Cell[733893, 23835, 250, 5, 70, "Print"],
Cell[734146, 23842, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[734257, 23848, 48, 1, 70, "Input"],
Cell[734308, 23851, 41, 1, 70, "Print"],
Cell[734352, 23854, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[734427, 23860, 50, 1, 70, "Input"],
Cell[734480, 23863, 79, 1, 70, "Print"],
Cell[734562, 23866, 46, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[734657, 23873, 69, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[734751, 23878, 51, 1, 70, "Input"],
Cell[734805, 23881, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[734888, 23887, 244, 5, 70, "Input"],
Cell[735135, 23894, 381, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[735553, 23906, 55, 1, 70, "Input"],
Cell[735611, 23909, 600, 11, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[736248, 23925, 52, 1, 70, "Input"],
Cell[736303, 23928, 2703, 82, 70, "Print"],
Cell[739009, 24012, 2478, 75, 70, "Print"],
Cell[741490, 24089, 3340, 99, 70, "Print"],
Cell[744833, 24190, 241, 5, 70, "Print"],
Cell[745077, 24197, 243, 5, 70, "Print"],
Cell[745323, 24204, 266, 6, 70, "Print"],
Cell[745592, 24212, 266, 6, 70, "Print"],
Cell[745861, 24220, 245, 5, 70, "Print"],
Cell[746109, 24227, 241, 5, 70, "Print"],
Cell[746353, 24234, 250, 5, 70, "Print"],
Cell[746606, 24241, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[746717, 24247, 48, 1, 70, "Input"],
Cell[746768, 24250, 43, 1, 70, "Print"],
Cell[746814, 24253, 38, 1, 70, "Output"]
}, Open  ]],
Cell[746867, 24257, 310, 9, 70, "Text"],

Cell[CellGroupData[{
Cell[747202, 24270, 50, 1, 70, "Input"],
Cell[747255, 24273, 79, 1, 70, "Print"],
Cell[747337, 24276, 46, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[747432, 24283, 77, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[747534, 24288, 51, 1, 70, "Input"],
Cell[747588, 24291, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[747671, 24297, 46, 1, 70, "Input"],
Cell[747720, 24300, 37, 1, 70, "Output"]
}, Open  ]],
Cell[747772, 24304, 159, 4, 70, "Text"],
Cell[747934, 24310, 176, 3, 70, "Input"],
Cell[748113, 24315, 128, 3, 70, "Input"],
Cell[748244, 24320, 73, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[748342, 24325, 75, 1, 70, "Input"],
Cell[748420, 24328, 79, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[748536, 24334, 279, 5, 70, "Input"],
Cell[748818, 24341, 1522, 38, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[750377, 24384, 64, 1, 70, "Input"],
Cell[750444, 24387, 2421, 56, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[752902, 24448, 52, 1, 70, "Input"],
Cell[752957, 24451, 4309, 112, 70, "Print"],
Cell[757269, 24565, 3799, 106, 70, "Print"],
Cell[761071, 24673, 3447, 97, 70, "Print"],
Cell[764521, 24772, 239, 5, 70, "Print"],
Cell[764763, 24779, 243, 5, 70, "Print"],
Cell[765009, 24786, 266, 6, 70, "Print"],
Cell[765278, 24794, 265, 6, 70, "Print"],
Cell[765546, 24802, 244, 5, 70, "Print"],
Cell[765793, 24809, 241, 5, 70, "Print"],
Cell[766037, 24816, 251, 5, 70, "Print"],
Cell[766291, 24823, 70, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[766398, 24829, 48, 1, 70, "Input"],
Cell[766449, 24832, 41, 1, 70, "Print"],
Cell[766493, 24835, 37, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[766567, 24841, 46, 1, 70, "Input"],
Cell[766616, 24844, 79, 1, 70, "Print"],
Cell[766698, 24847, 46, 1, 70, "Output"]
}, Open  ]],
Cell[766759, 24851, 53, 1, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[766861, 24858, 229, 10, 36, "Subsection"],

Cell[CellGroupData[{
Cell[767115, 24872, 65, 1, 52, "Subsubsection"],

Cell[CellGroupData[{
Cell[767205, 24877, 100, 2, 70, "Input"],
Cell[767308, 24881, 51, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[767396, 24887, 462, 10, 70, "Input"],
Cell[767861, 24899, 517, 10, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[768415, 24914, 55, 1, 70, "Input"],
Cell[768473, 24917, 623, 11, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[769133, 24933, 52, 1, 70, "Input"],
Cell[769188, 24936, 3526, 109, 70, "Print"],
Cell[772717, 25047, 3586, 110, 70, "Print"],
Cell[776306, 25159, 4741, 145, 70, "Print"],
Cell[781050, 25306, 239, 5, 70, "Print"],
Cell[781292, 25313, 243, 5, 70, "Print"],
Cell[781538, 25320, 265, 6, 70, "Print"],
Cell[781806, 25328, 264, 6, 70, "Print"],
Cell[782073, 25336, 243, 5, 70, "Print"],
Cell[782319, 25343, 239, 5, 70, "Print"],
Cell[782561, 25350, 250, 5, 70, "Print"],
Cell[782814, 25357, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[782925, 25363, 48, 1, 70, "Input"],
Cell[782976, 25366, 41, 1, 70, "Print"],
Cell[783020, 25369, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[783095, 25375, 50, 1, 70, "Input"],
Cell[783148, 25378, 44, 1, 70, "Print"],
Cell[783195, 25381, 72, 1, 70, "Print"],
Cell[783270, 25384, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[783353, 25390, 57, 1, 70, "Input"],
Cell[783413, 25393, 41, 1, 70, "Print"],
Cell[783457, 25396, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[783544, 25403, 83, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[783652, 25408, 51, 1, 70, "Input"],
Cell[783706, 25411, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[783789, 25417, 168, 4, 70, "Input"],
Cell[783960, 25423, 171, 3, 70, "Output"]
}, Open  ]],
Cell[784146, 25429, 68, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[784239, 25434, 55, 1, 70, "Input"],
Cell[784297, 25437, 436, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[784770, 25449, 52, 1, 70, "Input"],
Cell[784825, 25452, 2605, 82, 70, "Print"],
Cell[787433, 25536, 2219, 70, 70, "Print"],
Cell[789655, 25608, 3247, 103, 70, "Print"],
Cell[792905, 25713, 239, 5, 70, "Print"],
Cell[793147, 25720, 204, 4, 70, "Print"],
Cell[793354, 25726, 265, 6, 70, "Print"],
Cell[793622, 25734, 265, 6, 70, "Print"],
Cell[793890, 25742, 244, 5, 70, "Print"],
Cell[794137, 25749, 241, 5, 70, "Print"],
Cell[794381, 25756, 250, 5, 70, "Print"],
Cell[794634, 25763, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[794745, 25769, 48, 1, 70, "Input"],
Cell[794796, 25772, 41, 1, 70, "Print"],
Cell[794840, 25775, 38, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[794915, 25781, 46, 1, 70, "Input"],
Cell[794964, 25784, 44, 1, 70, "Print"],
Cell[795011, 25787, 72, 1, 70, "Print"],
Cell[795086, 25790, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[795169, 25796, 57, 1, 70, "Input"],
Cell[795229, 25799, 41, 1, 70, "Print"],
Cell[795273, 25802, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[795360, 25809, 77, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[795462, 25814, 56, 1, 70, "Input"],
Cell[795521, 25817, 51, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[795609, 25823, 135, 3, 70, "Input"],
Cell[795747, 25828, 135, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[795919, 25835, 55, 1, 70, "Input"],
Cell[795977, 25838, 156, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[796170, 25845, 52, 1, 70, "Input"],
Cell[796225, 25848, 951, 28, 70, "Print"],
Cell[797179, 25878, 1030, 34, 70, "Print"],
Cell[798212, 25914, 1078, 32, 70, "Print"],
Cell[799293, 25948, 240, 5, 70, "Print"],
Cell[799536, 25955, 245, 5, 70, "Print"],
Cell[799784, 25962, 267, 6, 70, "Print"],
Cell[800054, 25970, 268, 6, 70, "Print"],
Cell[800325, 25978, 201, 4, 70, "Print"],
Cell[800529, 25984, 243, 5, 70, "Print"],
Cell[800775, 25991, 250, 5, 70, "Print"],
Cell[801028, 25998, 75, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[801140, 26004, 48, 1, 70, "Input"],
Cell[801191, 26007, 45, 1, 70, "Print"],
Cell[801239, 26010, 40, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[801316, 26016, 46, 1, 70, "Input"],
Cell[801365, 26019, 44, 1, 70, "Print"],
Cell[801412, 26022, 72, 1, 70, "Print"],
Cell[801487, 26025, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[801570, 26031, 57, 1, 70, "Input"],
Cell[801630, 26034, 41, 1, 70, "Print"],
Cell[801674, 26037, 38, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[801761, 26044, 81, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[801867, 26049, 51, 1, 70, "Input"],
Cell[801921, 26052, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[802004, 26058, 93, 1, 70, "Input"],
Cell[802100, 26061, 101, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[802238, 26068, 55, 1, 70, "Input"],
Cell[802296, 26071, 127, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[802460, 26078, 52, 1, 70, "Input"],
Cell[802515, 26081, 604, 16, 70, "Print"],
Cell[803122, 26099, 611, 21, 70, "Print"],
Cell[803736, 26122, 587, 15, 70, "Print"],
Cell[804326, 26139, 197, 4, 70, "Print"],
Cell[804526, 26145, 244, 5, 70, "Print"],
Cell[804773, 26152, 268, 6, 70, "Print"],
Cell[805044, 26160, 267, 6, 70, "Print"],
Cell[805314, 26168, 201, 4, 70, "Print"],
Cell[805518, 26174, 242, 5, 70, "Print"],
Cell[805763, 26181, 207, 4, 70, "Print"],
Cell[805973, 26187, 70, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[806080, 26193, 48, 1, 70, "Input"],
Cell[806131, 26196, 41, 1, 70, "Print"],
Cell[806175, 26199, 37, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[806249, 26205, 46, 1, 70, "Input"],
Cell[806298, 26208, 44, 1, 70, "Print"],
Cell[806345, 26211, 57, 1, 70, "Print"],
Cell[806405, 26214, 65, 1, 70, "Print"],
Cell[806473, 26217, 45, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[806567, 26224, 75, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[806667, 26229, 51, 1, 70, "Input"],
Cell[806721, 26232, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[806804, 26238, 137, 3, 70, "Input"],
Cell[806944, 26243, 135, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[807116, 26250, 55, 1, 70, "Input"],
Cell[807174, 26253, 147, 2, 70, "Output"]
}, Open  ]],
Cell[807336, 26258, 60, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[807421, 26263, 52, 1, 70, "Input"],
Cell[807476, 26266, 743, 20, 70, "Print"],
Cell[808222, 26288, 796, 26, 70, "Print"],
Cell[809021, 26316, 828, 22, 70, "Print"],
Cell[809852, 26340, 240, 5, 70, "Print"],
Cell[810095, 26347, 244, 5, 70, "Print"],
Cell[810342, 26354, 268, 6, 70, "Print"],
Cell[810613, 26362, 267, 6, 70, "Print"],
Cell[810883, 26370, 244, 5, 70, "Print"],
Cell[811130, 26377, 242, 5, 70, "Print"],
Cell[811375, 26384, 122, 4, 70, "Output"],
Cell[811500, 26390, 207, 4, 70, "Print"],
Cell[811710, 26396, 70, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[811817, 26402, 48, 1, 70, "Input"],
Cell[811868, 26405, 41, 1, 70, "Print"],
Cell[811912, 26408, 37, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[811986, 26414, 46, 1, 70, "Input"],
Cell[812035, 26417, 44, 1, 70, "Print"],
Cell[812082, 26420, 57, 1, 70, "Print"],
Cell[812142, 26423, 65, 1, 70, "Print"],
Cell[812210, 26426, 45, 1, 70, "Output"]
}, Open  ]],
Cell[812270, 26430, 53, 1, 70, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[812372, 26437, 233, 10, 36, "Subsection"],

Cell[CellGroupData[{
Cell[812630, 26451, 66, 1, 52, "Subsubsection"],

Cell[CellGroupData[{
Cell[812721, 26456, 63, 1, 70, "Input"],
Cell[812787, 26459, 58, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[812882, 26465, 245, 6, 70, "Input"],
Cell[813130, 26473, 307, 5, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[813474, 26483, 55, 1, 70, "Input"],
Cell[813532, 26486, 374, 7, 70, "Output"]
}, Open  ]],
Cell[813921, 26496, 60, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[814006, 26501, 52, 1, 70, "Input"],
Cell[814061, 26504, 1775, 52, 70, "Print"],
Cell[815839, 26558, 1835, 55, 70, "Print"],
Cell[817677, 26615, 1799, 52, 70, "Print"],
Cell[819479, 26669, 240, 5, 70, "Print"],
Cell[819722, 26676, 244, 5, 70, "Print"],
Cell[819969, 26683, 267, 6, 70, "Print"],
Cell[820239, 26691, 267, 6, 70, "Print"],
Cell[820509, 26699, 244, 5, 70, "Print"],
Cell[820756, 26706, 199, 4, 70, "Print"],
Cell[820958, 26712, 116, 4, 70, "Output"],
Cell[821077, 26718, 75, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[821189, 26724, 48, 1, 70, "Input"],
Cell[821240, 26727, 45, 1, 70, "Print"],
Cell[821288, 26730, 40, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[821365, 26736, 46, 1, 70, "Input"],
Cell[821414, 26739, 44, 1, 70, "Print"],
Cell[821461, 26742, 57, 1, 70, "Print"],
Cell[821521, 26745, 59, 1, 70, "Print"],
Cell[821583, 26748, 44, 1, 70, "Output"]
}, Open  ]],
Cell[821642, 26752, 53, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[821732, 26758, 87, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[821844, 26763, 52, 1, 70, "Input"],
Cell[821899, 26766, 47, 1, 70, "Output"]
}, Open  ]],
Cell[821961, 26770, 59, 1, 70, "Input"],

Cell[CellGroupData[{
Cell[822045, 26775, 171, 4, 70, "Input"],
Cell[822219, 26781, 191, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[822447, 26789, 55, 1, 70, "Input"],
Cell[822505, 26792, 218, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[822760, 26800, 52, 1, 70, "Input"],
Cell[822815, 26803, 1100, 32, 70, "Print"],
Cell[823918, 26837, 1012, 32, 70, "Print"],
Cell[824933, 26871, 1158, 33, 70, "Print"],
Cell[826094, 26906, 240, 5, 70, "Print"],
Cell[826337, 26913, 244, 5, 70, "Print"],
Cell[826584, 26920, 267, 6, 70, "Print"],
Cell[826854, 26928, 268, 6, 70, "Print"],
Cell[827125, 26936, 244, 5, 70, "Print"],
Cell[827372, 26943, 242, 5, 70, "Print"],
Cell[827617, 26950, 207, 4, 70, "Print"],
Cell[827827, 26956, 120, 4, 70, "Output"],
Cell[827950, 26962, 75, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[828062, 26968, 48, 1, 70, "Input"],
Cell[828113, 26971, 42, 1, 70, "Print"],
Cell[828158, 26974, 39, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[828234, 26980, 50, 1, 70, "Input"],
Cell[828287, 26983, 63, 1, 70, "Print"],
Cell[828353, 26986, 44, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[828434, 26992, 57, 1, 70, "Input"],
Cell[828494, 26995, 41, 1, 70, "Print"],
Cell[828538, 26998, 37, 1, 70, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[828624, 27005, 82, 1, 34, "Subsubsection"],

Cell[CellGroupData[{
Cell[828731, 27010, 60, 1, 70, "Input"],
Cell[828794, 27013, 55, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[828886, 27019, 73, 1, 70, "Input"],
Cell[828962, 27022, 73, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[829072, 27028, 320, 6, 70, "Input"],
Cell[829395, 27036, 386, 7, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[829818, 27048, 63, 1, 70, "Input"],
Cell[829884, 27051, 487, 8, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[830408, 27064, 52, 1, 70, "Input"],
Cell[830463, 27067, 2451, 73, 70, "Print"],
Cell[832917, 27142, 2465, 74, 70, "Print"],
Cell[835385, 27218, 2457, 74, 70, "Print"],
Cell[837845, 27294, 240, 5, 70, "Print"],
Cell[838088, 27301, 243, 5, 70, "Print"],
Cell[838334, 27308, 266, 6, 70, "Print"],
Cell[838603, 27316, 266, 6, 70, "Print"],
Cell[838872, 27324, 244, 5, 70, "Print"],
Cell[839119, 27331, 199, 4, 70, "Print"],
Cell[839321, 27337, 116, 4, 70, "Output"],
Cell[839440, 27343, 75, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[839552, 27349, 48, 1, 70, "Input"],
Cell[839603, 27352, 176, 5, 70, "Output"]
}, Open  ]],
Cell[839794, 27360, 395, 11, 70, "Text"],

Cell[CellGroupData[{
Cell[840214, 27375, 37, 1, 70, "Input"],
Cell[840254, 27378, 91, 1, 70, "Output"]
}, Open  ]],
Cell[840360, 27382, 72, 1, 70, "Text"],

Cell[CellGroupData[{
Cell[840457, 27387, 207, 4, 70, "Input"],
Cell[840667, 27393, 194, 4, 70, "Output"]
}, Open  ]],
Cell[840876, 27400, 104, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[841005, 27408, 296, 8, 70, "Input"],
Cell[841304, 27418, 123, 2, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[841464, 27425, 192, 4, 70, "Input"],
Cell[841659, 27431, 123, 2, 70, "Output"]
}, Open  ]],
Cell[841797, 27436, 61, 1, 70, "Text"],

Cell[CellGroupData[{
Cell[841883, 27441, 630, 14, 70, "Input"],
Cell[842516, 27457, 557, 9, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[843110, 27471, 51, 1, 70, "Input"],
Cell[843164, 27474, 46, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[843247, 27480, 63, 1, 70, "Input"],
Cell[843313, 27483, 625, 12, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[843975, 27500, 52, 1, 70, "Input"],
Cell[844030, 27503, 2967, 92, 70, "Print"],
Cell[847000, 27597, 2920, 91, 70, "Print"],
Cell[849923, 27690, 2862, 89, 70, "Print"],
Cell[852788, 27781, 239, 5, 70, "Print"],
Cell[853030, 27788, 241, 5, 70, "Print"],
Cell[853274, 27795, 263, 6, 70, "Print"],
Cell[853540, 27803, 266, 6, 70, "Print"],
Cell[853809, 27811, 244, 5, 70, "Print"],
Cell[854056, 27818, 199, 4, 70, "Print"],
Cell[854258, 27824, 116, 4, 70, "Output"],
Cell[854377, 27830, 74, 1, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[854488, 27836, 37, 1, 70, "Input"],
Cell[854528, 27839, 162, 3, 70, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[854727, 27847, 48, 1, 70, "Input"],
Cell[854778, 27850, 45, 1, 70, "Print"],
Cell[854826, 27853, 40, 1, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],
Cell[854917, 27860, 563, 14, 132, "Text"],
Cell[855483, 27876, 720, 20, 113, "Text"],
Cell[856206, 27898, 529, 11, 113, "Text"],
Cell[856738, 27911, 632, 14, 137, "Text"]
}, Closed]],
Cell[857385, 27928, 64, 2, 29, "Text"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

